local ND = require("design.NarrativeDesignLibrary")
local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local timer = require("level.timer")
local thisObj, thisLevel, player, kraActor, sonActor, bldrActor, dragonActor, cineLights, arrowProp1, arrowProp2, arrowProp3, arrowProp4, baldurArrow, rockC, rockE, rockE1, rockE2, rockF, shard
local resumeBaldur2 = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  InitProps()
  HideProps()
  if resumeBaldur2 and game.Level.GetVariable("CompletedCineNumber") < 490 then
    Begin_ResumeBaldur2()
    resumeBaldur2 = false
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.resumeBaldur2 = resumeBaldur2
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  resumeBaldur2 = savedInfo.resumeBaldur2
end
function InitProps()
  arrowProp1 = GameObjects.arrowProp1.Child
  arrowProp2 = GameObjects.arrowProp2.Child
  arrowProp3 = GameObjects.arrowProp3.Child
  arrowProp4 = GameObjects.arrowProp4.Child
  baldurArrow = GameObjects.baldurArrow.Child
  rockC = GameObjects.rockC.Child
  rockE = GameObjects.rockE.Child
  rockE1 = GameObjects.rockE1.Child
  rockE2 = GameObjects.rockE2.Child
  rockF = GameObjects.rockF.Child
  shard = GameObjects.shard.Child
end
function HideProps()
  arrowProp1:Hide()
  arrowProp2:Hide()
  arrowProp3:Hide()
  arrowProp4:Hide()
  baldurArrow:Hide()
  rockC:Hide()
  rockE:Hide()
  rockE1:Hide()
  rockE2:Hide()
  rockF:Hide()
  shard:Hide()
end
function ShowProps()
  arrowProp1:Show()
  arrowProp2:Show()
  arrowProp3:Show()
  arrowProp4:Show()
  baldurArrow:Show()
  rockC:Show()
  rockE:Show()
  rockE1:Show()
  rockF:Show()
  shard:Show()
end
function ShowCineLights()
  game.FindLevel("Peak740_SummitPeak"):GetGameObject("Cine_MimirIntro"):CallScript("ShowBaldurReturnsLights")
end
function HideCineLights()
  game.FindLevel("Peak740_SummitPeak"):GetGameObject("Cine_MimirIntro"):CallScript("HideBaldurReturnsLights")
end
function SpawnBaldur()
  local baldur = GameObjects.BaldurSpawner.LuaObjectScript.SpawnEnemy()
  return baldur
end
function SpawnDragon()
  local baldurDragon = GameObjects.BaldurDragon00_SpawnPoint.LuaObjectScript.SpawnEnemy()
  return baldurDragon
end
function SetupActors()
  kraActor = actor.Actor.New("BALDUR RETURNS: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("BALDUR RETURNS: Son Actor", game.AI.FindSon)
  bldrActor = actor.Actor.New("BALDUR RETURNS: Baldur Actor")
  dragonActor = actor.Actor.New("BALDUR RETURNS: Dragon Actor")
  bldrActor:SetSpawnFunction(SpawnBaldur)
  dragonActor:SetSpawnFunction(SpawnDragon)
end
function SetupBaldurReturnsSequence()
  SetupActors()
  local cineSeq = ND.CreateCineSequence(thisLevel, thisObj, "Baldur Returns Sequence")
  local cineLights = game.FindLevel("Peak740_SummitPeak"):GetGameObject("Cine_Start_480")
  local actorTable = {
    {Actor = sonActor},
    {Actor = bldrActor},
    {
      Obj = arrowProp1,
      Anim = "narPeakBaldurReturns000CineScene1"
    },
    {
      Obj = arrowProp2,
      Anim = "narPeakBaldurReturns000CineScene2"
    },
    {
      Obj = arrowProp3,
      Anim = "narPeakBaldurReturns000CineScene3"
    },
    {
      Obj = arrowProp4,
      Anim = "narPeakBaldurReturns000CineScene4"
    },
    {
      Obj = baldurArrow,
      Anim = "narPeakBaldurReturns000CineScene"
    },
    {
      Obj = rockC,
      Anim = "narPeakBaldurReturns000CineScene"
    },
    {
      Obj = rockE,
      Anim = "narPeakBaldurReturns000CineScene"
    },
    {
      Obj = rockE1,
      Anim = "narPeakBaldurReturns000CineScene1"
    },
    {
      Obj = shard,
      Anim = "narPeakBaldurReturns000CineScene"
    },
    {
      Obj = rockF,
      Anim = "narPeakBaldurReturns000CineScene"
    },
    {Obj = cineLights, Anim = "default"}
  }
  cineSeq:Do(function()
    local son = game.AI.FindSon()
    son:CallScript("LuaHook_ResetEnraged")
  end)
  cineSeq:SetPostSkipMusic("SND_MX_PEAK_baldur2_master", nil, nil, nil, nil, "SND_MX_PEAK_baldur2_grapple1_trans")
  cineSeq:MarkAbleToSkip()
  cineSeq:SpawnActorAndWait(bldrActor)
  cineSeq:WaitFrames(1)
  cineSeq:Do(function()
    _G.SetBaldur(bldrActor:GetCreature())
  end)
  cineSeq:Do(ShowProps)
  cineSeq:Do(ShowCineLights)
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:WaitUntilActorAnimPastFrame(kraActor, 41)
  cineSeq:ActorSync(kraActor, {
    Slaves = actorTable,
    Branch = "BRA_BaldurReturns",
    ReferenceJoint = "BaldurReturns_SynchJoint"
  })
  cineSeq:Do(function()
    local peak740 = game.FindLevel("peak740_SummitPeak")
    peak740:CallScript("HengeBreak")
    peak740:CallScript("HengeActivate")
  end)
  cineSeq:WaitUntilActorAnimPastFrame(kraActor, 1242)
  cineSeq:Do(ShowBaldurWound)
  cineSeq:WaitUntilActorAnimPastFrame(kraActor, 4329)
  cineSeq:SpawnActorAndWait(dragonActor)
  cineSeq:Do(HideDeathPlanesIn740)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:Do(HideProps)
  cineSeq:Do(HideCineLights)
  cineSeq:Do(HideBaldurWound)
  cineSeq:SetCompletedCineNumber(470)
  cineSeq:Do(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  cineSeq:Do(CompleteQuestPP820)
  cineSeq:Do(function()
    resumeBaldur2 = true
    game.World.StoreCheckpoint()
  end)
  cineSeq:Do(PlayDragonFight)
  cineSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_BaldurDragonEnter")
  end)
  cineSeq:WaitForFunctionTrue(function()
    return not player:IsPlayingMove("MOV_BaldurDragonEnter")
  end)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(bldrActor)
  cineSeq:Do(function()
    resumeBaldur2 = false
  end)
  cineSeq:StartSequence()
end
function CanSeqFire()
  local completedCine = game.Level.GetVariable("CompletedCineNumber")
  return completedCine < 470 and 460 <= completedCine
end
function CompleteQuestPP820()
  game.QuestManager.ProposeQuestState("Quest_PeaksPass_Objective820", "Complete")
end
function PlayDragonFight()
  _G.StartDragonRide()
end
function HideDeathPlanesIn740()
  local peak740 = game.FindLevel("peak740_SummitPeak")
  if peak740 ~= nil then
    peak740:CallScript("HideDeathplanes")
  end
end
function Begin_ResumeBaldur2()
  _G.RestartDragonRide()
end
function ShowBaldurWound()
  local jointIndex = bldrActor:GetCreature():GetJointIndex("ArrowFace")
  bldrActor:GetCreature():ShowJoint(jointIndex)
end
function HideBaldurWound()
  local jointIndex = bldrActor:GetCreature():GetJointIndex("ArrowFace")
  bldrActor:GetCreature():HideJoint(jointIndex)
end
