local LD = require("design.LevelDesignLibrary")
timer = require("level.timer")
monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local SNDWolfA, SNDWolfB, wolfHowlTimerDelay, circleBtnMonitor
local circleButtonPressed = false
local bIsWitchSinging = false
function OnScriptLoaded(level)
  circleBtnMonitor = monitors.CreateCircleButtonMonitor()
  SNDWolfA = GameObjects.SNDGrpWolfA:FindSingleSoundEmitterByName("SNDWolfA")
  SNDWolfB = GameObjects.SNDGrpWolfB:FindSingleSoundEmitterByName("SNDWolfB")
  wolfHowlTimerDelay = 8 + math.random(0, 1) * 8
  timer.StartLevelTimer(wolfHowlTimerDelay, DoFirstWolfHowl)
  SoundInit()
  game.Audio.StartMusicMaster("SND_MX_RIV_start_master")
  game.Audio.StartMusicMaster("SND_MX_SonSick_master")
end
function OnStart(level, obj)
  LD.RegisterForCineUpdate(level, {
    {
      at = 390,
      immediateFn = ValidateRedStormState,
      fn = function()
        ValidateRedStormState()
        game.Audio.StopAmbiences()
      end
    }
  })
  ValidateRedStormState()
  if bIsWitchSinging then
    TurnOnTheWitchSinging()
  end
end
function DoFirstWolfHowl()
  SNDWolfA:Start("SND_CHR_Wolf_Vox_Howl_Distant_RIV085_A")
  LD.CallFunctionAfterDelay(DoSecondWolfHowl, 0.5)
end
function DoSecondWolfHowl()
  SNDWolfB:Start("SND_CHR_Wolf_Vox_Howl_Distant_RIV085_B")
  if circleButtonPressed == false then
    wolfHowlTimerDelay = 20 + math.random(0, 1) * 10
    LD.CallFunctionAfterDelay(function()
      timer.StartLevelTimer(wolfHowlTimerDelay, DoFirstWolfHowl)
    end, 0.5)
  end
end
function OnUpdate(level)
  if circleBtnMonitor ~= nil then
    circleBtnMonitor:OnButtonDown(CrossBtnInteract)
  end
end
function OnUseWorld(level)
end
function CrossBtnInteract()
  circleBtnMonitor:Stop()
  circleBtnMonitor = nil
  circleButtonPressed = true
end
local soundEmitter
local witchHouseMusic = false
local sonSickMusic = false
local soundEvents = {
  isLooping = false,
  WitchSing = "SND_vo_glb_cbt_bntr_lure_wit_LP"
}
function SoundInit()
  soundEmitter = GameObjects.SNDGrpWitchSpawnSing225:FindSingleSoundEmitterByName("SNDWitchSpawnSing225")
  FreyaHouseExit()
end
function TurnOnTheWitchSinging()
  LD.PlaySound(soundEmitter, soundEvents.WitchSing)
  bIsWitchSinging = true
end
function TurnOffTheWitchSinging()
  LD.StopSound(soundEmitter, soundEvents.WitchSing)
  bIsWitchSinging = false
end
function AfterWitchHouseBMusic()
  if witchHouseMusic == false and game.Level.GetVariable("CompletedCineNumber") >= 165 and game.Level.GetVariable("CompletedCineNumber") < 180 then
    game.Audio.StartMusic("SND_MX_RIV_freya_cavern_explore1_in")
    witchHouseMusic = true
  end
  HideRiv470Zone()
end
function sonSickMusicFun()
  if sonSickMusic == false and game.Level.GetVariable("CompletedCineNumber") >= 368 and game.Level.GetVariable("CompletedCineNumber") < 370 then
    game.Audio.StartMusic("SND_MX_SonSick_travel_to_freya_out")
    sonSickMusic = true
  end
end
function ShowRiv470Zone()
  GameObjects.SNDZnRiv470:ShowSoundEmitterVolume()
  GameObjects.SNDZnRiv475_1:ShowSoundEmitterVolume()
end
function HideRiv470Zone()
  GameObjects.SNDZnRiv470:HideSoundEmitterVolume()
  GameObjects.SNDZnRiv475_1:HideSoundEmitterVolume()
end
function FreyaHouseEnter()
  print("FreyaHouseEnter")
  GameObjects.SNDZnRiv485:ShowSoundEmitterVolume()
  game.Audio.PlaySound("SND_GLB_Interior")
end
function FreyaHouseExit()
  print("FreyaHouseExit")
  GameObjects.SNDZnRiv485:HideSoundEmitterVolume()
  game.Audio.PlaySound("SND_GLB_Exterior")
end
function ValidateRedStormState()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 365 <= cineNumber and cineNumber < 390 then
    EnableRedStormState()
  else
    DisableRedStormState()
  end
end
function EnableRedStormState()
  game.Audio.SetWwiseState("Red_Storm", "Active")
end
function DisableRedStormState()
  game.Audio.SetWwiseState("Red_Storm", "Inactive")
end
function musicLostBoy()
  timer.StartLevelTimer(0.5, forestChase1Music)
end
function forestChase1Music()
  game.Audio.StartMusic("SND_MX_RIV_forest_chase_1_in")
  LD.CompleteQuest("Quest_RiverPass_Objective420")
end
function HideRiv925Zone()
  GameObjects.SNDZnRiv925:HideSoundEmitterVolume()
end
function ShowRiv925Zone()
  GameObjects.SNDZnRiv925:ShowSoundEmitterVolume()
end
function OnSaveCheckpoint(level)
  return {bIsWitchSinging = bIsWitchSinging}
end
function OnRestoreCheckpoint(level, savedInfo)
  bIsWitchSinging = savedInfo.bIsWitchSinging
end
