local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local timer = require("level.timer")
local TUT = require("game.GlobalTutorials")
local player, son, thisLevel, level_Riv100, CheckPointMonitor, startAreaCheckpoint, OneHitCallMonitor, ZoneMonitorAggroEnemy, ZoneTrigger
local Encounter_01Complete = false
local Area_1_Encounter_1, Area_1_Encounter_2, queststartVolume, questStartTrigger
local musicisactive = false
local Riv085MusicOn = false
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  thisLevel = level
  if Area_1_Encounter_1 == nil then
    Patroling_Draugrs_Area_1_Fight_1()
  end
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level)
  GameObjects.DeathOnOff:HideCollision()
end
function OnStart(level)
end
function RiverPass_Demo_Bookmark_Start()
  GameObjects.Cine_BCDStart.LuaObjectScript.PlayCineIdle()
end
function Patroling_Draugrs_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Patroling Riv085", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_Riv_fight_1_in",
    StopMusic = "SND_MX_Riv_fight_1_out",
    LeashZone = "LeashZone_01"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Draugr_N_Patrol_01",
      spawnLocators = "EnemyLocator_1",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.01
    },
    {
      spawners = "Draugr_N_Patrol_02",
      spawnLocators = "A1_W4_07",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.3
    }
  })
  Area_1_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A1_W4_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.39
    }
  })
  Area_1_Encounter_1:AddWave({
    timeBetweenWaves = 8,
    {
      spawners = "Intro_Draugr_PT",
      spawnLocators = "A1_W3_01",
      useSpawnLocatorsOnly = true,
      markerID = "Fisrt_ProjectileDraugr",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_1_Encounter_1:AddWave({
    timeBeforeNextWave = 0.1,
    triggerWaveFromScript = true,
    {
      spawners = "Intro_Draugr_PT",
      spawnLocators = "A1_W4_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.25
    }
  })
  Area_1_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A1_W4_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.6
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A1_W4_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4.2
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A1_W5_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5.8
    }
  })
  Area_1_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr_N_RSFA",
      spawnLocators = "A1_E_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Draugr_N_RSFA",
      spawnLocators = "A1_E_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Draugr_P_SFA",
      spawnLocators = "A1_E_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5.7
    },
    {
      spawners = "Intro_Draugr_PT",
      spawnLocators = "A1_U_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.6
    }
  })
  Area_1_Encounter_1:OnEnemySpawn(HitEnemy, {wave = 1})
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(2)
  end, {count = 1})
  Area_1_Encounter_1:OnComplete(function()
    timer.StartLevelTimer(4.5, _G.StartAwarenessTutorial)
  end, 3)
  Area_1_Encounter_1:OnStart(function()
    GameObjects.DeathOnOff:HideCollision()
  end)
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave()
  end, {count = 2, wave = 5})
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:AlertEnemies()
  end)
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_1_Spawn"))
  ZoneMonitorAggroEnemy = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Area_1_AttackZone"))
  ZoneMonitorAggroEnemy:OnEnter(function()
    if ZoneMonitorAggroEnemy ~= nil then
      ZoneMonitorAggroEnemy:Stop()
      ZoneMonitorAggroEnemy = nil
      Area_1_Encounter_1:AlertEnemies()
    end
  end)
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Arm")
    game.FindLevel("Riv100_DangersEntrance"):CallScript("CrackClimb_Enable")
    local son = game.AI.FindSon()
    son:CallScript("LuaHook_SetNextPostCombatTimerLength", 16.5)
    son:CallScript("LuaHook_IgnoreDistanceExitNextPostCombat")
    game.Audio.PlayBanter("RIV_PostFirstFight", PostFightBanterDone)
    _G.EnableContextActions()
    if ZoneMonitorAggroEnemy ~= nil then
      ZoneMonitorAggroEnemy:Stop()
      ZoneMonitorAggroEnemy = nil
    end
    _G.Area1_EncounterComplete()
    GameObjects.DeathOnOff:ShowCollision()
    _G.CheckpointAndSetBehavior()
  end)
end
function IndicatorTutorialDone()
  LD.CallFunctionAfterDelay(function()
    TUT.BackAttack_Tutorial()
  end, 1)
  LD.CallFunctionAfterDelay(function()
    Area_1_Encounter_1:StartWave(4)
  end, 5)
end
function PostFightBanterDone()
  LD.CallFunctionAfterDelay(function()
    TUT.BackAttackAdjust_Tutorial()
  end, 2)
end
function Area_1_Encounter_1_Restart()
  Area_1_Encounter_1:Restart()
end
function ReadySonTakeDown()
  GameObjects.SonTakeDownE1.LuaObjectScript.Enable()
end
function TurnOffSonTakeDown()
  GameObjects.SonTakeDownE1.LuaObjectScript.Disable()
end
function Riv085_Bookmark_EncounterComplete()
  Area_1_Encounter_1:SetComplete()
end
function HitEnemy(enemy)
  OneHitCallMonitor = monitors.CreateHealthMonitor(enemy)
  OneHitCallMonitor:OnHealthLessThan(enemy:MeterGetValue("Health") - 1, function()
    Area_1_Encounter_1:AlertEnemies()
    OneHitCallMonitor = nil
  end)
end
