LD = require("design.LevelDesignLibrary")
timer = require("level.timer")
monitors = require("level.MonitorLibrary")
collisionCheck = require("camera.collisioncheck")
local thisObj, player, son, kraPuppeteerObj, sonPuppeteerObj
local kraEnteredZoneBool = false
local btrPlayedBool = false
local cineZoneStr = "CineZone_BCDStart"
preCombatTimer = nil
btrPostFirstFightTimer = nil
btrPostFirstFightLineStr = "RIV_PostFirstFight"
playedBtrPostFirstFightBool = false
btrPostFirstFightDoneBool = false
local circleBtnMonitor
local btrZoneFirstCrackClimbStr = "BtrZone_FirstCrackClimb"
local btrFirstCrackClimbLineStr = "RIV_FirstCrackClimb"
local btrPreCrackClimb01LineStr = "RIV_PreCrackClimb01"
local btrPreCrackClimb02LineStr = "RIV_PreCrackClimb02"
local playedBtrFirstCrackClimbBool = false
local playedBtrPreCrackClimbBool = false
local preCrackClimbTimer, crossBtnMonitor
HudToggle = true
penDepth = 0.5
verticalP = 0
horizontalP = 0
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
end
function OnUpdate(level, obj)
  if game.Player.FindPlayer():IsInsideEntityZone(cineZoneStr) == true and player ~= nil and son ~= nil and kraEnteredZoneBool == false then
    kraEnteredZoneBool = true
  end
  if _G.Encounter_01Complete == true and playedBtrPostFirstFightBool == false then
    playedBtrPostFirstFightBool = true
    btrPostFirstFightTimer = timer.StartLevelTimer(2, function()
      game.Audio.PlayBanter(btrPostFirstFightLineStr)
    end)
    timer.StartLevelTimer(10, function()
      btrPostFirstFightDoneBool = true
    end)
  end
  if (IsInCombat() == true or _G.Area_1_Encounter_1 == true) and preCombatTimer ~= nil then
    if preCombatTimer.running == true then
      preCombatTimer:Stop()
    end
    preCombatTimer = nil
  end
  if btrPostFirstFightDoneBool == true and playedBtrFirstCrackClimbBool == false and playedBtrPreCrackClimbBool == false and collisionCheck.isTargetInFrustumUnobstructed(thisObj:GetWorldJointPosition(thisObj:GetJointIndex("LookAt_CrackClimb")), horizontalP, verticalP, penDepth, HudToggle) == true then
    playedBtrPreCrackClimbBool = true
    game.Audio.PlayBanterNonCritical(btrPreCrackClimb01LineStr)
    preCrackClimbTimer = timer.StartLevelTimer(25, function()
      game.Audio.PlayBanterNonCritical(btrPreCrackClimb02LineStr)
    end)
  end
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {
    enteredBool = kraEnteredZoneBool,
    playedBool = btrPlayedBool,
    playedCrackClimbBool = playedBtrFirstCrackClimbBool
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  kraEnteredZoneBool = savedInfo.enteredBool
  btrPlayedBool = savedInfo.playedBool
  playedBtrFirstCrackClimbBool = savedInfo.playedCrackClimbBool
end
function InitializeVariables()
  circleBtnMonitor = monitors.CreateCircleButtonMonitor()
  circleBtnMonitor:OnButtonDown(CircleBtnInteract)
  crossBtnMonitor = monitors.CreateCrossButtonMonitor()
  crossBtnMonitor:OnButtonDown(CrossBtnInteract)
end
function CircleBtnInteract()
  if kraEnteredZoneBool == true and btrPlayedBool == false then
    btrPlayedBool = true
    game.Audio.PlayBanter("RIV_PreFirstFight")
    preCombatTimer = timer.StartLevelTimer(8.5, PlayPreCombatBtr01)
  end
end
function CrossBtnInteract()
  if player:IsInsideEntityZone(btrZoneFirstCrackClimbStr) == true and playedBtrFirstCrackClimbBool == false and _G.Area_1_Encounter_1 == true then
    playedBtrFirstCrackClimbBool = true
    if preCrackClimbTimer ~= nil then
      if preCrackClimbTimer.running == true then
        preCrackClimbTimer:Stop()
      end
      preCrackClimbTimer = nil
    end
    game.Audio.PlayBanter(btrFirstCrackClimbLineStr)
    game.Audio.StartMusic("SND_MX_Riv_climb_1")
    crossBtnMonitor:Stop()
    crossBtnMonitor = nil
  end
end
function PlayPreCombatBtr01()
  game.Audio.PlayBanter("RIV_PreFirstFight01")
  preCombatTimer = timer.StartLevelTimer(25, PlayPreCombatBtr02)
end
function PlayPreCombatBtr02()
  game.Audio.PlayBanter("RIV_PreFirstFight02")
  preCombatTimer = timer.StartLevelTimer(25, PlayPreCombatBtr03)
end
function PlayPreCombatBtr03()
  game.Audio.PlayBanter("RIV_PreFirstFight03")
  preCombatTimer = timer.StartLevelTimer(25, PlayPreCombatBtr04)
end
function PlayPreCombatBtr04()
  game.Audio.PlayBanter("RIV_PreFirstFight04")
end
function IsInCombat()
  return player:IsTargetedByHostileAI() or son:IsTargetedByHostileAI()
end
function PlayCineIdle()
  kraPuppeteerObj = game.Puppeteer.NewForce(thisObj, "Kratos Puppet", player)
  sonPuppeteerObj = game.Puppeteer.NewForce(thisObj, "Son Puppet", son)
  local slaveArray = {
    {
      Slave = sonPuppeteerObj,
      Branch = "BRA_BCDStartIdle"
    }
  }
  sonPuppeteerObj:Clear()
  sonPuppeteerObj:AcceptSync()
  kraPuppeteerObj:Sync("BRA_BCDStartIdle", true, slaveArray, "SynchJoint_BCDStart")
  kraPuppeteerObj:OnComplete(function()
    kraPuppeteerObj = nil
  end)
  sonPuppeteerObj:OnComplete(function()
    sonPuppeteerObj = nil
  end)
end
