local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
local level_Riv100, CheckPointMonitor, startAreaCheckpoint, LootCollected2, LootCollected3, runeReadComplete, postUpComplete, arrowReminderShown, ZoneMonitorAggroEnemy, ZoneTrigger
local Encounter_01Complete = false
local queststartVolume, questStartTrigger
function OnWadLoaded(level, newLevel)
  print(newLevel.Name)
  if newLevel.Name == "WAD_Riv100_DangersEntrance" then
    level_Riv100 = game.FindLevel("Riv100_DangersEntrance")
  end
end
function OnFirstStart()
end
function OnStart(level, obj)
  SoundOnStart()
  GameObjects.Riv085_RuneRead.LuaObjectScript.GetInteractZone():SetAngle(110)
end
function Area1_EncounterComplete()
  Enable_Follow_Splines()
  GameObjects.LTW_Intro.LuaObjectScript.Disable()
  GameObjects.CA_PostUp.LuaObjectScript.Disable()
  game.AI.FindSon():CallScript("LuaHook_ToggleSlowdownStops", true)
  postUpComplete = true
  if level_Riv100 ~= nil then
    level_Riv100:CallScript("CrackClimb_Enable")
  end
end
function AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("Dangers of the World")
end
function RP_Discovered()
  LD.SetRegionDiscovered("Riverpass")
end
function TempCA_SyncExitOnAppraoch()
  timer.StartLevelTimer(2.75, function()
    GameObjects.CA_ForSyncExit_Temp.LuaObjectScript.Disable()
  end)
end
function EnableContextActions()
  GameObjects.CA_Son_ObvserveForward_02.LuaObjectScript.Enable()
  GameObjects.CA_IdleBehavior_02.LuaObjectScript.Enable()
  if not LootCollected2 then
    GameObjects.CA_Son_Item2.LuaObjectScript.Enable()
  end
  if not LootCollected3 then
    GameObjects.CA_Son_Item3.LuaObjectScript:Enable()
  end
  if not runeReadComplete then
    GameObjects.CA_PreRuneRead.LuaObjectScript.Enable()
    GameObjects.Riv085_RuneRead.Child.Child.LuaObjectScript.Enable()
  end
end
function CheckpointAndSetBehavior()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.CheckpointOverrideCbt.Child
  })
  game.AI.FindSon():CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
end
function DisableContextActions()
  game.AI.FindSon():CallScript("ClearBehaviorContext")
  GameObjects.CA_Son_ObvserveForward_02.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_02.LuaObjectScript.Disable()
  GameObjects.CA_Son_Item3.LuaObjectScript.Disable()
  GameObjects.CA_Son_Item2.LuaObjectScript.Disable()
  GameObjects.CA_Son_CrackClimbHint.LuaObjectScript:Disable()
  GameObjects.CA_PreRuneRead.LuaObjectScript:Disable()
  GameObjects.CA_ForSyncExit_Temp.LuaObjectScript:Disable()
  GameObjects.LTW_Intro.LuaObjectScript:Disable()
end
function CA_DisablePhase1()
  GameObjects.CA_Son_Item3.LuaObjectScript.Disable()
  GameObjects.CA_Son_Item2.LuaObjectScript.Disable()
  GameObjects.CA_Son_ObvserveForward_02.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_02.LuaObjectScript.Disable()
  GameObjects.CA_Son_CrackClimbHint.LuaObjectScript:Enable()
end
function HangingLootBroken_03()
  LootCollected3 = true
  GameObjects.CA_Son_Item3.LuaObjectScript.Disable()
end
function HangingLootBroken_02()
  LootCollected2 = true
  GameObjects.CA_Son_Item2.LuaObjectScript.Disable()
end
function CA_LootFound_02()
  LootCollected2 = true
  GameObjects.CA_Son_Item2.LuaObjectScript:Disable()
end
function CA_LootFound_03()
  LootCollected3 = true
  GameObjects.CA_Son_Item3.LuaObjectScript:Disable()
end
function CA_ItemEnter_02()
  GameObjects.CA_Son_Item3.LuaObjectScript.Disable()
end
function CA_ItemEnter_03()
  GameObjects.CA_Son_Item2.LuaObjectScript.Disable()
end
function CA_DisablePreRuneRead()
  runeReadComplete = true
  GameObjects.CA_PreRuneRead.LuaObjectScript.Disable()
end
function Enable_LTW_FromForest()
  GameObjects.LTW_Intro.LuaObjectScript.Enable()
  GameObjects.CA_ForSyncExit_Temp.LuaObjectScript.Enable()
  if not postUpComplete then
    game.AI.FindSon():CallScript("EnterBehaviorContext", "PRECOMBAT_BEHAVIOR_CONTEXT_CONFIG")
    GameObjects.CA_PostUp.LuaObjectScript.Enable()
    game.AI.FindSon():CallScript("LuaHook_ToggleSlowdownStops", false)
  end
end
function Enable_Follow_Splines()
  GameObjects.LTW_Intro.LuaObjectScript.Disable()
  GameObjects.LTW_Follow_Main.LuaObjectScript.Enable()
end
function StartAwarenessTutorial()
  TUT.Indicator_Tutorial_Splash_01()
  TUT.Indicator_Tutorial_Splash_02()
  TUT.Indicator_Tutorial_Splash_03()
end
function RiverPass_Demo_Bookmark_Start()
  GameObjects.Cine_BCDStart.LuaObjectScript.PlayCineIdle()
end
function Riv085_Bookmark_PostFight()
  GameObjects.Cbt_Riv085_Script.LuaObjectScript.Riv085_Bookmark_EncounterComplete()
  DisableContextActions()
end
function StartArrowReminder()
  if not arrowReminderShown then
    LD.CallFunctionAfterDelay(function()
      uiCalls.SendSidebarDesignerMessage({
        Text = 18032,
        MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
        DisplayTime = 10
      })
    end, 1.5)
    arrowReminderShown = true
  end
end
function RiverPass_Obj050_FailSafe()
  LD.CompleteQuest("Quest_RiverPass_Objective050")
end
function SoundOnStart()
  GameObjects.Riv085_RuneRead.LuaObjectScript.WallRuneReadSoundSetup()
end
function PlaySizzleSound()
  game.Audio.PlaySound("SND_EVNT_Rune_Read_Sizzle_Settlement")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    temp_postUpComplete = postUpComplete,
    runeReadComplete = runeReadComplete,
    LootCollected2 = LootCollected2,
    LootCollected3 = LootCollected3
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  postUpComplete = savedInfo.temp_postUpComplete
  runeReadComplete = savedInfo.runeReadComplete
  LootCollected2 = savedInfo.LootCollected2
  LootCollected3 = savedInfo.LootCollected3
end
