local CamCheck = require("camera.collisioncheck")
timer = require("level.timer")
checkpoint = require("level.checkpoint")
local UICALLS = require("ui.uicalls")
local player, playerPosition, son
local bIsInsideDangerVistaZone = false
local bExitedDangerVistaZone = false
local cam150RuneIsInView = false
local go_cam150RuneReadMarker
local bRuneReadInView = false
local bRune150Read = false
local fseCamZoomSonHanging
local bCamSonZoomed = false
local timer_RuneRead150 = timer.StartLevelTimer(4.2)
timer_RuneRead150:Stop()
local timer_CamSonBridgeZoom = timer.StartLevelTimer(10)
timer_CamSonBridgeZoom:Stop()
local timer_BridgeCounter = timer.StartLevelTimer(30)
timer_BridgeCounter:Stop()
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  go_cam150RuneReadMarker = level:GetGameObject("Marker_RuneRead150")
  fseCamZoomSonHanging = {
    EffectName = "FSE_SWAY_CAM_TRANSITION_00",
    Duration = 5,
    TweenInTime = 0.8,
    TweenInEaseIn = 1,
    TweenOutTime = 2,
    TweenOutEaseIn = 1
  }
end
function OnUpdate(level)
  if player == nil then
    player = game.Player.FindPlayer()
  end
  playerPosition = player.WorldPosition
  VistaCameraUpdate()
  if bRune150Read == false then
    if game.World.IsInsideCameraZone(playerPosition, "CamZoneRuneRead_Riv150") then
      cam150RuneIsInView = CamCheck.isTargetInFrustum(go_cam150RuneReadMarker:GetWorldPosition(), 0, 0, 0.4, false)
      if son ~= nil and son:HasMarker("Reading") then
        if cam150RuneIsInView == true and bRuneReadInView == false then
          bRuneReadInView = true
          timer_RuneRead150:Start()
        end
        if timer_RuneRead150.running == true and timer_RuneRead150.fired == false then
          game.Camera.SubmitCameraByName("PLYR_RuneRead_Focus")
        end
      end
    end
    if timer_RuneRead150.fired == true then
      bRune150Read = true
    end
  end
end
function PrintTouchString(string)
  UICALLS.UI_Event_SendDesignerMessage(string, 2)
end
function VistaCameraUpdate()
  if bExitedDangerVistaZone == false then
    if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_Vista_DangersAhoy") == true then
      if bIsInsideDangerVistaZone == false then
        timer_BridgeCounter:Start()
      end
      local elapsedTime = timer_BridgeCounter:GetElapsedTime()
      if 5.1 < elapsedTime and bCamSonZoomed == false then
        game.FX.SubmitEffect(fseCamZoomSonHanging)
        timer_CamSonBridgeZoom:Reset()
        timer_CamSonBridgeZoom:Start()
        bCamSonZoomed = true
        timer.StartLevelTimer(4, function()
          bExitedDangerVistaZone = true
        end)
      end
      bIsInsideDangerVistaZone = true
      game.Camera.SubmitCameraByName("ENV_Nar_Dangers_Ahoy")
      if timer_CamSonBridgeZoom.running == true and timer_CamSonBridgeZoom.fired == false then
        game.Camera.SubmitCameraByName("PLYR_Nar_Dangers_Ahoy_SonLookAt")
      end
    elseif bIsInsideDangerVistaZone == true then
      bExitedDangerVistaZone = true
    end
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    temp_bExitedDangerVistaZone = bExitedDangerVistaZone,
    temp_bIsInsideDangerVistaZone = bIsInsideDangerVistaZone,
    temp_bRune150Read = bRune150Read
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  bExitedDangerVistaZone = savedInfo.temp_bExitedDangerVistaZone
  bIsInsideDangerVistaZone = savedInfo.temp_bIsInsideDangerVistaZone
  bRune150Read = savedInfo.temp_bRune150Read
end
function OnUseWorld(level)
end
function OnEvaluateLoadGroup_LoadGroup_AI()
  if game.Level.GetVariable("CompletedCineNumber") < 115 then
    return "BridgeCollapse"
  else
    return nil
  end
end
