local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local actor = require("narrative.actor")
local thisObj, thisLevel, crackClimbBanter
local passedCrackClimbHelpBanter = false
local draugrKnockNumber = 0
HudToggle = true
penDepth = 0.5
verticalP = 0
horizontalP = 0
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function PostBridgefallFighBanter()
  game.Audio.PlayBanter("RIV_PitFight_Post", postFight1banterComplete)
end
function postFight1banterComplete()
  _G.CA_Area0_Enable()
  _G.Quest_Objective085_Complete()
  _G.EnableRavenSound()
end
function ApproachingRuneRead()
  local sonActor = actor.Actor.New("Son", game.AI.FindSon)
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "preRuneMarker_Banter")
  cineSeq:Do(function()
    GameObjects.SonKnowledge_UnderBridge.Child.Child.LuaObjectScript.Enable()
  end)
  cineSeq:WaitForActorInZone(sonActor, GameObjects.SonKnowledge_UnderBridge_BtrZone)
  cineSeq:WaitSeconds(0.25)
  cineSeq:Do(function()
    game.Audio.PlayBanter("RIV_PreRuneMarker")
  end)
  cineSeq:StartSequence()
end
function RuneReadStart()
  GameObjects.CA_Area1_PreRune.LuaObjectScript.Disable()
end
function DraugrBreakThroughBanter_Knock1()
  draugrKnockNumber = draugrKnockNumber + 1
  if draugrKnockNumber == 1 then
    timer.StartLevelTimer(1, function()
      game.Audio.PlayBanter("RIV_DraugrBurstOutOfWall_01")
    end)
  elseif 2 < draugrKnockNumber then
    draugrKnockNumber = 0
  end
end
function DraugrBreakThroughBanter_Knock2()
  timer.StartLevelTimer(0.1, function()
    game.Audio.PlayBanter("RIV_DraugrBurstOutOfWall_03")
  end)
end
function CrackClimb_HintBanter()
  if not crackClimbBanter then
    crackClimbBanter = true
    local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "crackClimb_HintBanter")
    crackClimbBanter = true
    cineSeq:Do(PlayHint1_IfNeeded)
    cineSeq:WaitSeconds(20)
    cineSeq:Do(PlayHint2_IfNeeded)
    cineSeq:StartSequence()
  end
end
function StartClimbMonitor()
  MonitorForCrackClimb()
end
function PlayHint1_IfNeeded()
  if not passedCrackClimbHelpBanter then
    game.Audio.PlayBanter("RIV_BrokenWallHint_1")
  end
end
function PlayHint2_IfNeeded()
  if not passedCrackClimbHelpBanter then
    game.Audio.PlayBanter("RIV_BrokenWallHint_2")
  end
end
function MonitorForCrackClimb()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "crackClimb_Detection")
  seq:WaitForFunctionTrue(function()
    return game.Player.FindPlayer():IsPlayingMove("MOV_Crack_Climb_Up_Enter")
  end)
  seq:Do(function()
    passedCrackClimbHelpBanter = true
  end)
  seq:StartSequence()
end
function OnSaveCheckpoint(level, obj)
  return {playedCrackClimbHintBanter = passedCrackClimbHelpBanter, crackClimbBanter = crackClimbBanter}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  passedCrackClimbHelpBanter = savedInfo.playedCrackClimbHintBanter
  crackClimbBanter = savedInfo.crackClimbBanter
end
