local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local CCEC = require("camera.camera_cineentercamera")
local TUT = require("game.GlobalTutorials")
local thisObj, thisLevel, son
local btrHelp01LineStr = "RIV_RicketyBridge_Idle1"
local btrHelp02LineStr = "RIV_RicketyBridge_Idle2"
local btrHelp03LineStr = "RIV_RicketyBridge_Idle3"
local kratosActor, sonActor, debrisLift, wholeBridgeBreakable, sonBoardsBreakable, tutorialcomplete
local bSonInPlace = false
local cineEnterCamera_BridgeFallEnter, cineEnterCamera_BridgeFall
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  game.SubObject.Sleep(thisObj)
end
function OnStart(level, obj)
  CreateActorsAndProps()
end
function StartCineEnter_BridgeFall()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_BridgeFall = CCEC.CineEnterCamera.New("ENV_CineEnter_BridgeFall", 7)
  cineEnterCamera_BridgeFall:SetCallback(DestroyCineEnter_BridgeFall)
  cineEnterCamera_BridgeFall:Start()
  _G.SpawnDraugrs()
end
function DestroyCineEnter_BridgeFall()
  cineEnterCamera_BridgeFall = nil
  game.SubObject.Sleep(thisObj)
end
function StartCineEnter_BridgeFallEnter()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_BridgeFallEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_BridgeFallEnter", 7)
  cineEnterCamera_BridgeFallEnter:SetCallback(DestroyCineEnter_BridgeFallEnter)
  cineEnterCamera_BridgeFallEnter:Start()
end
function DestroyCineEnter_BridgeFallEnter()
  cineEnterCamera_BridgeFallEnter = nil
  game.SubObject.Sleep(thisObj)
end
function OnUpdate()
  if cineEnterCamera_BridgeFallEnter ~= nil then
    cineEnterCamera_BridgeFallEnter:Update()
  end
  if cineEnterCamera_BridgeFall ~= nil then
    cineEnterCamera_BridgeFall:Update()
  end
end
function CreateActorsAndProps()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  debrisLift = GameObjects.DebrisLift_Riv200.Child
  wholeBridgeBreakable = GameObjects.riv200_Bridge_break_01
  sonBoardsBreakable = GameObjects.riv200_Bridge_break_00_sonStep
  if game.Level.GetVariable("CompletedCineNumber") < 115 then
    wholeBridgeBreakable:JumpAnimToFrame(1)
    sonBoardsBreakable:JumpAnimToFrame(1)
    wholeBridgeBreakable:PauseAnim()
    sonBoardsBreakable:PauseAnim()
  else
    wholeBridgeBreakable:JumpAnimToPercent(0.99)
    sonBoardsBreakable:JumpAnimToPercent(0.99)
    wholeBridgeBreakable:PauseAnim()
    sonBoardsBreakable:PauseAnim()
    HideSonBoards()
  end
end
function BridgeFallEnter()
  if game.Level.GetVariable("CompletedCineNumber") < 115 then
    local cineSeq = LD.CreateCineSequence(thisLevel, debrisLift, "bridgeFall")
    local bridgeFallEnter_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_BridgeFallEnter"
      },
      {
        Obj = debrisLift,
        Anim = "narRivBridgeFall000Enter"
      }
    }
    local bridgeFall_ActorTable = {
      {Actor = sonActor}
    }
    debrisLift.LuaObjectScript.EnableCinematicTrigger()
    cineSeq:RequestCineModeAndWait(kratosActor, thisObj)
    cineSeq:Do(StartCineEnter_BridgeFallEnter)
    cineSeq:WaitForLoadCheck("Riv200_c115_BridgeCollapse")
    cineSeq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_BridgeFallEnter",
      ReferenceJoint = "synchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = ND.StopTurnRadius,
      weapon_state = "bare_on_back"
    })
    cineSeq:ActorSync(kratosActor, {
      Slaves = bridgeFallEnter_ActorTable,
      Branch = "BRA_BridgeFallEnter",
      ReferenceJoint = "synchJoint"
    })
    cineSeq:Do(BridgeHoleBreak)
    cineSeq:WaitUntilActorAnimPastFrame(kratosActor, 190)
    cineSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    cineSeq:Do(function()
      game.Player.FindPlayer():ClearAccelerationOverride()
    end)
    cineSeq:Do(function()
      debrisLift.LuaObjectScript:Disable()
    end)
    cineSeq:Do(SonUnavailableForCombat)
    cineSeq:Do(StartCryHelpLoop)
    cineSeq:WaitForActorInZone(kratosActor, thisObj)
    cineSeq:RequestCineModeAndWait(kratosActor, thisObj)
    cineSeq:Do(StartCineEnter_BridgeFall)
    cineSeq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_BridgeFall",
      ReferenceJoint = "synchJoint",
      speed = ND.KraRunSpeed,
      stop = false,
      foot = game.Creature.Foot.kLeft,
      radius = ND.RunArrivalRadius,
      weapon_state = "bare_on_back"
    })
    cineSeq:ActorSync(kratosActor, {
      Slaves = bridgeFall_ActorTable,
      Branch = "BRA_BridgeFall",
      ReferenceJoint = "synchJoint"
    })
    cineSeq:SetPostSkipMusic("SND_MX_RIV_start_master", "SND_MX_SonSick_master", nil, nil, nil, "SND_MX_Riv_fight_3_in")
    cineSeq:Do(function()
      cineSeq:MarkAbleToSkip()
    end)
    cineSeq:Do(BreakFullBridge)
    cineSeq:WaitUntilActorAnimPastFrame(kratosActor, 535)
    cineSeq:Do(HideAshPouch)
    cineSeq:WaitUntilActorAnimPastFrame(kratosActor, 868)
    cineSeq:Do(ShowAshPouch)
    cineSeq:WaitUntilActorAnimPastFrame(kratosActor, 1320)
    cineSeq:Do(HideSonBoards)
    cineSeq:Do(function()
      _G.AlertDraugr_7()
    end)
    cineSeq:Do(function()
      cineSeq:EndSkipIfActive()
    end)
    cineSeq:WaitSeconds(1.6)
    cineSeq:Do(function()
      TUT.EnemyLevel_Tutorial()
    end)
    cineSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    cineSeq:WaitForFunctionTrue(CheckEnemyTutorialComplete)
    cineSeq:Do(function()
      _G.AlertDraugrs()
    end)
    cineSeq:Do(function()
      _G.LevelBridgeCineComplete()
    end)
    cineSeq:SetCompletedCineNumber(115)
    cineSeq:StopPuppetingActor(kratosActor)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:Do(SonAvailableForCombat)
    cineSeq:StartSequence()
  end
end
function CheckEnemyTutorialComplete()
  return tutorialcomplete
end
function EnemyLevelTutorialComplete()
  tutorialcomplete = true
end
function StartCryHelpLoop()
  print("============== LOOPING HELP ME BANTER ==============")
  timer.StartLevelTimer(2, function()
    if not bSonInPlace then
      game.Audio.PlayBanter(btrHelp01LineStr)
      timer.StartLevelTimer(5, function()
        if not bSonInPlace then
          game.Audio.PlayBanter(btrHelp02LineStr)
          timer.StartLevelTimer(9, function()
            if not bSonInPlace then
              game.Audio.PlayBanter(btrHelp03LineStr)
            end
          end)
        end
      end)
    end
  end)
end
function EnableLeadTheWay()
  GameObjects.BridgeCollapse_LeadTheWay.LuaObjectScript:Enable()
  GameObjects.BridgeCollapse_YouShallNotPass.LuaObjectScript:Enable()
end
function DisableLeadTheWay()
  GameObjects.BridgeCollapse_LeadTheWay.LuaObjectScript:Disable()
  GameObjects.BridgeCollapse_YouShallNotPass.LuaObjectScript:Disable()
end
function BridgeHoleBreak()
  print("=========== BRIDGE HOLE BREAK=============")
  sonBoardsBreakable:PlayAnimToEnd()
end
function SonUnavailableForCombat()
  local availabilityState = {
    AvailableInLevel = true,
    AvailableForBanter = true,
    AvailableForSync = true,
    AvailableForCombat = false,
    Unoccupied = false
  }
  son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function SonAvailableForCombat()
  son:RemoveAvailabilityRequest("LevelDesignScript")
end
function HideAshPouch()
  kratosActor:GetCreature():CallScript("HideAshPouch")
end
function ShowAshPouch()
  kratosActor:GetCreature():CallScript("ShowAshPouch")
end
function HideSonBoards()
  sonBoardsBreakable:Hide()
end
function SonWait()
  son:SetMaxSpeedOverride(0)
end
function SonResume()
  son:ClearMaxSpeedOverride()
end
function BreakFullBridge()
  wholeBridgeBreakable:PlayAnimToEnd()
  _G.LevelBridgeBreak()
  bSonInPlace = true
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, gameInfo)
  if game.Level.GetVariable("CompletedCineNumber") >= 115 then
    wholeBridgeBreakable:JumpAnimToPercent(0.99)
    HideSonBoards()
  end
end
