local LD = require("design.LevelDesignLibrary")
local thisObj
function OnScriptLoaded(level, obj)
  thisObj = obj
  SoundInit()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  SoundOnStart()
end
function BrokenClasp()
  print("BrokenClasp")
  thisObj:FindSingleGOByName("Bridge3Anim"):PlayAnimToEnd()
  thisObj:FindSingleGOByName("InvisSheetCol"):HideCollision()
  PlaySoundOnBreak()
end
local soundEmitter, SHookRef
local soundEvents = {
  isLooping = true,
  OnDrawBridgeFall = "SND_MECH_Wood_Bridge_Lower_LP_Riv200",
  OnDrawBridgeFallFrame = -1,
  OnDrawBridgeEnd = "SND_MECH_Wood_Bridge_Lower_Stop_End_Riv200",
  OnDrawBridgeEndFrame = -1,
  HookSounds = {
    OnBreak = "SND_MECH_Wood_Bridge_S_Hook_Break_Riv200"
  }
}
function SoundInit()
  SHookRef = thisObj:FindSingleGOByName("S_CurveBreakable_DrawBridge")
  soundEmitter = thisObj:FindSingleGOByName("Bridge3Anim"):FindSingleSoundEmitterByName("SNDBridge")
end
function SoundOnStart()
  SHookRef.LuaObjectScript.SoundSetup(soundEvents.HookSounds)
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(soundEvents[key]))
    end
  end
end
function PlaySoundOnBreak()
  if soundEvents.isLooping then
    local anim = thisObj:FindSingleGOByName("Bridge3Anim")
    if soundEvents.OnDrawBridgeEndFrame < 1 then
      soundEvents.OnDrawBridgeEndFrame = anim.AnimLengthFrames - 3
    end
    LD.PlaySoundOnFrame(soundEmitter, anim, soundEvents.OnDrawBridgeFall, soundEvents.OnDrawBridgeFallFrame, "forward")
    LD.StopSoundOnFrame(soundEmitter, anim, soundEvents.OnDrawBridgeFall, soundEvents.OnDrawBridgeEndFrame, "forward")
    LD.PlaySoundOnFrame(soundEmitter, anim, soundEvents.OnDrawBridgeEnd, soundEvents.OnDrawBridgeEndFrame, "forward")
  else
    LD.PlaySound(soundEmitter, soundEvents.OnDrawBridgeFall)
  end
end
