local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, kratosActor, brokActor
local banterPlayed = {}
local firstChainBridgeSolved = false
local chainBridge_HintsStarted = false
local prepChainBridgeHint04 = false
local pulleyBridgeFailures = 0
local pulleyBridgeMisses = 0
local SlowZoneMonitor, player
local Btr_PullYourWeightStarted = false
function OnScriptLoaded(level, go)
  thisObj = go
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(thisObj)
  kratosActor = actor.Actor.New("Kratos_Actor", game.Player.FindPlayer)
end
function OnFirstStart()
  SlowZoneMonitor = monitors.CreateEntityZoneMonitor(player, GameObjects.BanditCamp_SpeedControl)
  SlowZoneMonitor:OnEnter(StartDecelOveride)
  SlowZoneMonitor:OnExit(StopDecelOveride)
end
function OnStart()
  if not prepChainBridgeHint04 then
    GameObjects.BtrZone_ChainBridgeHint04:Hide()
  end
  if not banterPlayed.shopFight05_A then
    GameObjects.BtrZone_GateCommit:Hide()
  end
  if Btr_PullYourWeightStarted then
    PullYourWeight_Played()
    GameObjects.BanterTimed_SpikeDoor.LuaObjectScript.StartFromBeginning()
  else
    GameObjects.Btr_SpikeDoorHint:HideEntityVolume()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  savedInfo.Btr_PullYourWeightStarted = Btr_PullYourWeightStarted
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    banterPlayed = savedInfo.banterPlayed
    Btr_PullYourWeightStarted = savedInfo.Btr_PullYourWeightStarted
  end
end
function Btr_RIV_BanditCampApproach()
  if not banterPlayed.banditCampApproach then
    game.Audio.PlayBanter("RIV_BanditCampApproach", function()
      RemoveBridgeNoPass()
      RemoveBanditSpeedControl()
    end)
    banterPlayed.banditCampApproach = true
    local availabilityState = {Unoccupied = false}
    game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  end
end
function StartDecelOveride()
  player:SetDecelerationOverride(1.3)
  player:SetAccelerationOverride(0.9)
  player:SetMaxSpeedOverride(1.5)
end
function StopDecelOveride()
  player:ClearMaxSpeedOverride()
  player:ClearDecelerationOverride()
  LD.CallFunctionAfterDelay(function()
    player:ClearAccelerationOverride()
  end, 1)
end
function RemoveBridgeNoPass()
end
function RemoveBanditSpeedControl()
  GameObjects.BanditCamp_SpeedControl:HideEntityVolume()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  if SlowZoneMonitor ~= nil then
    SlowZoneMonitor:Stop()
    StopDecelOveride()
  end
end
function HideTreePatch()
  GameObjects.Static_trees:Hide()
end
function ShowTreePatch()
  GameObjects.Static_trees:Show()
end
function DidntSeeSequence()
  local didntSeeSeq = ND.CreateCineSequence(thisLevel, thisObj, "didntSee")
  didntSeeSeq:WaitForActorInZone(kratosActor, GameObjects.BtrZone_DidntSee)
  didntSeeSeq:Do(function()
    game.Audio.PlayBanterNonCritical("DidntSee_Son")
  end)
  didntSeeSeq:Do(function()
    banterPlayed.didntSee = true
  end)
  didntSeeSeq:StartSequence()
end
function ICanFightNow_Banter()
  if not banterPlayed.iCanFightNow then
    ChainBridge_FirstChainBroken()
    banterPlayed.iCanFightNow = true
    game.Audio.PlayBanter("RIV_ICanFightNow", ICanFightNow_Complete)
  else
    ChainBridge_SecondChainBroken()
  end
end
function ICanFightNow_Complete()
  if not firstChainBridgeSolved then
    GameObjects.BrtZone_ChainBridgeHint03:ShowEntityVolume()
    if game.Player.FindPlayer():InsideZone(GameObjects.BrtZone_ChainBridgeHint03) then
      GameObjects.ChainBridgeHint03_BanterTimed.LuaObjectScript.StartFromBeginning()
    end
  end
end
function ChainBridge_FirstChainBroken()
  GameObjects.ChainBridgeHint01_BanterTimed.Child.LuaObjectScript.Cancel()
end
function ChainBridgeHints_TriptychFightOver()
  if chainBridge_HintsStarted then
    if not firstChainBridgeSolved then
      timer.StartLevelTimer(4.5, function()
        game.Audio.PlayBanter("RIV_ChainBridgeHint02")
      end)
    end
  else
    prepChainBridgeHint04 = true
  end
end
function ChainBridge_HintsStarted()
  if not prepChainBridgeHint04 then
    chainBridge_HintsStarted = true
  else
    GameObjects.BtrZone_ChainBridgeHint04:Show()
  end
end
function ChainBridge_SecondChainBroken()
  GameObjects.ChainBridgeHint03_BanterTimed.Child.LuaObjectScript.Cancel()
  firstChainBridgeSolved = true
  game.Audio.PlayBanterNonCritical("RIV_ChainBridgeHint05")
end
function ChainBridgeHint04_Banter()
  if not firstChainBridgeSolved then
    timer.StartLevelTimer(5, function()
      if game.Player.FindPlayer():InsideZone(GameObjects.BtrZone_ChainBridgeHint04) then
        GameObjects.BtrZone_ChainBridgeHint04:Hide()
        prepChainBridgeHint04 = false
        game.Audio.PlayBanter("RIV_ChainBridgeHint04")
      end
    end)
  else
    GameObjects.BtrZone_ChainBridgeHint04:Hide()
    prepChainBridgeHint04 = false
  end
end
function Hide_BackToTopHint()
  GameObjects.Btr_BackToTopHint:Hide()
end
function PulleyBridge01_Banter()
  pulleyBridgeFailures = pulleyBridgeFailures + 1
  if pulleyBridgeFailures == 1 then
    game.Audio.PlayBanter("RIV_PulleyBridge01_A")
  elseif pulleyBridgeFailures == 2 then
    game.Audio.PlayBanter("RIV_PulleyBridge03_A")
  elseif pulleyBridgeFailures == 5 then
    game.Audio.PlayBanter("RIV_PulleyBridge03_B")
  elseif pulleyBridgeFailures == 8 then
    game.Audio.PlayBanter("RIV_PulleyBridge03_C")
  end
end
function PulleyBridge02_Banter()
  if pulleyBridgeMisses == 0 then
    game.Audio.PlayBanter("RIV_PulleyBridge02_A", function()
      pulleyBridgeMisses = 1
    end)
  elseif pulleyBridgeMisses == 1 then
    game.Audio.PlayBanter("RIV_PulleyBridge02_B", function()
      pulleyBridgeMisses = 2
    end)
  end
end
function ShopFight_OnBegin()
  local LM = require("level.loadmonitor")
  local loadMonitor = LM.CreateLoadMonitor()
  loadMonitor:AddCallback({
    Wads = {
      "Riv260_ShopIntroCN"
    },
    Functions = {
      AIWadLoaded
    }
  })
  engine.SendHook("LuaHook_SuppressCombat", game.AI.FindSon(), true)
end
function AIWadLoaded(wads)
  wads.Riv260_ShopIntroCN:GetGameObject("Cine_BrokIntro"):CallScript("StartBrokSonHide")
end
function ShopFight_OnFirstKill()
  if not banterPlayed.shopFight03 then
    game.Audio.PlayBanter("RIV_ShopFight_03")
    banterPlayed.shopFight03 = true
  end
end
function Btr_BackHereAgain()
  game.Audio.PlayBanter("RIV_BackHereAgain")
end
function ShopFight_SonHideOver()
  engine.SendHook("LuaHook_SuppressCombat", game.AI.FindSon(), false)
  game.FindLevel("Riv260_ShopIntroCN"):GetGameObject("Cine_BrokIntro"):CallScript("EndBrokSonHide")
end
function Set_ShopFight05_A_Played()
  banterPlayed.shopFight05_A = true
  Quest_RiverPass_Objective370_End()
  UnlockBrokBestiaryEntry()
  GameObjects.BtrZone_GateCommit:Show()
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.ChkOvr_HuldraCamp
  })
end
function Should_GateCommit_Play()
  return banterPlayed.shopFight05_A and game.Level.GetVariable("CompletedCineNumber") < 135
end
function GateCommit_Finished()
  banterPlayed.GateCommit = true
  game.FindLevel("Riv300_CalderaVistaLH"):GetGameObject("Riv300_Banter"):CallScript("Set_GateCommit_Played")
end
function Quest_RiverPass_Objective370_End()
  game.SubmitActivityFeedStory("02_BrokIntro")
  uiCalls.UI_Event_SendMsgToQuestLog({
    Category = 10250,
    Header = 9086,
    Body = 37223,
    MessageType = tweaks.tQuestUiMessage.eMessageType.kQMS_Default,
    Quest = "Quest_RiverPass_Objective375"
  })
end
function UnlockBrokBestiaryEntry()
  LD.UnlockBestiaryEntry("Bestiary_Unlock_Brok")
end
function PullYourWeight_Started()
  Btr_PullYourWeightStarted = true
end
function PullYourWeight_Played()
  Btr_PullYourWeightStarted = false
  GameObjects.BanterTimed_SpikeDoor.LuaObjectScript.ShowEntityZones()
end
function FirstPanelOpen()
  Btr_PullYourWeightStarted = false
  GameObjects.BanterTimed_SpikeDoor.LuaObjectScript.Cancel()
end
