local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local CamCheck = require("camera.collisioncheck")
local TUT = require("game.GlobalTutorials")
local CSL = require("camera.shakelibrary")
local son, player, thisLevel, playerPosition, go_camRuneReadMarker, riv260, riv250
local camRuneIsInView = false
local timer_RuneRead200 = timer.StartLevelTimer(4.6)
timer_RuneRead200:Stop()
local bRuneReadInView200 = false
River_NAR_BanditFightDone = false
local alertCalledOnce = false
local DisableRopeDropMonitor, bridgeCollapseComplete, counterWeightHit, counterWeightWin, ravenKilled
Banter_PrePitFight = nil
Banter_PostPitFight = nil
timesBridgeFXPlayed = 0
local drawBridgeBreakableScript
local DrawBridgeHit = 0
temp_DrawBridgeHit = 0
local wallPressComplete, quickClearUsed
local AlertDraugr01 = 2.5
local AlertDraugr02 = 4.5
local AlertDraugr03 = 12
local AlertDraugr04 = 18
local AlertDraugr05 = 24
local AlertDraugr06 = 32
local AlertDraugr07 = 39
local PillarBreakKnock01 = 0.6
local PillarBreakKnock02 = 2.2
local lookAtMonitorTime = 2
local playerLookedAtPillar = false
local pillarOnScreen = false
local pillarAnimStarted = false
local playerInsideSafeZone = false
local MonitorBridgeFinale, lookatbridgeencounter
pitFight1Complete = false
pitFight2Complete = false
runeInteractComplete = false
local Enemy_HealthMonitor, ZM_A4_Attack
local BridgeCollapeCheckpoint = false
local BridgeEncounter, BridgeEncounter2, Area_1_Encounter_3, Area_1_Encounter_4, FinaleSafeZone, MonitorFinaleZone, AxeUpgradeEncounter
local trollFinale = false
local Area_2_Encounter_1, Area_2_Encounter_2
Area_3_Encounter_1H = nil
Area_3_Encounter_1 = nil
Area_3_Encounter_2 = nil
Area_3_Encounter_3 = nil
Area_3_Encounter_4 = nil
Area_4_Encounter_2 = nil
Area_5_Encounter_1 = nil
A3_ZM_1 = nil
local dragurIntro1, dragurIntro2, dragurIntro3, dragurIntro4, dragurIntro5, dragurIntro6, dragurIntro7
RuneRead = false
arrowSwapDone = false
local SND_PillarKnock
local draugrKnockNumber = 0
local pillarBreakBanterADone = false
local pillarBreakBanterBDone = false
local pillarBreak_LookAtMonitor
local pillarBreak_playerHasLooked = false
local pillarObject
function OnScriptLoaded(level, obj)
  thisLevel = level
  son = game.AI.FindSon()
  player = game.Player.FindPlayer()
  Area_1_Fight_1()
  Area_1_Fight_2()
  Area_1_Fight_3()
  Area_1_Fight_4()
  Area_3_Fight_1()
  Area_3_Fight_2()
  Area_3_Fight_3()
  Area_3_Fight_4()
  Axe_Upgrade_Encounter()
  drawBridgeBreakableScript = GameObjects.DrawBridge3:FindSingleGOByName("s_hook_brk").LuaObjectScript
  go_camRuneReadMarker = thisLevel:GetGameObject("Marker_RuneRead200")
  CbtRiv200Init(level)
  SoundInit()
end
function OnFirstPreStart(level, obj)
  GameObjects.DrawBridge3.Child:StartAnim("envRiv225DrawbridgeLift")
  GameObjects.DrawBridge3.Child:JumpAnimToFrame(0)
  GameObjects.DrawBridge3.Child:PauseAnim()
  GameObjects.WheelCrankRiv200.LuaObjectScript.SetDrivenObject(GameObjects.DrawBridge3.Child)
  drawBridgeBreakableScript.HideBreakableBehavior()
end
function OnFirstStart()
  GameObjects.bridge_down_cardproxy:HideCollision()
end
function OnStart(level)
  if AxeUpgradeEncounter:WasRunning() then
    AxeUpgradeEncounter:Start()
    game.Combat.TurnOnAndLockCombatStatus()
  end
  if bridgeCollapseComplete == true then
    if pitFight1Complete == false then
      BridgeEncounter:Start()
      GameObjects.BridgeCollapseCollision:HideCollision()
      timer.StartLevelTimer(0.1, AlertDraugrs)
    elseif pitFight1Complete == true and runeInteractComplete == false then
      GameObjects.Btr_PitFight.LuaObjectScript.postFight1banterComplete()
    elseif pitFight1Complete == true and runeInteractComplete == true and pitFight2Complete == false then
      PillarBreakA_Seq()
    end
  end
  SoundOnStart()
  if not ravenKilled then
    if game.Level.GetVariable("CompletedCineNumber") < 115 then
      GameObjects.Raven_Perch.LuaObjectScript.DisableIdleLoop()
    else
      GameObjects.Raven_Perch.LuaObjectScript.PlayIdleLoop()
    end
  end
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    GameObjects.axebridge01_down_01:Hide()
    GameObjects.axebridge01_down_02:Hide()
  else
    GameObjects.axebridge01_down_01:Show()
    GameObjects.axebridge01_down_02:Show()
    GameObjects.My_AxeBridge01:Hide()
    GameObjects.My_AxeBridge02:Hide()
  end
  if game.Level.GetVariable("CompletedCineNumber") < 115 then
    GameObjects.Riv200_Traversepaths:HideTraversePath()
    GameObjects.LoadZone_PitArea:HideEntityVolume()
    GameObjects.LoadZone_AddCave:HideEntityVolume()
    GameObjects.TL_BridgeRetreversal:HideTraversePath()
    GameObjects.riv200_bridge_final_pos:Hide()
    GameObjects.TL_DrawBridge_01:HideTraverseLink()
    GameObjects.TL_BonusBridge:HideTraverseLink()
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 120 and game.Level.GetVariable("CompletedCineNumber") < 130 then
    local availabilityState = {
      AvailableForSync = true,
      AvailableForBanter = true,
      AvailableInLevel = true,
      AvailableForCombat = false
    }
    son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 339 then
    Area_3_Encounter_3:Start()
    EnableBridgeLTW()
    GameObjects.DebrisLift_VineBlocker:Show()
    GameObjects.DebrisLift_Riv200.LuaObjectScript:Disable()
    GameObjects.EntZn_NoBackTrackMsg:HideEntityVolume()
  else
    GameObjects.DebrisLift_VineBlocker:Hide()
  end
  GameObjects.BtrZones_ChainBridgeHint01:HideEntityVolume()
end
function RavenHit()
  ravenKilled = true
end
function EnableRavenSound()
  if not ravenKilled then
    GameObjects.Raven_Perch.LuaObjectScript.PlayIdleLoop()
  end
end
function OnUpdate(level)
  playerPosition = player.WorldPosition
  if son == nil then
    son = game.AI.FindSon()
  end
  if LD.GetEntityVariable("FT_Riv200Loaded") then
    LD.SetEntityVariable("FT_Riv200Loaded", false)
  end
  if LD.GetEntityVariable("FT_Riv200Loaded") then
    LD.SetEntityVariable("FT_Riv200Loaded", false)
  end
  if River_NAR_BanditFightDone == false then
    local banditfightDone = game.Level.GetVariable("RIV_NAR_BanditFightDone")
    if banditfightDone ~= River_NAR_BanditFightDone then
      River_NAR_BanditFightDone = banditfightDone
    end
  end
  if game.Player.FindPlayer():IsInsideEntityZone("Zone_SonEnterZone") then
    GameObjects.Zone_SonEnterZone:Destroy()
  end
  if game.World.IsInsideCameraZone(playerPosition, "CamZoneRuneRead_Riv200") then
    camRuneIsInView = CamCheck.isTargetInFrustum(go_camRuneReadMarker:GetWorldPosition(), 0, 0, 0.4, false)
    if son ~= nil and son:HasMarker("Reading") then
      if camRuneIsInView == true and bRuneReadInView200 == false then
        bRuneReadInView200 = true
        timer_RuneRead200:Start()
      end
      if timer_RuneRead200.running == true and timer_RuneRead200.fired == false then
        game.Camera.SubmitCameraByName("PLYR_RuneRead_Focus")
      end
    end
  end
end
function EnableDebrisLift()
end
function AlertDraugrs()
  if not alertCalledOnce then
    timer.StartLevelTimer(AlertDraugr01, AlertDragur_1)
    timer.StartLevelTimer(AlertDraugr02, AlertDragur_2)
    timer.StartLevelTimer(AlertDraugr03, AlertDragur_3)
    timer.StartLevelTimer(AlertDraugr04, AlertDragur_4)
    timer.StartLevelTimer(AlertDraugr05, AlertDraugr_5)
    timer.StartLevelTimer(AlertDraugr06, AlertDraugr_6)
    timer.StartLevelTimer(AlertDraugr07, AlertDraugr_7)
    timer.StartLevelTimer(2.5, function()
      game.Audio.PlayBanter("RIV_PitFight_Pre")
    end)
    game.Audio.SetBanterFact("CreatureSpawnCooldown", "True", 20)
    game.Audio.SetBanterFact("GeneralCombatCooldown", "True", 3)
    if alertCalledOnce == false then
      print("---------------------------------------alertcalledonce is: " .. tostring(alertCalledOnce))
    end
    alertCalledOnce = true
  else
    print("---------------------------------------alertcalledonce is: " .. tostring(alertCalledOnce))
  end
  StartQuickClearCheck()
  timer.StartLevelTimer(20, RunicAttackReminder)
end
function AlertDragur_1()
  local dragurIntro1 = LD.FindSingleAIByMarker("InitialSpawn01")
  if dragurIntro1 ~= nil then
    dragurIntro1:TriggerMoveEvent("kLEAlert")
  end
end
function AlertDragur_2()
  local dragurIntro2 = LD.FindSingleAIByMarker("InitialSpawn02")
  if dragurIntro2 ~= nil then
    dragurIntro2:TriggerMoveEvent("kLEAlert")
  end
end
function AlertDragur_3()
  dragurIntro3 = LD.FindSingleAIByMarker("InitialSpawn03")
  if dragurIntro3 ~= nil then
    dragurIntro3:TriggerMoveEvent("kLEAlert")
  end
end
function AlertDragur_4()
  dragurIntro4 = LD.FindSingleAIByMarker("InitialSpawn04")
  if dragurIntro4 ~= nil then
    dragurIntro4:TriggerMoveEvent("kLEAlert")
  end
end
function AlertDraugr_5()
  dragurIntro5 = LD.FindSingleAIByMarker("InitialSpawn05")
  if dragurIntro5 ~= nil then
    dragurIntro5:TriggerMoveEvent("kLEAlert")
  end
end
function AlertDraugr_6()
  dragurIntro6 = LD.FindSingleAIByMarker("InitialSpawn06")
  if dragurIntro6 ~= nil then
    dragurIntro6:TriggerMoveEvent("kLEAlert")
  end
end
function AlertDraugr_7()
  dragurIntro7 = LD.FindSingleAIByMarker("InitialSpawn07")
  if dragurIntro7 ~= nil then
    dragurIntro7:TriggerMoveEvent("kLEAlert")
  end
end
function StartQuickClearCheck()
  local seq1 = LD.CreateCineSequence(thisLevel, GameObjects.ChkOvr_PitFight01, "Runic Attack Reminder")
  seq1:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_AxeSpecialQuickClear")
  end)
  seq1:Do(function()
    quickClearUsed = true
  end)
  seq1:StartSequence()
end
function RunicAttackReminder()
  if not quickClearUsed and not pitFight1Complete then
    local seq2 = LD.CreateCineSequence(thisLevel, GameObjects.ChkOvr_PitFight01, "Runic Attack Reminder")
    seq2:Do(TUT.Specials_TutorialReminder)
    seq2:WaitForFunctionTrue(function()
      return player:IsPlayingMove("MOV_AxeSpecialQuickClear")
    end)
    seq2:Do(function()
      if not pitFight1Complete then
        LD.CallFunctionAfterDelay(function()
          uiCalls.UI_Event_TurnOffDesignerMessage()
        end, 3.5)
      end
    end)
    seq2:StartSequence()
  end
end
function PitFight1_Complete()
  pitFight1Complete = true
  game.Audio.StartMusic("SND_MX_Riv_fight_3_out")
  GameObjects.LoadZone_UpperArea:HideEntityVolume()
  GameObjects.LoadZone_PitArea:ShowEntityVolume()
  GameObjects.LoadZone_AddCave:ShowEntityVolume()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  LD.CallFunctionAfterDelay(function()
    GameObjects.Btr_PitFight.LuaObjectScript.PostBridgefallFighBanter()
  end, 3.25)
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Arm")
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.ChkOvr_PitFight00.Child
  })
end
function CompleteRiverPassObjective085()
  LD.CompleteQuest("Quest_RiverPass_Objective085")
end
function Quest_Objective085_Complete()
  uiCalls.UI_Event_SendMsgToQuestLog({
    Category = 10250,
    Header = 9086,
    Body = 682,
    MessageType = tweaks.tQuestUiMessage.eMessageType.kQMS_Default,
    Quest = "Quest_RiverPass_Objective200"
  })
end
function LoadZones_Backtracking()
  GameObjects.LoadZone_UpperArea:ShowEntityVolume()
  GameObjects.LoadZone_PitArea:HideEntityVolume()
  GameObjects.LoadZone_AddCave:HideEntityVolume()
  GameObjects.CA_IdleBehavior_BackTrack.LuaObjectScript.Enable()
end
function LoadZones_Forward()
  GameObjects.LoadZone_UpperArea:HideEntityVolume()
  GameObjects.LoadZone_PitArea:ShowEntityVolume()
  GameObjects.LoadZone_AddCave:ShowEntityVolume()
  GameObjects.CA_IdleBehavior_BackTrack.LuaObjectScript.Disable()
end
function SpawnDraugrs()
  BridgeEncounter:Start()
end
function LevelBridgeBreak()
  GameObjects.TL_BridgeRetreversal:ShowTraversePath()
  pitFight1Complete = false
end
function LevelBridgeCineComplete()
  GameObjects.EntZn_NoBackTrackMsg:ShowEntityVolume()
  bridgeCollapseComplete = true
  GameObjects.BridgeCollapseCollision:HideCollision()
  pitFight1Complete = false
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.ChkOvr_PitFight00.Child
  })
  Banter_PrePitFight = true
end
function CineBridgeSwap()
  GameObjects.riv200_bridge_final_pos:Show()
  GameObjects.riv200_Bridge_Break_01_refnode:Hide()
end
function ShowReturnToMountainMsg()
  uiCalls.SendBottomDesignerMessage({
    Text = 680,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
function HideReturnToMountainMsg()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function BridgeEncounter2Complete()
  game.AI.FindSon():CallScript("ClearBehaviorContext")
  GameObjects.Btr_Pitfight.LuaObjectScript.MonitorForCrackClimb()
  GameObjects.Riv200_Traversepaths:ShowTraversePath()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_2H")
  game.Audio.StartMusic("SND_MX_Riv_fight_3b_out")
  pitFight1Complete = true
  pitFight2Complete = true
  Banter_PostPitFight = true
  GameObjects.DraugrHelperCollisoin:HideCollision()
  LD.CallFunctionAfterDelay(function()
    GameObjects.Reaction_OutOfBreath_PitFight.LuaObjectScript.Trigger()
  end, 3.95)
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_Area1_CrackClimbHint.LuaObjectScript.Enable()
  end, 6)
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.ChkOvr_PitFight02.Child
  })
end
function RuneInteractComplete()
  runeInteractComplete = true
  timer.StartLevelTimer(1, PillarBreakA_Seq)
  timer.StartLevelTimer(2, function()
    GameObjects.CA_Area1_Point_Breakout.LuaObjectScript.Enable()
  end)
  local availabilityState = {AvailableForCombat = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.ChkOvr_PitFight01.Child
  })
end
function SimulateFastTravel(level)
  GameObjects.fastTravelTable.LuaObjectScript.SimulateEndOfFastTravel()
end
function CheckPoint_Retreversal()
  if game.Level.GetVariable("CompletedCineNumber") >= 400 then
    game.World.StoreCheckpoint()
  end
end
function Troll_Knock01()
  local fseImpactShake = {
    EffectName = "FSE_shake_temp_Generic_Large",
    Duration = 0.1
  }
  game.FX.SubmitEffect(fseImpactShake)
end
function Troll_Knock02()
  local fseImpactShake = {
    EffectName = "FSE_shake_temp_Generic_Large",
    Duration = 0.3
  }
  game.FX.SubmitEffect(fseImpactShake)
end
function DisableDebriLift()
  GameObjects.DebrisLift.LuaObjectScript:Disable()
end
function PlayRuneSizzle()
  game.Audio.PlaySound("SND_EVNT_Rune_Read_Sizzle_Marketplace")
end
function OpenRopeRetreversal()
  GameObjects.RopeDropBelowBridge.LuaObjectScript:Enable()
end
function OpenRopeShopRetreversal()
  GameObjects.RopeDropShop.LuaObjectScript:Enable()
end
function EnableRopeFreebie()
  GameObjects.RopeDropFreebie.LuaObjectScript:EnableTraversePath()
end
function CA_Area0_Enable()
  timer.StartLevelTimer(9, function()
    GameObjects.CA_Area1_PreRune.LuaObjectScript.Enable()
  end)
end
function PitClimb_ExitBottom()
  GameObjects.CA_ClimbBottomExit.LuaObjectScript.Enable()
  GameObjects.LeadTheWay_DropBridges.LuaObjectScript.Disable()
  GameObjects.LTW_BanditCamp_Lead.LuaObjectScript.Disable()
  GameObjects.LTW_BanditCamp_Follow.LuaObjectScript.Disable()
  GameObjects.LTW_BanditCampMini_Lead.LuaObjectScript.Disable()
  GameObjects.CA_Area2_Forward_01.LuaObjectScript.Disable()
  GameObjects.CA_Area2_Forward_02.LuaObjectScript.Disable()
  GameObjects.CA_Area2_DBridge_01.LuaObjectScript.Disable()
  local riv225 = game.FindLevel("Riv225_DangersCave")
  if riv225 ~= nil then
    riv225:CallScript("CA_Area1_Disable")
    riv225:CallScript("LTW_225_Disable")
  end
end
function EnterBanditCamp()
  GameObjects.CA_Area2_DeadBodies.LuaObjectScript.Disable()
  GameObjects.CA_Area2_DeadBodies_DoorWait.LuaObjectScript.Disable()
  GameObjects.IdleContext_CampNervous.LuaObjectScript.Disable()
end
function PitClimb_ExitTop()
  GameObjects.CA_Area1_CrackClimbHint.LuaObjectScript.Disable()
  GameObjects.CA_ClimbBottomExit.LuaObjectScript.Disable()
  GameObjects.CA_Area2_Forward_01.LuaObjectScript.Enable()
  GameObjects.CA_Area2_Forward_02.LuaObjectScript.Enable()
  GameObjects.CA_Area2_DBridge_01.LuaObjectScript.Enable()
  if 2 <= DrawBridgeHit then
    GameObjects.LeadTheWay_DropBridges.LuaObjectScript.Enable()
    GameObjects.CA_Area2_DBridge_01.LuaObjectScript.Disable()
  end
  local riv225 = game.FindLevel("Riv225_DangersCave")
  if riv225 ~= nil then
    riv225:CallScript("CA_Area1_SyncExit")
    riv225:CallScript("CA_Area1_LTWEnable")
  end
end
function CA_DrawBridge_Attach()
  GameObjects.CA_Area2_Puzzle_01.LuaObjectScript.Enable()
  GameObjects.CA_Area2_Forward_01.LuaObjectScript.Disable()
  GameObjects.CA_Area2_Forward_02.LuaObjectScript.Disable()
end
function CA_DrawBridge_Detach()
end
function LTW_DropBridge_Enable()
  if counterWeightHit then
    GameObjects.LeadTheWay_DropBridges.LuaObjectScript.Enable()
    GameObjects.LTW_BanditCamp_Lead.LuaObjectScript.Disable()
    GameObjects.LTW_BanditCamp_Follow.LuaObjectScript.Enable()
    GameObjects.EntZn_LTW_DropBridgeEnable:HideEntityVolume()
  end
end
function SwitchDropBridges()
  GameObjects.My_AxeBridge01:Hide()
  GameObjects.My_AxeBridge02:Hide()
  GameObjects.axebridge01_down_01:Show()
  GameObjects.axebridge01_down_02:Show()
end
function DisableBanditCampSplines()
  GameObjects.LTW_BanditCamp_Lead.LuaObjectScript.Disable()
  GameObjects.LTW_BanditCamp_Follow.LuaObjectScript.Disable()
end
function BackToTopBanter()
  local riv225 = game.FindLevel("Riv225_DangersCave")
  if riv225 ~= nil then
    riv225:GetGameObject("Btr_Riv225"):CallScript("Btr_BackToTop")
  end
end
function Area_1_Fight_1()
  BridgeEncounter = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Sleeping Riv200")
  BridgeEncounter:AddWave({
    {
      spawners = "Draugr_N_SUSL",
      spawnLocators = "A1_W1_01",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      markerID = "InitialSpawn01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_N_SUSL",
      spawnLocators = "A1_W1_02",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      markerID = "InitialSpawn02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.03
    },
    {
      spawners = "Draugr_N_SUSL",
      spawnLocators = "A1_W1_03",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      markerID = "InitialSpawn03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.06
    },
    {
      spawners = "Draugr_N_SUSL",
      spawnLocators = "A1_W1_04",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      markerID = "InitialSpawn04",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.09
    },
    {
      spawners = "Draugr_N_SUSL",
      spawnLocators = "A1_W1_05",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      markerID = "InitialSpawn05",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.12
    },
    {
      spawners = "Draugr_N_SUSL",
      spawnLocators = "A1_W1_06",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      markerID = "InitialSpawn06",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.15
    },
    {
      spawners = "Draugr_N_2_SUSL",
      spawnLocators = "A1_W1_07",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      markerID = "InitialSpawn07",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.18
    }
  })
  BridgeEncounter:AddWave({
    timeBeforeNextWave = 0.1,
    {
      spawners = "Draugr_PT_SFG",
      spawnLocators = "A1_Loc_PT_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Draugr_PT_SFG",
      spawnLocators = "A1_Loc_PT_2",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 15
    }
  })
  BridgeEncounter:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr_N_SFA",
      spawnLocators = "A1_Loc_H_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.3
    },
    {
      spawners = "Draugr_N_SFA",
      spawnLocators = "A1_Loc_H_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.29
    },
    {
      spawners = "R2_Draugr_P_SFA",
      spawnLocators = "A1_Loc_H_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4.83
    }
  })
  BridgeEncounter:OnComplete(PitFight1_Complete)
  BridgeEncounter:OnComplete(CompleteRiverPassObjective085)
  BridgeEncounter:OnEnemyDeath(function()
    BridgeEncounter:StartWave(2)
  end, {count = 5})
  BridgeEncounter:SetStartZone(GameObjects.EntZn_DraguerFightFailSafe)
end
function Area_1_Fight_2()
  BridgeEncounter2 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 After Pillar Break Riv200")
  BridgeEncounter2:AddWave({
    timeBetweenWaves = 3,
    {
      spawners = "BridgeSpawnFromAbove1",
      spawnWad = "Riv200_AI_Visit01",
      markerID = "Fisrt_HeavyDraugr",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "BridgeSpawnFromAbove2",
      spawnWad = "Riv200_AI_Visit01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 15.5
    }
  })
  BridgeEncounter2:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "BridgeSpawnFromAbove3",
      spawnWad = "Riv200_AI_Visit01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Riv200_AI_Visit01",
      spawnLocators = "A1_Loc_U_1",
      spawnLocators = "A1_Loc_E_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.1
    },
    {
      spawners = "Draugr_N_SFA",
      spawnWad = "Riv200_AI_Visit01",
      spawnLocators = "A1_Loc_U_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.5
    }
  })
  BridgeEncounter2:OnEnemyDeath(function()
    BridgeEncounter2:StartWave(2)
  end, {count = 1})
  BridgeEncounter2:OnComplete(BridgeEncounter2Complete)
end
function Area_1_Fight_3()
  Area_1_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:3 Heavy Pit Repopulation Riv200", {
    CheckpointOnComplete = false,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 1]EC:2 After Pillar Break Riv200"
    }
  })
  Area_1_Encounter_3:AddWave({
    powerLevel = 2,
    {
      spawners = "H_Draugr_N_SFG",
      spawnWad = "Riv200_AI_Shop01",
      spawnLocators = "A1_W1_",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.5
    },
    {
      spawners = "Draugr_PT_SFG",
      spawnLocators = "A1_Loc_PT_3",
      spawnWad = "Riv200_AI_Shop01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.8
    },
    {
      spawners = "Draugr_PT_SFG",
      spawnLocators = "A1_Loc_PT_2",
      spawnWad = "Riv200_AI_Shop01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8.13
    }
  })
  Area_1_Encounter_3:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr_N_SFG",
      spawnWad = "Riv200_AI_Shop01",
      spawnLocators = "A1_W1_",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 2.5,
      powerLevel = 1
    }
  })
  Area_1_Encounter_3:SetStartZone(GameObjects.EntZn_DraguerFightFailSafe, {
    cineRequirement = {117, 301}
  })
  Area_1_Encounter_3:OnEnemyDeath(function()
    Area_1_Encounter_3:StartWave(2)
  end, {count = 2})
end
function Area_1_Fight_4()
  Area_1_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 1]EC:4 Witch Pit Repopulation Riv200", {
    CheckpointOnComplete = false,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 1]EC:2 After Pillar Break Riv200"
    }
  })
  Area_1_Encounter_4:AddWave({
    powerLevel = 6,
    {
      spawners = "Witch_P_SFG",
      spawnWad = "Riv200_AI_Visit02",
      spawnLocators = "A1_W1_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    },
    {
      spawners = "Draugr_P_RUNJUMP",
      spawnWad = "Riv200_AI_Visit02",
      spawnLocators = "A1_Loc_U_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5
    },
    {
      spawners = "Draugr_P_RUNJUMP",
      spawnWad = "Riv200_AI_Visit02",
      spawnLocators = "A1_Loc_U_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.8
    },
    {
      spawners = "Draugr_PT_SFG",
      spawnLocators = "A1_Loc_PT_2",
      spawnWad = "Riv200_AI_Visit02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8.13
    }
  })
  Area_1_Encounter_4:SetStartZone(GameObjects.EntZn_DraguerFightFailSafe, {
    cineRequirement = {117, 301}
  })
end
function PillarBreakA_Seq()
  pillarObject = GameObjects.riv200_tower_wall_break.Child
  local seq = LD.CreateCineSequence(thisLevel, GameObjects.Btr_PitFight, "pillarBreakA")
  seq:Do(PillarBreakA_Anim)
  seq:WaitForFunctionTrue(IsPillarPastFrame, 18)
  seq:Do(PillarKnockA_FX)
  seq:WaitForFunctionTrue(IsPillarPastFrame, 55)
  seq:Do(PillarBreak_BanterALoop_Check)
  seq:WaitForFunctionTrue(IsPillarBreakABanterDone)
  seq:WaitSeconds(3.5)
  seq:Do(LookAtPillar_Check)
  seq:StartSequence()
end
function EnvEvt_TriggerPillar_Small()
  GameObjects.EnvEvt_PillarBreak_Small.LuaObjectScript.Trigger()
end
function EnvEvt_TriggerPillar()
  GameObjects.EnvEvt_PillarBreak.LuaObjectScript.Trigger()
end
function LookAtPillar_Check()
  local lookAtPos = GameObjects.LookAt_Pillar:GetWorldJointPosition(GameObjects.LookAt_Pillar:GetJointIndex("LookAt_Joint"))
  if 0 < game.Camera.GetViewPenetration(lookAtPos, 0, 0) or pillarBreak_playerHasLooked == true then
    PillarBreak_B_and_C_Seq()
  elseif pillarBreak_LookAtMonitor == nil then
    pillarBreak_LookAtMonitor = monitors.CreateLookAtMonitor(lookAtPos)
    pillarBreak_LookAtMonitor:OnLookAt(function()
      pillarBreak_playerHasLooked = true
      pillarBreak_LookAtMonitor:Stop()
      pillarBreak_LookAtMonitor:Terminate()
      pillarBreak_LookAtMonitor = nil
    end)
    PillarBreakA_Seq()
  else
    PillarBreakA_Seq()
  end
end
function PillarBreak_B_and_C_Seq()
  local seq = LD.CreateCineSequence(thisLevel, GameObjects.Btr_PitFight, "pillarBreakB")
  seq:WaitForFunctionTrue(PlayerNotInSafeZone)
  seq:Do(PillarBreakB_Anim)
  seq:WaitForFunctionTrue(IsPillarPastFrame, 65)
  seq:Do(PillarKnockB_FX)
  seq:WaitForFunctionTrue(IsPillarPastFrame, 105)
  seq:Do(PillarBreak_BanterB)
  seq:WaitForFunctionTrue(IsPillarBreakBanterBDone)
  seq:Do(BridgeEncounter2_Start)
  seq:WaitSeconds(1)
  seq:Do(PillarBreakC_Anim)
  seq:WaitForFunctionTrue(IsPillarPastFrame, 111)
  seq:Do(PillarKnockC_FX)
  seq:WaitForFunctionTrue(IsPillarPastFrame, 145)
  seq:Do(PillarBreak_BanterC)
  seq:Do(function()
    GameObjects.CA_Area1_Point_Breakout.LuaObjectScript.Disable()
  end)
  seq:Do(function()
    game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  end)
  seq:StartSequence()
end
function PillarBreak_BanterALoop_Check()
  draugrKnockNumber = draugrKnockNumber + 1
  if draugrKnockNumber == 1 then
    game.Audio.PlayBanter("RIV_DraugrBurstOutOfWall_01", function()
      pillarBreakBanterADone = true
    end)
  elseif 2 < draugrKnockNumber then
    draugrKnockNumber = 0
  end
end
function PillarKnockA_FX()
  EnvEvt_TriggerPillar_Small()
  CSL.PlayDefaultShake("ImpactMedium", 2, 0.2, 0.8)
  SND_PillarKnock = GameObjects.SNDGrpPillarKnock:FindSingleSoundEmitterByName("SNDPillarKnock")
  if SND_PillarKnock ~= nil then
    SND_PillarKnock:Start("SND_EVNT_Stone_Wall_Explode_Pound_01")
  end
end
function PillarKnockB_FX()
  CSL.PlayDefaultShake("ImpactMedium", 2, 0.2, 0.8)
  if SND_PillarKnock ~= nil then
    SND_PillarKnock:Start("SND_EVNT_Stone_Wall_Explode_Pound_02")
  end
end
function PillarKnockC_FX()
  EnvEvt_TriggerPillar()
  CSL.PlayDefaultShake("ShakeRumbleLarge")
  timer.StartLevelTimer(0.89, function()
    CSL.PlayDefaultShake("CrumbleGeneric", 1.2, 0, 1.23)
  end)
  if SND_PillarKnock ~= nil then
    SND_PillarKnock:Start("SND_EVNT_Stone_Wall_Explode_Pound_03")
  end
end
function IsPillarPastFrame(frameNumber)
  return pillarObject.AnimFrame ~= nil and frameNumber <= pillarObject.AnimFrame
end
function PillarBreakA_Anim()
  pillarObject:PlayAnimToFrame(60)
end
function PillarBreakB_Anim()
  pillarObject:PlayAnimToFrame(105)
end
function PillarBreakC_Anim()
  pillarObject:PlayAnimToEnd()
  pillarObject:HideCollision()
  game.Audio.StartMusic("SND_MX_Riv_fight_3b_in")
end
function IsPillarBreakABanterDone()
  return pillarBreakBanterADone == true
end
function PlayerNotInSafeZone()
  return playerInsideSafeZone == false
end
function IsPillarBreakBanterBDone()
  return pillarBreakBanterBDone == true
end
function PillarBreak_BanterB()
  game.Audio.PlayBanter("RIV_DraugrBurstOutOfWall_02", function()
    pillarBreakBanterBDone = true
  end)
end
function PillarBreak_BanterC()
  game.Audio.PlayBanter("RIV_DraugrBurstOutOfWall_03")
end
function BridgeEncounter2_Start()
  BridgeEncounter2:Start()
end
function PillarSafeZoneTrue()
  playerInsideSafeZone = true
end
function PillarSafeZoneFalse()
  playerInsideSafeZone = false
end
function HeavyDraugr_Health_Monitor(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.75
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      BridgeEncounter2:StartWave()
    end)
  end
end
function BanditCampBacktrack()
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    riv260 = game.FindLevel("Riv260_ShopIntroCN")
    if riv260 ~= nil then
      riv260:FindSingleGameObject("Cine_BrokIntro"):CallScript("DisableLeadTheWay")
    end
  end
end
function LeavingBanditCamp()
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    riv260 = game.FindLevel("Riv260_ShopIntroCN")
    if riv260 ~= nil then
      riv260:FindSingleGameObject("Cine_BrokIntro"):CallScript("EnableLeadTheWay")
    end
  end
end
function Axe_Upgrade_Encounter()
  AxeUpgradeEncounter = EC.NewEncounter(thisLevel, "[Area 4]EC:1 Axe Upgrade Encounter Riv200", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_RIV_huldra_camp_fight_in",
    StopMusic = "SND_MX_RIV_huldra_camp_fight_out",
    LeashZone = "LshZn_Riv200_A4_ShopEnc"
  })
  AxeUpgradeEncounter:AddWave({
    timeBeforeNextWave = 14,
    {
      spawners = "H_Draugr_SHOP_PATROL",
      spawnLocators = "A4_O_Loc_2",
      spawnWad = "Riv200_AI_Shop01",
      markerID = "ShopDraugr",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 5.5
    }
  })
  AxeUpgradeEncounter:AddWave({
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "A4_O_Loc_5",
      spawnWad = "Riv200_AI_Shop01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2
    },
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "A4_G_Loc_1",
      spawnWad = "Riv200_AI_Shop01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 16
    },
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "A4_E_Loc_2",
      spawnWad = "Riv200_AI_Shop01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 8
    }
  })
  AxeUpgradeEncounter:OnComplete(AxeUpgradeEncounterComplete)
  AxeUpgradeEncounter:OnStart(SonBrokHide_Start)
  AxeUpgradeEncounter:OnComplete(SonBrokHide_End)
  AxeUpgradeEncounter:OnEnemyDeath(FirstShopKill_Banter, {count = 1, wave = 1})
end
function SonBrokHide_Start()
  local availabilityState = {Unoccupied = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  GameObjects.Riv200_Banter.LuaObjectScript.ShopFight_OnBegin()
end
function FirstShopKill_Banter()
  GameObjects.Riv200_Banter.LuaObjectScript.ShopFight_OnFirstKill()
end
function SonBrokHide_End()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  GameObjects.Riv200_Banter.LuaObjectScript.ShopFight_SonHideOver()
  EnableBridgeLTW()
end
function EnableBridgeLTW()
  GameObjects.LTW_BridgeRopeDrop.LuaObjectScript.Enable()
  GameObjects.LTW_BridgeChest.LuaObjectScript.Enable()
  GameObjects.LTW_BridgeMain.LuaObjectScript.Enable()
end
function DisableBridgeLTW()
  GameObjects.LTW_BridgeRopeDrop.LuaObjectScript.Disable()
  GameObjects.LTW_BridgeChest.LuaObjectScript.Disable()
  GameObjects.LTW_BridgeMain.LuaObjectScript.Disable()
end
function SecretGateOpen()
  GameObjects.EntZn_DisableCeveSpline:ShowEntityVolume()
  GameObjects.EntZn_EnableCaveSpline:ShowEntityVolume()
end
function Axe_Upgrade_Start_W2()
  if AxeUpgradeEncounter:IsRunning() then
    AxeUpgradeEncounter:AlertEnemies(2)
  end
end
function Axe_Upgrade_Start_W3()
  return
end
function AxeUpgradeEncounterComplete()
  riv260 = game.FindLevel("Riv260_ShopIntroCN")
  if riv260 ~= nil then
    riv260:CallScript("EnableBrokShop")
  end
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Arm")
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  game.AI.FindSon():CallScript("ClearBehaviorContext")
  GameObjects.Riv200_Banter.LuaObjectScript.DidntSeeSequence()
end
function StartPostAxeUpgradeEncounter()
  AxeUpgradeEncounter:Start()
  if not AxeUpgradeEncounter:IsComplete() then
    game.World.StoreCheckpoint()
  end
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Chest Riv200", {
    CheckpointOnComplete = false,
    spawnWad = "Riv200_AI_Visit01"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Helwalker_N_SFG",
      spawnLocators = "A2_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.3
    },
    {
      spawners = "Helwalker_N_SFG",
      spawnLocators = "A2_O_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.53
    }
  })
  Area_2_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_2_Attack"))
end
function Start_Area_2_Fight_2()
  Area_2_Encounter_2:Start()
end
function Area_2_Fight_2()
  Area_2_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 2]EC:2 Chest Riv200", {CheckpointOnComplete = false})
  Area_2_Encounter_2:AddWave({
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A2_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 8,
      totalSpawns = 8,
      spawnCooldown = 0.3
    }
  })
end
function Area_3_Fight_1()
  A3_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Arena_3_Attack__1)
  A3_ZM_1:SetTriggerCountLimit(1)
  A3_ZM_1:OnEnter(function()
    Area_3_Encounter_1:AlertEnemies()
    Area_3_Encounter_1:StartWave(2)
  end)
  Area_3_Encounter_1H = EC.NewEncounter(thisLevel, "[Area 3]EC:1  Helwalkers Fight Riv200", {
    CheckpointOnComplete = false,
    LeashZone = "Riv_200_A3_LeashZone",
    StartMusic = "SND_MX_RIV_fight_witch2_in",
    StopMusic = "SND_MX_RIV_fight_witch2_out"
  })
  Area_3_Encounter_1H:AddWave({
    {
      spawners = "Helwalker_N_AMBUSH",
      spawnWad = "Riv200_AI_Visit01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_3_Encounter_1H:OnStart(function()
    GameObjects.EntZn_Arena_3_Attack__1:HideEntityVolume()
    GameObjects.WheelCrankRiv200.LuaObjectScript.Disable()
    GameObjects.ReactionStim_Hellwalker.LuaObjectScript.Trigger()
  end)
  Area_3_Encounter_1H:SetStartZone(GameObjects.EntZn_Arena_3_Spawn__1)
  Area_3_Encounter_1H:OnComplete(function()
    GameObjects.EntZn_Arena_3_Attack__1:ShowEntityVolume()
  end)
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 3]EC:2  Witch Fight Riv200", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.ChkOvr_DrawBridge.Child,
    LeashZone = "Riv_200_A3_LeashZone",
    StartMusic = "SND_MX_RIV_fight_witch2_in",
    StopMusic = "SND_MX_RIV_fight_witch2_out"
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "Witch_P_SFG",
      spawnLocators = "A3_O_Loc_7",
      markerID = "A3_Witch",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.03
    }
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A3_E_Loc_2",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 4.03
    },
    {
      spawners = "H_Draugr_N_SFA",
      spawnLocators = "A3_U_Loc_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 22.8
    }
  })
  Area_3_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr_P_RUNJUMP",
      spawnLocators = "A3_U_Loc_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1,
      spawnCooldown = 5
    },
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "A3_E_Loc_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5,
      spawnCooldown = 10
    }
  })
  Area_3_Encounter_1:OnStart(function()
    GameObjects.WheelCrankRiv200.LuaObjectScript.Disable()
  end)
  Area_3_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_3_Attack__1)
  Area_3_Encounter_1:OnEnemySpawn(function()
    Area_3_Encounter_1:StartWave(2)
  end, {markerID = "A3_Witch"})
  Area_3_Encounter_1:OnEnemyDeath(function()
    Area_3_Encounter_1:StartWave(3)
  end, {markerID = "A3_Witch"})
  Area_3_Encounter_1:OnComplete(function()
    GameObjects.WheelCrankRiv200.LuaObjectScript.Enable()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Walker")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_2H")
    game.Audio.PlayBanter("RiverPass_EncEnd")
  end)
end
function Area_3_Fight_2()
  Area_3_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 3]EC:3 --- Repopulation Riv200", {
    CheckpointOnComplete = false,
    LeashZone = "Riv_200_A3_LeashZone",
    StartMusic = "SND_MX_RIV_fight_witch2_in",
    StopMusic = "SND_MX_RIV_fight_witch2_out",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 3]EC:2  Witch Fight Riv200"
    }
  })
  Area_3_Encounter_2:AddWave({
    requiredWaveCompletion = 50,
    {
      spawners = "Witch_P_SFG",
      spawnLocators = "A3_O_Loc_",
      markerID = "A3_Witch",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.03,
      powerLevel = 2
    },
    {
      spawners = "Witch_P_SFG",
      spawnLocators = "A3_O_Loc",
      markerID = "A3_Witch",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.03,
      powerLevel = 2
    }
  })
  Area_3_Encounter_2:AddWave({
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A3_E_Loc_2",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 2.03
    },
    {
      spawners = "Draugr_P_RUNJUMP",
      spawnLocators = "A3_U_Loc_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 16.8
    }
  })
  Area_3_Encounter_2:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr_P_RUNJUMP",
      spawnLocators = "A3_U_Loc_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1,
      spawnCooldown = 5
    },
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "A3_E_Loc_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5,
      spawnCooldown = 10
    }
  })
  Area_3_Encounter_2:SetStartZone(GameObjects.EntZn_Arena_3_Attack__1, {
    cineRequirement = {118, 300}
  })
end
function Area_3_Fight_3()
  Area_3_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 3]EC:3 Golem Repopulation Riv200", {
    CheckpointOnComplete = true,
    LeashZone = "Riv_200_A3_LeashZone",
    StartMusic = "SND_MX_RIV_fight_witch2_in",
    StopMusic = "SND_MX_RIV_fight_witch2_out",
    RepopulationEncounter = true
  })
  Area_3_Encounter_3:AddWave({
    {
      spawners = "Golem_SOUL_1",
      spawnLocators = "A3_O_Loc_8",
      markerID = "Golem",
      spawnWad = "Riv200_AI_Visit02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.03
    }
  })
  Area_3_Encounter_3:SetStartZone(GameObjects.EntZn_Area_3_Repop, {339, 9999})
end
function Area_3_Fight_4()
  Area_3_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 3]EC:4 - Wolf - Repopulation Riv200", {CheckpointOnComplete = false, RepopulationEncounter = true})
  Area_3_Encounter_4:AddWave({
    {
      spawners = "DW_Draugr_N_SFG",
      spawnLocators = "A3_E_Loc_1",
      spawnWad = "Riv200_AI_Visit02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 1.03,
      powerLevel = 6
    },
    {
      spawners = "DW_Draugr_N_SFG",
      spawnLocators = "A3_E_Loc_2",
      spawnWad = "Riv200_AI_Visit02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.03,
      powerLevel = 6
    }
  })
  Area_3_Encounter_4:SetStartZone(GameObjects.EntZn_Area_3_Repop_Zone_4, {339, 9999})
  Area_3_Encounter_4:OnEnemySpawn(function(enemy)
    enemy:ForceMove("BRA_SetDropHealthFlag_On")
  end, {element = 2})
end
function RecenterOnCrankAttach()
  game.Camera.Recenter({
    TimeStart = 0,
    TimeDuration = 2,
    LockRecenter = 0.46,
    PitchRange = -1,
    TriggerDown = -12,
    ReturnDown = -8,
    TriggerUp = 0,
    ReturnUp = 0,
    YawRange = -1,
    TriggerLeft = 0,
    ReturnLeft = -12,
    TriggerRight = -20,
    ReturnRight = -15
  })
end
function Banter_CounterWeightMiss()
  if not counterWeightWin then
    GameObjects.Riv200_Banter.LuaObjectScript.PulleyBridge02_Banter()
  end
end
function Troll_Health_Monitor(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.75
    local Health_Phase_2 = EnemyHealth * 0.55
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_3_Encounter_1:StartWave()
    end)
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      Area_3_Encounter_1:StartWave()
    end)
  end
end
function Golem_Health_Monitor(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.75
    local Health_Phase_2 = EnemyHealth * 0.45
    local Health_Phase_3 = EnemyHealth * 0.15
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_3_Encounter_2:StartWave()
    end)
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      Area_3_Encounter_2:StartWave()
    end)
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_3, function()
      Area_3_Encounter_2:StartWave()
    end)
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    temp_Start_pitFight1Complete = pitFight1Complete,
    temp_Start_pitFight2Complete = pitFight2Complete,
    runeInteractComplete = runeInteractComplete,
    temp_bridgeCollapseComplete = bridgeCollapseComplete,
    temp_DrawBridgeHit = DrawBridgeHit,
    counterWeightHit = counterWeightHit,
    ravenKilled = ravenKilled
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  pitFight1Complete = savedInfo.temp_Start_pitFight1Complete
  pitFight2Complete = savedInfo.temp_Start_pitFight2Complete
  bridgeCollapseComplete = savedInfo.temp_bridgeCollapseComplete
  runeInteractComplete = savedInfo.runeInteractComplete
  DrawBridgeHit = savedInfo.temp_DrawBridgeHit
  counterWeightHit = savedInfo.counterWeightHit
  ravenKilled = savedInfo.ravenKilled
end
function UpdateLoadGroup()
  game.EvaluateLoadZones()
end
function OnEvaluateLoadGroup_LoadGroup_AI()
  if game.Level.GetVariable("CompletedCineNumber") < 115 then
    return "BridgeCollapse"
  elseif game.Level.GetVariable("CompletedCineNumber") == 115 then
    return "AI_Visit01"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 115 and game.Level.GetVariable("CompletedCineNumber") < 400 then
    return "BrokIntroCine"
  else
    return "AI_Visit02"
  end
end
function LoadCheck_Riv250()
  game.UI.LoadCheck("Riv250_DangersSide")
end
function Riv200_Bookmark_BridgeCollapseStart()
  EnableDebrisLift()
end
function Riv200_Bookmark_BridgeCineComplete()
  GameObjects.riv200_Bridge_Break_01.Child:PlayAnimToEnd()
  GameObjects.TL_BridgeRetreversal:ShowTraversePath()
  GameObjects.BridgeCollapseCollision:HideCollision()
  timer.StartLevelTimer(0.1, AlertDraugrs)
  EnableDebrisLift()
  bridgeCollapseComplete = true
end
function Riv200_Bookmark_PitComplete()
  pillarObject = GameObjects.riv200_tower_wall_break.Child
  pillarObject:PlayAnimToEnd()
  pillarObject:HideCollision()
  GameObjects.Riv200_Traversepaths:ShowTraversePath()
  BridgeEncounter:SetComplete()
  BridgeEncounter2:SetComplete()
  BridgeEncounter2Complete()
  GameObjects.riv200_Bridge_Break_01.Child:PlayAnimToEnd()
  GameObjects.TL_BridgeRetreversal:ShowTraversePath()
  GameObjects.BridgeCollapseCollision:HideCollision()
  EnableDebrisLift()
end
function CbtRiv200Init(level)
  if level.Name == "WAD_Cbt_Riv200" then
    GameObjects.Zone_KraEnterZone:HideEntityVolume()
    GameObjects.Zone_SonEnterZone:HideEntityVolume()
    GameObjects.RicketyBridge_Spot:HideEntityVolume()
    BridgeEncounter:Start()
    pitFight1Complete = false
  end
end
function SonNearDropBridgePuzzle()
  GameObjects.BtrZones_ChainBridgeHint01:ShowEntityVolume()
end
function WheelCrankStateChange()
  if GameObjects.WheelCrankRiv200.LuaObjectScript.GetCurrentCycle() == 3 then
    drawBridgeBreakableScript.ShowBreakableBehavior()
  else
    drawBridgeBreakableScript.HideBreakableBehavior()
  end
end
function DrawBridgePuz_Win()
  DrawBridgeHit = DrawBridgeHit + 1
  if 2 <= DrawBridgeHit then
    GameObjects.TL_DrawBridge_01:ShowTraverseLink()
    GameObjects.LeadTheWay_DropBridges.LuaObjectScript.Enable()
  end
end
function EnableColHelper01()
  GameObjects.Col_My_AxeBridge01:ShowCollision()
end
function EnableColHelper02()
  GameObjects.Col_My_AxeBridge02:ShowCollision()
end
function HideDrawBridgeCollision()
  GameObjects.DrawBridge3:HideCollision()
end
function ShowDrawBrdigeCollision()
  GameObjects.DrawBridge3:ShowCollision()
end
function BrokenClasp_CounterWeight()
  PlayBridgeFallSound()
  PlayBridgeWeightFallSound()
  counterWeightWin = true
  counterWeightHit = true
  game.Audio.PlayBanter("RIV_PulleyBridge04")
  GameObjects.DrawBridge3.Child:StartAnim("envRiv225DrawbridgeWin")
  GameObjects.DrawBridge3.Child:JumpAnimToFrame(GameObjects.DrawBridge3.Child.AnimLengthFrames)
  GameObjects.WheelCrankRiv200.LuaObjectScript.SetCurrentCycle(GameObjects.WheelCrankRiv200.LuaObjectScript.GetMaxStopCycle())
  GameObjects.WheelCrankRiv200.LuaObjectScript.RecalculateStopFrames()
  GameObjects.WheelCrankRiv200.LuaObjectScript.SetRewindTime(1.25)
  GameObjects.WheelCrankRiv200.LuaObjectScript.RemovePlayerImmediate()
  GameObjects.WheelCrankRiv200.LuaObjectScript.Disable()
  GameObjects.LeadTheWay_DropBridges.LuaObjectScript.Disable()
  GameObjects.CA_Area2_Puzzle_01.LuaObjectScript.Disable()
  GameObjects.Col_PuzzleDeflect:HideCollision()
  GameObjects.bridge_up_cardproxy:Hide()
  GameObjects.bridge_down_cardproxy:Show()
end
function DrawBridgeEnd()
  if counterWeightHit then
    GameObjects.Sheet_DrawBridge:HideCollision()
    GameObjects.LeadTheWay_DropBridges.LuaObjectScript.Disable()
    GameObjects.LTW_BanditCamp_Lead.LuaObjectScript.Enable()
    GameObjects.LTW_BanditCampMini_Lead.LuaObjectScript.Enable()
    GameObjects.CA_Area2_Forward_01.LuaObjectScript.Disable()
    GameObjects.CA_Area2_Forward_02.LuaObjectScript.Disable()
    GameObjects.NavObstacle_DrawBridge:HideNavObstacle()
  end
end
function DrawBridge_EnableCol()
  GameObjects.Sheet_DrawBridge:ShowCollision()
end
function DrawBridgeRewind()
  LD.CallFunctionAfterDelay(function()
    if not counterWeightHit then
      GameObjects.Riv200_Banter.LuaObjectScript.PulleyBridge01_Banter()
    end
  end, 0.5)
end
function BonusClasp()
  GameObjects.TL_BonusBridge:ShowTraverseLink()
end
function Quest_RiverPass_Objective202_End()
  LD.CompleteQuest("Quest_RiverPass_Objective202")
end
function Enemy_1_Hit_Kill(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Enemy:MeterSetValue("Health", 1)
    local EnemyNewHealth = Enemy:GetHitPoints()
  else
    print("No Enemy")
  end
end
function SyncExit_SideA()
  if game.Level.GetVariable("CompletedCineNumber") > 115 then
    GameObjects.CA_LiftDoorSyncExit_01.LuaObjectScript.Enable()
  end
end
function SyncExit_SideB()
  if game.Level.GetVariable("CompletedCineNumber") > 115 then
    GameObjects.CA_LiftDoorSyncExit_02.LuaObjectScript.Enable()
  end
end
function rivFastTravelMusic()
  if game.Level.GetVariable("CompletedCineNumber") >= 400 then
    game.Audio.StartCheckpointedMusic("SND_MX_RIV_revisit_explore_in")
  end
  print("GOT CALLBACK FROM FT POINT!")
  game.Compass.SetDesignerForcedHide(true)
end
local bridgeDObjSoundOverrides = {
  SoundEmitter = nil,
  UseExplicitSoundMotion = true,
  OnForward = "SND_MECH_Wood_Bridge_Raise_LP_Riv200",
  OnEnd = "SND_MECH_Wood_Bridge_Lower_Stop_End_Riv200",
  OnBackward = "SND_MECH_Wood_Bridge_Lower_LP_Riv200",
  OnRewind = "SND_MECH_Wood_Bridge_Raise_LP_Riv200",
  OnReturnToStart = "SND_MECH_Wood_Bridge_Lower_Stop_End_Riv200",
  OnStuckAtEnd = "SND_MECH_Wood_Bridge_Raise_Stuck_On_End_Riv200",
  OnStuckAtStart = "SND_MECH_Wood_Bridge_Raise_Stuck_On_End_Riv200"
}
local sHookBridge_Hook_Overrides = {
  OnBreak = "SND_MECH_Wood_Bridge_S_Hook_Break_Riv200"
}
local sHookBridge_Bridge01_Overrides = {
  isLooping = false,
  OnDrawBridgeFall = "SND_MECH_Wooden_Bridge_Chains_Break2_Riv"
}
local sHookBridge_Bridge02_Overrides = {
  isLooping = false,
  OnDrawBridgeFall = "SND_MECH_Wooden_Bridge_Chains_Break1_Riv"
}
local sHookBridge_Bridge03_Overrides = {
  isLooping = false,
  OnDrawBridgeFall = "SND_MECH_Wooden_Bridge_Collapse_Crash_Riv"
}
local runeReadUnderBridgeOverrides = {EndFrame = 228}
local SNDBridgeFallEmitter
local BridgeWeightFallSound = "SND_MECH_Wood_Bridge_Counterweight_Fall"
function SoundInit()
  bridgeDObjSoundOverrides.SoundEmitter = GameObjects.DrawBridge3.Child:FindSingleSoundEmitterByName("SNDDrawBridgeTemplate")
  SNDBridgeFallEmitter = GameObjects.DrawBridge3.Child:FindSingleSoundEmitterByName("SNDDrawBridgeTemplate_Counterweight")
end
function SoundOnStart()
  GameObjects.WheelCrankRiv200.LuaObjectScript.DrivenObjectSoundSetup(bridgeDObjSoundOverrides)
  GameObjects.S_CurveBreakable1.LuaObjectScript.SoundSetup(sHookBridge_Hook_Overrides)
  GameObjects.SonKnowledge_UnderBridge.LuaObjectScript.SoundSetup(runeReadUnderBridgeOverrides)
  GameObjects.My_AxeBridge01.LuaObjectScript.SoundSetup(sHookBridge_Bridge01_Overrides)
  GameObjects.My_AxeBridge02.LuaObjectScript.SoundSetup(sHookBridge_Bridge02_Overrides)
  GameObjects.My_AxeBridge03.LuaObjectScript.SoundSetup(sHookBridge_Bridge03_Overrides)
end
function PlayBridgeFallSound()
  bridgeDObjSoundOverrides.OnForward = ""
  bridgeDObjSoundOverrides.OnEnd = ""
  bridgeDObjSoundOverrides.OnBackward = ""
  bridgeDObjSoundOverrides.OnRewind = ""
  bridgeDObjSoundOverrides.OnReturnToStart = ""
  bridgeDObjSoundOverrides.OnStuckAtEnd = ""
  bridgeDObjSoundOverrides.OnStuckAtStart = ""
  GameObjects.WheelCrankRiv200.LuaObjectScript.DrivenObjectSoundSetup(bridgeDObjSoundOverrides)
  GameObjects.WheelCrankRiv200.LuaObjectScript.PlaySoundOnDrivenObject("SND_MECH_Wood_Draw_Bridge_Release")
end
function PlayBridgeWeightFallSound()
  if SNDBridgeFallEmitter ~= nil then
    LD.PlaySoundRingOut(SNDBridgeFallEmitter, BridgeWeightFallSound)
  end
end
