local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local thisObj, thisLevel, shouldWitchForeshadowBPlay, backToTopBanter_BanterPlayed, reachedLookout
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if not banterPlayed.FearOfWitches_Shown then
    FearOfWitches_Hide()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  savedInfo.backToTopBanter_BanterPlayed = backToTopBanter_BanterPlayed
  savedInfo.reachedLookout = reachedLookout
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    banterPlayed = savedInfo.banterPlayed
    backToTopBanter_BanterPlayed = savedInfo.backToTopBanter_BanterPlayed
    reachedLookout = savedInfo.reachedLookout
  end
end
function Hide_WitchForeshadowB()
  GameObjects.BtrZone_WitchForeshadow_B:Hide()
end
function WitchAttack_Banter()
  game.Audio.PlayBanter("CBT_General_Spawn_1stWitch")
end
function PostWitchFight_Banter()
  game.Audio.PlayBanter("RIV_PostWitchFight", function()
    LD.CallFunctionAfterDelay(function()
      TUT.SkillPointIntro_Tutorial()
    end, 1)
    banterPlayed.PostWitchFight = true
  end)
end
function RiverBottom_Banter()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "riverBottom_Btr")
  seq:WaitForFunctionTrue(function()
    return (game.Player.FindPlayer():IsPlayingMove("MOV_Crack_Climb_Down_Exit"))
  end)
  seq:WaitForFunctionTrue(function()
    return not game.Player.FindPlayer():IsPlayingMove("MOV_Crack_Climb_Down_Exit")
  end)
  seq:Do(function()
    game.Audio.PlayBanter("RIV_RiverBottom")
  end)
  seq:StartSequence()
end
function FearOfWitches_Show()
  banterPlayed.FearOfWitches_Shown = true
  GameObjects.BtrZone_FearOfWitches:Show()
end
function FearOfWitches_Hide()
  GameObjects.BtrZone_FearOfWitches:Hide()
end
function EnableWitchForeshadowB()
  shouldWitchForeshadowBPlay = true
end
function ShouldWitchForeshadowBPlay()
  return shouldWitchForeshadowBPlay
end
function ShouldTempleCrackClimbPlay()
  return banterPlayed.PostWitchFight
end
function Btr_BackToTop()
  if not backToTopBanter_BanterPlayed then
    game.Audio.PlayBanter("RIV_BackToTopHint", function()
      GameObjects.CA_SeeBridge_01.LuaObjectScript.Disable()
    end)
    backToTopBanter_BanterPlayed = true
  end
end
function EnableBridgeLookOut()
  if not reachedLookout then
    reachedLookout = true
    GameObjects.InteractZone_SeeBridge.LuaObjectScript.Enable()
    _G.BridgeSeenStart()
  end
end
function DisableBridgeLookOut()
  print("DisableBridgeLookOut")
  GameObjects.InteractZone_SeeBridge.LuaObjectScript.Disable()
end
