local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local TUT = require("game.GlobalTutorials")
local thisLevel, player
local Demo_Mode = true
local Area_1_Encounter_1, Area_1_Encounter_2, Area_1_Encounter_3, Area_1_Encounter_4, Area_1_Encounter_5, Area_1_Encounter_6, Area_2_Encounter_1, Area_2_Encounter_2, Area_3_Encounter_1, Area_3_Encounter_2, Area_3_Encounter_3, Area_3_Encounter_4, WitchHiddenEnemyAttackZoneMonitor, WitchAlertZoneMonitor, Enemy_HealthMonitor, A3_Monitor_Spawn, A3_Monitor_DeSpawn, ZM_A1_E1_Attack, ZM_A3_E1_Attack, ZM_A3_E4, Riv000_Sound
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  Area_1_Fight_2()
  Area_1_Fight_3()
  Area_1_Fight_4()
  Area_1_Fight_5()
  Area_1_Fight_6()
  Area_2_Fight_2()
  Area_3_Fight_2()
  Area_3_Fight_3()
  Area_3_Fight_4()
  Riv000_Sound = game.FindLevel("Riv000_Sound")
end
function OnFirstStart(level, obj)
end
function OnStart(level, obj)
  GameObjects.Witch_green_gas.Child:HideParticleEmitter()
  if Area_3_Encounter_2:IsComplete() == false and game.Level.GetVariable("CompletedCineNumber") > 399 then
    Area_3_Encounter_2:SetComplete()
  end
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Hidden Enemy Riv225 ", {CheckpointOnComplete = false})
  Area_1_Encounter_1:AddWave({
    {
      spawners = "HiddenBindit_WitchRoom",
      markerID = "WitchHiddenEnemy",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Area_1_Spawn_1)
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Enemy_Spawn)
  Area_1_Encounter_1:OnStart(function()
    GameObjects.EntZn_Area_1_Spawn_2:HideEntityVolume()
  end)
  Area_1_Encounter_1:OnComplete(function()
    GameObjects.EntZn_Area_1_Spawn_2:ShowEntityVolume()
  end)
  WitchHiddenEnemyAttackZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Area_1_Attack_1"))
  WitchHiddenEnemyAttackZoneMonitor:OnEnter(function()
    Area_1_Encounter_1:AlertEnemies()
    _G.Area_1_Fight_Start()
  end)
  WitchHiddenEnemyAttackZoneMonitor:SetTriggerCountLimit(1)
end
function EnableWitchVolume()
  GameObjects.Combat_Witch_225A_1:PlayAnimToFrame(180, 1)
  GameObjects.Combat_Witch_225_1:PlayAnimToFrame(180, 1)
end
function DisableWitchVolume()
  GameObjects.Combat_Witch_225A_1:PlayAnimToFrame(0, -0.85)
  GameObjects.Combat_Witch_225_1:PlayAnimToFrame(0, -0.85)
end
function Area_1_Fight_2()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 First Witch10 Riv225", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_RIV_fight_4_in",
    StopMusic = "SND_MX_RIV_fight_4_out"
  })
  Area_1_Encounter_2:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Witch_P_SUI",
      spawnLocators = "A1_Loc_5",
      spawnWad = "Riv200_AI_Visit01",
      markerID = "First_Witch",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  Area_1_Encounter_2:SetStartZone(GameObjects.EntZn_Area_1_Spawn_2)
  WitchAlertZoneMonitor = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_1_Attack_2)
  WitchAlertZoneMonitor:SetTriggerCountLimit(1)
  WitchAlertZoneMonitor:OnEnter(function()
    if Area_1_Encounter_2 ~= nil then
      Area_1_Encounter_2:AlertEnemies()
      GameObjects.Combat_Witch_225A_1:PlayAnimToFrame(0)
      GameObjects.Combat_Witch_225_1:PlayAnimToFrame(0)
      GameObjects.TurnOnWitchVolumes:HideEntityVolume()
      GameObjects.TurnOffWitchVolumes:HideEntityVolume()
      _G.Area_1_Fight_Start()
      Riv000_Sound:CallScript("TurnOffTheWitchSinging")
      GameObjects.EntZn_Area_1_Attack_2:HideEntityVolume()
    end
    WitchAlertZoneMonitor:Stop()
    WitchAlertZoneMonitor = nil
  end)
  Area_1_Encounter_2:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Revenant_Poison")
    GameObjects.SonDispell_1.LuaObjectScript.Set_DispellTime(3)
    GameObjects.InteractZone_SeeBridge.LuaObjectScript.Disable()
    LD.CallFunctionAfterDelay(function()
      GameObjects.Btr_Riv225.LuaObjectScript.PostWitchFight_Banter()
    end, 0.5)
    _G.Area_1_Fight_Complete()
  end)
  Area_1_Encounter_2:OnEnemySpawn(OnFirstWitchSpawn, {
    markerID = "First_Witch"
  })
end
function OnFirstWitchSpawn(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.8
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_1_Encounter_2:StartWave()
    end)
  end
end
function DeSpawn_Area_1_Fight_3()
  if Area_1_Encounter_3 ~= nil and not Area_1_Encounter_3:IsComplete() then
    Area_1_Encounter_3:DespawnEnemies()
    Area_1_Encounter_3:Reset()
    Area_1_Encounter_3:Stop()
  end
end
function Spawn_Area_1_Fight_3()
  if Area_1_Encounter_3 ~= nil and not Area_1_Encounter_3:IsComplete() and not Area_1_Encounter_3:IsRunning() then
    if Area_1_Encounter_3:WasRunning() then
      Area_1_Encounter_3:Restart()
    else
      Area_1_Encounter_3:Start()
    end
  end
end
function Attack_Area_1_Fight_3()
  if Area_1_Encounter_3 ~= nil and not Area_1_Encounter_3:IsComplete() then
    Area_1_Encounter_3:AlertEnemies()
  end
end
function Area_1_Fight_3()
  A3_Monitor_Spawn = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn__HiddenShield_Spawn)
  A3_Monitor_Spawn:OnEnter(Spawn_Area_1_Fight_3)
  A3_Monitor_DeSpawn = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn__HiddenShield_DeSpawn)
  A3_Monitor_DeSpawn:OnEnter(DeSpawn_Area_1_Fight_3)
  Area_1_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:3 Hidden Heavy Riv225 ", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_RIV_fight_7_in",
    StopMusic = "SND_MX_RIV_fight_7_out"
  })
  Area_1_Encounter_3:AddWave({
    {
      spawners = "H_Draugr_N_SUSL",
      spawnLocators = "A1_L_Loc_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = 3
    }
  })
  Area_1_Encounter_3:OnComplete(_G.Area1_Encounter_3)
end
function Area_1_Fight_4()
  Area_1_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 1]EC:4 Repopulation Riv225 ", {
    CheckpointOnComplete = false,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 1]EC:2 First Witch10 Riv225"
    }
  })
  Area_1_Encounter_4:AddWave({
    powerLevel = 2,
    {
      spawners = "U_Draugr_PT_SFG",
      spawnLocators = "A1_B_Loc_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A1_Loc",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.8
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A1_Loc",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.3
    }
  })
  Area_1_Encounter_4:SetStartZone(GameObjects.EntZn_Area_1_Attack_4, {
    cineRequirement = {130, 399}
  })
end
function Area_1_Fight_5()
  Area_1_Encounter_5 = EC.NewEncounter(thisLevel, "[Area 1]EC:5 Hidden Heavy Repop Riv225 ", {CheckpointOnComplete = false, RepopulationEncounter = true})
  Area_1_Encounter_5:AddWave({
    {
      spawners = "H_Draugr_PL_SFG",
      spawnLocators = "A1_L_Loc_1",
      spawnWad = "Riv200_AI_Visit02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = 8
    }
  })
  Area_1_Encounter_5:SetStartZone(GameObjects.EntZn__HiddenShield_Attack, {
    cineRequirement = {399, 9999}
  })
end
function Area_1_Fight_6()
  Area_1_Encounter_6 = EC.NewEncounter(thisLevel, "[Area 1]EC:6 Repopulation Riv225 ", {CheckpointOnComplete = false, RepopulationEncounter = true})
  Area_1_Encounter_6:AddWave({
    powerLevel = 2,
    {
      spawners = "SH_Draugr_L_SFG",
      spawnLocators = "A1_B_Loc_1",
      spawnWad = "Riv200_AI_Visit02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1,
      powerLevel = 7
    },
    {
      spawners = "SH_Draugr_L_SFG",
      spawnLocators = "A1_Loc",
      spawnWad = "Riv200_AI_Visit02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 2.8,
      powerLevel = 7
    },
    {
      spawners = "Flyer_B_SABU",
      spawnLocators = "A1_Loc",
      spawnWad = "Riv200_AI_Visit02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 3.5,
      powerLevel = 8
    }
  })
  Area_1_Encounter_6:SetStartZone(GameObjects.EntZn_Area_1_Attack_4, {
    cineRequirement = {399, 9999}
  })
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Turret Enemy Riv225 ")
  Area_2_Encounter_1:AddWave({
    {
      spawners = "U_Draugr_PT_SFG",
      spawnLocators = "A2_E_Loc_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2
    }
  })
  Area_2_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_2_Attack_1"))
  Area_2_Encounter_1:OnStart(game.Audio.StartMusic("SND_MX_RIV_fight_5_in"), 1)
  Area_2_Encounter_1:OnComplete(Area2Encounter1Complete)
end
function Area2Encounter1Complete()
  GameObjects.CheckPoint_225Exit:ShowEntityVolume()
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.ChkOvr_CaveExit.Child
  })
end
function Start_Area_2_Fight_2()
  if Area_2_Encounter_2 ~= nil then
    Area_2_Encounter_2:AlertEnemies()
  end
end
function Area_2_Fight_2()
  Area_2_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 2]EC:2 SurpriseAttacker Riv225 ", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_Riv_fight_5_in",
    StopMusic = "SND_MX_Riv_fight_5_out",
    LeashZone = "NavLeash_SurpriseAttack"
  })
  Area_2_Encounter_2:AddWave({
    {
      spawners = "Draugr_N_SurpriseAttacker",
      spawnLocators = "A2_H_Loc_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  Area_2_Encounter_2:SetStartZone(thisLevel:GetGameObject("EntZn_Area_2_Attack_1"))
  Area_2_Encounter_2:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Base")
  end)
end
function Area_3_Fight_1()
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 3]EC:1 Upper Battle Riv225", {CheckpointOnComplete = true})
  Area_3_Encounter_1:AddWave({
    {
      spawners = "U_Draugr_PT_SFG",
      spawnLocators = "A3_Loc_U_3",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.55
    }
  })
end
function Area_3_Fight_2_Start()
end
function Area_3_Fight_2()
  ZM_A3_E1_Attack = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Arena_3_Attack__1)
  ZM_A3_E1_Attack:SetTriggerCountLimit(1)
  ZM_A3_E1_Attack:OnEnter(function()
    Area_3_Encounter_2:AlertEnemies()
  end)
  Area_3_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 3]EC:2 Upper Tryptic Room Riv225", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.ChkOvr_Area2.Child,
    LeashZone = "NavLeash_A3F2",
    StartMusic = "SND_MX_RIV_fight_6_in",
    StopMusic = "SND_MX_RIV_fight_6_out"
  })
  Area_3_Encounter_2:AddWave({
    {
      spawners = "Draugr_P_SUSL",
      spawnLocators = "A3_Loc_O_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = 2
    },
    {
      spawners = "Draugr_P_SUSL",
      spawnLocators = "A3_Loc_O_6",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.25,
      powerLevel = 2
    }
  })
  Area_3_Encounter_2:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "A3_Loc_O_9",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2
    },
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "A3_Loc_O_4",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 8.15
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A3_Loc_E_2",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 13
    }
  })
  Area_3_Encounter_2:SetStartZone(GameObjects.EntZn_Arena_3_Spawn__1)
  Area_3_Encounter_2:OnEnemyDeath(function()
    Area_3_Encounter_2:StartWave(2)
  end, {count = 1})
  Area_3_Encounter_2:OnComplete(function()
    game.FindLevel("Riv200_DangersMain"):GetGameObject("Riv200_Banter"):CallScript("ChainBridgeHints_TriptychFightOver")
  end)
end
function Area_3_Fight_3()
  Area_3_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 3]EC:3 Tryptic Room Repopulation Riv225", {
    LeashZone = "NavLeash_A3F2",
    CheckpointOnComplete = false,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 3]EC:2 Upper Tryptic Room Riv225"
    }
  })
  Area_3_Encounter_3:AddWave({
    {
      spawners = "H_Draugr_P_SFG",
      spawnLocators = "A3_Loc_O_1",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = 3
    },
    {
      spawners = "H_Draugr_P_SFG",
      spawnLocators = "A3_Loc_O_6",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.25,
      powerLevel = 3
    }
  })
  Area_3_Encounter_3:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "SH_Draugr_N_SFG",
      spawnLocators = "A3_Loc_O_9",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2,
      powerLeevl = 2
    },
    {
      spawners = "SH_Draugr_N_SFG",
      spawnLocators = "A3_Loc_E_2",
      spawnWad = "Riv200_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 13,
      powerLevel = 2
    }
  })
  Area_3_Encounter_3:SetStartZone(GameObjects.EntZn_Arena_3_Attack__1, {
    cineRequirement = {130, 399}
  })
  Area_3_Encounter_3:OnEnemyDeath(function()
    Area_3_Encounter_3:StartWave(2)
  end, {count = 1})
end
function Area_3_Fight_4()
  Area_3_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 3]EC:4 Repopulation Riv225", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeash_A3F2",
    RepopulationEncounter = true
  })
  Area_3_Encounter_4:AddWave({
    {
      spawners = "Flyer",
      spawnLocators = "A3_Loc_O",
      spawnWad = "Riv200_AI_Visit02",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.95,
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = 5,
      powerLevel = 4
    },
    {
      spawners = "Witch_P_SRFC",
      spawnLocators = "A3_Loc_O",
      spawnWad = "Riv200_AI_Visit02",
      initialSpawnAmount = 1,
      initialSpawnCooldown = 2.25,
      maxActive = 2,
      totalSpawns = 2,
      useSpawnLocatorsOnly = true,
      powerLevel = 7,
      spawnCooldown = 10.853
    }
  })
  Area_3_Encounter_4:SetStartZone(GameObjects.EntZn_Arena_3_Attack__1, {
    cineRequirement = {399, 9999}
  })
  ZM_A3_E4 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_A3_E4_Despawn)
  ZM_A3_E4:OnEnter(function()
    Area_3_Encounter_4:DespawnEnemies()
    Area_3_Encounter_4:Reset()
    Area_3_Encounter_4:Stop()
  end)
end
function Riv225_Bookmark_RuinsMiddle()
  Area_1_Encounter_1:SetComplete()
  Area_1_Encounter_2:SetComplete()
  GameObjects.SonDispell_1.LuaObjectScript.Disable()
end
function Riv225_Bookmark_RuinsExit()
  Area_1_Encounter_3:SetComplete()
end
