local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local CamCheck = require("camera.collisioncheck")
local TUT = require("game.GlobalTutorials")
local uiCalls = require("ui.uicalls")
Player = nil
son = nil
myGO = nil
thisLevel = nil
playerPosition = nil
riv200 = nil
local arrowUseCount = 0
local buttonMonitor1, witchHelperTimer
local coffinAvailable = 0
local Demo_Mode = true
local timerCamWitchIntro = timer.StartLevelTimer(2.8)
timerCamWitchIntro:Stop()
local bCamWitchIntroStarted = false
local camListWitch = {}
local camTargetWitch
local introWitchHasSpawned = false
local cameraWitchIntro
local isInView = false
local bCanResetPitClimbFWD = false
local triptychComplete, area3FightComplete
local bShowBridge = false
local bridgeSeen
function OnScriptLoaded(level, go)
  thisLevel = level
  Player = game.Player.FindPlayer()
  son = game.AI.FindSon()
end
function OnStart(level)
end
function OnUpdate(level, go)
  playerPosition = Player.WorldPosition
  if bCanResetPitClimbFWD == false then
    if game.World.IsInsideCameraZone(playerPosition, "CamZone_ClimbEnterRecenter") then
      bCanResetPitClimbFWD = true
    end
  elseif game.World.IsInsideCameraZone(playerPosition, "CamZone_ClimbEnterRecenter_ReEnable") then
    WakeUpTheRecenterZones("Recenter_Pit_Climb_Fwd")
    bCanResetPitClimbFWD = false
  end
  if bShowBridge == true and game.World.IsInsideCameraZone(playerPosition, "CamZone_BridgeDestination") then
    game.Camera.SubmitCameraByName("PLYR_Nar_BridgeDestination_RTT")
  end
end
function OnUseWorld(level)
end
function Start_Encounter_Upper1()
  print("In Maya")
end
function Final_Encounter_Upper1()
  print("In Maya")
end
function WakeUpTheRecenterZones(mayagroupname)
  print("Camera: Wake Up Recenter Group")
  local recentergroup = thisLevel:FindGameObject(mayagroupname)
  for _, child in pairs(recentergroup.Children) do
    child.Child.LuaObjectScript.Reset()
    game.SubObject.Wake(child.Child)
  end
end
function EnableTriptych_Riv225()
  GameObjects.TriptychBasic.LuaObjectScript:EnableTriptych()
end
function CoffinBreakable()
end
function OnEvaluateLoadGroup_LoadGroup_AI()
  if game.Level.GetVariable("CompletedCineNumber") < 400 then
    return "AI_Visit01"
  else
    return "AI_Visit02"
  end
end
function DisableChest()
  GameObjects.LootLockedChest.LuaObjectScript:Disable()
end
function CA_Area1_SyncExit()
  GameObjects.CA_Area1_Nervous_01.LuaObjectScript:Enable()
end
function CA_Area1_Enable()
end
function CA_Area1_Disable()
  GameObjects.CA_Area1_Nervous_01.LuaObjectScript:Disable()
end
function CA_Area1_LTWEnable()
  GameObjects.LTW_Area1_Follow.LuaObjectScript.Enable()
  GameObjects.LTW_Area2_Follow.LuaObjectScript.Enable()
  GameObjects.LTW_Area3_Follow.LuaObjectScript.Enable()
end
function LTW_225_Disable()
  GameObjects.LTW_Area1_Follow.LuaObjectScript.Disable()
  GameObjects.LTW_Area2_Follow.LuaObjectScript.Disable()
  GameObjects.LTW_Area3_Follow.LuaObjectScript.Disable()
end
function BridgeSeenStart()
  bridgeSeen = true
end
function CA_Area2_Enable()
  if not bridgeSeen then
    GameObjects.CA_SeeBridge_01.LuaObjectScript:Enable()
  else
    GameObjects.CA_SeeBridge_02.LuaObjectScript:Enable()
  end
  GameObjects.CA_Area2_Forward_01.LuaObjectScript.Enable()
  GameObjects.CA_Area2_Forward_02.LuaObjectScript.Enable()
  GameObjects.CA_Area2_Up_01.LuaObjectScript.Enable()
  if not triptychComplete then
    GameObjects.CA_Tryptic_Forward_01.LuaObjectScript.Enable()
  end
end
function CA_Area2_Disable()
  GameObjects.CA_SeeBridge_01.LuaObjectScript:Disable()
  GameObjects.CA_SeeBridge_02.LuaObjectScript:Disable()
  GameObjects.CA_Area2_Forward_01.LuaObjectScript.Disable()
  GameObjects.CA_Area2_Forward_02.LuaObjectScript.Disable()
  GameObjects.CA_Area2_Up_01.LuaObjectScript.Disable()
  GameObjects.CA_Tryptic_Forward_01.LuaObjectScript.Disable()
end
function CA_Area3_Enable()
  GameObjects.CA_Area3_Ground_01.LuaObjectScript:Disable()
  GameObjects.CA_Area3_Up_01.LuaObjectScript:Disable()
  GameObjects.CA_Area3_Up_02.LuaObjectScript:Disable()
  GameObjects.CA_Combat_01.LuaObjectScript:Enable()
  GameObjects.CA_Combat_02.LuaObjectScript:Enable()
  if not area3FightComplete then
    GameObjects.CA_Area3_Nervous_01.LuaObjectScript:Enable()
  end
end
function CA_Area3_Disable()
  GameObjects.CA_Area3_Ground_01.LuaObjectScript:Disable()
  GameObjects.CA_Area3_Up_01.LuaObjectScript:Disable()
  GameObjects.CA_Area3_Up_02.LuaObjectScript:Disable()
  GameObjects.CA_Area3_Nervous_01.LuaObjectScript:Disable()
  GameObjects.CA_Combat_01.LuaObjectScript:Disable()
  GameObjects.CA_Combat_02.LuaObjectScript:Disable()
end
function Area1_Encounter_3()
  area3FightComplete = true
  GameObjects.CA_Riv_TarPoke_01.LuaObjectScript.Enable()
end
function IdleBehave_Wait_Enable()
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
end
function IdleBehave_Wait_Disable()
  son:CallScript("ClearBehaviorContext")
end
function Area_1_Fight_Start()
  GameObjects.IdleContext_Panic.LuaObjectScript.Disable()
  GameObjects.Witch_green_gas.Child:HideParticleEmitter()
  buttonMonitor1 = monitors.CreateSquareButtonMonitor()
  buttonMonitor1:OnButtonDown(ArrowButtonUsed)
  witchHelperTimer = timer.StartLevelTimer(35, ArrowReminder)
  GameObjects.Btr_Riv225.LuaObjectScript.WitchAttack_Banter()
end
function ArrowButtonUsed()
  arrowUseCount = arrowUseCount + 1
end
function ArrowReminder()
  if arrowUseCount < 4 then
    TUT.FireSonArrow_Tutorial()
  end
end
function Area_1_Fight_Complete()
  if witchHelperTimer ~= nil then
    witchHelperTimer:Stop()
    witchHelperTimer = nil
  end
  uiCalls.UI_Event_TurnOffDesignerMessage()
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.ChkOvr_Area1.Child
  })
end
function TriptychRead()
  triptychComplete = true
  GameObjects.CA_Tryptic_Forward_01.LuaObjectScript.Disable()
end
function SeeBridge()
  bShowBridge = true
  GameObjects.ReactionStim.LuaObjectScript.Trigger()
  local fNumSecondsToShowBridge = 2.3
  timer.StartLevelTimer(fNumSecondsToShowBridge, function()
    bShowBridge = false
  end)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    area3FightComplete = area3FightComplete,
    bridgeSeen = bridgeSeen
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  area3FightComplete = savedInfo.area3FightComplete
  bridgeSeen = savedInfo.bridgeSeen
end
