local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
local thisLevel, player, son, FF_HealthMonitor, RestartBanditEncounter
RestartHellwalkerEncounter = nil
local temp_RestartHellwalkerEncounter, Area_1_Encounter_1
Area_1_Encounter_2 = nil
local Checkpoint_Encounter_1, Checkpoint_Encounter_2, riv250, riv250_Banter
BanditEncounter = nil
RestartBanditEncounter = nil
local banditReferences
function OnScriptLoaded(level)
  thisLevel = level
  son = game.AI.FindSon()
  riv250 = game.FindLevel("Riv250_DangersSide")
  if riv250 ~= nil then
    riv250_Banter = riv250:GetGameObject("Banter_Riv250")
  end
  GameObjects.FinalFanaticHelper:HideCollision()
  InitBanditEnctouner()
  Checkpoint_Area_1_Fight_1()
  Area_1_Fight_2()
  Checkpoint_Area_1_Fight_2()
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_Riv250_DangersSide" then
    riv250 = game.FindLevel("Riv250_DangersSide")
    riv250_Banter = riv250:GetGameObject("Banter_Riv250")
  end
end
function OnSaveCheckpoint(level, obj, savedInfo)
  return {
    levelstate = checkpoint.Save(),
    temp_RestartHellwalkerEncounter = RestartHellwalkerEncounter,
    temp_RestartBanditEncounter = RestartBanditEncounter
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  RestartHellwalkerEncounter = savedInfo.temp_RestartHellwalkerEncounter
  RestartBanditEncounter = savedInfo.temp_RestartBanditEncounter
  print("Restore checkpoint")
  if RestartBanditEncounter == true then
    Checkpoint_Encounter_1:Start()
    print("Awaiting Steven to setup the encounter")
  end
  if RestartHellwalkerEncounter == true then
    print("temp_RestartHellwalkerEncounter = true")
    Checkpoint_Encounter_2:Start()
  end
end
function Health_Encounter(Enemy)
  if Enemy ~= nil then
    FF_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local EnemyHealth = Enemy:GetHitPoints()
    FF_HealthMonitor:OnHealthLessThan(EnemyHealth, StartFirstHumanKillCine)
  end
end
function StartFirstHumanKillCine()
  thisLevel:GetGameObject("Cine_FirstHumanKill").LuaObjectScript.StartCineSequence()
end
function EnterSafeZone()
  GameObjects.FinalFanaticHelper:HideCollision()
end
function ExitSafeZone()
  GameObjects.FinalFanaticHelper:ShowCollision()
end
function HellWalkerEncounter_Spawn()
  Area_1_Encounter_2:Start()
end
function HellWalkerEncounterStart()
  RestartHellwalkerEncounter = true
  RestartBanditEncounter = false
  timers.StartLevelTimer(0.25, function()
    game.World.StoreCheckpoint()
  end)
end
function HellWalkerEncounterComplete()
  print("----------------------------------------------------HellWalkerEncounterComplete----------------------------")
  son:CallScript("LuaHook_SetNextPostCombatTimerLength", 15)
  son:CallScript("LuaHook_IgnoreDistanceExitNextPostCombat")
  RestartHellwalkerEncounter = false
  riv250_Banter:CallScript("FirstHumanKillAftermath1_Banter")
  game.Audio.StartMusic("SND_MX_RIV_fight_undead_out")
end
function InitBanditEnctouner()
  BanditEncounter = EC.NewEncounter(thisLevel, "BanditEncounter")
  BanditEncounter:AddWave({
    {
      spawners = "InitialSpawn03",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.1,
      spawnCooldown = 0
    }
  })
  BanditEncounter:AddWave({
    {
      spawners = "Fanatic_Spawn03",
      spawnLocators = "A1_U_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 2
    }
  })
  BanditEncounter:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Fanatic_Spawn03",
      spawnLocators = "A1_U_Loc_05",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.5
    }
  })
  BanditEncounter:AddWave({
    {
      spawners = "FinalFanatic_Spawn01",
      markerID = "FinalFanatic",
      spawnCooldown = 1.5
    }
  })
  BanditEncounter:OnEnemyDeath(function()
    StartFirstHumanKillCine()
    game.Player.FindPlayer():DropThrowable("ATT_Axe")
  end, {
    markerID = "FinalFanatic"
  })
end
function BanditEncounterStart()
  BanditEncounter:Start()
end
function GivePlayerTempNoReactions()
  game.Player.FindPlayer():PickupAcquire("PostCSMoveInvulnerability", 1)
end
function AddCineBandits_ToEncounter(level, cineBandit1, cineBandit2, cineBandit3, cineBandit4)
  BanditEncounter:InsertEnemy(cineBandit1, 1)
  BanditEncounter:InsertEnemy(cineBandit2, 1)
  BanditEncounter:InsertEnemy(cineBandit3, 1)
  BanditEncounter:InsertEnemy(cineBandit4, 1)
  RestartBanditEncounter = true
  banditReferences = {
    cineBandit1,
    cineBandit2,
    cineBandit3,
    cineBandit4
  }
end
function Checkpoint_Area_1_Fight_1()
  Checkpoint_Encounter_1 = EC.NewEncounter(thisLevel, "Restart Bandit Encounter", {})
  Checkpoint_Encounter_1:AddWave({
    {
      spawners = "Bandit_N_Spawn",
      spawnLocators = "A1_RB_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.01
    },
    {
      spawners = "Bandit_N_Spawn",
      spawnLocators = "A1_RB_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.04
    },
    {
      spawners = "Bandit_N_Spawn",
      spawnLocators = "A1_RB_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.07
    },
    {
      spawners = "Bandit_N_Spawn",
      spawnLocators = "A1_RB_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    },
    {
      spawners = "Bandit_N_Spawn",
      spawnLocators = "A1_RB_Loc_05",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.02
    }
  })
  Checkpoint_Encounter_1:AddWave({
    {
      spawners = "Fanatic_Spawn03",
      spawnLocators = "A1_U_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 2
    }
  })
  Checkpoint_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Fanatic_Spawn03",
      spawnLocators = "A1_U_Loc_05",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.5
    }
  })
  Checkpoint_Encounter_1:AddWave({
    {
      spawners = "FinalFanatic_Spawn01",
      markerID = "FinalFanatic",
      spawnCooldown = 1.5
    }
  })
  Checkpoint_Encounter_1:OnCombatStart(function()
    game.Audio.StartCheckpointedMusic("SND_MX_RIV_fight_bandits_in")
  end)
  Checkpoint_Encounter_1:OnEnemyDeath(function()
    StartFirstHumanKillCine()
    game.Player.FindPlayer():DropThrowable("ATT_Axe")
  end, {
    markerID = "FinalFanatic"
  })
  Checkpoint_Encounter_1:OnEnemySpawn(function(enemy)
    if banditReferences == nil then
      banditReferences = {}
    end
    table.insert(banditReferences, enemy)
  end, {wave = 1})
end
function DestroyBanditCorpses()
  if banditReferences ~= nil then
    for _, bandit in pairs(banditReferences) do
      if bandit ~= nil then
        bandit:Hide()
      end
    end
  end
end
function Start_Area_1_Encounter_2()
  RestartBanditEncounter = false
  Area_1_Encounter_2:Start()
end
function Area_1_Fight_2()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Helwalkers Riv250", {CheckpointOnComplete = false})
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Helwalker_S_1",
      markerID = "zombie1",
      spawnLocators = "A1_H_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    },
    {
      spawners = "Helwalker_S_2",
      markerID = "zombie2",
      spawnLocators = "A1_H_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2
    },
    {
      spawners = "Helwalker_S_3",
      markerID = "zombie3",
      spawnLocators = "A1_H_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.3
    }
  })
  Area_1_Encounter_2:OnComplete(HellWalkerEncounterComplete)
end
function Checkpoint_Area_1_Fight_2()
  print("Checkpoint_Area_1_Fight_2")
  Checkpoint_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Riv250", {CheckpointOnComplete = false})
  Checkpoint_Encounter_2:AddWave({
    {
      spawners = "Helwalker_1_SFG",
      spawnLocators = "A1_O_Loc_04",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Helwalker_1_SFG",
      spawnLocators = "A1_H_Loc_06",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.02
    },
    {
      spawners = "Helwalker_2_SFG",
      spawnLocators = "A1_H_Loc_05",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.03
    }
  })
  Checkpoint_Encounter_2:OnComplete(HellWalkerEncounterComplete)
  Checkpoint_Encounter_2:OnStart(function()
    game.AI.FindSon():CallScript("EnterBehaviorContext", "WILL_NOT_FIGHT_BEHAVIOR_CONTEXT_CONFIG")
  end)
  timers.StartLevelTimer(1, function()
    Checkpoint_Encounter_2:AlertEnemies()
  end)
  timers.StartLevelTimer(5, function()
    Checkpoint_Encounter_2:AlertEnemies()
  end)
end
function Riv250_Bookmark_FirstHumanKillComplete()
  BanditEncounter:SetComplete()
end
