local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local CCEC = require("camera.camera_cineentercamera")
local LM = require("level.loadmonitor")
local thisObj, thisLevel, gate, kratosActor, sonActor, banditActor1, banditActor2, banditActor3, banditActor4, banditCreature1, banditCreature2, banditCreature3, banditCreature4, cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_narRivBanditCamp000", 4, nil)
  cameraCineEnter:SetObjectToSleep(obj)
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") >= 120 then
    DisableAvoidSplineSmall()
  end
  if game.Level.GetVariable("CompletedCineNumber") <= 130 and game.CHECK_FEATURE("PRESTREAM_ENEMIES") then
    local aiWadMonitor = LM.CreateLoadMonitor()
    aiWadMonitor:AddCallback({
      Wads = {
        "Riv250_AI01"
      },
      Functions = {
        Riv250_AI01_IsLoaded
      }
    })
  end
end
function Riv250_AI01_IsLoaded()
  local aiWad = game.FindLevel("Riv250_AI01")
  local pos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("bandit_spawn1"))
  game.Encounters.RequestGlobalCharacterPrestream(aiWad, pos, "CRT_BanditHuman00", "Bandit01")
  pos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("bandit_spawn2"))
  game.Encounters.RequestGlobalCharacterPrestream(aiWad, pos, "CRT_BanditHuman00", "Bandit02")
  pos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("bandit_spawn3"))
  game.Encounters.RequestGlobalCharacterPrestream(aiWad, pos, "CRT_BanditHuman00", "Bandit04")
  pos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("bandit_spawn4"))
  game.Encounters.RequestGlobalCharacterPrestream(aiWad, pos, "CRT_BanditHuman00", "Bandit03")
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function CreateActors()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  banditActor1 = actor.Actor.New("BanditHuman1")
  banditActor2 = actor.Actor.New("BanditHuman2")
  banditActor3 = actor.Actor.New("BanditHuman3")
  banditActor4 = actor.Actor.New("BanditHuman4")
  gate = GameObjects.Lift_Gate.Child
end
function SetSpawnFunctions()
  banditActor1:SetSpawnFunction(function()
    local aiWad = game.FindLevel("Riv250_AI01")
    local pos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("bandit_spawn1"))
    local dir = thisObj:GetWorldJointForward(thisObj:GetJointIndex("bandit_spawn1"))
    local aiObject
    aiObject = game.AI.Spawn(aiWad, pos, dir, "CRT_BanditHuman00", "BRA_BanditCamp1", {PowerLevel = 1}, "Bandit01")
    aiObject:AddMarker("bandit1")
    return aiObject
  end)
  banditActor2:SetSpawnFunction(function()
    local aiWad = game.FindLevel("Riv250_AI01")
    local pos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("bandit_spawn2"))
    local dir = thisObj:GetWorldJointForward(thisObj:GetJointIndex("bandit_spawn2"))
    local aiObject
    aiObject = game.AI.Spawn(aiWad, pos, dir, "CRT_BanditHuman00", "BRA_BanditCamp2", {PowerLevel = 1}, "Bandit02")
    aiObject:AddMarker("bandit2")
    return aiObject
  end)
  banditActor3:SetSpawnFunction(function()
    local aiWad = game.FindLevel("Riv250_AI01")
    local pos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("bandit_spawn3"))
    local dir = thisObj:GetWorldJointForward(thisObj:GetJointIndex("bandit_spawn3"))
    local aiObject
    aiObject = game.AI.Spawn(aiWad, pos, dir, "CRT_BanditHuman00", "BRA_BanditCamp3", {PowerLevel = 1}, "Bandit04")
    aiObject:AddMarker("bandit3")
    return aiObject
  end)
  banditActor4:SetSpawnFunction(function()
    local aiWad = game.FindLevel("Riv250_AI01")
    local pos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("bandit_spawn4"))
    local dir = thisObj:GetWorldJointForward(thisObj:GetJointIndex("bandit_spawn4"))
    return game.AI.Spawn(aiWad, pos, dir, "CRT_BanditHuman00", "BRA_BanditCamp4", {PowerLevel = 1}, "Bandit03")
  end)
end
function BuildBanditCampSeq()
  if game.Level.GetVariable("CompletedCineNumber") < 118 then
    GameObjects.EntZn_LoadCheck_AI01:Hide()
    CreateActors()
    SetSpawnFunctions()
    local seq = ND.CreateCineSequence(thisLevel, thisObj, "banditCamp")
    local actorTable = {
      {Actor = sonActor},
      {
        Actor = banditActor1,
        Branch = "BRA_BanditCamp1"
      },
      {
        Actor = banditActor2,
        Branch = "BRA_BanditCamp2"
      },
      {
        Actor = banditActor3,
        Branch = "BRA_BanditCamp3"
      },
      {
        Actor = banditActor4,
        Branch = "BRA_BanditCamp4"
      },
      {
        Obj = gate,
        Anim = "narRivBanditCamp000CineScene"
      }
    }
    gate.LuaObjectScript.EnableCinematicTrigger()
    seq:SetPostSkipMusic("SND_MX_RIV_start_master", "SND_MX_SonSick_master", nil, nil, nil, "SND_MX_RIV_fight_bandits_in")
    seq:MarkAbleToSkip()
    seq:WaitForLoadCheck("Riv250_AI01")
    seq:RequestCineModeAndWait(kratosActor, thisObj)
    seq:Do(StartPreCineCamera)
    seq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_BanditCamp",
      ReferenceJoint = "BanditCamp_SyncJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = ND.StopTurnRadius,
      weapon_state = "bare_on_back"
    })
    seq:Do(CA_DisableRiv200_Riv225)
    seq:SpawnActorAndWait(banditActor1)
    seq:SpawnActorAndWait(banditActor2)
    seq:SpawnActorAndWait(banditActor3)
    seq:SpawnActorAndWait(banditActor4)
    seq:ActorSync(kratosActor, {
      Slaves = actorTable,
      Branch = "BRA_BanditCamp",
      ReferenceJoint = "BanditCamp_SyncJoint"
    })
    seq:WaitUntilActorAnimPastFrame(kratosActor, 640)
    seq:Do(BanditEncounter_Start)
    seq:Do(SetSonAvailabity)
    seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    seq:StopPuppetingActor(sonActor)
    seq:StopPuppetingActor(kratosActor)
    seq:StopPuppetingActor(banditActor1)
    seq:StopPuppetingActor(banditActor2)
    seq:StopPuppetingActor(banditActor3)
    seq:StopPuppetingActor(banditActor4)
    seq:SetCompletedCineNumber(118)
    seq:Do(ConnectToBanditEncounter)
    seq:Do(SonToHidingSpot_Start)
    seq:Do(Quest_RiverPass_Objective200_End)
    seq:Do(function()
      game.World.StoreCheckpoint()
    end)
    seq:StartSequence()
  end
end
function ConnectToBanditEncounter()
  local riv250ai = game.FindLevel("Riv250_AI01")
  banditCreature1 = banditActor1.spawned_object:GetCreature()
  banditCreature2 = banditActor2.spawned_object:GetCreature()
  banditCreature3 = banditActor3.spawned_object:GetCreature()
  banditCreature4 = banditActor4.spawned_object:GetCreature()
  riv250ai:CallScript("AddCineBandits_ToEncounter", banditCreature1, banditCreature2, banditCreature3, banditCreature4)
end
function BanditEncounter_Start()
  game.FindLevel("Riv250_AI01"):CallScript("BanditEncounterStart")
  game.FindLevel("Riv200_DangersMain"):CallScript("DisableBanditCampSplines")
  game.FindLevel("Riv200_DangersMain"):CallScript("RemoveBanditSpeedControl")
end
function SetSonAvailabity()
  local availabilityState = {
    AvailableForSync = true,
    AvailableForBanter = true,
    AvailableInLevel = true,
    AvailableForCombat = false
  }
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  game.AI.FindSon():CallScript("EnterBehaviorContext", "WILL_NOT_FIGHT_BEHAVIOR_CONTEXT_CONFIG")
end
function SonToHidingSpot_Start()
  GameObjects.LTW_AvoidEnemies_Small.LuaObjectScript.Enable()
  GameObjects.CA_CineHelper.LuaObjectScript.Enable()
end
function DisableAvoidSplineSmall()
  GameObjects.LTW_AvoidEnemies_Small.LuaObjectScript.Disable()
  GameObjects.CA_CineHelper.LuaObjectScript.Disable()
end
function LoadCheck_Riv250_AI01()
  game.UI.LoadCheck("Riv250_AI01")
end
function CA_DisableRiv200_Riv225()
  local riv200 = game.FindLevel("Riv200_DangersMain")
  if riv200 ~= nil then
    riv200:CallScript("EnterBanditCamp")
  end
end
function StartPreCineCamera()
  cameraCineEnter:Start()
end
function Quest_RiverPass_Objective200_End()
  game.QuestManager.ProposeQuestState("Quest_RiverPass_Objective200", "Complete")
end
