local EC = require("design.Encounter")
local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local uiCalls = require("ui.uicalls")
local myCamShake, myRumble, liftGateWasOpen, RIV_NAR_BanditFightDone, lowerCA_Disabled, Checkpoint_Encounter_1
function OnScriptLoaded(level)
  myCamShake = {
    EffectName = "FSE_shake_temp_Generic_Large",
    Duration = 3
  }
  myRumble = {EffectName = "FFB_LARGE", Duration = 3}
  SoundInit()
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_Riv250_AI01" and not liftGateWasOpen then
    GameObjects.Lift_Gate.LuaObjectScript.Enable()
  end
end
function OnStart(level)
  GameObjects.AI_SheetHelper:HideCollision()
  GameObjects.NavmeshHelper1:Hide()
  GameObjects.NavmeshHelper2:Hide()
  GameObjects.NavmeshHelper3:Hide()
  if game.FindLevel("Riv250_AI01") ~= nil and not liftGateWasOpen then
    GameObjects.Lift_Gate.LuaObjectScript.Enable()
  end
end
function OnUpdate(level)
end
function OnUseWorld(level)
end
function Encounter_1_Complete()
  Checkpoint_Encounter_1:SetComplete()
  GameObjects.AI_SheetHelper:ShowCollision()
  GameObjects.Banter_Riv250.LuaObjectScript.FirstHumanKillAftermath1_Banter()
end
function EnableBoost(level)
  GameObjects.SonBoost_StartSadness.LuaObjectScript:Enable()
end
function RumbleAndShake(level)
  game.FX.SubmitEffect(myCamShake)
  game.FX.SubmitEffect(myRumble)
end
function EnableContextAction()
  GameObjects.CA_ObserveForward.LuaObjectScript:Enable()
end
function DisableContextAction()
  GameObjects.CA_ObserveForward.LuaObjectScript:Disable()
end
function LTW_AvoidEnemiesEnable()
  GameObjects.LTW_AvoidEnemies.LuaObjectScript.Enable()
end
function HellwalkerFightComplete()
  if not lowerCA_Disabled then
    GameObjects.LTW_AvoidEnemies.LuaObjectScript.Disable()
    GameObjects.CA_Sad_Posiiton2.LuaObjectScript.Enable()
    GameObjects.CA_Idle_PreBoost.LuaObjectScript.Enable()
  end
end
function DisableLowerCA()
  lowerCA_Disabled = true
  GameObjects.CA_Sad_Posiiton2.LuaObjectScript.Disable()
  GameObjects.CA_Idle_PreBoost.LuaObjectScript.Disable()
  GameObjects.LTW_AvoidEnemies.LuaObjectScript.Disable()
  GameObjects.LTW_AvoidEnemies_Small.LuaObjectScript.Disable()
end
function EnableSyncExitCA()
  if game.Level.GetVariable("CompletedCineNumber") >= 130 then
    GameObjects.CA_CampSyncExit.LuaObjectScript.Enable()
  end
end
function OnSaveCheckpoint(level, obj, savedInfo)
  return {
    levelstate = checkpoint.Save(),
    temp_liftGateWasOpen = liftGateWasOpen
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  liftGateWasOpen = savedInfo.liftGateWasOpen
end
function ShowCameraVolume_GoToFallenSon()
  GameObjects.IndoorBaseNav_GoToFallenSon:ShowCameraVolume()
end
function HideCameraVolume_GoToFallenSon()
  GameObjects.IndoorBaseNav_GoToFallenSon:HideCameraVolume()
end
local SNDBanditGate, banditGate
function SoundInit()
  banditGate = GameObjects.Lift_Gate
  SNDBanditGate = banditGate.Child:FindSingleSoundEmitterByName("SNDLiftGate")
end
function LH_PlaySoundBanditGate()
  print("LIFT EMITTER ", SNDBanditGate, " AND LIFT OBJ", banditGate)
  LD.PlaySound(SNDBanditGate, "SND_DOOR_Gate_Metal_Lift_Start")
end
function OnEvaluateLoadGroup_LoadGroup_AI()
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    return "FirstHumanKillCine"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 130 and game.Level.GetVariable("CompletedCineNumber") < 400 then
    return "AI_Visit01"
  else
    return "AI_Visit02"
  end
end
function BanditCineStarted()
  liftGateWasOpen = true
end
function ShowMsg()
  if not liftGateWasOpen then
    uiCalls.UI_Event_SendTutorialMessage("Loading...", 0)
  end
end
function HideMsg()
  print("this is all temp")
  uiCalls.UI_Event_TurnOffTutorialMessage()
end
function SonReachedRope()
  GameObjects.CA_PostRope_UnAvailable.LuaObjectScript.Enable()
  SetAvailabity_NoSync()
end
function SetAvailabity_NoSync()
  if game.Level.GetVariable("CompletedCineNumber") <= 120 then
    local availabilityState = {
      AvailableForSync = false,
      AvailableForBanter = true,
      AvailableInLevel = true,
      AvailableForCombat = false
    }
    game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  end
end
function SetAvailabity_Sad()
  if game.Level.GetVariable("CompletedCineNumber") <= 120 then
    local availabilityState = {
      AvailableForSync = true,
      AvailableForBanter = true,
      AvailableInLevel = true,
      AvailableForCombat = false
    }
    game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  end
end
function InsideCamp()
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    GameObjects.CA_PostRope_UnAvailable.LuaObjectScript.Enable()
  else
    GameObjects.CA_RopeExit_Bottom.LuaObjectScript.Enable()
  end
  GameObjects.CA_WaitNearExit.LuaObjectScript.Disable()
  SetAvailabity_NoSync()
end
function RopeExit_Top()
  if game.Level.GetVariable("CompletedCineNumber") >= 130 then
    GameObjects.CA_RopeExit_Top.LuaObjectScript.Enable()
    GameObjects.CA_RopeExit_Bottom.LuaObjectScript.Disable()
  end
end
function RopeExit_Bottom()
  if game.Level.GetVariable("CompletedCineNumber") >= 130 then
    GameObjects.CA_RopeExit_Bottom.LuaObjectScript.Enable()
    GameObjects.CA_RopeExit_Top.LuaObjectScript.Disable()
  end
end
function LeavingCamp()
  GameObjects.CA_WaitNearExit.LuaObjectScript.Enable()
  GameObjects.CA_RopeExit_Top.LuaObjectScript.Disable()
  GameObjects.CA_PostRope_UnAvailable.LuaObjectScript.Disable()
  SetAvailabity_Sad()
end
function DisableAllCA()
  GameObjects.CA_WaitNearExit.LuaObjectScript.Disable()
  GameObjects.CA_RopeExit_Top.LuaObjectScript.Disable()
end
function Riv250_Bookmark_FirstHumanKillComplete()
  EnableBoost()
end
