local ND = require("design.NarrativeDesignLibrary")
local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local TUT = require("game.GlobalTutorials")
local CCEC = require("camera.camera_cineentercamera")
local player, thisObj, thisLevel, shopBrokSpawner, son, kratosActor, sonActor, brokActor, riv200, riv260, treePatch, crow, crow1, crow2, crow3, crow4, crow5, brokBrandingIron, beastOfBurden, cine_lights
local axeTargetHit = false
local shopFightBanter01_played = false
local useNonCineBrok = false
local introducingBrokPlayed = false
local brokIntroStarted = false
local loadedCheckpoint = false
local bThrewAxeIntoTree, cineEnterCamera_BrokIntro_010, cineEnterCamera_BrokIntro_020, reticleData, crowsound, crow1sound, crow2sound, crow3sound, crow4sound, crow5sound
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  riv260 = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  SoundInit()
  print("------------ init has initiated")
  GameObjects.EntZn_BrokIntrowallpress_SpeedControl:HideEntityVolume()
  bThrewAxeIntoTree = false
  reticleData = false
  game.SubObject.Sleep(thisObj)
end
function OnStart(level, obj)
  riv200 = game.FindLevel("Riv200_DangersMain")
  InitializeVariables()
  ClearActiveMarker()
  CreateActors()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  print("------------ OnStart has initiated and completed cine number is ", cineNum)
  if 120 <= cineNum and cineNum < 130 then
    InitializeProps()
    CreateActors()
    BuildBrokIntroIdleSequence()
    HideHammer()
  elseif useNonCineBrok then
    SpawnBrokIdle()
  end
  HideBeastIfEaten()
  HideCineLights()
end
function OnUpdate(level, obj)
  if cineEnterCamera_BrokIntro_010 ~= nil then
    cineEnterCamera_BrokIntro_010:Update()
  end
  if cineEnterCamera_BrokIntro_020 ~= nil then
    cineEnterCamera_BrokIntro_020:Update()
  end
  reticleData = player:GetReticleState()
  if bThrewAxeIntoTree == false and reticleData.Mechanic == "AXE" and bThrewAxeIntoTree == false and player:IsPlayingMove("MOV_AxeTossHorizontalEnterToss") then
    bThrewAxeIntoTree = true
    LockCameraControls(0.5)
  end
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  savedInfo.useNonCineBrok = useNonCineBrok
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
  useNonCineBrok = savedInfo.useNonCineBrok
  if game.Level.GetVariable("CompletedCineNumber") == 130 then
    loadedCheckpoint = true
  end
end
function InitializeVariables()
  treePatch = GameObjects.treePatch.Child
  crow = GameObjects.crow.Child
  crow1 = GameObjects.crow1.Child
  crow2 = GameObjects.crow2.Child
  crow3 = GameObjects.crow3.Child
  crow4 = GameObjects.crow4.Child
  crow5 = GameObjects.crow5.Child
  brokBrandingIron = GameObjects.brokBrandingIron.Child
  beastOfBurden = GameObjects.BeastOfBurden.Child
  cine_lights = GameObjects.Cine_Start_130
  shopBrokSpawner = GameObjects.SmallShop.Child:FindSingleGOByName("VendorSpawner").Child
end
function InitializeProps()
  treePatch:StartAnim("narRivBrokIntro035CineScene")
  treePatch:PauseAnim()
  treePatch:Hide()
  crow:StartAnim("narRivBrokIntro035CineScene")
  crow:PauseAnim()
  crow1:StartAnim("narRivBrokIntro035CineScene1")
  crow1:PauseAnim()
  crow2:StartAnim("narRivBrokIntro035CineScene2")
  crow2:PauseAnim()
  crow3:StartAnim("narRivBrokIntro035CineScene3")
  crow3:PauseAnim()
  crow4:StartAnim("narRivBrokIntro035CineScene4")
  crow4:PauseAnim()
  crow5:StartAnim("narRivBrokIntro035CineScene5")
  crow5:PauseAnim()
  crowsound = crow:FindSingleSoundEmitterByName("SNDCrow00")
  crow1sound = crow1:FindSingleSoundEmitterByName("SNDCrow00")
  crow2sound = crow2:FindSingleSoundEmitterByName("SNDCrow00")
  crow3sound = crow3:FindSingleSoundEmitterByName("SNDCrow00")
  crow4sound = crow4:FindSingleSoundEmitterByName("SNDCrow00")
  crow5sound = crow5:FindSingleSoundEmitterByName("SNDCrow00")
  brokBrandingIron:StartAnim("narRivBrokIntro040CineScene")
  brokBrandingIron:PauseAnim()
end
function ClearActiveMarker()
  if player:HasMarker("BrokIntroActive") then
    player:RemoveMarker("BrokIntroActive")
  end
end
function PlayCineLights()
  cine_lights:Show()
  cine_lights:JumpAnimToFrame(0)
  cine_lights:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights:Hide()
end
function HideHammer()
  local hammer = GameObjects.brokHammer_Prop.Child
  hammer:StartAnim("poiRivBrokSonHide020Exit")
  hammer:JumpAnimToFrame(hammer.AnimLengthFrames)
  hammer:PauseAnim()
  hammer:Hide()
end
function CreateActors()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  brokActor = actor.Actor.New("Brok")
  SetSpawnFunctions()
end
function SpawnBrokIdle()
  shopBrokSpawner.LuaObjectScript.SpawnEnemy()
end
function SetSpawnFunctions()
  brokActor:SetSpawnFunction(function()
    local brokRef = ND.FindBrok()
    if brokRef then
      return brokRef
    end
    if ShouldBrokSonHideRestart() then
      return ND.SpawnAIAtJoint(thisLevel, "POI_BrokSonHide", "BrokSonHide_SyncJoint", "CRT_Brok00", "BRA_BrokSonHideLoop", "Brok")
    else
      return ND.SpawnAIAtJoint(thisLevel, "Cine_BrokIntro", "Brok_Start", "CRT_Brok00", "BRA_BrokIntroIdle1", "Brok")
    end
  end)
end
function BuildBrokIntroIdleSequence()
  local brokIntroIdleSeq = ND.CreateCineSequence(thisLevel, thisObj, "brokIntroIdle")
  local introducingBrokASeq = ND.CreateCineSequence(thisLevel, thisObj, "introducingBrokA")
  local introducingBrokBSeq = ND.CreateCineSequence(thisLevel, thisObj, "introducingBrokB")
  local brokIntro_BrokIdle_ActorTable = {
    {
      Obj = beastOfBurden,
      Anim = "narRivBrokIntro010CineLoop"
    }
  }
  local brokIntro_SonIdle_ActorTable = {
    {Actor = brokActor},
    {
      Obj = beastOfBurden,
      Anim = "narRivBrokIntro020CineScene",
      TweenTime = 0.75
    }
  }
  brokIntroIdleSeq:Do(function()
    game.SubObject.Wake(thisObj)
  end)
  brokIntroIdleSeq:SpawnActorAndWait(brokActor)
  brokIntroIdleSeq:Do(SwitchTreesToCine)
  brokIntroIdleSeq:ActorSync(brokActor, {
    Slaves = brokIntro_BrokIdle_ActorTable,
    Branch = "BRA_BrokIntroIdle1",
    ReferenceJoint = "BrokIntro_SyncJoint"
  })
  brokIntroIdleSeq:WaitForActorInZone(kratosActor, GameObjects.CineZone_IntroducingBrok_On)
  brokIntroIdleSeq:BranchSequence(introducingBrokASeq)
  introducingBrokASeq:Do(function()
    game.Audio.PlayBanter("RIV_IntroducingBrokAFull", function()
      introducingBrokPlayed = true
    end)
  end)
  introducingBrokASeq:WaitForFunctionTrue(function()
    return introducingBrokPlayed
  end)
  introducingBrokASeq:WaitSeconds(20)
  introducingBrokASeq:Do(function()
    GameObjects.BrokIdle_BanterLoop.Child.LuaObjectScript.Enable()
  end)
  brokIntroIdleSeq:WaitForActorInZone(sonActor, thisObj)
  brokIntroIdleSeq:CancelSequence(introducingBrokASeq)
  brokIntroIdleSeq:Do(function()
    GameObjects.BrokIdle_BanterLoop.Child.LuaObjectScript.Disable()
  end)
  brokIntroIdleSeq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_BrokIntroIdle2",
    ReferenceJoint = "BrokIntro_SyncJoint",
    speed = ND.SonWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.SonWalkArrivalRadius
  })
  brokIntroIdleSeq:Do(DisableLeadTheWay)
  brokIntroIdleSeq:ActorSync(sonActor, {
    Slaves = brokIntro_SonIdle_ActorTable,
    Branch = "BRA_BrokIntroIdle2",
    ReferenceJoint = "BrokIntro_SyncJoint"
  })
  brokIntroIdleSeq:WaitUntilActorAnimPastFrame(sonActor, 679)
  brokIntroIdleSeq:Do(Quest_RiverPass_Objective350_End)
  brokIntroIdleSeq:Do(function()
    GameObjects.CineBehaviorZone.LuaObjectScript.AllowAxeThrow()
  end)
  brokIntroIdleSeq:WaitForActorPlayingMove(sonActor, "MOV_BrokIntroIdle2")
  brokIntroIdleSeq:BranchSequence(introducingBrokBSeq)
  introducingBrokBSeq:WaitSeconds(6)
  introducingBrokBSeq:Do(function()
    game.Audio.PlayBanter("RIV_IntroducingBrokB1")
  end)
  introducingBrokBSeq:WaitSeconds(10)
  introducingBrokBSeq:Do(function()
    game.Audio.PlayBanter("RIV_IntroducingBrokB2")
  end)
  introducingBrokBSeq:WaitSeconds(12)
  introducingBrokBSeq:Do(function()
    game.Audio.PlayBanter("RIV_IntroducingBrokB3")
  end)
  introducingBrokBSeq:WaitSeconds(15)
  introducingBrokBSeq:Do(function()
    game.Audio.PlayBanter("RIV_IntroducingBrokB4")
  end)
  introducingBrokBSeq:WaitSeconds(30)
  introducingBrokBSeq:Do(function()
    game.Audio.PlayBanter("RIV_IntroducingBrokB2")
  end)
  introducingBrokBSeq:WaitSeconds(30)
  introducingBrokBSeq:Do(function()
    GameObjects.BrokIdleB_BanterLoop.Child.LuaObjectScript.Enable()
  end)
  brokIntroIdleSeq:WaitForFunctionTrue(function()
    return bThrewAxeIntoTree or axeTargetHit
  end)
  brokIntroIdleSeq:WaitForFunctionTrue(function()
    return axeTargetHit
  end)
  brokIntroIdleSeq:CancelSequence(introducingBrokBSeq)
  brokIntroIdleSeq:Do(function()
    GameObjects.BrokIdleB_BanterLoop.Child.LuaObjectScript.Disable()
  end)
  brokIntroIdleSeq:StartSequence()
end
function BuildBrokIntroSequence()
  if not brokIntroStarted then
    brokIntroStarted = true
    local brokIntroSeq = ND.CreateCineSequence(thisLevel, thisObj, "brokIntro")
    local brokIntro_ActorTable = {
      {Actor = sonActor},
      {Actor = brokActor},
      {
        Obj = beastOfBurden,
        Anim = "narRivBrokIntro040CineScene"
      },
      {
        Obj = brokBrandingIron,
        Anim = "narRivBrokIntro040CineScene"
      }
    }
    LD.PlaySound(player:FindSingleSoundEmitterByName("SNDKratos"), "SND_POI_Brok_Intro_Axe_Throw_Tree_Scare_Draugr")
    CancelAimWalk()
    player.Pad:DisableGameButton(tweaks.ePad.kPadTriangle)
    axeTargetHit = true
    Play_AxeHit_PropReactions()
    brokIntroSeq:RequestCineModeAndWait(kratosActor, thisObj)
    brokIntroSeq:Do(StartCineEnter_BrokIntro)
    brokIntroSeq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_BrokIntro",
      ReferenceJoint = "BrokIntro_SyncJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = ND.StopTurnRadius,
      ignore_navmesh = true
    })
    brokIntroSeq:Do(function()
      kratosActor:GetActivePuppeteer():StartMove("MOV_CineIdle_LoopToSelf")
    end)
    brokIntroSeq:WaitForFunctionTrue(function()
      return treePatch.AnimFrame >= 164
    end)
    brokIntroSeq:Do(PlayCineLights)
    brokIntroSeq:Do(function()
      GameObjects.BeastCollision:HideCollision()
    end)
    brokIntroSeq:ActorSync(kratosActor, {
      Slaves = brokIntro_ActorTable,
      Branch = "BRA_BrokIntro",
      ReferenceJoint = "BrokIntro_SyncJoint"
    })
    brokIntroSeq:SetPostSkipMusic("SND_MX_RIV_start_master", "SND_MX_SonSick_master")
    brokIntroSeq:MarkAbleToSkip()
    brokIntroSeq:Do(function()
      if not player:HasMarker("BrokIntroActive") then
        player:AddMarker("BrokIntroActive")
      end
    end)
    brokIntroSeq:Do(function()
      player.Pad:EnableGameButton(tweaks.ePad.kPadTriangle)
    end)
    brokIntroSeq:Do(function()
      GameObjects.CineBehaviorZone.LuaObjectScript.BrokIntroStarted()
    end)
    brokIntroSeq:Do(function()
      GameObjects.SpeedControlZone_Bridge:HideEntityVolume()
    end)
    brokIntroSeq:Do(EnableTraversalSyncs)
    brokIntroSeq:Do(DisableLeadTheWay)
    brokIntroSeq:Do(function()
      riv260:CallScript("DisableBrokShop")
    end)
    brokIntroSeq:Do(function()
      beastOfBurden:OnAnimDone(thisObj, "BeastOfBurden_Idle")
    end)
    brokIntroSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.96)
    brokIntroSeq:Do(function()
      LockCameraControls(6.9)
    end)
    brokIntroSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.99)
    brokIntroSeq:Do(function()
      brokIntroSeq:EndSkipIfActive()
    end)
    brokIntroSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    brokIntroSeq:SetCompletedCineNumber(130)
    brokIntroSeq:Do(DisableAxeTarget)
    brokIntroSeq:StopPuppetingActor(sonActor)
    brokIntroSeq:StopPuppetingActor(kratosActor)
    brokIntroSeq:StopPuppetingActor(brokActor)
    brokIntroSeq:Do(BranchBrokToTableIdle)
    brokIntroSeq:Do(HideCineLights)
    brokIntroSeq:Do(SwitchTreesBack)
    brokIntroSeq:Do(function()
      riv260:CallScript("ForceShopInteract")
    end)
    brokIntroSeq:Do(function()
      riv200:CallScript("AxeUpgradeMonitorStart")
    end)
    brokIntroSeq:StartSequence()
    GameObjects.Temp_Blocker:HideCollision()
  end
end
function BranchBrokToTableIdle()
  GameObjects.smallShopModule.LuaObjectScript.StartCounterRequest(brokActor:GetCreature())
end
function RecallDisable()
  player.Pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  timers.StartLevelTimer(1, function()
    if not brokIntroStarted then
      player.Pad:EnableGameButton(tweaks.ePad.kPadTriangle)
    else
      GameObjects.BasicAxeTarget_RecallDisable:Hide()
    end
  end)
end
function StopBrokInteract()
  brokActor:GetCreature():EndInteract()
end
function BeastOfBurden_Idle()
  beastOfBurden:ClearAllAnimCallbacks()
  beastOfBurden:StartAnim("narRivBrokIntro050CineLoop")
  beastOfBurden:PlayAnimCycle()
end
function HideBeastIfEaten()
  if game.Level.GetVariable("CompletedCineNumber") >= 320 then
    beastOfBurden:PauseAnim()
    beastOfBurden:Hide()
  end
end
function Play_AxeHit_PropReactions()
  crow:StartAnim("narRivBrokIntro035CineScene")
  LD.PlaySoundOnFrame(crowsound, crow, "SND_AMB_EMIT_Crow_Call_Fly_Off", 7)
  LD.PlaySoundOnFrame(crowsound, crow, "SND_AMB_EMIT_Crow_Wing_Flap_Take_Off", 9)
  crow1:StartAnim("narRivBrokIntro035CineScene1")
  LD.PlaySoundOnFrame(crow1sound, crow1, "SND_AMB_EMIT_Crow_Call_Fly_Off", 48)
  LD.PlaySoundOnFrame(crow1sound, crow1, "SND_AMB_EMIT_Crow_Wing_Flap_Take_Off", 49)
  crow2:StartAnim("narRivBrokIntro035CineScene2")
  LD.PlaySoundOnFrame(crow2sound, crow2, "SND_AMB_EMIT_Crow_Call_Fly_Off", 7)
  LD.PlaySoundOnFrame(crow2sound, crow2, "SND_AMB_EMIT_Crow_Wing_Flap_Take_Off", 8)
  crow3:StartAnim("narRivBrokIntro035CineScene3")
  LD.PlaySoundOnFrame(crow3sound, crow3, "SND_AMB_EMIT_Crow_Call_Fly_Off", 3)
  LD.PlaySoundOnFrame(crow3sound, crow3, "SND_AMB_EMIT_Crow_Wing_Flap_Take_Off", 4)
  crow4:StartAnim("narRivBrokIntro035CineScene4")
  LD.PlaySoundOnFrame(crow4sound, crow4, "SND_AMB_EMIT_Crow_Call_Fly_Off", 6)
  LD.PlaySoundOnFrame(crow4sound, crow4, "SND_AMB_EMIT_Crow_Wing_Flap_Take_Off", 9)
  crow5:StartAnim("narRivBrokIntro035CineScene5")
  LD.PlaySoundOnFrame(crow5sound, crow5, "SND_AMB_EMIT_Crow_Call_Fly_Off", 8)
  LD.PlaySoundOnFrame(crow5sound, crow5, "SND_AMB_EMIT_Crow_Wing_Flap_Take_Off", 10)
  treePatch:StartAnim("narRivBrokIntro035CineScene")
  draugrHeavyVO()
end
function Quest_RiverPass_Objective350_End()
  LD.CompleteQuest("Quest_RiverPass_Objective350")
end
function StartBrokSonHide()
  local seq = ND.CreateCineSequence(thisLevel, GameObjects.POI_BrokSonHide, "brokSonHide")
  GameObjects.brokHammer_Prop.Child:Show()
  if ShouldBrokSonHideRestart() then
    local actorTable = {
      {Actor = brokActor},
      {
        Obj = GameObjects.brokHammer_Prop.Child,
        Anim = "poiRivBrokSonHide010Idle"
      }
    }
    seq:SpawnActorAndWait(brokActor)
    seq:ActorSync(sonActor, {
      Slaves = actorTable,
      Branch = "BRA_BrokSonHideLoop",
      ReferenceJoint = "BrokSonHide_SyncJoint"
    })
  else
    local actorTable = {
      {Actor = brokActor},
      {
        Obj = GameObjects.brokHammer_Prop.Child,
        Anim = "poiRivBrokSonHide000Enter"
      }
    }
    seq:WaitForFunctionTrue(function()
      return son:IsPlayingMove("MOV_BrokSonHide")
    end)
    seq:ActorSync(sonActor, {
      Slaves = actorTable,
      Branch = "BRA_BrokSonHide",
      ReferenceJoint = "BrokSonHide_SyncJoint"
    })
  end
  seq:Do(StopBrokInteract)
  seq:Do(function()
    useNonCineBrok = true
  end)
  seq:Do(SetSonOccupied)
  seq:WaitSeconds(0.5)
  seq:Do(ClearActiveMarker)
  seq:StartSequence()
end
function ShouldBrokSonHideRestart()
  return game.Level.GetVariable("CompletedCineNumber") == 130 and loadedCheckpoint
end
function EndBrokSonHide()
  local actorTable = {
    {Actor = brokActor},
    {
      Obj = GameObjects.brokHammer_Prop.Child,
      Anim = "poiRivBrokSonHide020Exit"
    }
  }
  local seq = ND.CreateCineSequence(thisLevel, GameObjects.POI_BrokSonHide, "brokSonHideExit")
  seq:WaitSeconds(1)
  seq:ActorSync(sonActor, {
    Slaves = actorTable,
    Branch = "BRA_BrokSonHideExit",
    ReferenceJoint = "BrokSonHide_SyncJoint"
  })
  seq:WaitSeconds(1)
  seq:Do(CompleteQuestObjective370)
  seq:Do(function()
    game.Audio.PlayBanter("RIV_ShopFight_05_A", Notify_Riv200Banter_ShopFight05A_Over)
  end)
  seq:WaitUntilActorAnimPastPercentage(brokActor, 0.991)
  seq:StopPuppetingActor(brokActor)
  seq:Do(BranchBrokToTableIdle)
  seq:WaitForFunctionTrue(function()
    return not son:IsPlayingMove("MOV_BrokSonHideExit")
  end)
  seq:StopPuppetingActor(sonActor)
  seq:Do(RemoveSonOccupied)
  seq:StartSequence()
end
function CompleteQuestObjective370()
  game.QuestManager.ProposeQuestState("Quest_RiverPass_Objective370", "Complete")
end
function Notify_Riv200Banter_ShopFight05A_Over()
  game.FindLevel("Riv200_DangersMain"):GetGameObject("Riv200_Banter"):CallScript("Set_ShopFight05_A_Played")
end
function SwitchTreesToCine()
  game.FindLevel("Riv200_DangersMain"):GetGameObject("Riv200_Banter"):CallScript("HideTreePatch")
  game.FindLevel("Riv200_DangersMain"):CallScript("SwitchDropBridges")
  treePatch:Show()
end
function SwitchTreesBack()
  treePatch:Hide()
  game.FindLevel("Riv200_DangersMain"):GetGameObject("Riv200_Banter"):CallScript("ShowTreePatch")
end
function SetSonOccupied()
  local availabilityState = {Unoccupied = false, AvailableForCombat = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function RemoveSonOccupied()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
end
function EnableAxeTarget()
  GameObjects.BasicAxeTarget_BrokIntro.LuaObjectScript.Enable()
  GameObjects.BasicAxeTarget_BrokIntro:ShowCollision()
  GameObjects.BasicAxeTarget_RecallDisable.LuaObjectScript.Enable()
  GameObjects.BasicAxeTarget_RecallDisable:ShowCollision()
end
function DisableAxeTarget()
  print("DisableAxeTarget")
  GameObjects.BasicAxeTarget_BrokIntro.LuaObjectScript.Disable()
  GameObjects.BasicAxeTarget_BrokIntro:HideCollision()
  GameObjects.BasicAxeTarget_RecallDisable.LuaObjectScript.Disable()
  GameObjects.BasicAxeTarget_RecallDisable:HideCollision()
end
function BrokIntroCine_KratosApproach()
  BuildBrokIntroSequence()
  GameObjects.EnableAxeTarget:HideEntityVolume()
end
function EnableLeadTheWay()
  GameObjects.BrokIntro_LeadTheWay.LuaObjectScript:Enable()
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    GameObjects.EntZn_BrokIntrowallpress_SpeedControl:ShowEntityVolume()
  end
end
function EnableShallNotPass()
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    GameObjects.BrokIntro_YouShallNotPass.LuaObjectScript:Enable()
    GameObjects.EntZn_BrokIntrowallpress_SpeedControl:HideEntityVolume()
  end
end
function DisableLeadTheWay()
  GameObjects.BrokIntro_LeadTheWay.LuaObjectScript:Disable()
  GameObjects.BrokIntro_YouShallNotPass.LuaObjectScript:Disable()
  GameObjects.EntZn_ShallNotPass_DisablePlayer:HideEntityVolume()
  GameObjects.EntZn_ShallNotPass_EnablePlayer:HideEntityVolume()
end
function DisableShallNotPass()
  GameObjects.BrokIntro_YouShallNotPass.LuaObjectScript:Disable()
end
function ChainDrop_LTW_Off()
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    DisableLeadTheWay()
  end
end
function ChainDrop_LTW_On()
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    GameObjects.BrokIntro_LeadTheWay.LuaObjectScript:Enable()
  end
end
function DisableTraversalSyncs()
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", {Unoccupied = false})
  end
end
function DisableWallpressSpeedControll()
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    GameObjects.EntZn_BrokIntrowallpress_SpeedControl:HideEntityVolume()
  end
end
function EnableTraversalSyncs()
  if game.Level.GetVariable("CompletedCineNumber") < 130 then
    game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", {Unoccupied = true})
  end
end
function StartCineEnter_BrokIntro()
  StartCineEnter_BrokIntro_010()
  timers.StartLevelTimer(0.1, function()
    StartCineEnter_BrokIntro_020()
  end)
end
function StartCineEnter_BrokIntro_010()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_BrokIntro_010 = CCEC.CineEnterCamera.New("PLYR_CineEnter_BrokIntro_010", 7)
  cineEnterCamera_BrokIntro_010:SetCallback(DestroyCineEnter_BrokIntro_010)
  cineEnterCamera_BrokIntro_010:Start()
end
function DestroyCineEnter_BrokIntro_010()
  cineEnterCamera_BrokIntro_010 = nil
end
function StartCineEnter_BrokIntro_020()
  cineEnterCamera_BrokIntro_020 = CCEC.CineEnterCamera.New("PLYR_CineEnter_BrokIntro_020", 7)
  cineEnterCamera_BrokIntro_020:SetCallback(DestroyCineEnter_BrokIntro_020)
  cineEnterCamera_BrokIntro_020:Start()
end
function DestroyCineEnter_BrokIntro_020()
  cineEnterCamera_BrokIntro_020 = nil
  game.SubObject.Sleep(thisObj)
end
function LockCameraControls(numseconds)
  local recenterToLock = {
    TimeStart = 0,
    TimeDuration = numseconds,
    LockRecenter = 1,
    YawRange = -1,
    TriggerLeft = 0,
    TriggerRight = 0,
    ReturnLeft = 180,
    ReturnRight = -180,
    PitchRange = -1,
    ReturnDown = -90,
    ReturnUp = 90
  }
  game.Camera.Recenter(recenterToLock)
end
function CancelAimWalk()
  player:TriggerMoveEvent("LE_BrokIntro_CancelAimwalk")
end
local soundEmitter
function SoundInit()
  soundEmitter = GameObjects.SNDGrpDraugrHeavyVO:FindSingleSoundEmitterByName("SNDDraugrHeavyVO")
end
function draugrHeavyVO()
  LD.PlaySoundAfterDelay(soundEmitter, "SND_CHR_Draugr_VO_Attack_Heavy", 1.5)
end
