local thisObj, player, pad, allowAxeThrow
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  pad = player.Pad
  allowAxeThrow = false
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnUpdate(level, obj)
  SetCustomInputMask()
end
function SetCustomInputMask()
  if pad.DisableGameButton and pad.EnableGameButton then
    print("Brok Intro Bridge - disable buttons: square, circle, L1, cross, dpad up, dpad left, dpad down")
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadCircle)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadCross)
    pad:DisableGameButton(tweaks.ePad.kPadUp)
    pad:DisableGameButton(tweaks.ePad.kPadLeft)
    pad:DisableGameButton(tweaks.ePad.kPadDown)
    if allowAxeThrow == false then
      print("Brok Intro Bridge - disable buttons: L2, R1, R2")
      pad:DisableGameButton(tweaks.ePad.kPadL2)
      pad:DisableGameButton(tweaks.ePad.kPadR1)
      pad:DisableGameButton(tweaks.ePad.kPadR2)
    elseif player:GetCurrentWeapon() == "Axe" then
      print("Brok Intro Bridge - disable buttons: dpad right")
      pad:DisableGameButton(tweaks.ePad.kPadRight)
      print("Brok Intro Bridge - allow buttons: L2")
      pad:EnableGameButton(tweaks.ePad.kPadL2)
      if pad.L2Down then
        print("Brok Intro Bridge - allow buttons: R1, R2")
        pad:EnableGameButton(tweaks.ePad.kPadR1)
        pad:EnableGameButton(tweaks.ePad.kPadR2)
      else
        print("Brok Intro Bridge - disable buttons: R1, R2")
        pad:DisableGameButton(tweaks.ePad.kPadR1)
        pad:DisableGameButton(tweaks.ePad.kPadR2)
      end
    else
      print("Brok Intro Bridge - allow buttons: dpad right")
      pad:EnableGameButton(tweaks.ePad.kPadRight)
      print("Brok Intro Bridge - disable buttons: L2, R1, R2")
      pad:DisableGameButton(tweaks.ePad.kPadL2)
      pad:DisableGameButton(tweaks.ePad.kPadR1)
      pad:DisableGameButton(tweaks.ePad.kPadR2)
    end
  end
end
function ClearCustomInputMask()
  if pad.EnableGameButton then
    print("Brok Intro Bridge - allow buttons: square, circle, L1, L2, R1, R2, cross, dpad up, dpad left, dpad down, dpad right")
    player.Pad:EnableGameButton(tweaks.ePad.kPadSquare)
    player.Pad:EnableGameButton(tweaks.ePad.kPadCircle)
    player.Pad:EnableGameButton(tweaks.ePad.kPadL1)
    player.Pad:EnableGameButton(tweaks.ePad.kPadL2)
    player.Pad:EnableGameButton(tweaks.ePad.kPadR1)
    player.Pad:EnableGameButton(tweaks.ePad.kPadR2)
    player.Pad:EnableGameButton(tweaks.ePad.kPadCross)
    player.Pad:EnableGameButton(tweaks.ePad.kPadUp)
    player.Pad:EnableGameButton(tweaks.ePad.kPadLeft)
    player.Pad:EnableGameButton(tweaks.ePad.kPadDown)
    player.Pad:EnableGameButton(tweaks.ePad.kPadRight)
  end
  game.SubObject.Sleep(thisObj)
end
function EnteredCineBehaviorZone()
  SetCustomInputMask()
  if allowAxeThrow == true then
    game.SubObject.Wake(thisObj)
  end
end
function AllowAxeThrow()
  allowAxeThrow = true
  if player:IsInsideEntityZone(thisObj) then
    game.SubObject.Wake(thisObj)
  end
end
function BrokIntroStarted()
  thisObj:HideEntityVolume()
  ClearCustomInputMask()
end
