local LD = require("design.LevelDesignLibrary")
thisLevel = nil
player = nil
son = nil
smallshop = nil
vendorInteract = nil
local riv200
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  smallshop = level:GetGameObject("SmallShop")
  vendorInteract = smallshop:FindSingleGOByName("vendorInteract")
  riv200 = game.FindLevel("Riv200_DangersMain")
end
function OnUpdate(level)
end
function OnUseWorld(level)
end
function ForceShopInteract()
  game.Resources.SetDebugAddMode(true)
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "Riv260_ShopIntroCN:ForceShopInteract", "DebugResources")
  game.Wallets.AddResource("HERO", "Hacksilver", 1000, "Riv260_ShopIntroCN:ForceShopInteract", "DebugResources")
  game.Resources.SetDebugAddMode(false)
  player:CallScript("LuaHook_IncrementAxeQuest")
  vendorInteract.LuaObjectScript.SetTutorialModeActive()
  vendorInteract.LuaObjectScript.StartVendorInteract()
  if game.GetNewGamePlus() == true then
    LD.AddRecipe_Safe("HERO", "Recipe_FrozenFlame_Sellback")
    LD.AddRecipe_Safe("HERO", "Recipe_PurchaseEpicRune_Tier7")
  end
end
function AxeTutorialOver()
  if game.Level.GetVariable("CompletedCineNumber") <= 130 and game.Level.GetVariable("TUT_AxeUpgradeTutorialDone") == false then
    game.Level.SetVariable("TUT_AxeUpgradeTutorialDone", true)
    print("got axe tutorial msg!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
    DisableBrokShop()
    local availabilityState = {
      AvailableForSync = true,
      AvailableForBanter = true,
      AvailableInLevel = true,
      AvailableForCombat = false
    }
    son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  end
  player:CallScript("LuaHook_AxeMomentumPurchased")
end
function StartShopFight()
  riv200:CallScript("StartPostAxeUpgradeEncounter")
end
function DisableBrokShop()
  print("Disabling Brok Shop")
  vendorInteract:CallScript("Disable")
  vendorInteract.LuaObjectScript.BlockAutoEnable(true)
end
function EnableBrokShop()
  print("Enabling Brok Shop")
  vendorInteract.LuaObjectScript.BlockAutoEnable(false)
  vendorInteract:CallScript("Enable")
end
function SetAccelOveride()
  if game.Level.GetVariable("CompletedCineNumber") <= 130 then
    game.Player.FindPlayer():SetAccelerationOverride(0.9)
  end
end
function ClearAccelOveride()
  game.Player.FindPlayer():ClearAccelerationOverride()
end
function OnSaveCheckpoint(level)
  return {}
end
function OnRestoreCheckpoint(level, savedInfo)
  local appVersion, masterVersion = level:GetAppMasterVersion()
  if appVersion == 256 then
    local player = game.Player.FindPlayer()
    local son = game.AI.FindSon()
    local savedAvailState = son:GetAvailabilityStateRequestByName("LevelDesignScript")
    if savedAvailState ~= nil and savedAvailState.Unoccupied == false then
      local vendorCheckpointPos = engine.Vector.New(-267.137, 90.977, -479.575)
      if player:GetWorldPosition():Distance(vendorCheckpointPos) < 2 then
        son:RemoveAvailabilityRequest("LevelDesignScript")
        if savedAvailState.AvailableForSync == false or savedAvailState.AvailableForBanter == false or savedAvailState.AvailableInLevel == false or savedAvailState.AvailableForCombat == false then
          savedAvailState.Unoccupied = true
          son:SetNewAvailabilityRequest("LevelDesignScript", savedAvailState)
        end
      end
    end
  end
end
function Riv260_Bookmark_BrokCineComplete()
  AxeTutorialOver()
  print("---------------------------- we made it")
end
