local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local TrapRoomCheckpointMontor, crawlComplete, firstVisit
local cameraIndoorChainRecenter = {
  TimeStart = 0,
  TimeDuration = 1.3,
  LockRecenter = 0.46,
  YawRange = -1,
  TriggerLeft = -58,
  ReturnLeft = -58,
  ReturnRight = -58,
  TriggerRight = -58,
  PitchRange = -1,
  TriggerUp = 28,
  ReturnUp = 20,
  ReturnDown = 18,
  TriggerDown = 16,
  RotationSpace = 1
}
local cameraOutdoorChainRecenter = {
  TimeStart = 0,
  TimeDuration = 1.3,
  LockRecenter = 0.46,
  YawRange = -1,
  TriggerLeft = 140,
  ReturnLeft = 124,
  ReturnRight = 112,
  TriggerRight = 100,
  PitchRange = -1,
  TriggerUp = 26,
  ReturnUp = 22,
  ReturnDown = 16,
  TriggerDown = 8,
  RotationSpace = 1
}
function OnScriptLoaded(level)
  GameObjects.ChainPull2.LuaObjectScript.OverrideDefaultCameraRecenter(true, cameraIndoorChainRecenter)
  GameObjects.ChainPull2.LuaObjectScript.OverrideDefaultCameraPitch(true, 20)
  GameObjects.ChainPull2.LuaObjectScript.OverrideDefaultCameraYaw(true, -58)
  GameObjects.ChainPull1.LuaObjectScript.OverrideDefaultCameraRecenter(true, cameraOutdoorChainRecenter)
  GameObjects.ChainPull1.LuaObjectScript.OverrideDefaultCameraPitch(true, 20)
  GameObjects.ChainPull1.LuaObjectScript.OverrideDefaultCameraYaw(true, 118)
  SoundInit()
end
function OnStart(level)
  GameObjects.ChainPull1.LuaObjectScript.SetAnimSynchedCrank(GameObjects.ChainPull2)
  GameObjects.ChainPull2.LuaObjectScript.SetAnimSynchedCrank(GameObjects.ChainPull1)
end
function ShowCrawlMessage()
  if not crawlComplete then
    print("remove me when prompts are ready")
  end
end
function HideCrawlMessage()
  uiCalls.UI_Event_TurnOffTutorialMessage()
end
function CrawlMessageDone()
  crawlComplete = true
  uiCalls.UI_Event_TurnOffTutorialMessage()
end
function Enter325()
  GameObjects.CA_Gate_CaveSide_Through.LuaObjectScript.Disable()
  GameObjects.CA_Gate_CaveSide_Wait.LuaObjectScript.Disable()
  SyncExitTrapSide()
  local riv200 = game.FindLevel("Riv200_DangersMain")
  if riv200 ~= nil then
    riv200:CallScript("EnableBridgeLTW")
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 400 then
    game.World.StoreCheckpoint()
  end
end
function Exit325()
  GameObjects.CA_CrawlExit_325.LuaObjectScript.Disable()
  GameObjects.CA_CrawlExit_325_Puzzle.LuaObjectScript.Disable()
  GameObjects.CA_Gate_CaveSide_Wait.LuaObjectScript.Enable()
  local riv200 = game.FindLevel("Riv200_DangersMain")
  if riv200 ~= nil then
    riv200:CallScript("DisableBridgeLTW")
  end
end
function Quest_RiverPass_Objective375_End()
  LD.CompleteQuest("Quest_RiverPass_Objective375")
  LD.CallFunctionAfterDelay(SoftSave, 1)
end
function SoftSave()
  game.SubObject.SoftSave()
end
function SyncExitTrapSide()
  game.FindLevel("Riv325_DangersExit"):CallScript("EnableFollowSpline")
  if not firstVisit then
    GameObjects.CA_CrawlExit_325_Puzzle.LuaObjectScript.Enable()
    firstVisit = true
  else
    GameObjects.CA_CrawlExit_325.LuaObjectScript.Enable()
  end
end
function LoadCheck_325()
  game.UI.LoadCheck("Riv325_DangersExit")
end
function LoadCheck_200()
  game.UI.LoadCheck("Riv200_DangersMain")
end
function OnEvaluateLoadGroup_Cinematic()
  if game.Level.GetVariable("CompletedCineNumber") < 400 then
    return "AI_Visit01"
  else
    return "AI_Visit02"
  end
end
function CrankLock()
  StopCrankLoops()
  PlayGatePinSound()
  PlayGateOnPauseSounds()
end
function CrankUnlock()
  PlayGateUnPinSound()
  if GameObjects.Gate.AnimFrame > 29 then
    GameObjects.CA_Gate_ShopSide_Wait.LuaObjectScript.Disable()
    GameObjects.CA_Gate_CaveSide_Wait.LuaObjectScript.Disable()
  end
end
function Embed_ShopSide()
  if GameObjects.Gate.AnimFrame > 29 then
    GameObjects.CA_Gate_ShopSide_Wait.LuaObjectScript.Interrupt()
    GameObjects.CA_Gate_ShopSide_Wait.LuaObjectScript.Disable()
    GameObjects.CA_Gate_CaveSide_Through.LuaObjectScript.Enable()
  end
end
function Embed_CaveSide()
  if GameObjects.Gate.AnimFrame > 29 then
    GameObjects.CA_Gate_ShopSide_Through.LuaObjectScript.Enable()
    GameObjects.CA_Gate_CaveSide_Wait.LuaObjectScript.Interrupt()
    GameObjects.CA_Gate_CaveSide_Wait.LuaObjectScript.Disable()
  end
end
function PlayerThroughGate()
  GameObjects.CA_Gate_CaveSide_Wait.LuaObjectScript.Disable()
  GameObjects.CA_Gate_ShopSide_Wait.LuaObjectScript.Disable()
end
function OnAttached_RecenterIndoor()
  assert(nil, "BAD BOOKMARK: OnAttached_RecenterIndoor callback has fired because of a bad bookmark. Remake this bookmark, please.")
end
function OnAttached_RecenterOutdoor()
  assert(nil, "BAD BOOKMARK: OnAttached_RecenterOutdoor callback has fired because of a bad bookmark. Remake this bookmark, please.")
end
local soundGateLeftEmitter, soundGateRightEmitter, soundGatePinEmitter
local soundGateState = "Rest"
local soundGateGO, soundOutsideChainScript, soundInsideChainScript
local soundGateStopFrames = {
  0,
  15,
  30,
  45,
  60
}
function SoundInit()
  soundGateLeftEmitter = GameObjects.Gate:FindSingleSoundEmitterByName("SNDGateLeft")
  soundGateRightEmitter = GameObjects.Gate:FindSingleSoundEmitterByName("SNDGateRight")
  soundGatePinEmitter = GameObjects.Gate:FindSingleSoundEmitterByName("SNDGatePin")
  soundGateGO = GameObjects.Gate
  soundOutsideChainScript = GameObjects.ChainPull1.LuaObjectScript
  soundInsideChainScript = GameObjects.ChainPull2.LuaObjectScript
end
function OnCrankGateAttachedEvent()
  if soundGateState == "Rewind" then
    local nextStopFrameIndex = 0
    local currentGateFrame = soundGateGO.AnimFrame
    for targetIndex = 1, #soundGateStopFrames do
      if targetIndex == #soundGateStopFrames then
        nextStopFrameIndex = targetIndex
        break
      else
        if currentGateFrame == soundGateStopFrames[targetIndex] then
          LD.StopSound(soundGateLeftEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_L")
          LD.StopSound(soundGateRightEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_R")
          LD.StopSound(soundGatePinEmitter, "SND_DOOR_Metal_Gate_Spread_Moving_Gears_LP")
          soundGateState = "Rest"
          return
        end
        if currentGateFrame > soundGateStopFrames[targetIndex] and currentGateFrame < soundGateStopFrames[targetIndex + 1] then
          nextStopFrameIndex = targetIndex
          break
        end
      end
    end
    if 0 < nextStopFrameIndex then
      LD.StopSoundOnFrame(soundGateLeftEmitter, soundGateGO, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_L", soundGateStopFrames[nextStopFrameIndex], "backward")
      LD.StopSoundOnFrame(soundGateRightEmitter, soundGateGO, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_R", soundGateStopFrames[nextStopFrameIndex], "backward")
      LD.StopSoundOnFrame(soundGatePinEmitter, soundGateGO, "SND_DOOR_Metal_Gate_Spread_Moving_Gears_LP", soundGateStopFrames[nextStopFrameIndex], "backward")
    end
    soundGateState = "Rest"
  end
end
function PlayGateOnPauseSounds()
  soundGateState = "Rest"
  StopGateSounds()
end
function PlayGateForwardSounds()
  if soundGateState ~= "Forward" then
    StopGateSounds()
    LD.PlaySound(soundGateLeftEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_L", true)
    LD.PlaySound(soundGateRightEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_R", true)
    PlayMovingLoop()
    soundGateState = "Forward"
    if soundGateGO and soundGateGO.AnimFrame < 3 then
      LD.PlaySound(soundGateLeftEmitter, "SND_DOOR_Metal_Gate_Spread_Open_L")
      LD.PlaySound(soundGateRightEmitter, "SND_DOOR_Metal_Gate_Spread_Open_R")
    end
  end
end
function PlayGateBackwardSounds()
  if soundGateState ~= "Backward" then
    StopGateSounds()
    LD.PlaySound(soundGateLeftEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_L", true)
    LD.PlaySound(soundGateRightEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_R", true)
    PlayMovingLoop()
    soundGateState = "Backward"
  end
end
function PlayGateRewindSounds()
  if soundGateState ~= "Backward" and soundGateState ~= "Rewind" then
    StopGateSounds()
    LD.PlaySound(soundGateLeftEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_L", true)
    LD.PlaySound(soundGateRightEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_R", true)
    PlayMovingLoop()
  end
  soundGateState = "Rewind"
end
function StopGateForwardSounds()
  LD.StopSound(soundGateLeftEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_L")
  LD.StopSound(soundGateRightEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_R")
end
function StopGateBackwardSounds()
  LD.StopSound(soundGateLeftEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_L")
  LD.StopSound(soundGateRightEmitter, "SND_DOOR_Metal_Gate_Moving_Squeak_LP_R")
end
function PlayGateAtBeginningSound()
  soundGateState = "Rest"
  StopGateSounds()
end
function PlayGateAtEndSound()
  soundGateState = "Rest"
  LD.PlaySound(soundGateLeftEmitter, "SND_DOOR_Metal_Gate_Spread_Close_L")
  LD.PlaySound(soundGateRightEmitter, "SND_DOOR_Metal_Gate_Spread_Close_R")
  StopGateSounds()
end
function StopGateSounds()
  StopGateBackwardSounds()
  StopGateForwardSounds()
  StopMovingLoop()
end
function PlayGatePinSound()
  LD.PlaySound(soundGateLeftEmitter, "SND_DOOR_Metal_Gate_Spread_Locked_L")
  LD.PlaySound(soundGateRightEmitter, "SND_DOOR_Metal_Gate_Spread_Locked_R")
end
function PlayGateUnPinSound()
end
function PlayMovingLoop()
  LD.PlaySound(soundGatePinEmitter, "SND_DOOR_Metal_Gate_Spread_Moving_Gears_LP", true)
end
function StopMovingLoop()
  LD.StopSound(soundGatePinEmitter, "SND_DOOR_Metal_Gate_Spread_Moving_Gears_LP")
end
function StopCrankLoops()
  soundOutsideChainScript.StopRewindSound()
  soundInsideChainScript.StopRewindSound()
  if soundGateState ~= "Rest" then
    soundOutsideChainScript.PlayCrankOnStopSound()
    soundInsideChainScript.PlayCrankOnStopSound()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.firstVisit = firstVisit
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    firstVisit = savedInfo.firstVisit
  end
end
