local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local checkpoint = require("level.checkpoint")
local ND = require("design.NarrativeDesignLibrary")
timers = require("level.timer")
local bSpikedDoor2
local sinkingCeiling9_played = false
local sinkingCeiling10_played = false
local ceilingSecret02_Enabled = false
local ceilingSecret03_Enabled = false
local RIV_SpikedDoor1 = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnStart(level)
  if not ceilingSecret02_Enabled then
    GameObjects.BtrZone_CeilingSecret2:Hide()
  end
  if not ceilingSecret03_Enabled then
    GameObjects.BtrZone_CeilingSecret3:Hide()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  savedInfo.bSpikedDoor2 = bSpikedDoor2
  savedInfo.sinkingCeiling9_played = sinkingCeiling9_played
  savedInfo.sinkingCeiling10_played = sinkingCeiling10_played
  savedInfo.ceilingSecret02_Enabled = ceilingSecret02_Enabled
  savedInfo.ceilingSecret03_Enabled = ceilingSecret03_Enabled
  savedInfo.RIV_SpikedDoor1 = RIV_SpikedDoor1
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    bSpikedDoor2 = savedInfo.bSpikedDoor2
    sinkingCeiling9_played = savedInfo.sinkingCeiling9_played
    sinkingCeiling10_played = savedInfo.sinkingCeiling10_played
    ceilingSecret02_Enabled = savedInfo.ceilingSecret02_Enabled
    ceilingSecret03_Enabled = savedInfo.ceilingSecret03_Enabled
    RIV_SpikedDoor1 = savedInfo.RIV_SpikedDoor1
  end
end
function RIV_SpikedDoor1_Banter()
  if not RIV_SpikedDoor1 then
    game.Audio.PlayBanter("RIV_SpikedDoor1")
    RIV_SpikedDoor1 = true
  end
end
function SpikedDoor2_Banter()
  print("------------------------DEBUG AXE HIT BANTER FUNCTION --------------------")
  if not bSpikedDoor2 then
    print("------------------------DEBUG BANTER FUNCTION IF TREE --------------------")
    game.Audio.PlayBanterNonCritical("RIV_SpikedDoor2")
    bSpikedDoor2 = true
  end
  local LM = require("level.loadmonitor")
  local loadMonitor = LM.CreateLoadMonitor()
  loadMonitor:AddCallback({
    Wads = {
      "Riv200_DangersMain"
    },
    Functions = {
      SpikeDoorOpen
    }
  })
end
function SpikeDoorOpen(wads)
  wads.Riv200_DangersMain:GetGameObject("Riv200_Banter"):CallScript("FirstPanelOpen")
end
function SinkingCeiling2_Banter()
  timers.StartLevelTimer(0.4, function()
    game.Audio.PlayBanter("RIV_SinkingCeiling2")
  end)
end
function SinkingCeiling4_Banter()
  game.Audio.PlayBanter("RIV_SinkingCeiling4")
end
function SinkingCeiling5_Banter()
  game.Audio.PlayBanter("RIV_SinkingCeiling5")
end
function SinkingCeiling6_Banter()
  game.Audio.PlayBanter("RIV_SinkingCeiling6")
end
function SinkingCeiling6b_Banter()
  game.Audio.PlayBanter("RIV_SinkingCeiling6b")
end
function SinkingCeiling9_Banter()
  if not sinkingCeiling9_played then
    game.Audio.PlayBanter("RIV_SinkingCeiling9")
    sinkingCeiling9_played = true
  end
end
function SinkingCeiling10_Banter()
  if not sinkingCeiling10_played then
    game.Audio.PlayBanter("RIV_SinkingCeiling10")
    sinkingCeiling10_played = true
  end
end
function SinkingCeiling10_Combat_Banter()
  if not sinkingCeiling10_played then
    game.Audio.PlayBanter("RIV_SinkingCeiling10_InCombat")
    sinkingCeiling10_played = true
  end
end
function Enable_CeilingSecret02()
  GameObjects.BtrZone_CeilingSecret2:Show()
  ceilingSecret02_Enabled = true
end
function Enable_CeilingSecret03()
  GameObjects.BtrZone_CeilingSecret3:Show()
  ceilingSecret03_Enabled = true
end
