local ND = require("design.NarrativeDesignLibrary")
local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local thisObj, thisLevel, kratosObj
local crowProps = {}
local kraPuppeteer, sonPuppeteer, kratosActor, sonActor, canyonOverlook_ActorTable
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  kratosObj = game.Player.FindPlayer()
  InitializeVariables()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") < 135 then
    CreateActorsAndPositions()
    BuildCanyonOverlookSequence()
  else
    HideCrows()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function InitializeVariables()
  crowProps.crow0 = GameObjects.crow00prop.Child
  crowProps.crow1 = GameObjects.crow01prop.Child
  crowProps.crow2 = GameObjects.crow02prop.Child
  crowProps.crow3 = GameObjects.crow03prop.Child
  crowProps.crow4 = GameObjects.crow04prop.Child
  crowProps.crow5 = GameObjects.crow05prop.Child
  crowProps.crow6 = GameObjects.crow06prop.Child
  crowProps.crow7 = GameObjects.crow07prop.Child
  crowProps.crow8 = GameObjects.crow08prop.Child
end
function HideCrows()
  crowProps.crow0:Hide()
  crowProps.crow1:Hide()
  crowProps.crow2:Hide()
  crowProps.crow3:Hide()
  crowProps.crow4:Hide()
  crowProps.crow5:Hide()
  crowProps.crow6:Hide()
  crowProps.crow7:Hide()
  crowProps.crow8:Hide()
end
function CreateActorsAndPositions()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function BuildCanyonOverlookSequence()
  local canyonOverlookSeq = ND.CreateCineSequence(thisLevel, thisObj, "canyonOverlook")
  local canyonOverlook_ActorTable = {
    {Actor = sonActor},
    {
      Obj = crowProps.crow0,
      Anim = "narRivCanyonOverlook000CineScene"
    },
    {
      Obj = crowProps.crow1,
      Anim = "narRivCanyonOverlook000CineScene1"
    },
    {
      Obj = crowProps.crow2,
      Anim = "narRivCanyonOverlook000CineScene2"
    },
    {
      Obj = crowProps.crow3,
      Anim = "narRivCanyonOverlook000CineScene3"
    },
    {
      Obj = crowProps.crow4,
      Anim = "narRivCanyonOverlook000CineScene4"
    },
    {
      Obj = crowProps.crow5,
      Anim = "narRivCanyonOverlook000CineScene5"
    },
    {
      Obj = crowProps.crow6,
      Anim = "narRivCanyonOverlook000CineScene6"
    },
    {
      Obj = crowProps.crow7,
      Anim = "narRivCanyonOverlook000CineScene7"
    },
    {
      Obj = crowProps.crow8,
      Anim = "narRivCanyonOverlook000CineScene8"
    }
  }
  canyonOverlookSeq:BeginMultipleWait()
  canyonOverlookSeq:WaitForActorInZone(kratosActor, thisObj)
  canyonOverlookSeq:WaitForFunctionTrue(function()
    return kratosObj:IsPlayingMove("MOV_Buddy_Boost")
  end)
  canyonOverlookSeq:EndMultipleWait()
  canyonOverlookSeq:SetPostSkipMusic("SND_MX_RIV_start_master", "SND_MX_SonSick_master")
  canyonOverlookSeq:Do(function()
    canyonOverlookSeq:MarkAbleToSkip()
  end)
  canyonOverlookSeq:Do(game.Cinematics.EnableCinematicMode)
  canyonOverlookSeq:ActorSync(kratosActor, {
    Slaves = canyonOverlook_ActorTable,
    Branch = "BRA_CanyonOverlook",
    ReferenceJoint = "Cine_CanyonOverlook_SyncJoint"
  })
  canyonOverlookSeq:Do(CanyonOverlookStart)
  canyonOverlookSeq:WaitUntilActorAnimPastFrame(kratosActor, 1185)
  canyonOverlookSeq:Do(function()
    _G.LevelVistaCineCompelte()
  end)
  canyonOverlookSeq:WaitForActorPuppeteerComplete(kratosActor)
  canyonOverlookSeq:SetCompletedCineNumber(135)
  canyonOverlookSeq:Do(game.Cinematics.DisableCinematicMode)
  canyonOverlookSeq:StopPuppetingActor(sonActor)
  canyonOverlookSeq:StopPuppetingActor(kratosActor)
  canyonOverlookSeq:Do(HideCrows)
  canyonOverlookSeq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "02_RiverPass_030_CalderaVista"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  canyonOverlookSeq:StartSequence()
end
function CanyonOverlookStart()
  local LM = require("level.loadmonitor")
  local loadMonitor = LM.CreateLoadMonitor()
  loadMonitor:AddCallback({
    Wads = {
      "Riv325_DangersExit"
    },
    Functions = {
      Riv325Loaded
    }
  })
end
function Riv325Loaded(wads)
  wads.Riv325_DangersExit:CallScript("DisableCielingLTW")
end
