local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local uiCalls = require("ui.uicalls")
local doorJambJam_Played = false
local thisObj, dialogBanterPlayed, firstHintBanterPlayed
local puzzleBrokenCount = 0
local puzzleCloseCount = 0
local puzzleSuccessCount = 0
local puzzleNotCloseCount = 0
local puzzleWasWon = false
function OnScriptLoaded(level, go)
  thisObj = go
  game.SubObject.Sleep(thisObj)
end
function OnStart()
  GameObjects.ShowPuzzleHelpMsg:HideEntityVolume()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    dialogBanterPlayed = dialogBanterPlayed,
    firstHintBanterPlayed = firstHintBanterPlayed,
    puzzleWasWon = puzzleWasWon
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  dialogBanterPlayed = savedInfo.dialogBanterPlayed
  firstHintBanterPlayed = savedInfo.firstHintBanterPlayed
  puzzleWasWon = savedInfo.puzzleWasWon
end
function Btr_FirstRuneBowl_hint1()
  if not dialogBanterPlayed then
    game.Audio.PlayBanter("FirstRuneBowl_hint1")
    firstHintBanterPlayed = true
  end
end
function StartPuzzleHelpTimer()
  LD.CallFunctionAfterDelay(PuzzleFreebie, 300)
end
function PuzzleFreebie()
  if not puzzleWasWon then
    GameObjects.ShowPuzzleHelpMsg:ShowEntityVolume()
  end
end
function ShowPuzzleHelpText()
  uiCalls.SendBottomDesignerMessage({
    Text = 43796,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
function HidePuzzleHelpText()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function Btr_FirstRuneBowl_PuzzleDialogue1()
  if not dialogBanterPlayed then
    game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue1")
    dialogBanterPlayed = true
  end
end
function Btr_FirstRuneBowl_PuzzleDialogue2()
  game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue2")
end
function Btr_FirstRuneBowl_PuzzleDialogue3()
  game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue3")
end
function PuzzleSuccess()
  puzzleSuccessCount = puzzleSuccessCount + 1
  if puzzleSuccessCount == 1 then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue11")
    end, 0.5)
  elseif puzzleSuccessCount == 3 then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue10")
    end, 0.5)
  end
end
function PuzzleBroken()
  puzzleBrokenCount = puzzleBrokenCount + 1
  if puzzleBrokenCount == 1 then
    game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue13a")
  elseif puzzleBrokenCount == 3 then
    game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue13b")
  end
end
function puzzleNotClose()
  if puzzleBrokenCount == 0 then
    puzzleNotCloseCount = puzzleNotCloseCount + 1
    if puzzleNotCloseCount == 2 then
      game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue4")
    elseif puzzleNotCloseCount == 4 then
      game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue7")
    elseif puzzleNotCloseCount == 6 then
      game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue6")
    elseif puzzleNotCloseCount == 7 then
      game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue9")
    elseif puzzleNotCloseCount == 10 then
      game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue8")
    end
  end
end
function PuzzleClose()
  if 0 < puzzleSuccessCount then
    puzzleCloseCount = puzzleCloseCount + 1
    if puzzleCloseCount == 2 then
      game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue5")
    elseif puzzleCloseCount == 6 then
      game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue8")
    end
  end
end
function PuzzleWin()
  puzzleWasWon = true
  GameObjects.ShowPuzzleHelpMsg:HideEntityVolume()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  game.Audio.PlayBanter("FirstRuneBowl_PuzzleDialogue14", function()
    GameObjects.SonLookAtInteract.LuaObjectScript.Enable()
  end)
end
