local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local mpicon = require("ui.mpicon")
local checkpoint = require("level.checkpoint")
local uiCalls = require("ui.uicalls")
local gVFSAltRuneBowlSolve = engine.VFSBool.New("Alternative Rune Bowl Activation")
local thisLevel, myVarMonitor, V4_Entry3
local zoneEntered = false
local sonPuppet
son = nil
local camZoneRotateToDoor, camZoneRuneGateSolvedBoy, camZoneRuneGateSolvedDoor, camZoneRuneGateSolvedStatue, entZoneTurnOnRuneInteract, entZoneActivateDot
local bRunePlayerInteractSequence = false
local bRuneAssembled = false
local bRuneBowlActivateZone = false
local woodBroken = 0
local boardsbroken = false
local runeDiscLock, powerOn, questionStart, gearFrozen, statue1, statue2, statue1Eyes, statue2Eyes
function OnScriptLoaded(level)
  thisLevel = level
  gVFSAltRuneBowlSolve.value = true
  camZoneRuneGateSolvedBoy = level:GetGameObject("CamZone_ABC_Rune_Solved_Boy")
  camZoneRuneGateSolvedDoor = level:GetGameObject("CamZone_ABC_Rune_Solved_Door")
  camZoneRuneGateSolvedStatue = level:GetGameObject("CamZone_ABC_Rune_Solved_Statue")
  camZoneRotateToDoor = level:GetGameObject("CamZone_ABC_Rune_LookAt")
  runeDiscLock = GameObjects.RuneBowl_DiscLock_02
  statue1 = GameObjects.Statue_01:FindSingleGOByName("lightonestatue_head_turn_v01").Child
  statue2 = GameObjects.Statue_02:FindSingleGOByName("lightonestatue_head_turn_v02").Child
  statue1Eyes = statue1:FindSingleGOByName("StatueEyes_01").Child
  statue2Eyes = statue2:FindSingleGOByName("StatueEyes_02").Child
  SoundInit()
  local wallswitch = level:FindGameObject("SwitchWall_Door")
  wallswitch.LuaObjectScript.OverrideCameraInteractApproach("ENV_Interact_WallSwitch_Riv350_RuneDoor")
  wallswitch.LuaObjectScript.OverideInteractApproachYaw(true)
  wallswitch.LuaObjectScript.OverrideCameraSubmissionTime(1.8)
end
function OnFirstStart(level)
  GameObjects.TraverseLink_TrapExit:HideTraverseLink()
  statue1Eyes:HideParticleEmitter()
  statue2Eyes:HideParticleEmitter()
end
function OnStart(level)
  runeDiscLock.LuaObjectScript.SetRuneBowl(level:GetGameObject("SonRunebowl_NEW"))
  GameObjects.EntZn_RetreversalCheckpoint:ShowEntityVolume()
end
function LoadCheckRiv325()
  game.UI.LoadCheck("Riv325_DangersExit", "Riv300_CalderaVistaLH")
end
function OnUpdate(level)
end
function SandBowlComplete()
  GameObjects.RotateDoor:PlayAnimToEnd()
  GameObjects.Runes_WheelDoor:PlayAnimToEnd()
  LD.ShowFX(GameObjects.FX_RuneDisk_Anim)
  LD.ShowFX(GameObjects.Riv350_RuneBowlDisk_UnlockFX)
  statue1:PlayAnimToEnd()
  statue2:PlayAnimToEnd()
  statue1Eyes:ShowParticleEmitter()
  statue2Eyes:ShowParticleEmitter()
  PlaySoundOnOpen()
  camZoneRotateToDoor:ShowCameraVolume()
  timer.StartLevelTimer(3, TurnOffRotateToRune)
  timer.StartLevelTimer(7.25, function()
    game.Audio.StartMusic("SND_MX_RIV_amb_rune_read_out")
  end)
  GameObjects.RotateDoor:OnAnimDone(thisLevel, "DoorOpenCompleted")
  uiCalls.UI_Event_TurnOffDesignerMessage()
  PlayShakes()
end
function DoorOpenCompleted()
  GameObjects.RotateDoor:ClearAllAnimCallbacks()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "02_RiverPass_033_SandbowlComplete"]
  tableEntry.OverrideObject = GameObjects.CO_BOOKMARK_SandbowlComplete
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function PlayShakes()
  timer.StartLevelTimer(0, function()
    game.Blender.Trigger({
      Name = "FFB_LOOP_SMALLEST",
      Duration = 5.8,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.3}
    })
  end)
  timer.StartLevelTimer(6, function()
    game.Blender.Trigger({
      Name = "FFB_SMALL",
      Duration = 0.7,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.3}
    })
  end)
  timer.StartLevelTimer(6, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_SPARKS",
      Duration = 4,
      TweenIn = {Time = 0.2},
      TweenOut = {Time = 0.3}
    })
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 4,
      TweenIn = {Time = 0.2},
      TweenOut = {Time = 0.3}
    })
  end)
  timer.StartLevelTimer(10, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_SLIDING_HORIZONTAL_LIGHT",
      Duration = 0.42,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.2}
    })
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 0.42,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.2}
    })
  end)
  timer.StartLevelTimer(10.59, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_MEDIUM",
      Duration = 0.3,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.17}
    })
    game.Blender.Trigger({
      Name = "FFB_MEDIUM",
      Duration = 0.3,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.17}
    })
  end)
  timer.StartLevelTimer(10.9, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_SLIDING_HORIZONTAL_HEAVY",
      Duration = 4.32,
      TweenIn = {Time = 0},
      TweenOut = {Time = 1.37}
    })
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_MEDIUM",
      Duration = 4.32,
      TweenIn = {Time = 0},
      TweenOut = {Time = 1.37}
    })
  end)
end
function BeginRuneReading()
  GameObjects.Ent_SpeedZone_Riv350_Solve:Show()
  timer.StartLevelTimer(8.6, TurnOffSonLookAt)
  timer.StartLevelTimer(13.7, TurnOffStatueLookAt)
  timer.StartLevelTimer(18.2, TurnOffDoorLookAt)
  LTW_Disable()
  local riv400 = game.FindLevel("Riv400_ForestIntro")
  if riv400 ~= nil then
    riv400:CallScript("CA_SwitchTo_Riv400")
  end
  GameObjects.CA_PuzzleDone.LuaObjectScript.Enable()
  camZoneRuneGateSolvedDoor:ShowCameraVolume()
  camZoneRuneGateSolvedBoy:ShowCameraVolume()
  camZoneRuneGateSolvedStatue:ShowCameraVolume()
end
function TurnOffSonLookAt()
  camZoneRuneGateSolvedBoy:HideCameraVolume()
end
function TurnOffStatueLookAt()
  camZoneRuneGateSolvedStatue:HideCameraVolume()
  GameObjects.Ent_SpeedZone_Riv350_Solve:Hide()
end
function TurnOffDoorLookAt()
  camZoneRuneGateSolvedDoor:HideCameraVolume()
end
function TurnOffRotateToRune()
  camZoneRotateToDoor:HideCameraVolume()
end
function LevelVistaCineCompelte()
  GameObjects.TraverseLink_TrapExit:ShowTraverseLink()
  GameObjects.TraversePath_Cine:HideTraversePath()
end
function TravPath_EnableRevisit()
  GameObjects.TraverseLink_TrapExit:HideTraverseLink()
  GameObjects.TraversePath_Cine:ShowTraversePath()
end
function ShowTraverseLink()
  if game.Level.GetVariable("CompletedCineNumber") >= 135 then
    LevelVistaCineCompelte()
  end
end
function LTW_Enable()
  GameObjects.LTW_ToSandBowl.LuaObjectScript.Enable()
end
function LTW_Disable()
  GameObjects.LTW_ToSandBowl.LuaObjectScript.Disable()
end
function OnEvaluateLoadGroup_Cinematic()
  if game.Level.GetVariable("CompletedCineNumber") <= 135 then
    return "CanyonOverlookConfig"
  elseif game.Level.GetVariable("CompletedCineNumber") > 135 and game.Level.GetVariable("CompletedCineNumber") < 400 then
    return "AI_Visit01"
  else
    return "AI_Visit02"
  end
end
function RetrevesalCheckpoint()
  if game.Level.GetVariable("CompletedCineNumber") >= 400 then
    game.World.StoreCheckpoint()
    GameObjects.EntZn_RetreversalCheckpoint:HideEntityVolume()
  end
end
function SandbowlArrive()
  LD.CallFunctionAfterDelay(function()
    if not questionStart then
      GameObjects.Riv350_Banter.LuaObjectScript.Btr_FirstRuneBowl_hint1()
    end
  end, 14)
end
function QuestionStart()
  questionStart = true
end
function QuestionComplete()
  LD.CallFunctionAfterDelay(function()
    if not powerOn then
      GameObjects.Riv350_Banter.LuaObjectScript.Btr_FirstRuneBowl_PuzzleDialogue1()
    end
  end, 12)
end
function PowerOn_Disclock()
  runeDiscLock.LuaObjectScript.TurnOnDisclock()
  PlaySoundOnActivate()
  powerOn = true
  LD.CallFunctionAfterDelay(PuzzleHint, 24)
  GameObjects.Riv350_Banter.LuaObjectScript.StartPuzzleHelpTimer()
end
function PuzzleHint()
  if not gearFrozen then
    GameObjects.Riv350_Banter.LuaObjectScript.Btr_FirstRuneBowl_PuzzleDialogue3()
  end
end
function GearEmbed()
  gearFrozen = true
end
local soundEmitter
local StoneCircleOpen = "SND_DOOR_Rune_Disc_Open"
local StoneCircleReveal = "SND_DOOR_Rune_Disc_Reveal"
function SoundInit()
  soundEmitter = GameObjects.RotateDoor.SoundEmitters[1]
end
function PlaySoundOnOpen()
  LD.PlaySound(soundEmitter, StoneCircleOpen)
  LD.PlaySoundOnFrame(soundEmitter, GameObjects.RotateDoor, StoneCircleReveal, 60)
end
function PlaySoundOnActivate()
  LD.PlaySound(soundEmitter, "SND_DOOR_Rune_Disc_Gears_LP")
  if runeDiscLock.LuaObjectScript.IsAnyGearLocked() then
    LD.PlaySound(soundEmitter, "SND_DOOR_Rune_Disc_Pinned_Gears_LP")
  end
end
function PlayGearEmbedSound()
  LD.PlaySound(soundEmitter, "SND_DOOR_Rune_Disc_Gear_Pinned")
  LD.PlaySound(soundEmitter, "SND_DOOR_Rune_Disc_Pinned_Gears_LP")
end
function PlayGearUnembedSound()
  LD.PlaySound(soundEmitter, "SND_DOOR_Rune_Disc_Gear_Freed")
  LD.StopSound(soundEmitter, "SND_DOOR_Rune_Disc_Pinned_Gears_LP")
end
function StopDiscRotateSound()
  LD.StopSound(soundEmitter, "SND_DOOR_Rune_Disc_Gears_LP")
end
function FirstRuneBowlMusic()
  game.Audio.StartMusic("SND_MX_RIV_amb_rune_read_in")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
