local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local color = require("core.color")
local monitors = require("level.MonitorLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local checkpoint = require("level.checkpoint")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kratosActor, sonActor, cameraCineEnter_NewTracks
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(thisObj)
end
function OnUpdate(level, obj)
  if cameraCineEnter_NewTracks ~= nil then
    cameraCineEnter_NewTracks:Update()
  end
end
function StartCineEnter_NewTracks()
  game.SubObject.Wake(thisObj)
  cameraCineEnter_NewTracks = CCEC.CineEnterCamera.New("ENV_CineEnter_NewTracks", 8)
  cameraCineEnter_NewTracks:SetCallback(DestroyCineEnter_NewTracks)
  cameraCineEnter_NewTracks:Start()
end
function DestroyCineEnter_NewTracks()
  cameraCineEnter_NewTracks = nil
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function CreateActors()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function BuildRivSonNewTracksSeq()
  CreateActors()
  if game.Level.GetVariable("CompletedCineNumber") < 136 then
    local seq = ND.CreateCineSequence(thisLevel, thisObj, "RivSonNewTracks")
    local actorTable = {
      {Actor = sonActor}
    }
    seq:RequestCineModeAndWait(kratosActor, thisObj)
    seq:Do(StartCineEnter_NewTracks)
    seq:Do(function()
      game.Player.FindPlayer():SetDecelerationOverride(1.5)
    end)
    seq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_NewTracks",
      ReferenceJoint = "RivSonNewTracks_SynchJoint",
      speed = 2,
      stop = false,
      radius = ND.ArrivalRadius,
      weapon_state = "bare",
      foot = game.Creature.Foot.kRight
    })
    seq:ActorSync(kratosActor, {
      Slaves = actorTable,
      Branch = "BRA_NewTracks",
      ReferenceJoint = "RivSonNewTracks_SynchJoint"
    })
    seq:SetPostSkipMusic("SND_MX_RIV_start_master", "SND_MX_SonSick_master")
    seq:Do(function()
      seq:MarkAbleToSkip()
    end)
    seq:Do(function()
      GameObjects.LTW_Main_Lead.LuaObjectScript.Enable()
    end)
    seq:WaitUntilActorAnimPastFrame(sonActor, 330)
    seq:Do(QuestUpdate)
    seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    seq:StopPuppetingActor(sonActor)
    seq:StopPuppetingActor(kratosActor)
    seq:Do(function()
      GameObjects.NoGoZone_NewTracks:Hide()
    end)
    seq:Do(function()
      local riv400 = game.FindLevel("Riv400_ForestIntro")
      if riv400 ~= nil then
        riv400:CallScript("LTW_SwitchToLead")
      end
    end)
    seq:SetCompletedCineNumber(136)
    seq:Do(function()
      if seq.skipping then
        game.Audio.PlayBanter("RIV_NewTracksExtra")
      end
    end)
    seq:Do(function()
      local bookmarks = require("design.Bookmarks")
      local tableEntry = bookmarks["BOOKMARK_" .. "02_RiverPass_034_EnterClearance"]
      tableEntry.OverrideObject = GameObjects.ChkOvr_Riv420Start.Child
      game.World.StoreCheckpointAndBookmark(tableEntry)
    end)
    seq:StartSequence()
  end
end
function QuestUpdate()
  game.QuestManager.ProposeQuestState("Quest_RiverPass_Objective380", "Complete")
end
