local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local checkpoint = require("level.checkpoint")
local thisObj
local banterPlayed = false
local boneyardVista_Played = false
local btrBoneyard = "TheBoneyard_Son"
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  savedInfo.banterPlayed = banterPlayed
  savedInfo.boneyardVista_Played = boneyardVista_Played
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  banterPlayed = savedInfo.banterPlayed
  boneyardVista_Played = savedInfo.boneyardVista_Played
end
function BoneyardVista_Banter()
  if not boneyardVista_Played then
    game.Audio.PlayBanterNonCritical("RIV_BoneyardVista")
    boneyardVista_Played = true
  end
end
