local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local thisLevel, player, Area_1_Encounter_1, A1_ZM_1, hellwalkerKilled
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  GameObjects.AI_Wall:HideCollision()
  if game.Level.GetVariable("CompletedCineNumber") < 180 then
    Area_1_Fight_1()
  end
end
function OnStart(level, obj)
  print("hellwalkerKilled = ", hellwalkerKilled)
  if not hellwalkerKilled then
    A1_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_Attack_1)
    A1_ZM_1:SetTriggerCountLimit(1)
    A1_ZM_1:OnEnter(function()
      GameObjects.Evt_Emitter_Hellwalker.LuaObjectScript.Trigger()
      Area_1_Encounter_1:AlertEnemies()
      EnableCollision()
      GameObjects.Riv430_HintBanter.LuaObjectScript.HelSurprise_Banter()
      GameObjects.Riv430_HintBanter.LuaObjectScript.FightStarted()
    end)
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    levelstate = checkpoint.Save(),
    hellwalkerKilled = hellwalkerKilled
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  hellwalkerKilled = savedInfo.hellwalkerKilled
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC: Woods XPL850", {CheckpointOnComplete = true})
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Hidden_Bindit",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Area_Spawn_1)
  Area_1_Encounter_1:OnStart(function()
    GameObjects.Riv430_HintBanter.LuaObjectScript.FightStarted()
  end)
  Area_1_Encounter_1:OnComplete(function()
    hellwalkerKilled = true
    GameObjects.Riv430_HintBanter.LuaObjectScript.Enable_ReacquireTracks()
    game.AI.FindSon():CallScript("ClearBehaviorContext")
    if A1_ZM_1 ~= nil then
      A1_ZM_1:Stop()
    end
  end)
end
function EnableCollision()
  LD.CallFunctionAfterDelay(function()
    GameObjects.AI_Wall:ShowCollision()
  end, 3)
end
function AxeBreakDoorAlert()
  GameObjects.EntZn_Area_Attack_1:HideEntityVolume()
  GameObjects.Evt_Emitter_Hellwalker.LuaObjectScript.Trigger()
  Area_1_Encounter_1:AlertEnemies()
  EnableCollision()
  GameObjects.Riv430_HintBanter.LuaObjectScript.HelSurprise_Banter()
  GameObjects.Riv430_HintBanter.LuaObjectScript.FightStarted()
end
