local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, kratosActor, sonActor, boarActor, miniGameObject, preCineCam, pad, player
local minigameInProgress = false
local spawningMinigameBoar = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  pad = player.Pad
  preCineCam = CCEC.CineEnterCamera.New("ENV_CineEnter_narRivBoarIntro020cineScene", 8)
  preCineCam:SetObjectToSleep(obj)
end
function OnStart(level, obj)
  InitializeVariables()
  if game.Level.GetVariable("CompletedCineNumber") < 137 then
    CreateActorsAndPositions()
    SetSpawnFunctions()
    BuildCineSequence()
  end
end
function OnUpdate(level, obj)
  if preCineCam ~= nil then
    preCineCam:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function InitializeVariables()
end
function CreateActorsAndPositions()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  boarActor = actor.Actor.New("Boar")
end
function SetSpawnFunctions()
  boarActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_BoarIntro", "Boar_Start", "CRT_WildBoar00", "BRA_BoarIntroIdle", "Boar")
  end)
end
function BuildCineSequence()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "boarIntro")
  seq:SpawnActorAndWait(boarActor)
  seq:WaitForActorInZone(sonActor, GameObjects.CineZone_BoarIntro_SonLTW)
  seq:Do(function()
    game.AI.FindSon():SetAccelerationOverride(1)
  end)
  seq:Do(function()
    game.Player.FindPlayer():SetDecelerationOverride(20)
  end)
  seq:Do(function()
    GameObjects.BoarIntro_LeadTheWay.LuaObjectScript:Enable()
  end)
  seq:Do(function()
    GameObjects.BoarIntro_YouShallNotPass.LuaObjectScript:Enable()
  end)
  seq:Do(StartButtonMask)
  seq:WaitForActorInZone(sonActor, GameObjects.CineZone_BoarIntro_SonApproach)
  seq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_BoarIntroIdle",
    ReferenceJoint = "BoarIntro_SynchJoint",
    speed = ND.SonRunSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = ND.SonRunArrivalRadius
  })
  seq:ActorSync(sonActor, {
    Branch = "BRA_BoarIntroIdle",
    ReferenceJoint = "BoarIntro_SynchJoint"
  })
  seq:WaitForActorInZone(kratosActor, thisObj)
  seq:Do(ClearButtonMask)
  seq:RequestCineModeAndWait(kratosActor, thisObj)
  seq:Do(function()
    GameObjects.BoarIntro_LeadTheWay.LuaObjectScript:Disable()
  end)
  seq:Do(function()
    GameObjects.BoarIntro_YouShallNotPass.LuaObjectScript:Disable()
  end)
  seq:Do(StartPreCineCamera)
  seq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_BoarIntro",
    ReferenceJoint = "BoarIntro_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = ND.ArrivalRadius,
    weapon_state = "bare"
  })
  local boarIntro_actorTable = {
    {Actor = sonActor},
    {Actor = boarActor}
  }
  seq:ActorSync(kratosActor, {
    Slaves = boarIntro_actorTable,
    Branch = "BRA_BoarIntro",
    ReferenceJoint = "BoarIntro_SynchJoint"
  })
  seq:SetPostSkipMusic("SND_MX_RIV_start_master", "SND_MX_SonSick_master")
  seq:Do(function()
    seq:MarkAbleToSkip()
  end)
  seq:Do(_G.CA_StartIntro_Enable)
  seq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_BoarIntroAimIdle")
  end)
  seq:Do(function()
    seq:EndSkipIfActive()
  end)
  seq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_BoarIntroExit")
  end)
  seq:Do(function()
    seq:MarkAbleToSkip()
  end)
  seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  seq:WaitForFunctionTrue(function()
    return not minigameInProgress
  end)
  seq:SetCompletedCineNumber(137)
  seq:Do(function()
    game.AI.FindSon():ClearAccelerationOverride()
  end)
  seq:Do(function()
    game.Player.FindPlayer():ClearDecelerationOverride()
  end)
  seq:Do(function()
    GameObjects.SpeedControlZone_BoarIntro:Hide()
  end)
  seq:Do(CrackClimb_Check)
  seq:StopPuppetingActor(sonActor)
  seq:StopPuppetingActor(kratosActor)
  seq:StopPuppetingActor(boarActor)
  seq:DespawnActor(boarActor)
  seq:Do(function()
    game.World.StoreCheckpoint()
  end)
  seq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "02_RiverPass_035_IntroBoar"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  seq:StartSequence()
end
function SpawnMinigameBoar()
  if not spawningMinigameBoar then
    spawningMinigameBoar = true
    local seq = ND.CreateCineSequence(thisLevel, thisObj, "minigameBoarSpawn")
    seq:SpawnActorAndWait(boarActor)
    seq:ActorSync(boarActor, {
      Branch = "BRA_BoarIntroAimIdle01",
      ReferenceJoint = "BoarIntro_SynchJoint"
    })
    seq:Do(function()
      spawningMinigameBoar = false
    end)
    seq:StartSequence()
  end
end
function CrackClimb_Check()
  print("CrackClimb_Check")
  local level_Riv425 = game.FindLevel("Riv425_ForestBoarTrackLH")
  level_Riv425:CallScript("EnableCrackClimb")
end
function StartPreCineCamera()
  preCineCam:Start()
end
function StartButtonMask()
  if pad.DisableGameButton and pad.EnableGameButton then
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadL2)
    pad:DisableGameButton(tweaks.ePad.kPadL3)
    pad:DisableGameButton(tweaks.ePad.kPadR1)
    pad:DisableGameButton(tweaks.ePad.kPadR2)
    pad:DisableGameButton(tweaks.ePad.kPadCross)
  end
end
function ClearButtonMask()
  if pad.ClearAllDisabledGameButtons then
    pad:ClearAllDisabledGameButtons()
  end
end
function LuaHook_StartMiniGame()
  local miniGameLevel = game.FindLevel("Riv430_ForestBoarTrack")
  miniGameObject = miniGameLevel:FindGameObject("BoarAimMiniGame")
  miniGameObject.LuaObjectScript.StartMiniGame(true)
  uiCalls.UI_Event_Force_Reticle_Clear()
  minigameInProgress = true
end
function LuaHook_EndMiniGame()
  miniGameObject.LuaObjectScript.StartMiniGame(false)
  miniGameObject:Hide()
  uiCalls.UI_Event_Force_Reticle_Off()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  minigameInProgress = false
end
