local LD = require("design.LevelDesignLibrary")
monitors = require("level.MonitorLibrary")
timer = require("level.timer")
local checkpoint = require("level.checkpoint")
son = nil
player = nil
local SonLead01Monitor, SonTrackingMonitor, TrackPoint1Monitor
function OnScriptLoaded(level)
  son = game.AI.FindSon()
  player = game.Player.FindPlayer()
end
function OnStart()
  if game.Level.GetVariable("CompletedCineNumber") > 180 then
    GameObjects.ReacquireTracks_CA_Son_InvestigateGround.LuaObjectScript.Disable()
  end
end
function OnUpdate(level)
end
function OnUseWorld(level)
end
function CA_StartIntro_Enable()
  GameObjects.LTW_Intro.LuaObjectScript.Enable()
  GameObjects.CA_Intro_LookOut_01.LuaObjectScript.Enable()
end
function CA_Intro_LTWComplete()
  GameObjects.LTW_Intro.LuaObjectScript.Disable()
  GameObjects.LTW_Lead_Follow.LuaObjectScript.Enable()
end
function CA_Area1_Enable()
  GameObjects.CA_Area1_Ground_01.LuaObjectScript.Enable()
  GameObjects.CA_Area1_ObserveF.LuaObjectScript.Enable()
  GameObjects.CA_Area1_Ground_03.LuaObjectScript.Enable()
  GameObjects.CA_Area3_Ground_01.LuaObjectScript.Enable()
  GameObjects.CA_Area1_Gound_NoBanter.LuaObjectScript.Enable()
  GameObjects.CA_Intro_LookOut_01.LuaObjectScript.Disable()
end
function CA_Area1_Disable()
  GameObjects.CA_Area1_Ground_01.LuaObjectScript.Disable()
  GameObjects.CA_Area1_ObserveF.LuaObjectScript.Disable()
  GameObjects.CA_Area1_Ground_03.LuaObjectScript.Disable()
  GameObjects.CA_Area3_Ground_01.LuaObjectScript.Disable()
  GameObjects.CA_Area1_Gound_NoBanter.LuaObjectScript.Disable()
  GameObjects.EntZn_RestartLTW:ShowEntityVolume()
end
function CA_Area1Intro_Disable()
  GameObjects.CA_Area1Intro_Ground_01.LuaObjectScript.Disable()
end
function OnEvaluateLoadGroup_Cinematic()
  if game.Level.GetVariable("CompletedCineNumber") <= 136 then
    return "BoarIntroConfig"
  elseif game.Level.GetVariable("CompletedCineNumber") == 137 then
    return "BoarShootConfig"
  else
    return nil
  end
end
function StartLTWBehavior()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "LEAD_THE_WAY_BEHAVIOR_CONTEXT_CONFIG")
end
function EndLTWBehavior()
  game.AI.FindSon():CallScript("ClearBehaviorContext")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
