local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local actor = require("narrative.actor")
local checkpoint = require("level.checkpoint")
local thisObj
local destroyedVillage_Banter_Counter = 0
local reacquiredTracks_Enabled = false
local hellwalkerFightStarted
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(thisObj)
end
function OnStart()
  if not reacquiredTracks_Enabled then
    GameObjects.BtrZone_ReacquireTracks_Kratos:Hide()
  end
  GameObjects.BtrZone_SoftTissue:HideEntityVolume()
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {
    LevelState = checkpoint.Save()
  }
  savedInfo.abandonedSettlementBanter_Counter = destroyedVillage_Banter_Counter
  savedInfo.reacquiredTracks_Enabled = reacquiredTracks_Enabled
  savedInfo.hellwalkerFightStarted = hellwalkerFightStarted
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  destroyedVillage_Banter_Counter = savedInfo.abandonedSettlementBanter_Counter
  reacquiredTracks_Enabled = savedInfo.reacquiredTracks_Enabled
  hellwalkerFightStarted = savedInfo.hellwalkerFightStarted
  checkpoint.Restore(savedInfo.LevelState)
end
function AbandonedSettlement2_Banter()
  if destroyedVillage_Banter_Counter == 0 then
    game.Audio.PlayBanter("RIV_DestroyedVillage_02_A")
    destroyedVillage_Banter_Counter = 1
  elseif destroyedVillage_Banter_Counter == 1 then
    game.Audio.PlayBanter("RIV_DestroyedVillage_02_B", function()
      LD.CallFunctionAfterDelay(BtrSoftTissue_ZoneEnable, 7)
    end)
    destroyedVillage_Banter_Counter = 2
  end
end
function HelSurprise_Banter()
  game.Audio.PlayBanter("RIV_HelSurprise")
end
function Enable_ReacquireTracks()
  GameObjects.ReacquireTracks_CA_Son_InvestigateGround.Child.LuaObjectScript.Enable()
  GameObjects.BtrZone_ReacquireTracks_Kratos:Show()
  reacquiredTracks_Enabled = true
end
function DisableReacquireTracks_CA()
  GameObjects.ReacquireTracks_CA_Son_InvestigateGround.Child.LuaObjectScript.Disable()
end
function Son_ReacquireTracks_Banter()
  GameObjects.BtrZone_ReacquireTracks_Kratos:Hide()
end
function FightStarted()
  hellwalkerFightStarted = true
end
function BtrSoftTissue_ZoneEnable()
  if not hellwalkerFightStarted then
    GameObjects.BtrZone_SoftTissue:ShowEntityVolume()
  end
end
