local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, sonActor, boarActor, kratosActor, branchObj, debrisLiftObject, preCineCam
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  preCineCam = CCEC.CineEnterCamera.New("ENV_CineEnter_narRivBoarShoot020CineScene", 8)
  preCineCam:SetObjectToSleep(obj)
end
function OnStart()
  CreateActorsAndProps()
  if game.Level.GetVariable("CompletedCineNumber") < 140 then
    SetSpawnFunctions()
    SpawnBoar()
    GameObjects.DeadTree_Cine_02.Child:Hide()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 140 and game.Level.GetVariable("CompletedCineNumber") < 150 then
    WitchIntro_PreIdle()
    SwitchLog()
  else
    GameObjects.BoarShoot_DebrisLift.LuaObjectScript.Disable()
  end
end
function OnUpdate(level, obj)
  if preCineCam ~= nil then
    preCineCam:Update()
  end
end
function OnSaveCheckpoint(level)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function CreateActorsAndProps()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  boarActor = actor.Actor.New("Boar")
  print("createactors has fired and the boar actor variable holds this: " .. tostring(boarActor))
  debrisLiftObject = GameObjects.BoarShoot_DebrisLift.Child
  branchObj = GameObjects.deadbranch.Child
end
function SetSpawnFunctions()
  boarActor:SetSpawnFunction(function()
    local boar = boarActor:CatchCreature()
    if boar == nil then
      return ND.SpawnAIAtJoint(thisLevel, "Cine_BoarShoot", "Boar_Start", "CRT_WildBoar00", "BRA_BoarShootIdle", "BoarShoot")
    else
      return boar
    end
  end)
end
function SpawnBoar()
  local seq = ND.CreateCineSequence(thisLevel, debrisLiftObject, "spawn boar")
  seq:SpawnActorAndWait(boarActor)
  seq:StartSequence()
end
function BoarShootSequence()
  if game.Level.GetVariable("CompletedCineNumber") < 140 then
    local boarShootSeq = ND.CreateCineSequence(thisLevel, debrisLiftObject, "boarShoot")
    local boarShoot_ActorTable = {
      {Actor = sonActor},
      {Actor = boarActor},
      {
        Obj = debrisLiftObject,
        Anim = "narRivBoarShoot020CineScene"
      },
      {
        Obj = branchObj,
        Anim = "narRivBoarShoot020CineScene"
      }
    }
    debrisLiftObject.LuaObjectScript.EnableCinematicTrigger()
    boarShootSeq:SetPostSkipMusic("SND_MX_RIV_start_master", "SND_MX_SonSick_master")
    boarShootSeq:MarkAbleToSkip()
    boarShootSeq:SpawnActorAndWait(boarActor)
    boarShootSeq:RequestCineModeAndWait(kratosActor, thisObj)
    boarShootSeq:Do(StartPreCineCamera)
    boarShootSeq:WaitForLoadCheck("Riv445_c140_BoarShoot")
    boarShootSeq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_BoarShoot",
      ReferenceJoint = "synchJoint",
      speed = ND.KraWalkSpeed,
      stop = true,
      prevent_path_eval = true,
      radius = ND.StopTurnRadius,
      weapon_state = "bare"
    })
    boarShootSeq:ActorSync(kratosActor, {
      Slaves = boarShoot_ActorTable,
      Branch = "BRA_BoarShoot",
      ReferenceJoint = "synchJoint"
    })
    boarShootSeq:WaitUntilActorAnimPastFrame(kratosActor, 900)
    boarShootSeq:Do(SwitchLog)
    boarShootSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    boarShootSeq:DespawnActor(boarActor)
    boarShootSeq:StopPuppetingActor(sonActor)
    boarShootSeq:StopPuppetingActor(kratosActor)
    boarShootSeq:Do(function()
      branchObj:Hide()
    end)
    boarShootSeq:SetCompletedCineNumber(140)
    boarShootSeq:Do(WitchIntro_PreIdle)
    boarShootSeq:Do(function()
      local bookmarks = require("design.Bookmarks")
      local tableEntry = bookmarks["BOOKMARK_" .. "02_RiverPass_036_BoarShoot"]
      game.World.StoreCheckpointAndBookmark(tableEntry)
    end)
    boarShootSeq:StartSequence()
  end
end
function WitchIntro_PreIdle()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "witchIntro_PreIdle")
  seq:ActorSync(sonActor, {
    Branch = "BRA_WitchIntroIdle",
    ReferenceJoint = "WitchIntroIdle_SyncJoint",
    ReferenceObject = thisObj
  })
  seq:WaitForActorPlayingMove(sonActor, "MOV_WitchIntroIdle")
  seq:WaitSeconds(2)
  seq:StopPuppetingActor(sonActor)
  seq:StartSequence()
end
function SaveCheckpoint()
  game.World.StoreCheckpoint()
end
function StartPreCineCamera()
  preCineCam:Start()
end
function SwitchLog()
  GameObjects.DeadTree_Cine_01.Child:Hide()
  GameObjects.DeadTree_Cine_01.Child:HideCollision()
  GameObjects.DeadTree_Cine_02.Child:Show()
  GameObjects.BoarShoot_DebrisLift.LuaObjectScript:Disable()
end
