local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local uiCalls = require("ui.uicalls")
local thisLevel, player, FrenzyRun_Encounter, Area_1_Encounter_1, Area_2_Encounter_1, Area_3_Encounter_1, Area_4_Encounter_1, A1_ZM_1, A2_ZM_1, A3_ZM_1, A4_ZM_1, Stop_ZM
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
end
function FrenzyRun()
  A1_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Arena_Attack__1)
  A1_ZM_1:SetTriggerCountLimit(1)
  A1_ZM_1:OnEnter(function()
    FrenzyRun_Encounter:Start(1)
  end)
  A2_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Arena_Attack__2)
  A2_ZM_1:SetTriggerCountLimit(1)
  A2_ZM_1:OnEnter(function()
    FrenzyRun_Encounter:StartWave(2)
  end)
  A3_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Arena_Attack__3)
  A3_ZM_1:SetTriggerCountLimit(1)
  A3_ZM_1:OnEnter(function()
    FrenzyRun_Encounter:StartWave(3)
  end)
  A4_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Arena_Attack__4)
  A4_ZM_1:SetTriggerCountLimit(1)
  A4_ZM_1:OnEnter(function()
    FrenzyRun_Encounter:StartWave(4)
  end)
  Stop_ZM = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Maze_End)
  Stop_ZM:SetTriggerCountLimit(1)
  Stop_ZM:OnEnter(function()
    FrenzyRun_Encounter:DespawnEnemies()
    FrenzyRun_Encounter:Stop()
  end)
  FrenzyRun_Encounter = EC.NewEncounter(thisLevel, "[FrenzyRun]EC: Riv450", {CheckpointOnComplete = false})
  FrenzyRun_Encounter:AddWave({
    requireSpawnersInRange = {0, 15},
    requireOnScreenSpawners = true,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    }
  })
  FrenzyRun_Encounter:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A2_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    }
  })
  FrenzyRun_Encounter:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Draugr_N_SFH",
      spawnLocators = "A3_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    }
  })
  FrenzyRun_Encounter:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Draugr_N_SFA",
      spawnLocators = "A4_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2
    },
    {
      spawners = "Draugr_N_SFA",
      spawnLocators = "A4_O_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.2
    }
  })
  FrenzyRun_Encounter:SetStartZone(GameObjects.EntZn_Maze_Start)
  FrenzyRun_Encounter:OnEnemySpawn(function()
    GameObjects.Riv450_HintBanter.LuaObjectScript.LostBoy06_A_Banter()
  end, {count = 1, wave = 1})
  FrenzyRun_Encounter:OnEnemyDeath(function()
    GameObjects.Riv450_HintBanter.LuaObjectScript.LostBoy06_B_Banter()
  end, {count = 1, wave = 1})
  FrenzyRun_Encounter:OnEnemySpawn(weakenEnemy)
end
function weakenEnemy(enemy)
  LD.CallFunctionAfterDelay(function()
    if enemy ~= nil then
      local EnemyHealth = enemy:GetHitPoints()
      local Health_Phase_1 = EnemyHealth * 0.25
      enemy:MeterSetValue("Health", Health_Phase_1)
    end
  end, 0.08)
end
