local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
monitors = require("level.MonitorLibrary")
timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local player, playerWorldPosition, SquareButtonMonitor, SprintButtonMonitor
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  SquareButtonMonitor = monitors.CreateSquareButtonMonitor()
  SquareButtonMonitor:OnButtonDown(OnSquarePressed)
end
function OnFirstStart(level)
  GameObjects.AI_DeathPlane:HideCollision()
end
function OnUpdate(level)
  playerWorldPosition = player.WorldPosition
  SubmitRiv450NavCams()
end
function OnSquarePressed()
  if player:IsInsideEntityZone("BanterZone_LostBoy_02") then
    game.Audio.PlayBanter("RIV_LostBoy_03")
    GameObjects.BanterZone_LostBoy_02:HideEntityVolume()
    HideMessage()
  end
  if player:IsInsideEntityZone("BanterZone_LostBoy_03") then
    game.Audio.PlayBanter("RIV_LostBoy_02")
    GameObjects.BanterZone_LostBoy_03:HideEntityVolume()
    HideMessage()
  end
  if player:IsInsideEntityZone("BanterZone_LostBoy_04") then
    game.Audio.PlayBanter("RIV_LostBoy_04")
    GameObjects.BanterZone_LostBoy_04:HideEntityVolume()
    HideMessage()
  end
  if player:IsInsideEntityZone("BanterZone_LostBoy_09") then
    game.Audio.PlayBanter("RIV_LostBoy_09")
    GameObjects.BanterZone_LostBoy_09:HideEntityVolume()
    HideMessage()
  end
  if player:IsInsideEntityZone("BanterZone_LostBoy_10") then
    game.Audio.PlayBanter("RIV_LostBoy_10")
    GameObjects.BanterZone_LostBoy_10:HideEntityVolume()
    HideMessage()
  end
  if player:IsInsideEntityZone("BanterZone_LostBoy_11") then
    game.Audio.PlayBanter("RIV_LostBoy_10")
    GameObjects.BanterZone_LostBoy_11:HideEntityVolume()
    HideMessage()
  end
end
function ShowAiDeathPlane()
  GameObjects.AI_DeathPlane:ShowCollision()
end
function HideAiDeathPlane()
  GameObjects.AI_DeathPlane:HideCollision()
end
function WitchIntroLoadCheck()
  game.UI.LoadCheck("Riv475_FreyaHouseExt")
end
function SubmitRiv450NavCams()
  if game.World.IsInsideCameraZone(playerWorldPosition, "CamZone_PanicForest") then
    game.Camera.SubmitCameraByName("PLYR_Set_Panic_RiverPass")
  elseif game.World.IsInsideCameraZone(playerWorldPosition, "CamZone_RageForest_020") then
    game.Camera.SubmitCameraByName("ENV_RageForest_020")
  end
end
function BadFatherAchievement()
  game.Wallets.AddResource("HERO", "Hacksilver", 2186, "NO_TELEMETRY")
end
function OnEvaluateLoadGroup_Cinematic()
  if game.Level.GetVariable("CompletedCineNumber") < 149 then
    return "WitchIntroConfig"
  else
    return nil
  end
end
function ShowMessage()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  uiCalls.SendSidebarDesignerMessage({
    Text = 31067,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
end
function HideMessage()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function StartPanicIdle()
  player:CallScript("EnablePanicIdle")
  player:CallScript("PlaySoundOnKratos", "SND_AMB_Bed_Riv450_Maze_Haunting_LP")
  if game.SetPlayerCameraHeadtrackActive then
    game.SetPlayerCameraHeadtrackActive(false)
  end
end
function StopPanicIdle()
  player:CallScript("DisablePanicIdle")
  player:CallScript("StopSoundOnKratos", "SND_AMB_Bed_Riv450_Maze_Haunting_LP")
  if game.SetPlayerCameraHeadtrackActive then
    game.SetPlayerCameraHeadtrackActive(true)
  end
end
