local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local thisObj, thisLevel, boarAiObj
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  StartSpawnBoar()
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.boarAiObj = boarAiObj
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  boarAiObj = savedInfo.boarAiObj
end
function StartSpawnBoar()
  if game.Level.GetVariable("CompletedCineNumber") < 180 then
    local seq = ND.CreateCineSequence(thisLevel, thisObj, "Delay Boar Spawn Until Anims Load")
    seq:WaitForFunctionTrue(NeededCineWadLoaded)
    seq:Do(SpawnBoar)
    seq:StartSequence()
  end
end
function NeededCineWadLoaded()
  if game.FindLevel("Riv480_c160_WitchHouseA") == nil and game.FindLevel("Riv480_c165_WitchHouseB") == nil and game.FindLevel("Riv455_c150_WitchIntro") == nil then
    return false
  else
    return true
  end
end
function SpawnBoar()
  local boarSpawnBranchString
  if game.Level.GetVariable("CompletedCineNumber") < 150 then
    boarSpawnBranchString = "BRA_WitchIntroIdle"
  else
    boarSpawnBranchString = "BRA_WitchHouseAEndIdle"
  end
  if boarAiObj == nil then
    boarAiObj = ND.SpawnAIAtJoint(thisLevel, "CineSupport_BoarSpawn", "Boar_Spawn", "CRT_WildBoar00", boarSpawnBranchString, "WitchHouseBoar")
    print("------------------------------------------------------------------boar exists and is: " .. tostring(boarAiObj))
    print("------------------------------------------------------------------boar is located at: " .. tostring(boarAiObj:GetWorldPosition()))
  end
end
