local LD = require("design.LevelDesignLibrary")
checkpoint = require("level.checkpoint")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisLevel, thisObj, kratosActor, sonActor, redrootObj, knifeReturn_lights
SND_Flower = nil
local preKnifeReturn_Valid = false
local cameraCineEnter_KnifeReturn
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  SND_Flower = GameObjects.Cine_KnifeReturn:FindSingleSoundEmitterByName("SNDFlower")
end
function OnStart(level, obj)
  CreateActorsAndProps()
  if game.Level.GetVariable("CompletedCineNumber") < 163 then
    BuildIdleSwitchSequence()
  end
end
function OnUpdate()
  if cameraCineEnter_KnifeReturn ~= nil then
    cameraCineEnter_KnifeReturn:Update()
  end
end
function CreateActorsAndProps()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  redrootObj = GameObjects.redRoot00A.Child
  knifeReturn_lights = GameObjects.Cine_Start_163
  GameObjects.SpeedControlZone_ILikeHer:Hide()
  HidePropsAndLights()
end
function HidePropsAndLights()
  redrootObj:Hide()
  knifeReturn_lights:Hide()
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function BuildIdleSwitchSequence()
  local idleSwitchSeq = ND.CreateCineSequence(thisLevel, thisObj, "sonIdleSwitch")
  idleSwitchSeq:WaitForActorInZone(kratosActor, GameObjects.CineZone_SonIdleSwitch)
  idleSwitchSeq:ActorSync(sonActor, {
    Branch = "BRA_ILikeHerPreIdle",
    ReferenceJoint = "ILikeHer_SyncJoint"
  })
  idleSwitchSeq:Do(function()
    game.FindLevel("Riv480_FreyaHouse"):CallScript("CreatureStandIdle")
  end)
  idleSwitchSeq:StartSequence()
end
function ILikeHerSequence()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "redRootIdle")
  GameObjects.SpeedControlZone_ILikeHer:Show()
  seq:RequestCineModeAndWait(sonActor, thisObj)
  seq:Do(function()
    game.Audio.PlayBanter("RIV_ILikeHer")
  end)
  seq:ActorSync(sonActor, {
    Branch = "BRA_ILikeHer",
    ReferenceJoint = "ILikeHer_SyncJoint"
  })
  seq:WaitForAndCompleteCineMode(sonActor, thisObj)
  seq:Do(function()
    GameObjects.SpeedControlZone_ILikeHer:Hide()
  end)
  seq:StartSequence()
end
function PickedUpLambsCress()
  game.FindLevel("Riv480_FreyaHouse"):GetGameObject("Cine_WitchHouse"):CallScript("Acquired_Lambscress")
  RedRootIdleSequence()
end
function RedRootIdleSequence()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "redRootIdle")
  local table = {
    {
      Obj = redrootObj,
      Anim = "narKnifeReturn000IntSonIdle"
    }
  }
  GameObjects.ILikeHer_InteractZone.Child.LuaObjectScript.Disable()
  redrootObj:Show()
  preKnifeReturn_Valid = true
  GameObjects.RedRoot_InteractZone.Child.LuaObjectScript.Enable()
  seq:ActorSync(sonActor, {
    Slaves = table,
    Branch = "BRA_KnifeReturnSonIdle",
    ReferenceJoint = "KnifeReturn_SyncJoint"
  })
  seq:StartSequence()
end
function PreKnifeReturn_On()
  if preKnifeReturn_Valid then
    GameObjects.PreKnifeReturn_BanterLoop.Child.LuaObjectScript.Enable()
  end
end
function PreKnifeReturn_Off()
  GameObjects.PreKnifeReturn_BanterLoop.Child.LuaObjectScript.Disable()
end
function BuildKnifeReturnSequence()
  local knifeReturnSeq = ND.CreateCineSequence(thisLevel, thisObj, "knifeReturn")
  local knifeReturn_ActorTable = {
    {Actor = sonActor},
    {
      Obj = redrootObj,
      Anim = "narKnifeReturn010Cine"
    }
  }
  preKnifeReturn_Valid = false
  GameObjects.ToggleZone_PreKnifeReturn:Hide()
  GameObjects.PreKnifeReturn_BanterLoop.Child.LuaObjectScript.Disable()
  knifeReturnSeq:SetPostSkipMusic("SND_MX_RIV_start_master", "SND_MX_SonSick_master")
  knifeReturnSeq:MarkAbleToSkip()
  knifeReturnSeq:RequestCineModeAndWait(kratosActor, thisObj)
  knifeReturnSeq:Do(StartCineEnter_KnifeReturn)
  knifeReturnSeq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_KnifeReturnCine",
    ReferenceJoint = "KnifeReturn_SyncJoint",
    speed = ND.KraWalkSpeed,
    stop = true,
    prevent_path_eval = true,
    radius = ND.StopTurnRadius,
    weapon_state = "bare"
  })
  knifeReturnSeq:Do(function()
    knifeReturn_lights:Show()
    knifeReturn_lights:JumpAnimToFrame(0)
    knifeReturn_lights:PlayAnimToEnd()
  end)
  knifeReturnSeq:ActorSync(kratosActor, {
    Slaves = knifeReturn_ActorTable,
    Branch = "BRA_KnifeReturnCine",
    ReferenceJoint = "KnifeReturn_SyncJoint"
  })
  knifeReturnSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  knifeReturnSeq:StopPuppetingActor(kratosActor)
  knifeReturnSeq:StopPuppetingActor(sonActor)
  knifeReturnSeq:Do(HidePropsAndLights)
  knifeReturnSeq:Do(function()
    game.Level.SetVariable("RIV_NAR_KnifeReturnDone", true)
  end)
  knifeReturnSeq:Do(CompleteQuestObj476)
  knifeReturnSeq:SetCompletedCineNumber(163)
  knifeReturnSeq:Do(EnableWitchHouseB)
  knifeReturnSeq:Do(EnableWitchHouseB)
  knifeReturnSeq:StartSequence()
end
function CompleteQuestObj476()
  game.QuestManager.ProposeQuestState("Quest_RiverPass_Objective476", "Complete")
end
function EnableWitchHouseB()
  game.EvaluateLoadZones()
end
function StartCineEnter_KnifeReturn()
  game.SubObject.Wake(thisObj)
  cameraCineEnter_KnifeReturn = CCEC.CineEnterCamera.New("ENV_CineEnter_KnifeReturn", 8)
  cameraCineEnter_KnifeReturn:SetCallback(DestroyCineEnter_KnifeReturn)
  cameraCineEnter_KnifeReturn:Start()
end
function DestroyCineEnter_KnifeReturn()
  cameraCineEnter_KnifeReturn = nil
  game.SubObject.Sleep(thisObj)
end
