local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local thisObj, thisLevel, sonActor, turtle
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  InitializeVariables()
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
function InitializeVariables()
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function SonPetTurtleSeq()
  print("POI - Son Pet Turtle - On")
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "sonPetTurtle")
  turtle = game.FindLevel("Riv480_FreyaHouse"):GetGameObject("freyaCreature").Child
  local actor_table = {
    {
      Obj = turtle,
      Anim = "poiRivSonPetTurtle"
    }
  }
  seq:Do(function()
    GameObjects.Son_Riv475_LeadTheWay.Child.LuaObjectScript.Disable()
  end)
  seq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_SonPetTurtle",
    ReferenceJoint = "SonPetTurtle_SyncJoint",
    speed = ND.SonRunSpeed,
    stop = false,
    radius = ND.RunArrivalRadius,
    foot = game.Creature.Foot.kRight
  })
  seq:ActorSync(sonActor, {
    Slaves = actor_table,
    Branch = "BRA_SonPetTurtle",
    ReferenceJoint = "SonPetTurtle_SyncJoint"
  })
  seq:StopPuppetingActor(sonActor)
  seq:StartSequence()
end
