local timers = require("level.timer")
local player
local banterPlayed = {}
local questionWasRead
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 160 and 150 <= cineNum then
    local pad = game.Player.FindPlayer().Pad
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadR1)
    pad:DisableGameButton(tweaks.ePad.kPadR2)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadCross)
  end
  if banterPlayed.FreyaYardRuneBowl2_DiscoverAnswer then
    DisableFoundRunes_CA()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  questionWasRead = questionWasRead
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  banterPlayed = savedInfo.banterPlayed
  questionWasRead = savedInfo.questionWasRead
end
function BifrostGraffiti_Banter()
  if not banterPlayed.BifrostGraffiti then
    game.Audio.PlayBanter("RIV_BifrostGraffiti")
    banterPlayed.BifrostGraffiti = true
  end
end
function StoneGraffiti1_Banter()
  if player:PickupIsAcquired("MimirHead") and game.Level.GetVariable("CompletedCineNumber") >= 330 then
    game.Audio.SetBanterFact("MimirHeadRevived", "TRUE", "Infinite")
  end
end
function StoneGraffiti2_Banter()
  if player:PickupIsAcquired("MimirHead") and game.Level.GetVariable("CompletedCineNumber") >= 330 then
    game.Audio.SetBanterFact("MimirHeadRevived", "TRUE", "Infinite")
  end
end
function FreyaYardRuneBowl3_SolveComplete_Banter()
  if not banterPlayed.FreyaYardRuneBowl3_SolveComplete then
    game.Audio.PlayBanter("RIV_FreyaYardRuneBowl3_SolveComplete")
    banterPlayed.FreyaYardRuneBowl3_SolveComplete = true
  end
end
function QuestionStart()
  questionWasRead = true
end
function RuneRead_NotEnough_WrongStart()
  game.Audio.PlayBanter("RIV_FreyaYardWrongRunes_01", _G.DisableWrongRunes)
end
function FreyaYardRuneBowl2_HintAfterDelay_Banter()
  if questionWasRead and not banterPlayed.FreyaYardRuneBowl2_HintAfterDelay and not banterPlayed.FreyaYardRuneBowl2_DiscoverAnswer then
    game.Audio.PlayBanter("RIV_FreyaYardRuneBowl2_HintAfterDelay")
    banterPlayed.FreyaYardRuneBowl2_HintAfterDelay = true
  end
end
function Btr_DiscoverAnswer()
  if questionWasRead then
    game.Audio.PlayBanter("RIV_FreyaYardRuneBowl2_DiscoverAnswerB", DisableFoundRunes_CA)
  else
    game.Audio.PlayBanter("RIV_FreyaYardRuneBowl2_DiscoverAnswerBeforeQuestion", DisableFoundRunes_CA)
  end
  banterPlayed.FreyaYardRuneBowl2_DiscoverAnswer = true
end
function DisableFoundRunes_CA()
  GameObjects.CA_FoundRunes.LuaObjectScript.Disable()
end
function BoatReminderTimer()
  timers.StartLevelTimer(45, function()
    game.FindLevel("Riv600_FreyaRiver"):GetGameObject("Cine_AthenaBoat"):CallScript("BoatReminder_Banter")
  end)
end
