local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local ND = require("design.NarrativeDesignLibrary")
local CCEC = require("camera.camera_cineentercamera")
local checkpoint = require("level.checkpoint")
local gVFSToggleCamZoneENVFixed = engine.VFSBool.New("Toggle Boar Carry ENV Fixed via R3: ")
local gVFSToggleCamZoneENVRail = engine.VFSBool.New("Toggle Boar Carry ENV Rail via R3: ")
local gVFSToggleCamZonePLYRRTT = engine.VFSBool.New("Toggle Boar Carry Rotate To Target via R3: ")
local bBoarCarryENVFixed = false
local bBoarCarryENVRail = false
local bBoarCarryRTT = false
local cameraTurtleRise, tripleChestComplete, SpinnerHit, translateComplete_01, translateComplete_02, runeDiscovered, sandbowlComplete
local cameraShakeTurtleRise = {
  EffectName = "FSE_SWAY_TURTLERISE_SHAKE",
  Duration = 8,
  TweenInTime = 1.2,
  TweenOutTime = 3
}
local WellCheckPointMonitor
local firstvisitDone = false
function OnScriptLoaded(level)
  CompassPathCheck()
end
function OnFirstStart(level)
  WellCheckPointMonitor = monitors.CreateEntityZoneMonitor(game.Player.FindPlayer(), GameObjects.EntZn_WellCheckPoint)
  WellCheckPointMonitor:SetTriggerCountLimit(1)
  WellCheckPointMonitor:OnEnter(function()
    game.World.StoreCheckpoint()
  end)
  HideCreatureHiddenCollision()
end
function OnStart(level)
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 150 <= cineNumber and cineNumber < 160 then
    EnableLTW()
    if game.FindLevel("Riv480_c160_WitchHouseA") ~= nil then
      GameObjects.POI_FirstHeimili.LuaObjectScript.FreyaPathWildlifeSeq()
    end
  elseif 160 <= cineNumber then
    DisableLTW()
  end
  if cineNumber <= 300 then
    GameObjects.Riv475_FreyaHouseExt_Zone_1:Hide()
    GameObjects.Riv475_FreyaHouseExt_Zone_1:HideEntityVolume()
    GameObjects.Scripted_HouseDefenseCol:HideCollision()
    GameObjects.VineBlocker_Col:HideCollision()
    GameObjects.Turtle_Laying_Down:HideCollision()
    GameObjects.Turtle_On_Defense:HideCollision()
  else
    GameObjects.VineBlocker_Col:ShowCollision()
  end
  if cineNumber == 369 then
    ShowTurtleStandCollision()
    HideCreatureHiddenCollision()
  end
  if 387 <= cineNumber then
    ShowTurtleDownCollision()
  end
  if 365 <= cineNumber and cineNumber < 380 then
    GameObjects.SNDGrpFreyaRiver:Hide()
  else
    GameObjects.SNDGrpFreyaRiver:Show()
  end
  if game.Level.GetVariable("RIV_NAR_FlowerPickup") == true then
    DisableLambsCress()
  end
  GameObjects.TP_OverLog:ShowTraverseLink()
  GameObjects.EntZn_PuzzledContext:HideEntityVolume()
  SoundOnStart()
  local Rune_Interact_Rock = GameObjects.Rune_Interact_Rock.LuaObjectScript.GetInteractZone()
  Rune_Interact_Rock:SetXZRange(14)
  Rune_Interact_Rock:SetYRange(5)
  Rune_Interact_Rock:SetAngle(110)
  Rune_Interact_Rock:SetHintXZRange(22)
  Rune_Interact_Rock:SetHintAngle(110)
  local Rune_Interact_Ground = GameObjects.Rune_Interact_Ground.LuaObjectScript.GetInteractZone()
  Rune_Interact_Ground:SetXZRange(16)
  Rune_Interact_Ground:SetYRange(5)
  Rune_Interact_Ground:SetAngle(240)
  Rune_Interact_Ground:SetHintXZRange(24)
  Rune_Interact_Ground:SetHintAngle(240)
  RuneRead1Interact_Show()
end
function RuneRead1Interact_Hide()
  GameObjects.SonReadRune1.LuaObjectScript.GetInteractZone():SetAngle(0)
end
function RuneRead1Interact_Show()
  GameObjects.SonReadRune1.LuaObjectScript.GetInteractZone():SetAngle(60)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    firstvisitDone = firstvisitDone,
    runeDiscovered = runeDiscovered,
    sandbowlComplete = sandbowlComplete
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  firstvisitDone = savedInfo.firstvisitDone
  runeDiscovered = savedInfo.runeDiscovered
  sandbowlComplete = savedInfo.sandbowlComplete
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_Riv480_c160_WitchHouseA" then
    GameObjects.POI_FirstHeimili.LuaObjectScript.FreyaPathWildlifeSeq()
  end
end
function OnUpdate(level)
  BoarCarryCameraSwitcher()
  if cameraTurtleRise ~= nil then
    cameraTurtleRise:Update()
  end
end
function DisableLambsCress()
  GameObjects.LambsCress_01.LuaObjectScript.Disable()
  GameObjects.LambsCress_02.LuaObjectScript.Disable()
  GameObjects.LambsCress_03.LuaObjectScript.Disable()
  GameObjects.LambsCress_04.LuaObjectScript.Disable()
  GameObjects.LambsCress_05.LuaObjectScript.Disable()
  GameObjects.LambsCress_06.LuaObjectScript.Disable()
end
function LambsCressAcquired()
  LD.CompleteQuest("Quest_RiverPass_Objective475")
  game.Level.SetVariable("RIV_NAR_FlowerPickup", true)
  DisableLambsCress()
  GameObjects.Cine_KnifeReturn.LuaObjectScript.PickedUpLambsCress()
end
function CompassPathCheck()
  if game.Level.GetVariable("RIV_NAR_FreyaHouseUp") == false then
    game.Compass.SetGatewayMarkerIsOpen("RP_475_Helper20", false)
  elseif game.Level.GetVariable("RIV_NAR_FreyaHouseUp") == true then
    OpenCompassPath()
  end
end
function OpenCompassPath()
  game.Compass.SetGatewayMarkerIsOpen("RP_475_Helper20", true)
end
function CameraTurtleRising()
  game.FX.SubmitEffect(cameraShakeTurtleRise)
  timer.StartLevelTimer(0.2, function()
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 9,
      TweenIn = {Time = 0.8},
      TweenOut = {Time = 0},
      Priority = 5000
    })
  end)
  timer.StartLevelTimer(4.2, CameraStartTurtleOneShot)
end
function CameraStartTurtleOneShot()
  cameraTurtleRise = CCEC.CineEnterCamera.New("PLYR_NarrativeCarry_Boar_TurtleRise", 9.5, nil)
  cameraTurtleRise:Start()
end
function HeadEnchantActivateInit()
  if game.Level.GetVariable("CompletedCineNumber") > 160 and game.Level.GetVariable("CompletedCineNumber") < 300 then
    GameObjects.InteractZone_Temp.LuaObjectScript:Enable()
  end
end
function ShowHouseDefenseCollision()
  GameObjects.Scripted_HouseDefenseCol:ShowCollision()
end
function HideHouseDefenseCollision()
  GameObjects.Scripted_HouseDefenseCol:HideCollision()
end
function ShowTurtleStandCollision()
  GameObjects.Turtle_Laying_Down:HideCollision()
  GameObjects.Turtle_On_Defense:HideCollision()
  GameObjects.Turtle_Standing:ShowCollision()
end
function ShowTurtleDownCollision()
  GameObjects.Turtle_On_Defense:HideCollision()
  GameObjects.Turtle_Standing:HideCollision()
  GameObjects.Turtle_Laying_Down:ShowCollision()
end
function ShowTurtleDefenseCollision()
  GameObjects.Turtle_Standing:HideCollision()
  GameObjects.Turtle_Laying_Down:HideCollision()
  GameObjects.Turtle_On_Defense:ShowCollision()
end
function HideTurtleCollision()
  GameObjects.Turtle_On_Defense:HideCollision()
  GameObjects.Turtle_Standing:HideCollision()
  GameObjects.Turtle_Laying_Down:HideCollision()
end
function HideCreatureHiddenCollision()
  GameObjects.Scripted_HouseDown_Col:HideCollision()
  GameObjects.NavObstacleHouseDown:HideNavObstacle()
end
function CreatureCollisionCheck()
  if game.Level.GetVariable("CompletedCineNumber") >= 330 then
    GameObjects.Scripted_HouseDown_Col:ShowCollision()
    GameObjects.NavObstacleHouseDown:ShowNavObstacle()
  end
end
function SyncExit_Well()
  GameObjects.Lead_Intro.LuaObjectScript.Enable()
  if not firstvisitDone then
    GameObjects.CA_Point_Forward_Turtle.LuaObjectScript.Enable()
    EnableTurtleAwarenessZone()
    firstvisitDone = true
  else
    GameObjects.CA_SyncExitHelper.LuaObjectScript.Enable()
    GameObjects.CA_Point_Forward_Turtle.LuaObjectScript.Disable()
  end
  CreatureCollisionCheck()
end
function DisableLeadZone()
  GameObjects.EntZn_LeadTheWay:HideEntityVolume()
end
function CA_Area_Enable()
  GameObjects.Lead_Intro.LuaObjectScript.Enable()
  GameObjects.Lead_UpperArea.LuaObjectScript.Enable()
  GameObjects.LTW_Main_Follow.LuaObjectScript.Enable()
  if not translateComplete_01 then
    GameObjects.CA_ObsFwd_Rune1.LuaObjectScript.Enable()
    GameObjects.SonReadRune1.Child.Child.LuaObjectScript.Enable()
  end
  if not translateComplete_02 then
    GameObjects.CA_ObsFwd_Rune2.LuaObjectScript.Enable()
    GameObjects.SonRuneRead2.Child.Child.LuaObjectScript.Enable()
  end
end
function CA_Area_Disable()
  GameObjects.CA_ObsFwd_Rune1.LuaObjectScript.Disable()
  GameObjects.CA_ObsFwd_Rune2.LuaObjectScript.Disable()
  GameObjects.LTW_Main_Follow.LuaObjectScript.Disable()
  GameObjects.Lead_Intro.LuaObjectScript.Disable()
end
function CA_DisableAll()
end
function CA_SwitchTo_Area1()
end
function Translate_Start()
  GameObjects.RopeDropFree.LuaObjectScript.Disable()
end
function Translate_Complete_01()
  GameObjects.RopeDropFree.LuaObjectScript.Enable()
  translateComplete_01 = true
end
function Translate_Complete_02()
  GameObjects.RopeDropFree.LuaObjectScript.Enable()
  translateComplete_02 = true
end
function TripleChestOpened()
  tripleChestComplete = true
  GameObjects.CA_ObsFwdUp_Area3_01.LuaObjectScript.Disable()
  GameObjects.EntZn_PuzzledContext:HideEntityVolume()
end
function EnableLTW()
  GameObjects.Son_Riv475_LeadTheWay.LuaObjectScript.Enable()
  GameObjects.Freya_Riv475_LeadTheWay.LuaObjectScript.Enable()
  GameObjects.Riv475_PlayerNavCurve.LuaObjectScript.Enable()
  GameObjects.Riv475_SpeedControl_BoarCarry:ShowEntityVolume()
end
function DisableLTW()
  GameObjects.Son_Riv475_LeadTheWay.LuaObjectScript.Disable()
  GameObjects.Freya_Riv475_LeadTheWay.LuaObjectScript.Disable()
  GameObjects.Riv475_PlayerNavCurve.LuaObjectScript.Disable()
  GameObjects.Riv475_SpeedControl_BoarCarry:Hide()
end
function SpinnerFound()
  if not tripleChestComplete and not SpinnerHit then
    SpinnerHit = true
    GameObjects.CA_ObsFwdUp_Area3_01.LuaObjectScript.Enable()
    GameObjects.EntZn_PuzzledContext:ShowEntityVolume()
  end
end
function RavenKilled()
  GameObjects.RavenKillEvent.LuaObjectScript.Trigger()
end
function Riv475_Bookmark_DisableFlowers()
  GameObjects.FlowerPull01.LuaObjectScript:Disable()
  GameObjects.FlowerPull02.LuaObjectScript:Disable()
  GameObjects.FlowerPull03.LuaObjectScript:Disable()
  GameObjects.FlowerPull04.LuaObjectScript:Disable()
end
function Riv475_LeadTheWay_StartMidPathDebug(level)
  print("Riv475_LeadTheWay_StartMidPathDebugRiv475_LeadTheWay_StartMidPathDebugRiv475_LeadTheWay_StartMidPathDebugRiv475_LeadTheWay_StartMidPathDebug")
  local freyaRef = ND.FindFreya()
  local freyaBookmarkObj = GameObjects.FreyaPathDebug_FreyaStart
  if freyaRef ~= nil then
    freyaRef:Warp(freyaBookmarkObj:GetWorldPosition(), freyaBookmarkObj:GetWorldForward())
  else
    LD.SpawnFreyaAtVector(freyaBookmarkObj:GetWorldPosition(), freyaBookmarkObj:GetWorldForward())
  end
  GameObjects.Son_Riv475_LeadTheWay.Child.LuaObjectScript.Enable()
  GameObjects.Freya_Riv475_LeadTheWay.Child.LuaObjectScript.Enable()
end
function BoarCarryCameraSwitcher()
  if gVFSToggleCamZoneENVRail.value == true and bBoarCarryENVRail == false then
    bBoarCarryENVRail = true
    GameObjects.Cams_ENV_RailVersion:ShowCameraVolume()
  elseif gVFSToggleCamZoneENVRail.value == false and bBoarCarryENVRail == true then
    bBoarCarryENVRail = false
    GameObjects.Cams_ENV_RailVersion:HideCameraVolume()
  end
  if gVFSToggleCamZoneENVFixed.value == true and bBoarCarryENVFixed == false then
    bBoarCarryENVFixed = true
    GameObjects.Cams_ENV_Fixed_Version:ShowCameraVolume()
  elseif gVFSToggleCamZoneENVFixed.value == false and bBoarCarryENVFixed == true then
    bBoarCarryENVRail = false
    GameObjects.Cams_ENV_Fixed_Version:HideCameraVolume()
  end
  if gVFSToggleCamZonePLYRRTT.value == true and bBoarCarryRTT == false then
    bBoarCarryRTT = true
  elseif gVFSToggleCamZonePLYRRTT.value == false and bBoarCarryRTT == true then
    bBoarCarryRTT = false
  end
end
function RemoveTurtleAwarenessZone()
  GameObjects.AwarenessZone_Turtle.LuaObjectScript.DisableEventEmitter()
end
function EnableTurtleAwarenessZone()
  GameObjects.AwarenessZone_Turtle.LuaObjectScript.EnableEventEmitter()
end
function EnableSandBowl()
  LD.CallFunctionAfterDelay(function()
    GameObjects.Riv475_Sandbowl.Child.LuaObjectScript.Enable()
  end, 2.5)
end
function QuestionDone()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  ShowWrongRunes()
end
function RunesInView_True()
  if not runeDiscovered then
    GameObjects.Rune_Interact_Success.LuaObjectScript.Enable()
  end
end
function RunesInView_False()
  GameObjects.Rune_Interact_Success.LuaObjectScript.Disable()
end
function RunesFound()
  runeDiscovered = true
  GameObjects.EntZn_RunesInView:HideEntityVolume()
  GameObjects.Riv475_Sandbowl.LuaObjectScript.SetRuneDiscovered()
  GameObjects.Lead_UpperArea.LuaObjectScript.Disable()
  GameObjects.Lead_UpperArea_Reverse.LuaObjectScript.Enable()
  game.Audio.PlayBanter("RIV_FreyaYardRuneBowl2_DiscoverAnswerA")
  GameObjects.CA_FoundRunes.LuaObjectScript.Enable()
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", {Unoccupied = false})
end
function RuneReadComplete()
  GameObjects.Riv475_Banter.LuaObjectScript.Btr_DiscoverAnswer()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
end
function SandBowlSolveStart()
  LD.CallFunctionAfterDelay(function()
    if game.AI.FindSon():IsPlayingMove("MOV_SandbowlApproach") then
      LD.PlaySoundAfterDelay(GameObjects.Freya_RockPileReform.Child.SoundEmitters[1], "SND_MAG_Stone_Gate_Reveal_Riv475", 4.805)
    elseif game.AI.FindSon():IsPlayingMove("MOV_SandbowlApproachWithAnswer") or game.AI.FindSon():IsPlayingMove("MOV_SandbowlQuestionWithAnswer") then
      LD.PlaySoundAfterDelay(GameObjects.Freya_RockPileReform.Child.SoundEmitters[1], "SND_MAG_Stone_Gate_Reveal_Riv475", 8.041)
    end
  end, 0.1)
end
function SandBowlComplete()
  sandbowlComplete = true
  GameObjects.LTW_Main_Lead.LuaObjectScript.Disable()
  GameObjects.LTW_Main_Follow.LuaObjectScript.Enable()
  GameObjects.Freya_RockPileReform.Child:PlayAnimToEnd(1)
  GameObjects.chest_legendary_scripted.LuaObjectScript.Enable()
  GameObjects.RockPile_Col:HideCollision()
  game.Blender.Trigger({
    Name = "FSE_SHAKE_TREMORS_LEVEL_1",
    Duration = 5.67,
    TweenIn = {Time = 0.2},
    TweenOut = {Time = 0.8}
  })
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_MEDIUM",
    Duration = 5.67,
    TweenIn = {Time = 0.2},
    TweenOut = {Time = 0.5},
    Priority = 2
  })
end
function ExitRopeTop()
  GameObjects.CA_ObsFwd_Rune1.LuaObjectScript.Disable()
  GameObjects.CA_SyncExit_RopeTop.LuaObjectScript.Enable()
  RemoveTurtleAwarenessZone()
end
function ExitRopeBottom()
  GameObjects.CA_ObsFwdUp_Area3_01.LuaObjectScript:Disable()
  GameObjects.CA_ObsFwd_Rune1.LuaObjectScript.Disable()
  if runeDiscovered == true and not sandbowlComplete then
    GameObjects.Riv475_Sandbowl.LuaObjectScript.Enable()
    GameObjects.LTW_Main_Follow.LuaObjectScript.Disable()
    GameObjects.LTW_Main_Lead.LuaObjectScript.Enable()
    if not translateComplete_01 then
      LD.CallFunctionAfterDelay(function()
        GameObjects.CA_ObsFwd_Rune1.LuaObjectScript.Enable()
      end, 5)
    end
  elseif not translateComplete_01 then
    LD.CallFunctionAfterDelay(function()
      GameObjects.CA_ObsFwd_Rune1.LuaObjectScript.Enable()
    end, 2)
  end
  GameObjects.CA_SyncExit_RopeBottom.LuaObjectScript:Enable()
end
function ShowWrongRunes()
  GameObjects.Rune_Interact_Ground.LuaObjectScript.Enable()
  GameObjects.Rune_Interact_Rock.LuaObjectScript.Enable()
end
function DisableWrongRunes()
  GameObjects.Rune_Interact_Ground.LuaObjectScript.Disable()
  GameObjects.Rune_Interact_Rock.LuaObjectScript.Disable()
end
function StartSpeedControl()
  GameObjects.EntZn_NoTalking_SpeedControl:ShowEntityVolume()
end
function StopSpeedControl()
  GameObjects.EntZn_NoTalking_SpeedControl:HideEntityVolume()
end
function OnEvaluateLoadGroup_Cinematic()
  if game.Level.GetVariable("CompletedCineNumber") < 160 then
    return "WitchHouseA"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 160 and game.Level.GetVariable("CompletedCineNumber") < 165 then
    return "WitchHouseB"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 320 and game.Level.GetVariable("CompletedCineNumber") < 331 then
    return "HeadEnchant"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 365 and game.Level.GetVariable("CompletedCineNumber") < 371 then
    return "FreyaTendsSon"
  else
    return "SonHealed"
  end
end
function EnableInvisInkCA()
  GameObjects.InvisibleInk_Totem_Well:FindSingleGOByName("SonInkObserve").LuaObjectScript.Enable()
end
function SoundOnStart()
  GameObjects.InvisibleInk_Totem_Well:FindSingleGOByName("pSonReadRune").LuaObjectScript.LoreMarkerRuneReadSoundSetup()
  GameObjects.SonReadRune1:FindSingleGOByName("pSonReadRune").LuaObjectScript.WallRuneReadSoundSetup()
  GameObjects.SonRuneRead2:FindSingleGOByName("pSonReadRune").LuaObjectScript.WallRuneReadSoundSetup()
  GameObjects.Rune_Interact_Success.LuaObjectScript.Disable()
end
function riv475OutOfTheWellMusic()
  game.Audio.StartCheckpointedMusic("SND_MX_RIV2_explore2_in")
end
function EnableBoarCarryAwarenessZones()
  local son = game.AI.FindSon()
  if son then
    son:CallScript("LuaHook_HeadTrack_DeprioritizeFriendlyAI")
  end
  GameObjects.AwarenessZone_LookAround1.LuaObjectScript.EnableEventEmitter()
  GameObjects.AwarenessZone_LookAround2.LuaObjectScript.EnableEventEmitter()
  GameObjects.AwarenessZone_LookAround3.LuaObjectScript.EnableEventEmitter()
  GameObjects.AwarenessZone_LookAround4.LuaObjectScript.EnableEventEmitter()
  GameObjects.AwarenessZone_LookAround5.LuaObjectScript.EnableEventEmitter()
end
function DisableAwarenessZone1()
  GameObjects.AwarenessZone_LookAround1.LuaObjectScript.DisableEventEmitter()
end
function DisableAwarenessZone2()
  GameObjects.AwarenessZone_LookAround2.LuaObjectScript.DisableEventEmitter()
end
function DisableAwarenessZone3()
  GameObjects.AwarenessZone_LookAround3.LuaObjectScript.DisableEventEmitter()
end
function DisableAwarenessZone4()
  GameObjects.AwarenessZone_LookAround4.LuaObjectScript.DisableEventEmitter()
end
function DisableBoarCarryAwarenessZones()
  local son = game.AI.FindSon()
  if son then
    son:CallScript("LuaHook_HeadTrack_PrioritizeFriendlyAI")
  end
  GameObjects.AwarenessZone_LookAround1.LuaObjectScript.DisableEventEmitter()
  GameObjects.AwarenessZone_LookAround2.LuaObjectScript.DisableEventEmitter()
  GameObjects.AwarenessZone_LookAround3.LuaObjectScript.DisableEventEmitter()
  GameObjects.AwarenessZone_LookAround4.LuaObjectScript.DisableEventEmitter()
  GameObjects.AwarenessZone_LookAround5.LuaObjectScript.DisableEventEmitter()
end
