local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local EC = require("design.Encounter")
local thisLevel, Area_1_Encounter_1, Area_1_Encounter_2, Area_2_Encounter_1, Area_2_Encounter_2, Area_3_Encounter_1
function OnScriptLoaded(level, obj)
  thisLevel = level
  Arena_1_Fight_1()
  Arena_2_Fight_1()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
end
function OnStart(level, obj)
end
function Arena_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Arena 1]EC:1 -Well Riv475", {CheckpointOnComplete = false})
  Area_1_Encounter_1:AddWave({
    {
      spawners = "SH_Draugr_L_SFG",
      spawnLocators = "A1_O_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 3
    },
    {
      spawners = "SH_Draugr_L_SFG",
      spawnLocators = "A1_O_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8,
      powerLevel = 2
    }
  })
  Area_1_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "S_Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 1,
      powerLevel = 3
    },
    {
      spawners = "S_Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 3,
      powerLevel = 2
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.AttackZone_Well)
  Area_1_Encounter_1:OnStart(function()
    game.Compass.SetDesignerForcedHide(true)
    local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
    if riv475 ~= nil then
      riv475:CallScript("RemoveTurtleAwarenessZone")
    end
  end)
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(2)
  end, {count = 1})
  Area_1_Encounter_1:OnEnemySpawn(function(enemy)
    timers.StartLevelTimer(0.03, function()
      enemy:ForceMove("BRA_SetDropHealthFlag_On")
    end)
  end, {wave = 1})
  Area_1_Encounter_1:OnComplete(function()
    game.Compass.SetDesignerForcedHide(false)
    local riv480 = game.FindLevel("Riv480_FreyaHouse")
    if riv480 ~= nil then
      riv480:CallScript("CreatureResumeStandIdle")
      riv480:CallScript("Riv475AI_FightComplete")
    end
    local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
    if riv475 ~= nil then
      riv475:CallScript("RemoveTurtleAwarenessZone")
      riv475:CallScript("CA_Area_Enable")
    end
  end)
end
function Arena_1_Fight_2()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Arena 1]EC:2 Repopulation Riv475", {
    CheckpointOnComplete = true,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Arena 1]EC:1 -Well Riv475"
    }
  })
  Area_1_Encounter_2:AddWave({
    timeBetweenWaves = 5,
    {
      spawners = "H_Draugr_L_SFG",
      spawnLocators = "A4_Loc_B",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 3
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A4_Loc_B",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8,
      powerLevel = 3
    }
  })
  Area_1_Encounter_2:SetStartZone(GameObjects.AttackZone_Well)
  Area_1_Encounter_2:OnStart(function()
  end)
  Area_1_Encounter_2:OnComplete(function()
  end)
end
function Arena_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Arena 2]EC:1 -Well Riv475", {CheckpointOnComplete = true})
  Area_2_Encounter_1:AddWave({
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A2_O_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 3
    },
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A2_O_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8,
      powerLevel = 3
    }
  })
  Area_2_Encounter_1:SetStartZone(GameObjects.SpawnZone_TripleChest)
  Area_2_Encounter_1:OnStart(function()
  end)
  Area_1_Encounter_1:OnComplete(function()
  end)
end
function Arena_2_Fight_2()
  Area_2_Encounter_2 = EC.NewEncounter(thisLevel, "[Arena 2]EC:2 Repopulation Riv475", {
    CheckpointOnComplete = true,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Arena 2]EC:1 -Well Riv475"
    }
  })
  Area_2_Encounter_2:AddWave({
    timeBetweenWaves = 5,
    {
      spawners = "H_Draugr_L_SFG",
      spawnLocators = "A2_O_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 3
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A2_O_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8,
      powerLevel = 3
    }
  })
  Area_2_Encounter_2:SetStartZone(GameObjects.SpawnZone_TripleChest)
  Area_2_Encounter_2:OnStart(function()
  end)
  Area_1_Encounter_2:OnComplete(function()
  end)
end
function Arena_3_Fight_1()
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Arena 2]EC:2 --- Riv475", {CheckpointOnComplete = true})
  Area_3_Encounter_1:AddWave({
    timeBetweenWaves = 5,
    {
      spawners = "H_Draugr_L_SFG",
      spawnLocators = "A3_O_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 3
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A3_O_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8,
      powerLevel = 3
    }
  })
  Area_3_Encounter_1:SetStartZone(GameObjects.SpawnZone_Pathway)
  Area_3_Encounter_1:OnStart(function()
  end)
  Area_3_Encounter_1:OnComplete(function()
  end)
end
