local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local timers = require("level.timer")
local TUT = require("game.GlobalTutorials")
local uiCalls = require("ui.uicalls")
local LM = require("level.loadmonitor")
local thisLevel, thisObj, son, player, kratosActor, sonActor, freyaActor, boarActor, pad, largeBowl_WitchHouseA, largeSpoon_WitchHouseA, smallVial_WitchHouseA, tallCup1_WitchHouseA, tallCup2_WitchHouseA, largeSpoon_WitchHouseB, smallBowl_WitchHouseB, lambsCress_WitchHouseB, rootFragment_WitchHouseB, tallCup_HeadEnchant_A, tallCup_HeadEnchant_B, tallCup_HeadEnchant_C, smallVial_HeadEnchant, largeBowl_HeadEnchant, grubs_HeadEnchant, hangingHerbs_HeadEnchant, largeSpoon_HeadEnchant, smallBowl_HeadEnchant, freyaTable_FreyaTendsSon, largeSpoon_SonHealed, largeBowl_SonHealed, tallCup_SonHealed, smallBowl_SonHealed, pillow1_SonHealed, pillow2_SonHealed, pillow3_SonHealed, pillow4_SonHealed, trollHeart_SonHealed, preCineCam_WitchHouseA, preCineCam_WitchHouseB, preCineCam_HeadEnchant, preCineCam_SonHealed, cineEnter_CompassTut, cineEnterCamera_FreyaTendsSon, witchHouseA_Lights, witchHouseB_Lights, headEnchant_Lights, freyaTendsSon_Lights, sonHealed_Lights
local witchHouseA_Props = {}
local witchHouseB_props = {}
local headEnchant_Props = {}
local sonHealed_Props = {}
local freyaTendsSon_Props = {}
local freyaFrontDoor, freyaBackDoor
local justSpawnedFreya = false
local justEnteredHouse = false
local playerLeftHouse = false
local acquiredLambscress = false
local freyaIsTalking = false
local freyaInterrupted = false
local replayCannotTrustHer, lambscressTimer, turtleBoarVanaTimer
reminderSeq = nil
postSonHealedSeq = nil
local banterPlayed = {}
local resumeInputMaskOnRestart
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  pad = player.Pad
  InitializeVariables()
end
function OnFirstStart()
  HideVanaheimWindow()
end
function OnStart(level, obj)
  HideAllProps()
  CreateActors()
  freyaFrontDoor:HideNavObstacle()
  GameObjects.WindowBlocker:Hide()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 160 then
    SpawnFreyaIfDoesntExist()
  else
    GameObjects.TVRiv480_Cine160:Hide()
  end
  SceneSelectionLogic()
  if cineNum == 330 and replayCannotTrustHer then
    PostMimirRevivedRestart()
  end
  freyaBackDoor.LuaObjectScript.ExcludeSon()
  game.SubObject.Sleep(obj)
end
function OnUpdate(level, obj)
  if preCineCam_WitchHouseA ~= nil then
    preCineCam_WitchHouseA:Update()
  end
  if preCineCam_WitchHouseB ~= nil then
    preCineCam_WitchHouseB:Update()
  end
  if preCineCam_HeadEnchant ~= nil then
    preCineCam_HeadEnchant:Update()
  end
  if preCineCam_SonHealed ~= nil then
    preCineCam_SonHealed:Update()
  end
  if cineEnterCamera_FreyaTendsSon ~= nil then
    cineEnterCamera_FreyaTendsSon:Update()
  end
  if cineEnter_CompassTut ~= nil then
    cineEnter_CompassTut:Update()
  end
end
function RunFunctionOnObjectsInTable(obj_table, func_name, ...)
  for _, each_obj in ipairs(obj_table) do
    each_obj[func_name](each_obj, ...)
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  savedInfo.resumeInputMaskOnRestart = resumeInputMaskOnRestart
  savedInfo.replayCannotTrustHer = replayCannotTrustHer
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  resumeInputMaskOnRestart = savedInfo.resumeInputMaskOnRestart
  replayCannotTrustHer = savedInfo.replayCannotTrustHer
  if savedInfo.banterPlayed ~= nil then
    banterPlayed = savedInfo.banterPlayed
  end
  if resumeInputMaskOnRestart then
    SetInputMask()
  end
end
function InitializeVariables()
  largeBowl_WitchHouseA = GameObjects.largeBowl_WitchHouseA.Child
  largeSpoon_WitchHouseA = GameObjects.largeSpoon_WitchHouseA.Child
  smallVial_WitchHouseA = GameObjects.smallVial_WitchHouseA.Child
  tallCup1_WitchHouseA = GameObjects.tallCup1_WitchHouseA.Child
  tallCup2_WitchHouseA = GameObjects.tallCup2_WitchHouseA.Child
  largeSpoon_WitchHouseB = GameObjects.largeSpoon_WitchHouseB.Child
  smallBowl_WitchHouseB = GameObjects.smallBowl_WitchHouseB.Child
  lambsCress_WitchHouseB = GameObjects.lambsCress_WitchHouseB.Child
  rootFragment_WitchHouseB = GameObjects.rootFragment_WitchHouseB.Child
  tallCup_HeadEnchant_A = GameObjects.tallCup_HeadEnchant_A.Child
  tallCup_HeadEnchant_B = GameObjects.tallCup_HeadEnchant_B.Child
  tallCup_HeadEnchant_C = GameObjects.tallCup_HeadEnchant_C.Child
  smallVial_HeadEnchant = GameObjects.smallVial_HeadEnchant.Child
  largeBowl_HeadEnchant = GameObjects.largeBowl_HeadEnchant.Child
  grubs_HeadEnchant = GameObjects.grubs_HeadEnchant.Child
  hangingHerbs_HeadEnchant = GameObjects.hangingHerbs_HeadEnchant.Child
  largeSpoon_HeadEnchant = GameObjects.largeSpoon_HeadEnchant.Child
  smallBowl_HeadEnchant = GameObjects.smallBowl_HeadEnchant.Child
  freyaTable_FreyaTendsSon = GameObjects.freyaTable_FreyaTendsSon.Child
  largeSpoon_SonHealed = GameObjects.largeSpoon_SonHealed.Child
  largeBowl_SonHealed = GameObjects.largeBowl_SonHealed.Child
  tallCup_SonHealed = GameObjects.tallCup_SonHealed.Child
  smallBowl_SonHealed = GameObjects.smallBowl_SonHealed.Child
  pillow1_SonHealed = GameObjects.pillow1_SonHealed.Child
  pillow2_SonHealed = GameObjects.pillow2_SonHealed.Child
  pillow3_SonHealed = GameObjects.pillow3_SonHealed.Child
  pillow4_SonHealed = GameObjects.pillow4_SonHealed.Child
  trollHeart_SonHealed = GameObjects.trollHearth_SonHealed.Child
  freyaFrontDoor = GameObjects.FreyaHouseDoorFront.Child
  freyaBackDoor = GameObjects.FreyaHouseDoorBack.Child
  witchHouseA_Lights = GameObjects.Cine_Start_160
  witchHouseB_Lights = GameObjects.Cine_Start_165
  headEnchant_Lights = GameObjects.Cine_Start_330
  freyaTendsSon_Lights = GameObjects.Cine_Start_370
  sonHealed_Lights = GameObjects.Cine_Start_390
  witchHouseA_Props = {
    largeBowl_WitchHouseA,
    largeSpoon_WitchHouseA,
    smallVial_WitchHouseA,
    tallCup1_WitchHouseA,
    tallCup2_WitchHouseA
  }
  witchHouseB_props = {
    largeSpoon_WitchHouseB,
    smallBowl_WitchHouseB,
    lambsCress_WitchHouseB,
    rootFragment_WitchHouseB
  }
  headEnchant_Props = {
    tallCup_HeadEnchant_A,
    tallCup_HeadEnchant_B,
    tallCup_HeadEnchant_C,
    smallVial_HeadEnchant,
    largeBowl_HeadEnchant,
    grubs_HeadEnchant,
    hangingHerbs_HeadEnchant,
    smallBowl_HeadEnchant,
    largeSpoon_HeadEnchant
  }
  freyaTendsSon_Props = {freyaTable_FreyaTendsSon}
  sonHealed_Props = {
    largeBowl_SonHealed,
    largeSpoon_SonHealed,
    tallCup_SonHealed,
    smallBowl_SonHealed,
    pillow1_SonHealed,
    pillow2_SonHealed,
    pillow3_SonHealed,
    pillow4_SonHealed,
    trollHeart_SonHealed
  }
end
function InitProps_WitchHouseA()
  largeBowl_WitchHouseA:StartAnim("narRivWitchHouseA010CineEnter")
  largeSpoon_WitchHouseA:StartAnim("narRivWitchHouseA010CineEnter")
  smallVial_WitchHouseA:StartAnim("narRivWitchHouseA010CineEnter")
  tallCup1_WitchHouseA:StartAnim("narRivWitchHouseA010CineEnter")
  tallCup2_WitchHouseA:StartAnim("narRivWitchHouseA010CineEnter1")
  ResetProps_WitchHouseA()
end
function InitProps_WitchHouseB()
  RunFunctionOnObjectsInTable(witchHouseB_props, "StartAnim", "narRivWhitchHouseB000CineScene")
  ResetProps_WitchHouseB()
end
function InitProps_HeadEnchant()
  tallCup_HeadEnchant_A:StartAnim("narRivHeadEnchant020CineScene")
  tallCup_HeadEnchant_B:StartAnim("narRivHeadEnchant020CineScene1")
  tallCup_HeadEnchant_C:StartAnim("narRivHeadEnchant020CineScene2")
  smallVial_HeadEnchant:StartAnim("narRivHeadEnchant020CineScene")
  largeBowl_HeadEnchant:StartAnim("narRivHeadEnchant020CineScene")
  grubs_HeadEnchant:StartAnim("narRivHeadEnchant020CineScene")
  hangingHerbs_HeadEnchant:StartAnim("narRivHeadEnchant020CineScene")
  smallBowl_HeadEnchant:StartAnim("narRivHeadEnchant020CineScene")
  largeSpoon_HeadEnchant:StartAnim("narRivHeadEnchant020CineScene")
  ResetProps_HeadEnchant()
end
function InitProps_FreyaTendsSon()
  freyaTable_FreyaTendsSon:StartAnim("narRivFreyaTendsSon000CineScene")
  ResetProps_FreyaTendsSon()
end
function InitProps_SonHealed()
  largeBowl_SonHealed:StartAnim("narRivSonHealed030CineIdle")
  largeSpoon_SonHealed:StartAnim("narRivSonHealed030CineIdle")
  tallCup_SonHealed:StartAnim("narRivSonHealed030CineIdle")
  smallBowl_SonHealed:StartAnim("narRivSonHealed020CineScene")
  pillow1_SonHealed:StartAnim("narRivSonHealed020CineScene")
  pillow2_SonHealed:StartAnim("narRivSonHealed020CineScene1")
  pillow3_SonHealed:StartAnim("narRivSonHealed020CineScene2")
  pillow4_SonHealed:StartAnim("narRivSonHealed020CineScene3")
  ResetProps_SonHealed()
end
function InitializeAllProps()
  InitProps_WitchHouseA()
  InitProps_WitchHouseB()
  InitProps_HeadEnchant()
  InitProps_FreyaTendsSon()
  InitProps_SonHealed()
end
function ResetProps_WitchHouseA()
  RunFunctionOnObjectsInTable(witchHouseA_Props, "JumpAnimToFrame", 0)
  RunFunctionOnObjectsInTable(witchHouseA_Props, "PauseAnim")
  witchHouseA_Lights:JumpAnimToFrame(0)
  witchHouseA_Lights:PauseAnim()
end
function ResetProps_WitchHouseB()
  RunFunctionOnObjectsInTable(witchHouseB_props, "JumpAnimToFrame", 0)
  RunFunctionOnObjectsInTable(witchHouseB_props, "PauseAnim")
  witchHouseB_Lights:JumpAnimToFrame(0)
  witchHouseB_Lights:PauseAnim()
end
function ResetProps_HeadEnchant()
  RunFunctionOnObjectsInTable(headEnchant_Props, "JumpAnimToFrame", 0)
  RunFunctionOnObjectsInTable(headEnchant_Props, "PauseAnim")
  headEnchant_Lights:JumpAnimToFrame(0)
  headEnchant_Lights:PauseAnim()
end
function ResetProps_FreyaTendsSon()
  RunFunctionOnObjectsInTable(freyaTendsSon_Props, "JumpAnimToFrame", 0)
  RunFunctionOnObjectsInTable(freyaTendsSon_Props, "PauseAnim")
  freyaTendsSon_Lights:JumpAnimToFrame(0)
  freyaTendsSon_Lights:PauseAnim()
end
function ResetProps_SonHealed()
  RunFunctionOnObjectsInTable(sonHealed_Props, "JumpAnimToFrame", 0)
  RunFunctionOnObjectsInTable(sonHealed_Props, "PauseAnim")
  sonHealed_Lights:JumpAnimToFrame(0)
  sonHealed_Lights:PauseAnim()
end
function HideAllProps()
  RunFunctionOnObjectsInTable(witchHouseA_Props, "Hide")
  RunFunctionOnObjectsInTable(witchHouseB_props, "Hide")
  RunFunctionOnObjectsInTable(headEnchant_Props, "Hide")
  RunFunctionOnObjectsInTable(freyaTendsSon_Props, "Hide")
  RunFunctionOnObjectsInTable(sonHealed_Props, "Hide")
  witchHouseA_Lights:Hide()
  witchHouseB_Lights:Hide()
  headEnchant_Lights:Hide()
  freyaTendsSon_Lights:Hide()
  sonHealed_Lights:Hide()
end
function ShowProps_WitchHouseA()
  RunFunctionOnObjectsInTable(witchHouseA_Props, "Show")
  witchHouseA_Lights:Show()
end
function ShowProps_WitchHouseB()
  RunFunctionOnObjectsInTable(witchHouseB_props, "Show")
  witchHouseB_Lights:Show()
end
function ShowProps_HeadEnchant()
  RunFunctionOnObjectsInTable(headEnchant_Props, "Show")
  headEnchant_Lights:Show()
end
function ShowProps_FreyaTendsSon()
  RunFunctionOnObjectsInTable(freyaTendsSon_Props, "Show")
  freyaTendsSon_Lights:Show()
end
function ShowProps_SonHealed()
  RunFunctionOnObjectsInTable(sonHealed_Props, "Show")
  sonHealed_Lights:Show()
end
function SetupPostCineProps_SonHealed()
  ShowProps_SonHealed()
  local sonHealed_PropTable = {
    {
      Obj = smallBowl_SonHealed,
      Anim = "narRivSonHealed020CineScene"
    },
    {
      Obj = pillow1_SonHealed,
      Anim = "narRivSonHealed020CineScene"
    },
    {
      Obj = pillow2_SonHealed,
      Anim = "narRivSonHealed020CineScene1"
    },
    {
      Obj = pillow3_SonHealed,
      Anim = "narRivSonHealed020CineScene2"
    },
    {
      Obj = pillow4_SonHealed,
      Anim = "narRivSonHealed020CineScene3"
    },
    {
      Obj = trollHeart_SonHealed,
      Anim = "narRivSonHealed020CineScene"
    }
  }
  for _, prop in ipairs(sonHealed_PropTable) do
    prop.Obj:PlayAnimationToEnd({
      Animation = prop.Anim
    })
    prop.Obj:JumpAnimationToFrame(prop.Obj.AnimLengthFrames)
  end
end
function CreateActors()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  freyaActor = actor.Actor.New("Freya", ND.FindFreya)
  if game.Level.GetVariable("CompletedCineNumber") < 180 then
    boarActor = actor.Actor.New("Boar", FindBoar)
  end
end
function SpawnFreyaIfDoesntExist()
  if LD.FindFreya() == nil then
    local spawnPosVector = LD.GetWorldJointPosition("Cine_WitchHouseB", "FreyaEnd")
    local spawnDirVector = LD.GetWorldJointForward("Cine_WitchHouseB", "FreyaEnd")
    local seq = ND.CreateCineSequence(thisLevel, thisLevel, "SPAWN FREYA FROM RIV480")
    seq:WaitForFunctionTrue(function()
      return game.FindLevel("FreyaLvl100_Global")
    end)
    seq:Do(function()
      ND.SpawnFreyaAtVector(spawnPosVector, spawnDirVector)
    end)
    seq:StartSequence()
    justSpawnedFreya = true
  end
end
function SpawnBoarIfDoesntExit()
  if not DoesBoarExist() then
    game.FindLevel("Riv470_FreyaPath"):GetGameObject("CineSupport_BoarSpawn"):CallScript("StartSpawnBoar")
  end
end
function DoesFreyaExist()
  local freyaAiObject
  freyaAiObject = ND.CatchFreyaReference(freyaAiObject)
  if freyaAiObject ~= nil then
    return true
  else
    return false
  end
end
function FindBoar()
  local boarReference
  local objArray = game.World.FindGameObjectsByMarker("WitchHouseBoar")
  if 1 < #objArray then
    error("Warning: there are multiple boars, getting reference will be unpredictable.")
    return boarReference
  else
    for _, obj in ipairs(objArray) do
      if obj:GetCreature() ~= nil and obj:GetCreature():GetAI() ~= nil then
        boarReference = obj:GetCreature():GetAI()
      end
    end
    return boarReference
  end
end
function DoesBoarExist()
  local boarVariable = FindBoar()
  if boarVariable ~= nil then
    return true
  else
    return false
  end
end
function SceneSelectionLogic()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if thisLevel.Name == "WAD_Riv480_FreyaHouse" then
    if cineNum < 160 then
      print("----------------------------------------Setting up WitchHouseA")
      BuildWitchHouseASequence()
      if justSpawnedFreya then
        ApproachPathWarpAndEnable()
      end
    elseif 160 <= cineNum and cineNum < 163 then
      FreyaAndBoarIdles_PostWitchHouseA()
      SonIdle_PostWitchHouseA()
      lambscressTimer = timers.StartLevelTimer(15, BuildNeedLambscressSequence)
    elseif 163 <= cineNum and cineNum < 165 then
      FreyaAndBoarIdles_PostWitchHouseA()
    elseif 370 <= cineNum and cineNum < 375 then
      FreyaAndSonIdles_PostFreyaTendsSon()
    elseif 390 <= cineNum and cineNum < 470 then
      FreyaIdles_PostSonHealed()
    elseif justSpawnedFreya then
      FreyaFailsafe_WitchHouseAIdle()
    end
    if cineNum < 160 or 165 <= cineNum and cineNum < 180 or 320 <= cineNum and cineNum < 330 or cineNum == 369 or 387 <= cineNum and cineNum < 470 then
      EnableFrontDoorPrompt()
    elseif 160 <= cineNum and cineNum < 165 or 330 <= cineNum and cineNum < 365 or 370 <= cineNum and cineNum < 375 or 470 <= cineNum then
      DisableFrontDoorPrompt()
    end
    if cineNum < 165 or 370 <= cineNum and cineNum < 375 then
      EnableBackDoorPrompt()
    elseif 165 <= cineNum and cineNum < 180 or 387 <= cineNum then
      DisableBackDoorPrompt()
    end
    if cineNum == 369 then
      GameObjects.CineZone_FreyaTendsSon:Show()
    else
      GameObjects.CineZone_FreyaTendsSon:Hide()
    end
  end
end
function FreyaFailsafe_WitchHouseAIdle()
  local seq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_WitchHouseA, "DEBUG/TESTING FREYA HOUSE IDLE")
  seq:SetPostSkipMusic("SND_MX_RIV_start_master", "SND_MX_SonSick_master")
  seq:WaitForFunctionTrue(DoesFreyaExist)
  seq:WaitForFunctionTrue(function()
    return game.FindLevel("Riv480_c160_WitchHouseA")
  end)
  seq:WaitForFunctionTrue(function()
    return game.FindLevel("Riv475_FreyaHouseExt")
  end)
  seq:Do(DisableBothLeadTheWay)
  seq:ActorSync(freyaActor, {
    Branch = "BRA_WitchHouseAEndIdle",
    ReferenceJoint = "Cine_WitchHouseA_SyncJoint"
  })
  seq:WaitForActorPuppeteerComplete(freyaActor)
  seq:StopPuppetingActor(freyaActor)
  seq:StartSequence()
end
function ApproachPathWarpAndEnable()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "DEBUG/TESTING FREYA LTW PATH")
  seq:WaitForFunctionTrue(DoesFreyaExist)
  seq:WaitForFunctionTrue(function()
    return game.FindLevel("Riv475_FreyaHouseExt")
  end)
  seq:Do(function()
    game.FindLevel("Riv475_FreyaHouseExt"):CallScript("Riv475_LeadTheWay_StartMidPathDebug")
  end)
  seq:StartSequence()
end
function OnFrontDoorEnter()
  ShowVanaheimWindow()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  print("---------------- through frunt door--------- and cine number is: ", cineNum)
  if 165 <= cineNum and cineNum < 180 then
    BuildFreyaTendsBoarSequence()
  elseif 330 <= cineNum and cineNum < 360 then
    BuildGoAwaySequence()
  elseif 320 <= cineNum and cineNum < 330 then
    BuildHeadEnchantSequence()
  elseif 387 <= cineNum and cineNum < 390 then
    BuildSonHealedSequence()
  end
  PlayerEnterDoors()
  SetInputMask()
end
function OnBackDoorExit()
  HideVanaheimWindow()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 160 <= cineNum and cineNum < 163 then
    print("the player is exiting through the back door, between witchHouseA and knifeReturn")
    playerLeftHouse = true
    EnableSelectInputs()
    FreyaAndBoarIdles_PostWitchHouseA()
    if lambscressTimer ~= nil then
      lambscressTimer:Stop()
      lambscressTimer = nil
    end
    if reminderSeq ~= nil then
      reminderSeq:Complete()
      reminderSeq = nil
    end
  else
    print("the player is exiting through the back door, NOT between witchHouseA and knifeReturn")
  end
  if cineNum == 160 then
    return
  else
    ClearInputMask()
  end
  if cineNum == 370 then
    local monitor = LM.CreateLoadMonitor()
    monitor:AddCallback({
      Wads = {
        "Riv475_FreyaHouseExt"
      },
      Functions = {
        TurtleStandColOn
      }
    })
  end
end
function TurtleStandColOn(wads)
  wads.Riv475_FreyaHouseExt:CallScript("ShowTurtleStandCollision")
end
function OnFrontDoorExit()
  DisableHouseCA()
  HideVanaheimWindow()
  ClearInputMask()
  CA_Cave_Enable()
  GameObjects.CA_SyncExitHouse.LuaObjectScript.Enable()
  if turtleBoarVanaTimer ~= nil then
    turtleBoarVanaTimer:Stop()
    turtleBoarVanaTimer = nil
  end
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 165 <= cineNum and cineNum < 180 then
    print("the player is exiting through the front door, between witchHouseB and SnakeIntro")
    if freyaIsTalking then
      freyaInterrupted = true
      game.Audio.PlayBanter("RIV_PostHeal_Interrupt")
      freyaIsTalking = false
    else
      game.Audio.PlayBanter("RIV_WhatsWithTheTurtleB")
    end
  elseif 390 <= cineNum then
    print("the player is exiting through the front door, after SonHealed")
    if postSonHealedSeq ~= nil then
      CancelPostHeal()
    end
    if freyaIsTalking then
      freyaInterrupted = true
      game.Audio.PlayBanter("RIV_PostHeal_Interrupt")
      freyaIsTalking = false
    elseif 400 <= cineNum and cineNum < 470 then
      game.Audio.PlayBanter("RIV_WhatsWithTheTurtleB")
    end
  end
end
function FrontDoorInteractionFinish()
  local monitor = LM.CreateLoadMonitor()
  monitor:AddCallback({
    Wads = {
      "Riv925_FreyaCave"
    },
    Functions = {
      InteractFinishLoadCheck
    }
  })
end
function InteractFinishLoadCheck(wads)
  game.FindLevel("Riv925_FreyaCave"):CallScript("Riv925_FDInteractionFinish")
end
function OnBackDoorEnter()
  ShowVanaheimWindow()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 163 <= cineNum and cineNum < 165 then
    print("<<<<<<------------- backdoor opens, yeilds WitchHouseB")
    BuildWitchHouseBSequence()
  elseif 160 <= cineNum and cineNum < 163 then
    print("<<<<<<------------- backdoor opens, yeilds NeedBothFlowers")
    BuildNeedBothFlowersSequence()
  elseif 370 <= cineNum and cineNum < 375 then
    IWillKeepHimSafe_Banter()
    game.FindLevel("Riv475_FreyaHouseExt"):CallScript("HideTurtleCollision")
  else
    print("<<<<<<------------- backdoor opens, normal behavior")
  end
  PlayerEnterDoors()
  SetInputMask()
end
function PlayerEnterDoors()
  justEnteredHouse = true
  TurtleBoarVanaheimLogic()
end
function ShowVanaheimWindow()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "showVanaWindow")
  seq:WaitForFunctionTrue(function()
    return player.GroundLevel ~= nil and player.GroundLevel.Name == "WAD_Riv480_FreyaHouse"
  end)
  seq:Do(function()
    print("ShowVanaheimWindow")
    GameObjects.vanaheim_windowRef:Show()
  end)
  seq:StartSequence()
end
function HideVanaheimWindow()
  GameObjects.vanaheim_windowRef:Hide()
end
function BuildWitchHouseASequence()
  local witchHouseASeq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_WitchHouseA, "witchHouseA")
  local witchHouseAFreyaSeq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_WitchHouseA, "witchHouseAFreyaApproach")
  local boarFreakOut_ActorTable = {
    {Actor = boarActor},
    {Actor = freyaActor}
  }
  witchHouseASeq:Do(SpawnFreyaIfDoesntExist)
  witchHouseASeq:WaitForFunctionTrue(DoesFreyaExist)
  witchHouseASeq:WaitForFunctionTrue(function()
    return game.FindLevel("Riv480_c160_WitchHouseA")
  end)
  witchHouseASeq:WaitForActorInZone(freyaActor, GameObjects.Cine_WitchHouse_EntryWay)
  witchHouseASeq:Do(DisableFreyaLeadTheWay)
  witchHouseASeq:Do(SetInputMask)
  witchHouseASeq:BranchSequence(witchHouseAFreyaSeq)
  witchHouseAFreyaSeq:ActorForceApproachAndWait(freyaActor, {
    Branch = "BRA_BoarFreakOut_Enter",
    ReferenceJoint = "Cine_WitchHouseA_SyncJoint",
    speed = 1.6,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius
  })
  witchHouseAFreyaSeq:ActorSync(freyaActor, {
    Branch = "BRA_BoarFreakOut_Enter",
    ReferenceJoint = "Cine_WitchHouseA_SyncJoint"
  })
  witchHouseAFreyaSeq:Do(OpenFreyaFrontDoor)
  witchHouseASeq:WaitForActorInZone(kratosActor, GameObjects.Cine_WitchHouse_EntryWay_Kratos)
  witchHouseASeq:RequestCineModeAndWait(kratosActor, GameObjects.Cine_WitchHouseA)
  witchHouseASeq:Do(function()
    player:ClearMaxSpeedOverride()
  end)
  witchHouseASeq:Do(StartCineEnter_PreBoarFreakout)
  witchHouseASeq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_WitchHouseACineEnter",
    ReferenceJoint = "Cine_WitchHouseA_SyncJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = 0.2,
    weapon_state = "sheathed",
    strafe_distance = 3
  })
  witchHouseASeq:ActorSync(kratosActor, {
    Slaves = boarFreakOut_ActorTable,
    Branch = "BRA_WitchHouseACineEnter",
    ReferenceJoint = "Cine_WitchHouseA_SyncJoint"
  })
  witchHouseASeq:Do(ShowProps_WitchHouseA)
  witchHouseASeq:Do(InitProps_WitchHouseA)
  witchHouseASeq:WaitForActorPlayingMove(kratosActor, "MOV_WitchHouseACineEnter")
  witchHouseASeq:Do(function()
    witchHouseASeq:MarkAbleToSkip()
  end)
  witchHouseASeq:WaitUntilActorAnimPastFrame(kratosActor, 216)
  witchHouseASeq:Do(function()
    witchHouseA_Lights:PlayAnimationToEnd()
  end)
  witchHouseASeq:WaitForAndCompleteCineMode(kratosActor, GameObjects.Cine_WitchHouseA)
  witchHouseASeq:Do(function()
    witchHouseA_Lights:Hide()
  end)
  witchHouseASeq:StopPuppetingActor(kratosActor)
  witchHouseASeq:StopPuppetingActor(freyaActor)
  witchHouseASeq:StopPuppetingActor(sonActor)
  witchHouseASeq:StopPuppetingActor(boarActor)
  witchHouseASeq:Do(CloseFreyaFrontDoor)
  witchHouseASeq:Do(CompleteQuestObj455)
  witchHouseASeq:SetCompletedCineNumber(160)
  witchHouseASeq:Do(DisableFrontDoorPrompt)
  witchHouseASeq:Do(DisableBothLeadTheWay)
  witchHouseASeq:Do(EnableSelectInputs)
  witchHouseASeq:Do(SaveInputMask)
  witchHouseASeq:Do(Cine_Collision)
  witchHouseASeq:Do(function()
    GameObjects.TVRiv480_Cine160:Hide()
  end)
  witchHouseASeq:Do(function()
    GameObjects.BoarCollision:ShowCollision()
  end)
  witchHouseASeq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "02_RiverPass_039_WitchHouseA"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  witchHouseASeq:Do(FreyaAndBoarIdles_PostWitchHouseA)
  witchHouseASeq:Do(function()
    lambscressTimer = timers.StartLevelTimer(15, BuildNeedLambscressSequence)
  end)
  witchHouseASeq:StartSequence()
end
function CompleteQuestObj455()
  game.QuestManager.ProposeQuestState("Quest_RiverPass_Objective455", "Complete")
end
function EnableSelectInputs()
  local pad = player.Pad
  pad:EnableGameButton(tweaks.ePad.kPadSquare)
end
function FreyaAndBoarIdles_PostWitchHouseA()
  local seq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_WitchHouseA, "witchHouseA_FreyaEndIdle")
  local actorTable = {
    {Actor = boarActor},
    {
      Obj = tallCup1_WitchHouseA,
      Anim = "narRivWitchHouseA040IntFreyaIdle"
    },
    {
      Obj = smallVial_WitchHouseA,
      Anim = "narRivWitchHouseA040IntFreyaIdle"
    },
    {
      Obj = largeSpoon_WitchHouseA,
      Anim = "narRivWitchHouseA040IntFreyaIdle"
    },
    {
      Obj = largeBowl_WitchHouseA,
      Anim = "narRivWitchHouseA040IntFreyaIdle"
    }
  }
  seq:WaitForLoadCheck("FreyaLvl100_Global")
  seq:WaitForLoadCheck("Riv470_FreyaPath")
  seq:Do(SpawnFreyaIfDoesntExist)
  seq:Do(SpawnBoarIfDoesntExit)
  seq:WaitForFunctionTrue(DoesFreyaExist)
  seq:WaitForFunctionTrue(DoesBoarExist)
  seq:WaitForFunctionTrue(function()
    return game.FindLevel("Riv480_c160_WitchHouseA")
  end)
  seq:Do(WitchHouseA_StopProps)
  seq:ActorSync(freyaActor, {
    Slaves = actorTable,
    Branch = "BRA_WitchHouseAEndIdle",
    ReferenceJoint = "Cine_WitchHouseA_SyncJoint"
  })
  seq:StartSequence()
end
function SonIdle_PostWitchHouseA()
  local seq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_WitchHouseA_SonPostIdle, "witchHouseA_SonEndIdle")
  seq:WaitForFunctionTrue(function()
    return game.FindLevel("Riv480_c160_WitchHouseA")
  end)
  seq:ActorSync(sonActor, {
    Branch = "BRA_WitchHouseA_SonIdle",
    ReferenceJoint = "Cine_WitchHouseA_SonIdle_SyncJoint"
  })
  seq:StartSequence()
end
function PlayLights_WitchHouseA()
  witchHouseA_Lights:Show()
  witchHouseA_Lights:JumpAnimToFrame(0)
  witchHouseA_Lights:PlayAnimToEnd()
end
function WitchHouseA_StopProps()
  local table = {
    largeBowl_WitchHouseA,
    largeSpoon_WitchHouseA,
    smallVial_WitchHouseA,
    tallCup1_WitchHouseA,
    tallCup2_WitchHouseA
  }
  RunFunctionOnObjectsInTable(table, "Show")
  largeBowl_WitchHouseA:StartAnim("narRivWitchHouseA040IntFreyaIdle")
  largeSpoon_WitchHouseA:StartAnim("narRivWitchHouseA040IntFreyaIdle")
  smallVial_WitchHouseA:StartAnim("narRivWitchHouseA040IntFreyaIdle")
  tallCup1_WitchHouseA:StartAnim("narRivWitchHouseA040IntFreyaIdle")
  tallCup2_WitchHouseA:StartAnim("narRivWitchHouseA040IntFreyaIdle1")
  RunFunctionOnObjectsInTable(table, "JumpAnimToFrame", 0)
  RunFunctionOnObjectsInTable(table, "PauseAnim")
end
function WitchHouseA_StopCups()
  local table = {smallVial_WitchHouseA}
  RunFunctionOnObjectsInTable(table, "Show")
  smallVial_WitchHouseA:StartAnim("narRivWitchHouseA040IntFreyaIdle")
  RunFunctionOnObjectsInTable(table, "JumpAnimToFrame", 0)
  RunFunctionOnObjectsInTable(table, "PauseAnim")
end
function DisableFreyaLeadTheWay()
  game.AI.FindSon():CallScript("ClearBehaviorContext")
  local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
  if not riv475 then
    engine.Warning("Warning: attempting to get reference to Riv475, reference returned nil.")
  else
    riv475:GetGameObject("Freya_Riv475_LeadTheWay").Child:CallScript("Disable")
  end
end
function DisableBothLeadTheWay()
  local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
  if not riv475 then
    engine.Warning("Warning: attempting to get reference to Riv475, reference returned nil.")
  else
    riv475:CallScript("DisableLTW")
  end
end
function DisableSonWaitByDoor()
  local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
  if not riv475 then
    engine.Warning("Warning: attempting to get reference to Riv475, reference returned nil.")
  else
    riv475:GetGameObject("PreHouse_ContextAction_SonWaitAtPoint").Child:CallScript("Disable")
  end
end
function Acquired_Lambscress()
  acquiredLambscress = true
end
function BuildNeedBothFlowersSequence()
  if acquiredLambscress and not banterPlayed.FlowerReminder2A then
    BuildNeedRedrootSequence()
  elseif acquiredLambscress and banterPlayed.FlowerReminder2A then
    return
  else
    BuildNeedLambscressSequence()
  end
end
function BuildNeedLambscressSequence()
  local actorTable = {
    {Actor = boarActor},
    {
      Obj = largeSpoon_WitchHouseA,
      Anim = "narRivFreyaGatherIngredients000Enter"
    },
    {
      Obj = largeBowl_WitchHouseA,
      Anim = "narRivFreyaGatherIngredients000Enter"
    },
    {
      Obj = tallCup1_WitchHouseA,
      Anim = "narRivFreyaGatherIngredients000Enter"
    },
    {
      Obj = tallCup2_WitchHouseA,
      Anim = "narRivFreyaGatherIngredients000Enter1"
    }
  }
  if not banterPlayed.FlowerReminder1B then
    if not playerLeftHouse then
      reminderSeq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_WitchHouseA, "idledInHouse_lambscressPlease")
      reminderSeq:WaitForLoadCheck("FreyaLvl100_Global")
      reminderSeq:WaitForLoadCheck("Riv470_FreyaPath")
      reminderSeq:Do(SpawnFreyaIfDoesntExist)
      reminderSeq:WaitForFunctionTrue(DoesFreyaExist)
      reminderSeq:WaitForFunctionTrue(function()
        return game.FindLevel("Riv480_c160_WitchHouseA")
      end)
      reminderSeq:Do(WitchHouseA_StopProps)
      reminderSeq:ActorSync(freyaActor, {
        Slaves = actorTable,
        Branch = "BRA_GatherIngredients",
        ReferenceJoint = "Cine_WitchHouseA_SyncJoint"
      })
      reminderSeq:Do(WitchHouseA_StopCups)
      reminderSeq:WaitForFunctionTrue(function()
        return freyaActor:GetCreature():IsPlayingMove("MOV_GatherIngredientsIdle")
      end)
      reminderSeq:Do(function()
        game.Audio.PlayBanter("RIV_FlowerReminder1A", function()
          banterPlayed.FlowerReminder1A = true
        end)
      end)
      reminderSeq:WaitSeconds(2)
      reminderSeq:Do(function()
        freyaActor:GetCreature():TriggerMoveEvent("LE_GatherIngredientsGesture1")
      end)
      reminderSeq:WaitSeconds(20)
      reminderSeq:Do(function()
        game.Audio.PlayBanter("RIV_FlowerReminder1B", function()
          banterPlayed.FlowerReminder1B = true
        end)
      end)
      reminderSeq:WaitSeconds(2)
      reminderSeq:Do(function()
        freyaActor:GetCreature():TriggerMoveEvent("LE_GatherIngredientsGesture2")
      end)
      reminderSeq:WaitForFunctionTrue(function()
        return freyaActor:GetCreature():IsPlayingMove("MOV_GatherIngredientsIdle")
      end)
      reminderSeq:Do(function()
        freyaActor:GetCreature():TriggerMoveEvent("LE_GatherIngredientsExit")
      end)
      reminderSeq:WaitForFunctionTrue(function()
        return freyaActor:GetCreature():IsPlayingMove("MOV_WitchHouseAEndIdle")
      end)
      reminderSeq:Do(FreyaAndBoarIdles_PostWitchHouseA)
      reminderSeq:StartSequence()
    elseif not banterPlayed.FlowerReminder1A then
      reminderSeq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_WitchHouseA, "reEnteredHouse_lambscressReminder1")
      reminderSeq:WaitForLoadCheck("FreyaLvl100_Global")
      reminderSeq:WaitForLoadCheck("Riv470_FreyaPath")
      reminderSeq:Do(SpawnFreyaIfDoesntExist)
      reminderSeq:WaitForFunctionTrue(DoesFreyaExist)
      reminderSeq:WaitForFunctionTrue(function()
        return game.FindLevel("Riv480_c160_WitchHouseA")
      end)
      reminderSeq:Do(WitchHouseA_StopProps)
      reminderSeq:ActorSync(freyaActor, {
        Slaves = actorTable,
        Branch = "BRA_GatherIngredients",
        ReferenceJoint = "Cine_WitchHouseA_SyncJoint"
      })
      reminderSeq:Do(WitchHouseA_StopCups)
      reminderSeq:WaitForFunctionTrue(function()
        return freyaActor:GetCreature():IsPlayingMove("MOV_GatherIngredientsEnter")
      end)
      reminderSeq:WaitSeconds(0.3)
      reminderSeq:WaitUntilActorAnimPastFrame(freyaActor, 170)
      reminderSeq:Do(function()
        game.Audio.PlayBanter("RIV_FlowerReminder1A", function()
          banterPlayed.FlowerReminder1A = true
        end)
      end)
      reminderSeq:WaitSeconds(20)
      reminderSeq:Do(function()
        game.Audio.PlayBanter("RIV_FlowerReminder1B", function()
          banterPlayed.FlowerReminder1B = true
        end)
      end)
      reminderSeq:WaitSeconds(2)
      reminderSeq:Do(function()
        freyaActor:GetCreature():TriggerMoveEvent("LE_GatherIngredientsGesture2")
      end)
      reminderSeq:WaitForFunctionTrue(function()
        return freyaActor:GetCreature():IsPlayingMove("MOV_GatherIngredientsIdle")
      end)
      reminderSeq:Do(function()
        freyaActor:GetCreature():TriggerMoveEvent("LE_GatherIngredientsExit")
      end)
      reminderSeq:WaitForFunctionTrue(function()
        return freyaActor:GetCreature():IsPlayingMove("MOV_WitchHouseAEndIdle")
      end)
      reminderSeq:Do(FreyaAndBoarIdles_PostWitchHouseA)
      reminderSeq:StartSequence()
    else
      reminderSeq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_WitchHouseA, "reEnteredHouse_lambscressReminder2")
      reminderSeq:WaitForLoadCheck("FreyaLvl100_Global")
      reminderSeq:WaitForLoadCheck("Riv470_FreyaPath")
      reminderSeq:Do(SpawnFreyaIfDoesntExist)
      reminderSeq:WaitForFunctionTrue(DoesFreyaExist)
      reminderSeq:WaitForFunctionTrue(function()
        return game.FindLevel("Riv480_c160_WitchHouseA")
      end)
      reminderSeq:Do(WitchHouseA_StopProps)
      reminderSeq:ActorSync(freyaActor, {
        Slaves = actorTable,
        Branch = "BRA_GatherIngredients",
        ReferenceJoint = "Cine_WitchHouseA_SyncJoint"
      })
      reminderSeq:Do(WitchHouseA_StopCups)
      reminderSeq:WaitForFunctionTrue(function()
        return freyaActor:GetCreature():IsPlayingMove("MOV_GatherIngredientsEnter")
      end)
      reminderSeq:WaitSeconds(0.3)
      reminderSeq:WaitUntilActorAnimPastFrame(freyaActor, 170)
      reminderSeq:Do(function()
        game.Audio.PlayBanter("RIV_FlowerReminder1B", function()
          banterPlayed.FlowerReminder1B = true
        end)
      end)
      reminderSeq:WaitSeconds(12)
      reminderSeq:Do(function()
        freyaActor:GetCreature():TriggerMoveEvent("LE_GatherIngredientsGesture2")
      end)
      reminderSeq:WaitSeconds(10)
      reminderSeq:Do(function()
        freyaActor:GetCreature():TriggerMoveEvent("LE_GatherIngredientsGesture1")
      end)
      reminderSeq:StartSequence()
    end
  end
end
function BuildNeedRedrootSequence()
  local seq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_WitchHouseA, "GatherIngredients_needRedRoot")
  local actorTable = {
    {Actor = boarActor},
    {
      Obj = largeSpoon_WitchHouseA,
      Anim = "narRivFreyaGatherIngredients000Enter"
    },
    {
      Obj = largeBowl_WitchHouseA,
      Anim = "narRivFreyaGatherIngredients000Enter"
    },
    {
      Obj = tallCup1_WitchHouseA,
      Anim = "narRivFreyaGatherIngredients000Enter"
    },
    {
      Obj = tallCup2_WitchHouseA,
      Anim = "narRivFreyaGatherIngredients000Enter1"
    }
  }
  seq:WaitForLoadCheck("FreyaLvl100_Global")
  seq:WaitForLoadCheck("Riv470_FreyaPath")
  seq:Do(SpawnFreyaIfDoesntExist)
  seq:WaitForFunctionTrue(DoesFreyaExist)
  seq:WaitForFunctionTrue(function()
    return game.FindLevel("Riv480_c160_WitchHouseA")
  end)
  seq:Do(WitchHouseA_StopProps)
  seq:WaitSeconds(2)
  seq:ActorSync(freyaActor, {
    Slaves = actorTable,
    Branch = "BRA_GatherIngredients",
    ReferenceJoint = "Cine_WitchHouseA_SyncJoint"
  })
  seq:Do(WitchHouseA_StopCups)
  seq:WaitForFunctionTrue(function()
    return freyaActor:GetCreature():IsPlayingMove("MOV_GatherIngredientsEnter")
  end)
  seq:WaitSeconds(0.3)
  seq:WaitUntilActorAnimPastFrame(freyaActor, 170)
  seq:Do(function()
    game.Audio.PlayBanter("RIV_FlowerReminder2A", function()
      banterPlayed.FlowerReminder2A = true
    end)
  end)
  seq:WaitSeconds(6)
  seq:Do(function()
    freyaActor:GetCreature():TriggerMoveEvent("LE_GatherIngredientsGesture1")
  end)
  seq:WaitSeconds(6)
  seq:Do(function()
    freyaActor:GetCreature():TriggerMoveEvent("LE_GatherIngredientsGesture2")
  end)
  seq:WaitSeconds(4)
  seq:Do(function()
    freyaActor:GetCreature():TriggerMoveEvent("LE_GatherIngredientsExit")
  end)
  seq:WaitForFunctionTrue(function()
    return freyaActor:GetCreature():IsPlayingMove("MOV_WitchHouseAEndIdle")
  end)
  seq:Do(FreyaAndBoarIdles_PostWitchHouseA)
  seq:StartSequence()
end
function BuildWitchHouseBSequence()
  BackDoorCinematicFlagTrue()
  local witchHouseBSeq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_WitchHouseB, "witchHouseB")
  local witchHouseB_ActorTable = {
    {Actor = sonActor},
    {Actor = freyaActor},
    {Actor = boarActor},
    {
      Obj = largeSpoon_WitchHouseB,
      Anim = "narRivWhitchHouseB000CineScene"
    },
    {
      Obj = smallBowl_WitchHouseB,
      Anim = "narRivWhitchHouseB000CineScene"
    },
    {
      Obj = lambsCress_WitchHouseB,
      Anim = "narRivWhitchHouseB000CineScene"
    },
    {
      Obj = rootFragment_WitchHouseB,
      Anim = "narRivWhitchHouseB000CineScene"
    },
    {
      Obj = freyaBackDoor,
      Anim = "narRivWhitchHouseB000CineScene"
    },
    {
      Obj = freyaFrontDoor,
      Anim = "narRivWhitchHouseB000CineScene"
    }
  }
  witchHouseBSeq:SetPostSkipMusic("SND_MX_RIV_start_master", "SND_MX_SonSick_master")
  witchHouseBSeq:MarkAbleToSkip()
  witchHouseBSeq:RequestCineModeAndWait(kratosActor, GameObjects.Cine_WitchHouseB)
  witchHouseBSeq:Do(HideAllProps)
  witchHouseBSeq:Do(ShowProps_WitchHouseB)
  witchHouseBSeq:Do(InitProps_WitchHouseB)
  witchHouseBSeq:Do(StartCineEnter_WitchHouseB)
  witchHouseBSeq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_WitchHouseBCine",
    ReferenceJoint = "Cine_WitchHouseB_SyncJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.StopTurnRadius,
    weapon_state = "bare"
  })
  witchHouseBSeq:Do(SpawnFreyaIfDoesntExist)
  witchHouseBSeq:Do(SpawnBoarIfDoesntExit)
  witchHouseBSeq:WaitForFunctionTrue(DoesFreyaExist)
  witchHouseBSeq:WaitForFunctionTrue(DoesBoarExist)
  witchHouseBSeq:ActorSync(kratosActor, {
    Slaves = witchHouseB_ActorTable,
    Branch = "BRA_WitchHouseBCine",
    ReferenceJoint = "Cine_WitchHouseB_SyncJoint"
  })
  witchHouseBSeq:Do(PlayLights_WitchHouseB)
  witchHouseBSeq:WaitUntilActorAnimPastFrame(kratosActor, 2000)
  witchHouseBSeq:Do(TriggerHouseLayDown, function()
    _G.SkipCreatureMovement()
  end)
  witchHouseBSeq:WaitUntilActorAnimPastFrame(kratosActor, 2250)
  witchHouseBSeq:Do(function()
    GameObjects.GI_Volume_Riv480:PlayAnimationToEnd()
  end)
  witchHouseBSeq:WaitUntilActorAnimPastFrame(kratosActor, 2415)
  witchHouseBSeq:Do(_G.SwitchLoadZones_Down)
  witchHouseBSeq:Do(function()
    game.AI.FindSon():SetMaxSpeedOverride(0)
  end)
  witchHouseBSeq:Do(DisableGameButtons)
  witchHouseBSeq:WaitUntilActorAnimPastPercentage(kratosActor, 93)
  witchHouseBSeq:Do(function()
    witchHouseBSeq:EndSkipIfActive()
  end)
  witchHouseBSeq:WaitUntilActorAnimPastFrame(kratosActor, 3120)
  witchHouseBSeq:WaitUntilActorAnimPastPercentage(kratosActor, 98)
  witchHouseBSeq:Do(StartCineEnter_CompassTut)
  witchHouseBSeq:Do(DisableCreatureAudio)
  witchHouseBSeq:WaitForAndCompleteCineMode(kratosActor, GameObjects.Cine_WitchHouseB)
  witchHouseBSeq:StopPuppetingActor(kratosActor)
  witchHouseBSeq:StopPuppetingActor(freyaActor)
  witchHouseBSeq:StopPuppetingActor(sonActor)
  witchHouseBSeq:StopPuppetingActor(boarActor)
  witchHouseBSeq:Do(HideAllProps)
  witchHouseBSeq:Do(DisableBackDoorPrompt)
  witchHouseBSeq:Do(EnableCompass)
  witchHouseBSeq:Do(HideVanaheimWindow)
  witchHouseBSeq:Do(UnlockBestiaryEntry)
  witchHouseBSeq:Do(function()
    GameObjects.BoarCollision:HideCollision()
  end)
  witchHouseBSeq:SetCompletedCineNumber(165)
  witchHouseBSeq:Do(Cine_Collision)
  witchHouseBSeq:Do(AwardTrophyOne)
  witchHouseBSeq:StartSequence()
end
function DisableGameButtons()
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickY)
  pad:DisableGameButton(tweaks.ePad.kPadRightStickX)
  pad:DisableGameButton(tweaks.ePad.kPadRightStickY)
  pad:DisableGameButton(tweaks.ePad.kPadSquare)
  pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  pad:DisableGameButton(tweaks.ePad.kPadCross)
  pad:DisableGameButton(tweaks.ePad.kPadCircle)
  pad:DisableGameButton(tweaks.ePad.kPadUp)
  pad:DisableGameButton(tweaks.ePad.kPadLeft)
  pad:DisableGameButton(tweaks.ePad.kPadDown)
  pad:DisableGameButton(tweaks.ePad.kPadRight)
  pad:DisableGameButton(tweaks.ePad.kPadL1)
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadL3)
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
  pad:DisableGameButton(tweaks.ePad.kPadR3)
end
function EnableCompass()
  game.Audio.PlayBanter("RIV_UndergroundPassage", CompassBanterComplete)
  TUT.Compass_Acquire()
end
function CompassBanterComplete()
  LD.CompleteQuest("Quest_RiverPass_Objective480")
  game.AI.FindSon():ClearMaxSpeedOverride()
  game.FindLevel("Riv925_FreyaCave"):CallScript("EnableLTWIntro")
  CA_Cave_Enable()
  StartCineEnter_CompassTut = nil
  uiCalls.UI_Event_TurnOffDesignerMessage()
  timers.StartLevelTimer(0.7, ClearInputMask)
  EnableFrontDoorPrompt()
  game.Compass.SetHaveCompass()
  timers.StartLevelTimer(3, function()
    uiCalls.UI_Event_DiscoverLocation("CalderaRPLoad")
  end)
end
function AwardTrophyOne()
  print("Award Trophy: Kratos' New Neighborhood")
  game.UnlockTrophy(2)
end
function UnlockBestiaryEntry()
  local freyaEntry = game.Wallets.GetResourceValue("HERO", "Bestiary_Unlock_Freya")
  if freyaEntry <= 0 then
    game.Wallets.AddResource("HERO", "Bestiary_Unlock_WitchOfWoods", 1)
  end
end
function UnlockFreyaBestiaryEntry()
  local witchBestiaryEntry = game.Wallets.GetResourceValue("HERO", "Bestiary_Unlock_WitchOfWoods")
  if 0 < witchBestiaryEntry then
    game.Wallets.RemoveResource("HERO", "Bestiary_Unlock_WitchOfWoods", 1)
  end
  game.Wallets.AddResource("HERO", "Bestiary_Unlock_Freya", 1)
  game.Wallets.AddResource("HERO", "Bestiary_Unlock_Mimir", 1)
end
function PlayLights_WitchHouseB()
  witchHouseB_Lights:Show()
  witchHouseB_Lights:JumpAnimToFrame(0)
  witchHouseB_Lights:PlayAnimToEnd()
end
function BuildFreyaTendsBoarSequence()
  local seq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_WitchHouseB, "freyaTendsBoar")
  seq:WaitForLoadCheck("FreyaLvl100_Global")
  seq:WaitForLoadCheck("Riv470_FreyaPath")
  seq:Do(SpawnFreyaIfDoesntExist)
  seq:Do(SpawnBoarIfDoesntExit)
  seq:WaitForFunctionTrue(DoesFreyaExist)
  seq:WaitForFunctionTrue(DoesBoarExist)
  seq:WaitForFunctionTrue(function()
    return game.FindLevel("Riv480_c165_WitchHouseB")
  end)
  seq:ActorSync(freyaActor, {
    Slaves = {
      {Actor = boarActor}
    },
    Branch = "BRA_FreyaTendsBoar",
    ReferenceJoint = "POI_FreyaTendsBoar_SyncJoint"
  })
  seq:StartSequence()
end
function BuildHeadEnchantSequence()
  local headEnchantSeq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_HeadEnchant, "headEnchant")
  local headEnchant_ActorTable = {
    {Actor = sonActor},
    {Actor = freyaActor},
    {
      Obj = tallCup_HeadEnchant_A,
      Anim = "narRivHeadEnchant020CineScene"
    },
    {
      Obj = tallCup_HeadEnchant_B,
      Anim = "narRivHeadEnchant020CineScene1"
    },
    {
      Obj = tallCup_HeadEnchant_C,
      Anim = "narRivHeadEnchant020CineScene2"
    },
    {
      Obj = grubs_HeadEnchant,
      Anim = "narRivHeadEnchant020CineScene"
    },
    {
      Obj = largeSpoon_HeadEnchant,
      Anim = "narRivHeadEnchant020CineScene"
    },
    {
      Obj = smallBowl_HeadEnchant,
      Anim = "narRivHeadEnchant020CineScene"
    },
    {
      Obj = smallVial_HeadEnchant,
      Anim = "narRivHeadEnchant020CineScene"
    },
    {
      Obj = largeBowl_HeadEnchant,
      Anim = "narRivHeadEnchant020CineScene"
    },
    {
      Obj = hangingHerbs_HeadEnchant,
      Anim = "narRivHeadEnchant020CineScene"
    },
    {
      Obj = freyaFrontDoor,
      Anim = "narRivHeadEnchant020CineScene"
    },
    {Obj = headEnchant_Lights, Anim = "default"}
  }
  headEnchantSeq:SetPostSkipMusic("SND_MX_RIV_start_master")
  headEnchantSeq:MarkAbleToSkip()
  headEnchantSeq:WaitForFunctionTrue(function()
    return game.FindLevel("Riv480_c330_HeadEnchant")
  end)
  headEnchantSeq:Do(PrestreamNewArrows)
  headEnchantSeq:Do(ShowVanaheimWindow)
  headEnchantSeq:Do(ShowProps_HeadEnchant)
  headEnchantSeq:Do(InitProps_HeadEnchant)
  headEnchantSeq:RequestCineModeAndWait(kratosActor, GameObjects.Cine_HeadEnchant)
  headEnchantSeq:Do(StartCineEnter_HeadEnchant)
  headEnchantSeq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_HeadEnchant",
    ReferenceJoint = "HeadEnchant_SyncJoint",
    speed = ND.KraWalkSpeed,
    stop = true,
    prevent_path_eval = true,
    radius = ND.StopTurnRadius,
    weapon_state = "bare"
  })
  headEnchantSeq:Do(SpawnFreyaIfDoesntExist)
  headEnchantSeq:Do(CA_FrontYard_Disable)
  headEnchantSeq:WaitForFunctionTrue(DoesFreyaExist)
  headEnchantSeq:Do(ArrowVisualsStage2)
  headEnchantSeq:Do(function()
    game.World.DisablePlayerStateSoftSave()
  end)
  headEnchantSeq:ActorSync(kratosActor, {
    Slaves = headEnchant_ActorTable,
    Branch = "BRA_HeadEnchant",
    ReferenceJoint = "HeadEnchant_SyncJoint"
  })
  headEnchantSeq:WaitUntilActorAnimPastFrame(kratosActor, 1560)
  headEnchantSeq:Do(SwapArrowVisuals)
  headEnchantSeq:WaitUntilActorAnimPastFrame(kratosActor, 2710)
  headEnchantSeq:Do(function()
    GameObjects.GI_Volume_Riv480:PlayAnimationToEnd(1)
  end)
  headEnchantSeq:Do(TriggerHouseLayDown, function()
    _G.SkipCreatureMovement()
  end)
  headEnchantSeq:WaitUntilActorAnimPastFrame(kratosActor, 3200)
  headEnchantSeq:Do(_G.SwitchLoadZones_Down)
  headEnchantSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.95)
  headEnchantSeq:WaitForLoadCheck("Riv935_FreyaElevator")
  headEnchantSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.99)
  headEnchantSeq:Do(function()
    headEnchantSeq:EndSkipIfActive()
  end)
  headEnchantSeq:Do(UpdateCreaturePosCollision)
  headEnchantSeq:WaitForAndCompleteCineMode(kratosActor, GameObjects.Cine_HeadEnchant)
  headEnchantSeq:SetCompletedCineNumber(330)
  headEnchantSeq:Do(function()
    game.Audio.SetBanterFact("MimirHeadRevived", "TRUE", "Infinite")
  end)
  headEnchantSeq:Do(HideVanaheimWindow)
  headEnchantSeq:Do(ClearPrestreamData)
  headEnchantSeq:StopPuppetingActor(kratosActor)
  headEnchantSeq:StopPuppetingActor(freyaActor)
  headEnchantSeq:StopPuppetingActor(sonActor)
  headEnchantSeq:DespawnActor(freyaActor)
  headEnchantSeq:Do(HideAllProps)
  headEnchantSeq:Do(DisableFrontDoorPrompt)
  headEnchantSeq:Do(ClearInputMask)
  headEnchantSeq:Do(CA_Cave_Enable)
  headEnchantSeq:Do(function()
    game.AI.FindSon():CallScript("ClearBehaviorContext")
  end)
  headEnchantSeq:Do(function()
    player:PickupSetStage("MimirHead", 2)
  end)
  headEnchantSeq:Do(function()
    GameObjects.CA_SyncExitHouse.LuaObjectScript.Enable()
  end)
  headEnchantSeq:Do(DisableCreatureDefenseZones)
  headEnchantSeq:Do(UnlockFreyaBestiaryEntry)
  headEnchantSeq:Do(function()
    game.SubmitActivityFeedStory("06_FreyaReturn")
  end)
  headEnchantSeq:Do(function()
    game.World.EnablePlayerStateSoftSave()
  end)
  headEnchantSeq:Do(function()
    LD.DisableBoatLore()
    replayCannotTrustHer = true
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("RIV_WeCannotTrustHer", CannotTrustHerComplete)
    end, 0.5)
    LD.CallFunctionAfterDelay(MimirRevivedSlowDownCheck, 0.5)
    LD.CallFunctionAfterDelay(function()
      uiCalls.UI_Event_DiscoverLocation("Freya Cavern")
    end, 2)
  end)
  headEnchantSeq:Do(Complete_Quest_PeaksPass_Objective746)
  headEnchantSeq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "12_RiverPass_020_MimirRevived"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  headEnchantSeq:StartSequence()
end
function MimirRevivedSlowDownCheck()
  local monitor = LM.CreateLoadMonitor()
  monitor:AddCallback({
    Wads = {
      "Riv925_FreyaCave"
    },
    Functions = {
      MimirRevivedSlowZone_Start
    }
  })
end
function MimirRevivedSlowZone_Start(wads)
  game.FindLevel("Riv925_FreyaCave"):CallScript("MimirRevivedSlowZone_Enable")
end
function MimirRevivedSlowZone_Stop()
  game.FindLevel("Riv925_FreyaCave"):CallScript("MimirRevivedSlowZone_Disable")
end
function CannotTrustHerComplete()
  replayCannotTrustHer = false
  MimirRevivedSlowZone_Stop()
end
function PostMimirRevivedRestart()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("RIV_WeCannotTrustHer", CannotTrustHerComplete)
  end, 3.5)
  LD.CallFunctionAfterDelay(MimirRevivedSlowDownCheck, 3.5)
  LD.CallFunctionAfterDelay(function()
    uiCalls.UI_Event_DiscoverLocation("Freya Cavern")
  end, 6.5)
end
function ArrowVisualsStage2()
  game.Wallets.AddResource("HERO", "ArrowUnlockStage2", 1, "NO_TELEMETRY")
end
function SwapArrowVisuals()
  game.Wallets.AddResource("HERO", "ArrowUnlockStage3", 1, "NO_TELEMETRY")
end
function PrestreamNewArrows()
  local pos = GameObjects.Cine_HeadEnchant:GetWorldJointPosition(GameObjects.Cine_HeadEnchant:GetJointIndex("HeadEnchant_SyncJoint"))
  game.Encounters.RequestGlobalCharacterPrestream(thisLevel, pos, "goquiver00", "_20_arrows")
  game.Encounters.RequestGlobalCharacterPrestream(thisLevel, pos, "goArrow00", "arrow20_stream")
end
function ClearPrestreamData()
  game.Encounters.ClearGlobalCharacterPrestreamRequest()
end
function Complete_Quest_PeaksPass_Objective746()
  game.QuestManager.ProposeQuestState("Quest_PeaksPass_Objective746", "Complete")
  game.Compass.SetGatewayMarkerIsOpen("RP_925_Helper", true)
  game.Compass.SetGatewayMarkerIsOpen("RP_925_Helper2", true)
end
function UpdateCreaturePosCollision()
  game.FindLevel("Riv925_FreyaCave"):CallScript("UpdateHouseCollision")
end
function BuildGoAwaySequence()
end
function BuildFreyaTendsSonSequence()
  GameObjects.CineZone_FreyaTendsSon:Hide()
  print("entered front door, freya tends son--------------------------------------")
  local freyaTendsSonSeq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_FreyaTendsSon, "freyaTendsSon")
  local freyaTendsSon_ActorTable = {
    {Actor = sonActor},
    {
      Obj = freyaFrontDoor,
      Anim = "narRivFreyaTendsSon000CineScene1"
    },
    {
      Obj = freyaTable_FreyaTendsSon,
      Anim = "narRivFreyaTendsSon000CineScene"
    },
    {Actor = freyaActor}
  }
  freyaTendsSonSeq:SetPostSkipMusic("SND_MX_RIV_start_master")
  freyaTendsSonSeq:MarkAbleToSkip()
  freyaTendsSonSeq:Do(SpawnFreyaIfDoesntExist)
  freyaTendsSonSeq:RequestCineModeAndWait(kratosActor, GameObjects.Cine_FreyaTendsSon)
  freyaTendsSonSeq:Do(StartCineEnter_FreyaTendsSon)
  freyaTendsSonSeq:WaitForFunctionTrue(DoesFreyaExist)
  freyaTendsSonSeq:Do(ShowVanaheimWindow)
  freyaTendsSonSeq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_FreyaTendsSon",
    ReferenceJoint = "Cine_FreyaTendsSon_SyncJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.ArrivalRadius
  })
  freyaTendsSonSeq:Do(OpenCompassMarker)
  freyaTendsSonSeq:Do(ShowProps_FreyaTendsSon)
  freyaTendsSonSeq:Do(InitProps_FreyaTendsSon)
  freyaTendsSonSeq:Do(PlayLights_FreyaTendsSon)
  freyaTendsSonSeq:ActorSync(kratosActor, {
    Slaves = freyaTendsSon_ActorTable,
    Branch = "BRA_FreyaTendsSon",
    ReferenceJoint = "Cine_FreyaTendsSon_SyncJoint"
  })
  freyaTendsSonSeq:WaitUntilActorAnimPastFrame(kratosActor, 3390)
  freyaTendsSonSeq:Do(function()
    GameObjects.GI_Volume_Riv480:PlayAnimationToEnd({Rate = -1})
  end)
  freyaTendsSonSeq:WaitUntilActorAnimPastFrame(kratosActor, 3449)
  freyaTendsSonSeq:Do(TriggerHouseStandUp)
  freyaTendsSonSeq:Do(function()
    GameObjects.WindowBlocker:Show()
  end)
  freyaTendsSonSeq:Do(_G.SwitchLoadZones_Up)
  freyaTendsSonSeq:WaitForAndCompleteCineMode(kratosActor, GameObjects.Cine_FreyaTendsSon)
  freyaTendsSonSeq:Do(function()
    freyaTendsSon_Lights:Hide()
  end)
  freyaTendsSonSeq:SetCompletedCineNumber(370)
  freyaTendsSonSeq:Do(UpdateBoatSpawningInCaldera)
  freyaTendsSonSeq:Do(function()
    GameObjects.WindowBlocker:Hide()
  end)
  freyaTendsSonSeq:StopPuppetingActor(kratosActor)
  freyaTendsSonSeq:Do(function()
    freyaFrontDoor.LuaObjectScript.ExcludeSon()
  end)
  freyaTendsSonSeq:Do(DisableFrontDoorPrompt)
  freyaTendsSonSeq:Do(EnableBackDoorPrompt)
  freyaTendsSonSeq:Do(Complete_Caldera_Objective330)
  freyaTendsSonSeq:Do(SaveInputMask)
  freyaTendsSonSeq:Do(function()
    game.World.StoreCheckpoint()
  end)
  freyaTendsSonSeq:Do(FreyaAndSonIdles_PostFreyaTendsSon)
  freyaTendsSonSeq:Do(RemoveTurtleCollision)
  freyaTendsSonSeq:Do(Cine_Collision)
  freyaTendsSonSeq:Do(function()
    game.SubmitActivityFeedStory("08_FreyaTendsSon")
  end)
  freyaTendsSonSeq:StartSequence()
end
function RemoveTurtleCollision()
  local monitor = LM.CreateLoadMonitor()
  monitor:AddCallback({
    Wads = {
      "Riv475_FreyaHouseExt"
    },
    Functions = {
      TurtleCollisionOff
    }
  })
end
function TurtleCollisionOff(wads)
  wads.Riv475_FreyaHouseExt:CallScript("HideTurtleCollision")
end
function OpenCompassMarker()
  local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
  if riv475 ~= nil then
    riv475:CallScript("OpenCompassPath")
  end
end
function FreyaAndSonIdles_PostFreyaTendsSon()
  local seq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_FreyaTendsSon, "post_FreyaTendsSon_Idles")
  seq:Do(IWillKeepHimSafe_Banter)
  seq:WaitForLoadCheck("Riv480_c370_FreyaTendsSon")
  seq:Do(SpawnFreyaIfDoesntExist)
  seq:WaitForFunctionTrue(DoesFreyaExist)
  seq:ActorSync(freyaActor, {
    Slaves = {
      {Actor = sonActor}
    },
    Branch = "BRA_PostFreyaTendsSonIdle",
    ReferenceJoint = "Cine_FreyaTendsSon_SyncJoint"
  })
  seq:WaitForActorPlayingMove(sonActor, "MOV_PostFreyaTendsSonIdle")
  seq:WaitSeconds(1)
  seq:StopPuppetingActor(freyaActor)
  seq:StopPuppetingActor(sonActor)
  seq:StartSequence()
end
function IWillKeepHimSafe_Banter()
  if not banterPlayed.IWillKeepHimSafe then
    timers.StartLevelTimer(20, function()
      if player.GroundLevel ~= nil and player.GroundLevel.Name == "WAD_Riv480_FreyaHouse" and not banterPlayed.IWillKeepHimSafe then
        banterPlayed.IWillKeepHimSafe = true
        game.Audio.PlayBanter("RIV_IWillKeepHimSafe")
      end
    end)
  end
end
function PlayLights_FreyaTendsSon()
  freyaTendsSon_Lights:Show()
  freyaTendsSon_Lights:JumpAnimToFrame(0)
  freyaTendsSon_Lights:PlayAnimToEnd()
end
function UpdateBoatSpawningInCaldera()
  local cal080 = game.FindLevel("Cal080_Global")
  if cal080 ~= nil then
    cal080:CallScript("UpdateBoatSpawning")
  end
end
function GoToHelAlreadyB_Banter()
  timers.StartLevelTimer(22, function()
    if player.GroundLevel.Name == "WAD_Riv480_FreyaHouse" then
      game.Audio.PlayBanter("RIV_GoToHelAlreadyB")
    end
  end)
end
function IsSonAvailableForCines()
  local son = sonActor:GetCreature()
  return son:IsAvailableInLevel() and son:IsAvailableForBanter() and son:IsAvailableForSync()
end
function BuildSonHealedSequence()
  local sonHealedSeq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_SonHealed, "sonHealed")
  local sonHealed_ActorTable = {
    {Actor = sonActor},
    {Actor = freyaActor},
    {
      Obj = smallBowl_SonHealed,
      Anim = "narRivSonHealed020CineScene"
    },
    {
      Obj = pillow1_SonHealed,
      Anim = "narRivSonHealed020CineScene"
    },
    {
      Obj = pillow2_SonHealed,
      Anim = "narRivSonHealed020CineScene1"
    },
    {
      Obj = pillow3_SonHealed,
      Anim = "narRivSonHealed020CineScene2"
    },
    {
      Obj = pillow4_SonHealed,
      Anim = "narRivSonHealed020CineScene3"
    },
    {
      Obj = trollHeart_SonHealed,
      Anim = "narRivSonHealed020CineScene"
    },
    {
      Obj = freyaFrontDoor,
      Anim = "narRivSonHealed020CineScene"
    },
    {Obj = sonHealed_Lights, Anim = "default"}
  }
  local idleProp_ActorTable = {
    {
      Obj = largeBowl_SonHealed,
      Anim = "narRivSonHealed030CineIdle"
    },
    {
      Obj = largeSpoon_SonHealed,
      Anim = "narRivSonHealed030CineIdle"
    },
    {
      Obj = tallCup_SonHealed,
      Anim = "narRivSonHealed030CineIdle"
    }
  }
  local sonWarpPos = LD.GetWorldJointPosition("Cine_SonHealed", "SonHealed_SyncJoint")
  sonHealedSeq:SetPostSkipMusic("SND_MX_RIV_start_master", "SND_MX_SonSick_master")
  sonHealedSeq:MarkAbleToSkip()
  sonHealedSeq:Do(function()
    sonActor:GetCreature():Warp(sonWarpPos, kratosActor:GetCreature():GetWorldForward())
  end)
  sonHealedSeq:Do(function()
    freyaFrontDoor.LuaObjectScript.ExcludeSon()
  end)
  sonHealedSeq:Do(CA_Cave_Disable)
  sonHealedSeq:Do(function()
    GameObjects.LoadZone_FreyaHouse_Up:HideEntityVolume()
  end)
  sonHealedSeq:Do(ClearSpecialOccupiedZones)
  sonHealedSeq:Do(HideAllProps)
  sonHealedSeq:Do(ShowProps_SonHealed)
  sonHealedSeq:Do(InitProps_SonHealed)
  sonHealedSeq:RequestCineModeAndWait(kratosActor, GameObjects.Cine_SonHealed)
  sonHealedSeq:Do(StartCineEnter_SonHealed)
  sonHealedSeq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_SonHealed",
    ReferenceJoint = "SonHealed_SyncJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = ND.ArrivalRadius,
    weapon_state = "bare"
  })
  sonHealedSeq:Do(SpawnFreyaIfDoesntExist)
  sonHealedSeq:WaitForFunctionTrue(DoesFreyaExist)
  sonHealedSeq:Do(function()
    son:RemoveAvailabilityRequest("SonUnavailable")
  end)
  sonHealedSeq:WaitForFunctionTrue(IsSonAvailableForCines)
  sonHealedSeq:ActorSync(kratosActor, {
    Slaves = sonHealed_ActorTable,
    Branch = "BRA_SonHealed",
    ReferenceJoint = "SonHealed_SyncJoint"
  })
  sonHealedSeq:SetCompletedCineNumber(390)
  sonHealedSeq:Do(UpdateBoatSpawningInCaldera)
  sonHealedSeq:WaitForFunctionTrue(function()
    return son:IsPlayingMove("MOV_SonHealed")
  end)
  sonHealedSeq:Do(function()
    GameObjects.AfterSonHeal_CA_Idle.LuaObjectScript.Enable()
  end)
  sonHealedSeq:WaitUntilActorAnimPastFrame(sonActor, 0)
  sonHealedSeq:WaitUntilActorAnimPastFrame(sonActor, 3555)
  sonHealedSeq:Do(function()
    son:CallScript("LuaHook_originalMaterial")
  end)
  sonHealedSeq:WaitForFunctionTrue(function()
    return not son:IsPlayingMove("MOV_SonHealed")
  end)
  sonHealedSeq:StopPuppetingActor(sonActor)
  sonHealedSeq:Do(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  sonHealedSeq:WaitForAndCompleteCineMode(kratosActor, GameObjects.Cine_SonHealed)
  sonHealedSeq:Do(function()
    sonHealed_Lights:Hide()
  end)
  sonHealedSeq:StopPuppetingActor(kratosActor)
  sonHealedSeq:StopPuppetingActor(freyaActor)
  sonHealedSeq:Do(function()
    freyaFrontDoor.LuaObjectScript.IncludeSon()
  end)
  sonHealedSeq:Do(AwardTrophyTwo)
  sonHealedSeq:Do(CompleteTheSickness)
  sonHealedSeq:Do(PostSonHealedStopProps)
  sonHealedSeq:Do(EnableFreyaElevator)
  sonHealedSeq:Do(DisableBackDoorPrompt)
  sonHealedSeq:Do(EnableFakeFastTravelIfLoaded)
  sonHealedSeq:Do(SaveInputMask)
  sonHealedSeq:Do(Cine_Collision)
  sonHealedSeq:Do(function()
    LD.DisableContextBehaviorBanter()
  end)
  sonHealedSeq:Do(function()
    game.World.StoreCheckpoint()
  end)
  sonHealedSeq:WaitSeconds(2.25)
  sonHealedSeq:Do(PostSonHealedCheck)
  sonHealedSeq:StartSequence()
end
function CompleteTheSickness()
  game.QuestManager.ProposeQuestState("Quest_Helheim_Objective022", "Complete")
  LD.ActivateQuest("Quest_Caldera_Parent")
end
function AwardTrophyTwo()
  print("Award Trophy: Modern Medicine")
  game.UnlockTrophy(7)
end
function Complete_Caldera_Objective330()
  game.QuestManager.ProposeQuestState("Quest_Caldera_Objective330", "Complete")
end
function EnableFakeFastTravelIfLoaded()
  local riv935 = game.FindLevel("Riv935_FreyaElevator")
  if riv935 ~= nil then
    riv935:GetGameObject("InteractZone_StillKinked").Child:CallScript("Enable")
  end
end
function EnableFreyaElevator()
  local riv935 = game.FindLevel("Riv935_FreyaElevator")
  if riv935 ~= nil then
    riv935:CallScript("ReEnable_ElevatorSwitch")
  end
end
function KratosIsInHouse()
  return player:IsInsideEntityZone(GameObjects.Cine_WitchHouse)
end
function PostSonHealedCheck()
  if KratosIsInHouse() and not banterPlayed.PostHealB then
    BuildPostSonHealedSequence()
  else
    SonHealedIdle2_FreyaSolo()
  end
end
function FreyaIdles_PostSonHealed()
  local seq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_SonHealed, "postHeal_FreyaIdle")
  seq:WaitForFunctionTrue(function()
    return game.FindLevel("Riv480_c390_SonHealed")
  end)
  seq:Do(SpawnFreyaIfDoesntExist)
  seq:WaitForFunctionTrue(DoesFreyaExist)
  seq:ActorSync(freyaActor, {
    Branch = "BRA_SonHealedIdle2",
    ReferenceJoint = "SonHealed_SyncJoint"
  })
  seq:Do(SetupPostCineProps_SonHealed)
  seq:Do(function()
    pillow2_SonHealed:Hide()
    sonHealed_Lights:Hide()
  end)
  seq:WaitSeconds(5)
  seq:Do(PostSonHealedCheck)
  seq:StartSequence()
end
function BuildPostSonHealedSequence()
  postSonHealedSeq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_SonHealed, "postSonHealed")
  local poi_ActorTable = {
    {
      Actor = freyaActor,
      Branch = "BRA_PostSonHealed"
    }
  }
  postSonHealedSeq:Do(function()
    FreyaStartTalking()
    game.Audio.PlayBanter("RIV_PostHealA")
  end)
  postSonHealedSeq:Do(SetSonOccupied)
  postSonHealedSeq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_PostSonHealed",
    ReferenceJoint = "SonHealed_SyncJoint",
    speed = ND.SonWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = ND.SonWalkArrivalRadius
  })
  postSonHealedSeq:ActorSync(sonActor, {
    Slaves = poi_ActorTable,
    Branch = "BRA_PostSonHealed",
    ReferenceJoint = "SonHealed_SyncJoint"
  })
  postSonHealedSeq:WaitUntilActorAnimPastFrame(sonActor, 136)
  postSonHealedSeq:Do(function()
    game.Audio.PlayBanter("RIV_PostHealB", function()
      banterPlayed.PostHealB = true
      freyaIsTalking = false
    end)
  end)
  postSonHealedSeq:WaitForFunctionTrue(function()
    return banterPlayed.PostHealB == true
  end)
  postSonHealedSeq:Do(ClearAvailability)
  postSonHealedSeq:Do(TurtleBoarVanaheimLogic)
  postSonHealedSeq:WaitForActorNotPlayingMove(sonActor, "MOV_PostSonHealed")
  postSonHealedSeq:StopPuppetingActor(sonActor)
  postSonHealedSeq:Do(SonHealedIdle2_FreyaSolo)
  postSonHealedSeq:StartSequence()
end
function SonHealedIdle2_FreyaSolo()
  local seq = ND.CreateCineSequence(thisLevel, GameObjects.Cine_SonHealed, "SonHealedIdle2_FreyaSolo")
  local idle_ActorTable = {
    {
      Obj = largeBowl_SonHealed,
      Anim = "narRivSonHealed030CineIdle"
    },
    {
      Obj = largeSpoon_SonHealed,
      Anim = "narRivSonHealed030CineIdle"
    },
    {
      Obj = tallCup_SonHealed,
      Anim = "narRivSonHealed030CineIdle"
    }
  }
  seq:ActorSync(freyaActor, {
    Slaves = idle_ActorTable,
    Branch = "BRA_SonHealedIdle2Solo",
    ReferenceJoint = "SonHealed_SyncJoint"
  })
  seq:StartSequence()
end
function SetSonOccupied()
  local availabilityState = {Unoccupied = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function ClearAvailability()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
end
function CancelPostHeal()
  sonActor:StopPuppeting()
end
function PostSonHealedStopProps()
  largeBowl_SonHealed:JumpAnimToFrame(0)
  largeBowl_SonHealed:PauseAnim()
  largeSpoon_SonHealed:JumpAnimToFrame(0)
  largeSpoon_SonHealed:PauseAnim()
  tallCup_SonHealed:JumpAnimToFrame(0)
  tallCup_SonHealed:PauseAnim()
end
function Cine_Collision()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 160 <= cineNum and cineNum <= 164 then
    GameObjects.Cine_CollisionSonA:ShowCollision()
    GameObjects.Cine_CollisionSonHealed:HideCollision()
  elseif 165 <= cineNum and cineNum < 370 then
    GameObjects.Cine_CollisionSonHealed:HideCollision()
    GameObjects.Cine_CollisionSonA:HideCollision()
  elseif 370 <= cineNum and cineNum <= 999 then
    GameObjects.Cine_CollisionSonHealed:ShowCollision()
    GameObjects.Cine_CollisionSonA:HideCollision()
  end
end
function TurtleBoarVanaheimLogic()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 470 < cineNum or cineNum < 165 then
    return
  elseif 180 < cineNum and cineNum < 390 then
    return
  elseif 390 <= cineNum and not banterPlayed.WindowToVanaheimA and CanVanaheimBanterPlay() then
    if justEnteredHouse then
      EnableVanaheimCA()
    else
      EnableVanaheimCA()
    end
  elseif 390 <= cineNum then
    GameObjects.VanaheimWindow_CA_Observe_Forward.LuaObjectScript.Disable()
    EnableTurtleCA()
  elseif 165 <= cineNum and cineNum < 180 then
    EnableBoarCA()
  end
  justEnteredHouse = false
end
function CanVanaheimBanterPlay()
  return game.Audio.CanBanterConversationPlay("RIV_WindowToVanaheimA")
end
function OnVanaheimWindowApproach()
  if not banterPlayed.WindowToVanaheimA then
    FreyaStartTalking()
    timers.StartLevelTimer(1, function()
      game.Audio.PlayBanterNonCritical("RIV_WindowToVanaheimA", function()
        freyaIsTalking = false
        if not freyaInterrupted then
          banterPlayed.WindowToVanaheimA = true
        end
        turtleBoarVanaTimer = timers.StartLevelTimer(5, function()
          if player.GroundLevel ~= nil and player.GroundLevel.Name == "WAD_Riv480_FreyaHouse" then
            TurtleBoarVanaheimLogic()
          end
        end)
      end)
    end)
  end
end
function OnTurtleCAApproach()
  if not banterPlayed.WhatsWithTheTurtleA then
    FreyaStartTalking()
    game.Audio.PlayBanterNonCritical("RIV_WhatsWithTheTurtleA", function()
      freyaIsTalking = false
      if not freyaInterrupted then
        banterPlayed.WhatsWithTheTurtleA = true
      end
    end)
  end
end
function OnBoarArrive()
  if not banterPlayed.WhatsABoar then
    FreyaStartTalking()
    game.Audio.PlayBanterNonCritical("RIV_WhatsABoarA", function()
      freyaIsTalking = false
      if not freyaInterrupted then
        banterPlayed.WhatsABoar = true
      end
    end)
  end
end
function EnableVanaheimCA()
  GameObjects.VanaheimWindow_CA_Observe_Forward.LuaObjectScript.Enable()
  CA_Cave_Disable()
end
function EnableTurtleCA()
  GameObjects.WhatsWithTurtle_CA_Observe_Forward.LuaObjectScript.Enable()
  CA_Cave_Disable()
end
function EnableBoarCA()
  GameObjects.WhatsABoar_CA_Idle.LuaObjectScript.Enable()
  CA_Cave_Disable()
end
function FreyaStartTalking()
  freyaIsTalking = true
  freyaInterrupted = false
end
function CA_FrontYard_Disable()
  game.FindLevel("Riv475_FreyaHouseExt"):CallScript("CA_Area_Disable")
end
function CA_Cave_Disable()
  game.FindLevel("Riv925_FreyaCave"):CallScript("CA_CaveStart_Disable")
end
function CA_Cave_Enable()
  game.FindLevel("Riv925_FreyaCave"):CallScript("CA_CaveStart_Enable")
end
function DisableCreatureDefenseZones()
  game.FindLevel("Riv925_FreyaCave"):CallScript("RemoveDefenseTriggerZones")
end
function ClearSpecialOccupiedZones()
  game.FindLevel("Riv925_FreyaCave"):CallScript("ClearOccupiedZones")
end
function DisableHouseCA()
  GameObjects.WhatsWithTurtle_CA_Observe_Forward.LuaObjectScript.Disable()
  GameObjects.WhatsABoar_CA_Idle.LuaObjectScript.Disable()
  GameObjects.VanaheimWindow_CA_Observe_Forward.LuaObjectScript.Disable()
  GameObjects.AfterSonHeal_CA_Idle.LuaObjectScript.Disable()
end
function OpenFreyaFrontDoor()
  PlayObjectAnim(freyaFrontDoor, "TEMP_Freya_DoorStayOpen1")
  DisableFrontDoorPrompt()
end
function CloseFreyaFrontDoor()
  PlayObjectAnim(freyaFrontDoor, "TEMP_Freya_DoorClose1")
  EnableFrontDoorPrompt()
end
function PlayObjectAnim(obj, animName)
  obj:StartAnim(animName)
  obj:JumpAnimToFrame(0)
  obj:PlayAnimToEnd()
end
function TriggerHouseLayDown()
  _G.CreatureLayDown()
end
function TriggerHouseStandUp()
  _G.CreatureStand()
end
function EnableFrontDoorPrompt()
  freyaFrontDoor.LuaObjectScript.Enable()
end
function EnableBackDoorPrompt()
  freyaBackDoor.LuaObjectScript.Enable()
end
function DisableFrontDoorPrompt()
  freyaFrontDoor.LuaObjectScript.Disable()
end
function DisableBackDoorPrompt()
  freyaBackDoor.LuaObjectScript.Disable()
end
function FrontDoorCinematicFlagTrue()
  freyaFrontDoor.LuaObjectScript.EnableCinematicTrigger()
end
function BackDoorCinematicFlagTrue()
  freyaBackDoor.LuaObjectScript.EnableCinematicTrigger()
end
function SetInputMask()
  if pad.DisableGameButton and pad.EnableGameButton then
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadL2)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadR1)
    pad:DisableGameButton(tweaks.ePad.kPadR2)
    pad:DisableGameButton(tweaks.ePad.kPadCross)
    pad:DisableGameButton(tweaks.ePad.kPadLeft)
    pad:DisableGameButton(tweaks.ePad.kPadRight)
    pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  end
end
function ClearInputMask()
  resumeInputMaskOnRestart = false
  if pad.ClearAllDisabledGameButtons then
    pad:ClearAllDisabledGameButtons()
  end
end
function SaveInputMask()
  resumeInputMaskOnRestart = true
end
function StartCineEnter_PreBoarFreakout()
  game.SubObject.Wake(thisObj)
  preCineCam_WitchHouseA = CCEC.CineEnterCamera.New("ENV_CineEnter_WitchHouseA_Pre", 15)
  preCineCam_WitchHouseA:SetCallback(DestroyCineEnter_PreBoarFreakout)
  preCineCam_WitchHouseA:Start()
end
function DestroyCineEnter_PreBoarFreakout()
  preCineCam_WitchHouseA = nil
  game.SubObject.Sleep(thisObj)
end
function StartCineEnter_CompassTut()
  game.SubObject.Wake(thisObj)
  cineEnter_CompassTut = CCEC.CineEnterCamera.New("ENV_Nar_Compass_Tutorial", 20)
  cineEnter_CompassTut:SetCallback(DestroyCineEnter_CompassTut)
  cineEnter_CompassTut:Start()
end
function DestroyCineEnter_CompassTut()
  cineEnter_CompassTut = nil
  game.SubObject.Sleep(thisObj)
end
function StartCineEnter_WitchHouseB()
  game.SubObject.Wake(thisObj)
  preCineCam_WitchHouseB = CCEC.CineEnterCamera.New("ENV_CineEnter_WitchHouseB", 8)
  preCineCam_WitchHouseB:SetCallback(DestroyCineEnter_WitchHouseB)
  preCineCam_WitchHouseB:Start()
end
function DestroyCineEnter_WitchHouseB()
  preCineCam_WitchHouseB = nil
  game.SubObject.Sleep(thisObj)
end
function StartCineEnter_SonHealed()
  game.SubObject.Wake(thisObj)
  preCineCam_SonHealed = CCEC.CineEnterCamera.New("ENV_CineEnter_SonHealed", 8)
  preCineCam_SonHealed:SetCallback(DestroyCineEnter_SonHealed)
  preCineCam_SonHealed:Start()
end
function DestroyCineEnter_SonHealed()
  preCineCam_SonHealed = nil
  game.SubObject.Sleep(thisObj)
end
function StartCineEnter_HeadEnchant()
  game.SubObject.Wake(thisObj)
  preCineCam_HeadEnchant = CCEC.CineEnterCamera.New("ENV_CineEnter_HeadEnchant", 8)
  preCineCam_HeadEnchant:SetCallback(DestroyCineEnter_HeadEnchant)
  preCineCam_HeadEnchant:Start()
end
function DestroyCineEnter_HeadEnchant()
  preCineCam_HeadEnchant = nil
  game.SubObject.Sleep(thisObj)
end
function StartCineEnter_FreyaTendsSon()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_FreyaTendsSon = CCEC.CineEnterCamera.New("ENV_CineEnter_FreyaTendsSon", 7)
  cineEnterCamera_FreyaTendsSon:SetCallback(DestroyCineEnter_FreyaTendsSon)
  cineEnterCamera_FreyaTendsSon:Start()
end
function DestroyCineEnter_FreyaTendsSon()
  cineEnterCamera_FreyaTendsSon = nil
  game.SubObject.Sleep(thisObj)
end
function DisableCreatureAudio()
  local riv480 = game.FindLevel("Riv480_FreyaHouse")
  if riv480 ~= nil then
    riv480:CallScript("AudioCreatureIdleStop")
  end
end
