local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local timers = require("level.timer")
local thisLevel, CreatureAnimGO, LookAtHouseRaise, FirstVisitMonitor, revisitFightComplete, secondVisitDone, houseDefenseDone
function OnScriptLoaded(level)
  thisLevel = level
  CreatureAnimGO = GameObjects.freyaCreature.Child
  SoundInit()
end
function OnStart(level)
  if game.FindLevel("Riv925_FreyaCave") then
    GameObjects.Unload_with_house_anim:Hide()
  else
    GameObjects.Unload_with_house_anim:Show()
  end
  SoundOnStart()
  if game.Level.GetVariable("CompletedCineNumber") < 160 then
    FirstVisitMonitor = monitors.CreateEntityZoneMonitor(game.Player.FindPlayer(), GameObjects.EntZn_HouseUpZone)
    FirstVisitMonitor:OnEnter(FirstVisitInit)
    FirstVisitMonitor:SetTriggerCountLimit(1)
    CreatureAnimGO:PlayAnimationCycle({
      Animation = "rivFreyaCreatureDownIdle",
      Tween = 0.6
    })
    GameObjects.LoadZone_FreyaHouse_Down:HideEntityVolume()
    AudioCreatureIdleStart()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 160 and game.Level.GetVariable("CompletedCineNumber") < 165 then
    CreatureAnimGO:PlayAnimationCycle({
      Animation = "poiRivSonPetTurtle_TurtleIdle",
      Tween = 0.6
    })
    GameObjects.LoadZone_FreyaHouse_Down:HideEntityVolume()
    AudioCreatureIdleStart()
    GameObjects.BoarCollision:ShowCollision()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 165 and game.Level.GetVariable("CompletedCineNumber") < 250 then
    CreatureAnimGO:PlayAnimationCycle({
      Animation = "rivFreyaCreatureDownIdle",
      Tween = 0.6
    })
  elseif game.Level.GetVariable("CompletedCineNumber") >= 250 and game.Level.GetVariable("CompletedCineNumber") < 330 then
    GameObjects.GI_Volume_Riv480:PlayAnimationToEnd({Rate = -1})
    if not secondVisitDone then
      secondVisitDone = true
      CreatureAnimGO:PlayAnimationCycle({
        Animation = "rivFreyaCreatureUnderIdle",
        Tween = 0.6
      })
      local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
      if riv475 ~= nil then
        riv475:CallScript("ShowTurtleDownCollision")
      end
      GameObjects.LoadZone_FreyaHouse_Up:ShowEntityVolume()
      GameObjects.LoadZone_FreyaHouse_Down:HideEntityVolume()
    end
  elseif game.Level.GetVariable("CompletedCineNumber") >= 330 and game.Level.GetVariable("CompletedCineNumber") < 370 then
    CreatureAnimGO:PlayAnimationCycle({
      Animation = "rivFreyaCreatureDownIdle",
      Tween = 0.6
    })
    GameObjects.LoadZone_FreyaHouse_Down:ShowEntityVolume()
    GameObjects.LoadZone_FreyaHouse_Up:HideEntityVolume()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 370 and game.Level.GetVariable("CompletedCineNumber") < 380 then
    CreatureAnimGO:PlayAnimationCycle({
      Animation = "poiRivSonPetTurtle_TurtleIdle",
      Tween = 0.6
    })
  else
    GameObjects.GI_Volume_Riv480:PlayAnimationToEnd()
    CreatureAnimGO:PlayAnimationCycle({
      Animation = "rivFreyaCreatureDownIdle",
      Tween = 0.6
    })
    GameObjects.LoadZone_FreyaHouse_Down:ShowEntityVolume()
    GameObjects.LoadZone_FreyaHouse_Up:HideEntityVolume()
  end
  GameObjects.FreyaHouseDoorFront.LuaObjectScript.OverrideInteractZone({useLOSTest = true})
  GameObjects.FreyaHouseDoorBack.LuaObjectScript.OverrideInteractZone({useLOSTest = true, xzRange = 3})
end
function OnUpdate(level)
  if game.Level.GetVariable("RIV_NAR_FreyaHouseSkip") == true then
    CreatureAnimGO:JumpAnimToPercent(100)
    game.Level.SetVariable("RIV_NAR_FreyaHouseSkip", false)
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    revisitFightComplete = revisitFightComplete,
    houseDefenseDone = houseDefenseDone,
    secondVisitDone = secondVisitDone
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  revisitFightComplete = savedInfo.revisitFightComplete
  houseDefenseDone = savedInfo.houseDefenseDone
  secondVisitDone = savedInfo.secondVisitDone
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_Riv925_FreyaCave" then
    GameObjects.Unload_with_house_anim:Hide()
  end
end
function OnWadUnloaded(level, oldLevel)
  if oldLevel.Name == "WAD_Riv925_FreyaCave" then
    GameObjects.Unload_with_house_anim:Show()
  end
end
function FirstVisitInit()
end
function CreatureStand_FirstHeimili()
  AudioCreatureIdleStop()
  AudioOnRise()
  CreatureAnimGO:StartAnimation({
    Animation = "poiRivFirstHeimili020Scene",
    Tween = 0.6
  })
  CreatureAnimGO:OnAnimationDone(thisLevel, "CreatureStandIdle", {
    Animation = "poiRivFirstHeimili020Scene"
  })
end
function CreatureStandImmediate_FirstHeimili()
  AudioCreatureIdleStop()
  AudioOnRise()
  CreatureAnimGO:StartAnimation({
    Animation = "poiRivFirstHeimili020Scene",
    Tween = 0.6
  })
  CreatureAnimGO:JumpAnimToFrame(155)
  CreatureAnimGO:PlayAnimToEnd()
  CreatureAnimGO:OnAnimationDone(thisLevel, "CreatureStandIdle", {
    Animation = "poiRivFirstHeimili020Scene"
  })
end
function CreatureStand()
  AudioCreatureIdleStop()
  CreatureAnimGO:StartAnimation({
    Animation = "rivFreyaCreatureRise",
    Tween = 0.6
  })
  CreatureAnimGO:OnAnimationDone(thisLevel, "CreatureStandIdle", {
    Animation = "rivFreyaCreatureRise"
  })
  GameObjects.GI_Volume_Riv480:PlayAnimationToEnd({Rate = -1})
end
function CreatureLayDown()
  AudioCreatureIdleStop()
  CreatureAnimGO:StartAnimation({
    Animation = "rivFreyaCreatureLayDown",
    Tween = 0.6
  })
  CreatureAnimGO:OnAnimationDone(thisLevel, "CreatureLayIdle", {
    Animation = "rivFreyaCreatureLayDown"
  })
  AudioCreatureLowerStart()
  GameObjects.GI_Volume_Riv480:PlayAnimationToEnd()
  local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
  if riv475 ~= nil then
    riv475:CallScript("ShowTurtleDownCollision")
  end
end
function SkipCreatureMovement()
  CreatureAnimGO:SetAnimationRate(10)
end
function CreatureStandIdle()
  CreatureAnimGO:PlayAnimationCycle({
    Animation = "poiRivSonPetTurtle_TurtleIdle",
    Tween = 0.6,
    Rate = 1,
    Reset = true
  })
  AudioCreatureIdleStart()
  local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
  if riv475 ~= nil then
    riv475:CallScript("ShowTurtleStandCollision")
  end
end
function CreatureStandIdleNoSound()
  CreatureAnimGO:PlayAnimationCycle({
    Animation = "poiRivSonPetTurtle_TurtleIdle",
    Tween = 0.6,
    Rate = 1,
    Reset = true
  })
  local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
  if riv475 ~= nil then
    riv475:CallScript("ShowTurtleStandCollision")
  end
end
function CreatureDefenseDone()
  local animTweenTime = 0.4
  CreatureAnimGO:PlayAnimationCycle({
    Animation = "poiRivSonPetTurtle_TurtleIdle",
    Tween = animTweenTime,
    Rate = 1
  })
  AudioCreatureIdleStart()
  houseDefenseDone = true
  local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
  if riv475 ~= nil then
    riv475:CallScript("HideHouseDefenseCollision")
    riv475:CallScript("ShowTurtleStandCollision")
    riv475:CallScript("EnableSandBowl")
  end
  timers.StartLevelTimer(animTweenTime + 0.1, CheckPointCreatureDefenseDone)
end
function CheckPointCreatureDefenseDone(level)
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.ChkOvr_FrontofHouse.Child
  })
end
function CreatureLayIdle()
  AudioCreatureLowerStop()
  CreatureAnimGO:PlayAnimationCycle({
    Animation = "rivFreyaCreatureDownIdle",
    Tween = 0.6,
    Rate = 1
  })
end
function CreaturePetBySon()
  CreatureAnimGO:StartAnimation({
    Animation = "poiRivSonPetTurtle",
    Tween = 0.6
  })
end
function Riv475AI_FightComplete()
  revisitFightComplete = true
end
function MimirRevivHousePositionCheck()
  if revisitFightComplete then
    CreatureStandIdleNoSound()
    local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
    if riv475 ~= nil then
      riv475:CallScript("HideHouseDefenseCollision")
    end
  else
    CreatureRearUpIdle()
  end
end
function CreatureUnderIdle()
  CreatureAnimGO:StartAnimation({
    Animation = "rivFreyaCreatureUnderIdle",
    Tween = 0.6,
    Reset = true
  })
end
function CreatureRearUpIdle()
  print("CreatureRearUpIdle", houseDefenseDone)
  AudioCreatureIdleStart()
  if not houseDefenseDone then
    CreatureAnimGO:PlayAnimationCycle({
      Animation = "rivFreyaCreatureUpIdle",
      Rate = 1,
      Reset = true
    })
    print("rivFreyaCreatureUpIdle")
    local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
    if riv475 ~= nil then
      riv475:CallScript("ShowHouseDefenseCollision")
      riv475:CallScript("ShowTurtleDefenseCollision")
    end
  else
    CreatureAnimGO:PlayAnimationCycle({
      Animation = "poiRivSonPetTurtle_TurtleIdle",
      Rate = 1
    })
  end
end
function CreatureResumeStandIdle()
  CreatureAnimGO:StartAnimation({
    Animation = "rivFreyaCreatureUpToStandIdle",
    Tween = 0.6
  })
  CreatureAnimGO:OnAnimationDone(thisLevel, "CreatureDefenseDone", {
    Animation = "rivFreyaCreatureUpToStandIdle"
  })
  AudioCreatureLowerStartPostFight()
end
function EndOfHeimili_CreatureMonitor()
  CreatureAnimGO:OnAnimationDone(thisLevel, "CreatureStandIdle")
end
local SND_TORSO, SND_LEFTLEG, SND_RIGHTLEG, SND_TURTMOUTH
local doorSoundOverride = {
  UseDirectSoundEmitterOverride = true,
  SoundEmitter_Center = nil,
  OnInteractForward_Center = "SND_Door_Wood_Freya_House_Push_Open",
  OnInteractBackward_Center = "SND_Door_Wood_Freya_House_Pull_Open",
  OnInteractClose_Center = "SND_Door_Wood_Freya_House_Pull_Close",
  OnInteractCloseFrameDelay = 100
}
function SoundInit()
  SND_TORSO = CreatureAnimGO:FindSingleSoundEmitterByName("SNDFREYACREATURE00")
  SND_LEFTLEG = CreatureAnimGO:FindSingleSoundEmitterByName("SNDFRONTLEFTLEG")
  SND_RIGHTLEG = CreatureAnimGO:FindSingleSoundEmitterByName("SNDFRONTRIGHTLEG")
  SND_TURTMOUTH = CreatureAnimGO:FindSingleSoundEmitterByName("SNDMOUTH")
end
function SoundOnStart()
  doorSoundOverride.SoundEmitter_Center = GameObjects.FreyaHouseDoorBack.Child.SoundEmitters[1]
  GameObjects.FreyaHouseDoorBack.LuaObjectScript.SoundSetup(doorSoundOverride)
  doorSoundOverride.SoundEmitter_Center = GameObjects.FreyaHouseDoorFront.Child.SoundEmitters[1]
  GameObjects.FreyaHouseDoorFront.LuaObjectScript.SoundSetup(doorSoundOverride)
end
function AudioOnRise()
  AudioCreatureRiseTorso()
  AudioCreatureRiseMouth()
  AudioCreatureRiseLeftLeg()
  AudioCreatureRiseRightLeg()
end
function AudioCreatureRiseTorso()
  LD.PlaySound(SND_TORSO, "SND_CHR_Freya_Home_Foley_Rise_Stem_Torso")
end
function AudioCreatureRiseLeftLeg()
  LD.PlaySound(SND_LEFTLEG, "SND_CHR_Freya_Home_Foley_Rise_Stem_FS_Front_Left")
end
function AudioCreatureRiseRightLeg()
  LD.PlaySound(SND_RIGHTLEG, "SND_CHR_Freya_Home_Foley_Rise_Stem_FS_Front_Right")
end
function AudioCreatureRiseMouth()
  LD.PlaySound(SND_TURTMOUTH, "SND_CHR_Freya_Home_Foley_Rise_Stem_Vox")
  game.Audio.StartMusic("SND_MX_RIV_turtle_stands")
end
function AudioCreatureLowerStart()
  LD.PlaySound(SND_TORSO, "SND_EVNT_Witch_House_B_Lower_Home_LP")
end
function AudioCreatureLowerStop()
  LD.StopSound(SND_TORSO, "SND_EVNT_Witch_House_B_Lower_Home_LP")
end
function AudioCreatureLowerStartPostFight()
  LD.PlaySound(SND_TORSO, "SND_CHR_Freya_Home_Foley_Lower_Post_Draugr_Fight")
end
function AudioCreatureIdleStart()
  print("AudioCreatureIdleStart")
  LD.PlaySound(SND_TURTMOUTH, "SND_CHR_Freya_Home_Breathing_LP")
end
function AudioCreatureIdleStop()
  print("AudioCreatureIdleStop")
  LD.StopSound(SND_TURTMOUTH, "SND_CHR_Freya_Home_Breathing_LP")
end
function FreyaHouseEnter()
  local riv000 = game.FindLevel("Riv000_Sound")
  if riv000 ~= nil then
    riv000:CallScript("FreyaHouseEnter")
  end
end
function FreyaHouseExit()
  local riv000 = game.FindLevel("Riv000_Sound")
  if riv000 ~= nil then
    riv000:CallScript("FreyaHouseExit")
  end
end
function Riv480_Bookmark_FreyaBasement_Visit01()
  if game.Level.GetVariable("CompletedCineNumber") < 166 then
    GameObjects.FreyaHouseDoorFront.Child.LuaObjectScript.Disable()
  end
end
function Riv480_Bookmark_TendsSon()
end
function Riv480_Bookmark_SonHealed()
end
function Riv480_Bookmark_HouseUp()
  CreatureStand()
end
function SwitchLoadZones_Down()
  GameObjects.LoadZone_FreyaHouse_Up:HideEntityVolume()
  GameObjects.LoadZone_FreyaHouse_Down:ShowEntityVolume()
end
function SwitchLoadZones_Up()
  GameObjects.LoadZone_FreyaHouse_Up:ShowEntityVolume()
  GameObjects.LoadZone_FreyaHouse_Down:HideEntityVolume()
end
function OnEvaluateLoadGroup_Cinematic()
  if game.Level.GetVariable("CompletedCineNumber") < 163 then
    return "WitchHouseA"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 163 and game.Level.GetVariable("CompletedCineNumber") <= 165 then
    return "WitchHouseB"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 320 and game.Level.GetVariable("CompletedCineNumber") < 331 then
    return "HeadEnchant"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 365 and game.Level.GetVariable("CompletedCineNumber") < 371 then
    return "FreyaTendsSon"
  else
    return "SonHealed"
  end
end
function OnEvaluateLoadGroup_Combat()
  if game.Level.GetVariable("CompletedCineNumber") >= 163 and game.Level.GetVariable("CompletedCineNumber") <= 165 then
    return "CombatVisit_01"
  elseif game.Level.GetVariable("CompletedCineNumber") > 165 and game.Level.GetVariable("CompletedCineNumber") < 360 then
    return "CombatVisit_02"
  else
    return "NoAIVisit_FreyaTendsSon"
  end
end
