local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local timer = require("level.timer")
local thisLevel, player, visit2SideEncounter, Jotunn_HealthMonitor, Witch_HealthMonitor, Area_1_Encounter_1, Area_1_Encounter_2, A1E3
local A1E3_deathCheck = 0
local Area_1_Encounter_4, enc_A1E4_Flyers, enc_Area1_PostPuzzle_FlyerSpawn, enc_A1E4_Flyers_Repop, enc_Area1_Flyer_Repop, flyerAlert, Area_2_Encounter_1, Area_2_Encounter_2, enc_Area2_WitchPatrol, enc_Area2_WitchPatrol_Fight, Area_3_Encounter_1, Encounter1_TempStart, ZM_A1_EC2_Attack, ZM_A2_EC1_Attack, ZM_A3_EC1_Attack, A02_ZM_1, A03_ZM_1
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  PuzzleRevisitEncounter()
  FNC_A1E3()
  if game.Level.GetVariable("CompletedCineNumber") < 210 then
    Area_1_Fight_1()
    Area_2_Fight_1()
    Area1_PostPuzzle_FlyerSpawn()
    Area2_WitchPatrol_Fight()
    GameObjects.EntZn_Area1_PostPuzzleWitchRun_Spawn:HideEntityVolume()
    GameObjects.EntZn_Area1_PostPuzzleWitchRun_Alert:HideEntityVolume()
  end
  FNC_A1E4_Flyers_Repop()
  Area1_Flyer_Repop()
end
function OnStart(level)
  GameObjects.EntZn_ThirdFightStart:HideEntityVolume()
  if game.Level.GetVariable("CompletedCineNumber") >= 150 and game.Level.GetVariable("CompletedCineNumber") <= 180 and not Area_2_Encounter_1:IsComplete() then
    Area_2_Encounter_1:Start()
  end
  if game.Level.GetVariable("CompletedCineNumber") <= 319 then
    GameObjects.EntZn_A1E4_SapFight:HideEntityVolume()
  end
end
function StartVisit2SideEncounter()
  visit2SideEncounter:Start()
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Intro Fight Riv925", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_A1_Top"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Flyer_N_Hang",
      spawnWad = "Riv925_AI_Visit01",
      spawnLocators = "A1_Loc_U_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.01
    },
    {
      spawners = "Flyer_N_Hang",
      spawnWad = "Riv925_AI_Visit01",
      spawnLocators = "A1_Loc_U_02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2
    }
  })
  Area_1_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Flyer_N_SFBU",
      spawnWad = "Riv925_AI_Visit01",
      spawnLocators = "A1_Loc_E_07",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_1_Encounter_Spawn_1)
  Area_1_Encounter_1:SetAlertZone(GameObjects.EntZn_Arena_1_Encounter_Alert)
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(2)
  end, {count = 1})
  flyerAlert = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Arena_1_Encounter_Alert"))
  flyerAlert:OnEnter(function()
    Area_1_Encounter_1:StartWave(2)
    Area_1_Encounter_1:AlertEnemies()
  end)
  flyerAlert:SetTriggerCountLimit(1)
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Base")
    game.Audio.PlayBanter("1stNightmareEncounterEnd")
  end)
end
function Area_1_TempStart()
  if not Encounter1_TempStart then
    Encounter1_TempStart = true
    if Area_1_Encounter_1 ~= nil then
      Area_1_Encounter_1:Start()
    end
  end
end
function Area_1_Escaped()
  if not Area_1_Encounter_1:IsComplete() then
    Area_1_Encounter_1:SetComplete()
  end
end
function Area1_PostPuzzle_FlyerSpawn()
  enc_Area1_PostPuzzle_FlyerSpawn = EC.NewEncounter(thisLevel, "[Area 1] Post Puzzle - Flyer Spawn - Riv925")
  enc_Area1_PostPuzzle_FlyerSpawn:AddWave({
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A1_Loc_O_01",
      spawnWad = "Riv925_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.1
    },
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A1_Loc_O_02",
      spawnWad = "Riv925_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.3
    }
  })
  enc_Area1_PostPuzzle_FlyerSpawn:SetStartZone(GameObjects.EntZn_Area1_PostPuzzleWitchRun_Spawn, {cineRequirement = 320, 329})
end
function Area1_Flyer_Repop()
  enc_Area1_Flyer_Repop = EC.NewEncounter(thisLevel, "[Area 1] Flyer Spawn Repop- Riv925", {
    RepopulationEncounter = false,
    LeashZone = "LshZn_A1_Top",
    MustHaveCompletedList = {
      "[Area 1] Post Puzzle - Flyer Spawn - Riv925"
    }
  })
  enc_Area1_Flyer_Repop:AddWave({
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A1_Loc_O_01",
      spawnWad = "Riv925_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.1
    },
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A1_Loc_O_02",
      spawnWad = "Riv925_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.3
    }
  })
  enc_Area1_Flyer_Repop:SetStartZone(GameObjects.EntZn_Area1_PostPuzzleWitchRun_Spawn)
end
function Area2_WitchPatrol_Fight()
  enc_Area2_WitchPatrol_Fight = EC.NewEncounter(thisLevel, "[Area 2] Fight - Witch Spawns and Patrols - Riv925", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_Riv925_PuzzleRevisitEncounter"
  })
  enc_Area2_WitchPatrol_Fight:AddWave({
    {
      spawners = "Witch00_SRFC_Patrol_01",
      spawnWad = "Riv925_AI_Visit01",
      spawnCooldown = 0.2
    }
  })
  enc_Area2_WitchPatrol_Fight:OnComplete(function()
    GameObjects.EntZn_Area1_PostPuzzleWitchRun_Spawn:ShowEntityVolume()
    GameObjects.EntZn_Area1_PostPuzzleWitchRun_Alert:ShowEntityVolume()
  end)
  enc_Area2_WitchPatrol_Fight:SetStartZone(GameObjects.EntZn_Arena2_Encounter_Witch)
end
function PostPuzzle_SpawnWitchPatrol()
  enc_Area2_WitchPatrol_Fight:Start()
end
function Start_Area_2_Fight()
  if Area_2_Encounter_1 ~= nil then
    Area_2_Encounter_1:AlertEnemies()
  end
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Hidden Attacker Riv925", {
    LeashZone = "LshZn_A1_Top"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Draugr_N_SSA",
      spawnLocators = "A2_Loc_H_2",
      spawnWad = "Riv925_AI_Visit01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2
    }
  })
  Area_2_Encounter_1:OnComplete(print("Please Trigger Water Dont touch the water Banter Here"))
  Area_2_Encounter_1:SetAlertZone(GameObjects.EntZnGrp_Arena2_Enc1_Attack)
end
function Start_A1E3()
  if game.Level.GetVariable("CompletedCineNumber") >= 320 then
    GameObjects.EntZn_A1E4_SapFight:ShowEntityVolume()
  end
end
function FNC_A1E3()
  A1E3 = EC.NewEncounter(thisLevel, "[A1]EC: Visit2 - Witch - Riv925", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_A1_Top",
    StartMusic = "SND_MX_RIV2_fight1_in",
    StopMusic = "SND_MX_RIV2_fight1_out"
  })
  A1E3:AddWave({
    powerLevel = 3,
    {
      spawners = "Witch_N_SRFC",
      spawnLocators = "A1_Loc_O_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Riv925_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    },
    {
      spawners = "SH_Seidr_N_SDR",
      spawnLocators = "A1_Loc_H_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Riv925_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.03
    },
    {
      spawners = "SH_Seidr_N_SDR",
      spawnLocators = "A1_Loc_O_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Riv925_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  A1E3:OnStart(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  A1E3:OnComplete(function()
    game.Compass.SetDesignerForcedHide(false)
  end)
  A1E3:SetStartZone(GameObjects.EntZn_A1E4_SapFight, {cineRequirement = 320, 329})
end
function FNC_A1E4_Flyers()
  enc_A1E4_Flyers = EC.NewEncounter(thisLevel, "[A1]EC:3 Visit2 - Flyer Climb Block - Riv925", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_A1_Top"
  })
  enc_A1E4_Flyers:AddWave({
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A1_Loc_H_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Riv925_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A1_Loc_H_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Riv925_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.3
    }
  })
  enc_A1E4_Flyers:SetStartZone(GameObjects.EntZn_A1E4_Flyers, {cineRequirement = 320, 329})
end
function FNC_A1E4_Flyers_Repop()
  enc_A1E4_Flyers_Repop = EC.NewEncounter(thisLevel, "[A1] Flyer Climb Block Repop - Riv925", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_A1_Top",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[A1]EC: Visit2 - Witch - Riv925",
      "[A1]EC:3 Visit2 - Flyer Climb Block - Riv925"
    }
  })
  enc_A1E4_Flyers_Repop:AddWave({
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A1_Loc_H_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Riv925_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A1_Loc_H_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Riv925_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  enc_A1E4_Flyers_Repop:SetStartZone(GameObjects.EntZn_A1E4_Flyers, {cineRequirement = 339, 999})
end
function Area_2_EnctounterTrigger()
end
function Alert_PuzzleRevisitEncounter()
  visit2SideEncounter:AlertEnemies()
end
function PuzzleRevisitEncounter()
  visit2SideEncounter = EC.NewEncounter(thisLevel, "Visit2SideEncounter", {
    CheckpointOnComplete = true,
    AutoResetOnReload = true,
    LeashZone = "LshZn_Riv925_PuzzleRevisitEncounter"
  })
  visit2SideEncounter:AddWave({
    {
      spawners = "CR4_Witch_N_SUS",
      spawnWad = "Riv925_AI_Visit02",
      spawnLocators = "A3_Loc_O_4",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1
    }
  })
  visit2SideEncounter:AddWave({
    {
      spawners = "CR4_Witch_N_SRFC",
      spawnWad = "Riv925_AI_Visit02",
      spawnLocators = "A3_Loc_O_",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.5
    }
  })
  visit2SideEncounter:SetStartZone(GameObjects.EntZn_SpawnPuzzle1, {
    cineRequirement = {319, 999}
  })
  visit2SideEncounter:OnEnemySpawn(Witch_Health_Encounter, {count = 1})
  visit2SideEncounter:OnComplete(function()
    game.World.StoreCheckpoint()
  end)
end
function Witch_Health_Encounter(Enemy)
  if Enemy ~= nil then
    Witch_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Witch_Health = Enemy:GetHitPoints()
    local Phase_1 = Witch_Health * 0.985
    Witch_HealthMonitor:OnHealthLessThan(Phase_1, function()
      visit2SideEncounter:StartWave()
    end)
  end
end
function Riv925_Bookmark_Puzzle()
end
function Riv925_Bookmark_Boat()
  GameObjects.EntZn_Arena_1_Encounter_2_Attack:HideEntityVolume()
end
function Riv925_Bookmark_A1_E1_Complete()
  print("Riv925_Bookmark_A1_E1_Complete Riv925_Bookmark_A1_E1_Complete")
  Area_1_Encounter_1:SetComplete()
end
