local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, thisLevel
local banterPlayed = {}
local pushStarted = false
local skipShockAndAh = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  banterPlayed = savedInfo.banterPlayed
end
function FirstPushBlock01_Banter()
  if not banterPlayed.firstPushBlock01_Played and not pushStarted then
    pushStarted = true
    local seq = LD.CreateCineSequence(thisLevel, thisObj, "firstPushBlock01_Banter")
    seq:WaitForFunctionTrue(function()
      return GameObjects.PushBlock01.AnimFrame > 5
    end)
    seq:Do(FirstPushBlock01_Play)
    seq:StartSequence()
  end
end
function FirstPushBlock01_Play()
  if game.Level.GetVariable("CompletedCineNumber") ~= 387 then
    game.Audio.PlayBanterNonCritical("RIV_FirstPushBlock_01")
    banterPlayed.firstPushBlock01_Played = true
  end
end
function DoNotTouchTheWater_Banter()
  if game.Level.GetVariable("CompletedCineNumber") < 180 then
    game.Audio.PlayBanter("RIV_DoNotTouchTheWater")
  end
end
function SeesRuneBowl01_Banter()
  if not banterPlayed.seesRuneBowl01_Played and game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    game.Audio.PlayBanterNonCritical("RIV_SeesRuneBowl_01")
    banterPlayed.seesRuneBowl01_Played = true
  end
end
function SeesRuneBowl02_Banter()
  if not banterPlayed.seesRuneBowl02_Played and game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    game.Audio.PlayBanterNonCritical("RIV_SeesRuneBowl_02")
    banterPlayed.seesRuneBowl02_Played = true
  end
end
function SeesRuneBowl03_Banter()
  if not banterPlayed.seesRuneBowl03_Played then
    game.Audio.PlayBanterNonCritical("RIV_SeesRuneBowl_03")
    banterPlayed.seesRuneBowl03_Played = true
  end
end
function SeesRuneBowl04_Banter()
  if not banterPlayed.seesRuneBowl04_Played and game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanterNonCritical("RIV_SeesRuneBowl_04")
    end, 0.3)
    banterPlayed.seesRuneBowl04_Played = true
  end
end
function SeesRuneBowl05_Banter()
  if not banterPlayed.seesRuneBowl05_Played and game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    game.Audio.PlayBanterNonCritical("RIV_SeesRuneBowl_05_B")
    banterPlayed.seesRuneBowl05_Played = true
  end
end
function SeesRuneBowl06_Banter()
  if not banterPlayed.seesRuneBowl06_Played and game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    game.Audio.PlayBanterNonCritical("RIV_SeesRuneBowl_06")
    banterPlayed.seesRuneBowl06_Played = true
  end
end
function SeesRuneBowl07_Banter()
  if not banterPlayed.seesRuneBowl07_Played and game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    game.Audio.PlayBanterNonCritical("RIV_SeesRuneBowl_07")
    banterPlayed.seesRuneBowl07_Played = true
  end
end
function FreyaCaveRuneBowl_notice_Banter()
  if not banterPlayed.FreyaCaveRuneBowl_notice and game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    game.Audio.PlayBanter("FreyaCaveRuneBowl_notice")
    banterPlayed.FreyaCaveRuneBowl_notice = true
  end
end
function FreyaCaveRuneBowl_arrive_Banter()
  if not banterPlayed.FreyaCaveRuneBowl_arrive and game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    game.Audio.PlayBanter("FreyaCaveRuneBowl_arrive")
    banterPlayed.FreyaCaveRuneBowl_arrive = true
  end
end
function PlayBtr_TurtleUp()
  if not banterPlayed.TurtleUp_Played and game.Level.GetVariable("CompletedCineNumber") == 320 then
    game.Audio.PlayBanter("Btr_TurtleUp", _G.ChangePathing)
  end
end
function TurtleUp_Played()
  if not banterPlayed.TurtleUp_Played and not skipShockAndAh then
    GameObjects.BtrZone_ShockAndAhTimer:ShowEntityVolume()
    GameObjects.BanterTimer_ShockAndAh.LuaObjectScript.StartFromBeginning()
  end
  banterPlayed.TurtleUp_Played = true
end
function WellPath_Opened()
  GameObjects.BanterTimer_ShockAndAh.Child.LuaObjectScript.Cancel()
  GameObjects.BtrZone_ShockAndAhTimer:HideEntityVolume()
  GameObjects.Btr_TurtleUp:HideEntityVolume()
  skipShockAndAh = true
end
function ShockAndAh_04_Play()
  if not banterPlayed.ShockAndAh_04 and game.Level.GetVariable("CompletedCineNumber") < 330 then
    game.Audio.PlayBanter("RIV_ShockAndAh_04")
    banterPlayed.ShockAndAh_04 = true
  end
end
