local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, player, son, sandBowl, floatingPlatform
local runeDiscoverd = false
local boardsCounter = 0
local crankObject, pushBlockState, pushBlockMonitor, camZoneBlockSlideStage1
local sonPathClear = false
local cielingRuneInteract
local TP_PushBlocks = {}
local progress, burnableBurnt
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  crankObject = thisObj:FindSingleGOByName("StraightCrankSidewaysHandle").Child
  TP_PushBlocks[1] = level:GetGameObject("TP_PushBlock01")
  TP_PushBlocks[2] = level:GetGameObject("TP_PushBlock02")
  camZoneBlockSlideStage1 = thisLevel:GetGameObject("CamZone_BlockSlideStage1")
  sandBowl = thisLevel:GetGameObject("SandBowl_01").Child
  cielingRuneInteract = thisLevel:GetGameObject("CeilingRuneInteract")
  floatingPlatform = thisLevel:GetGameObject("FloatingPlatformV12").Child
  game.SubObject.SetUpdateDisableDistance(obj, 10)
  SoundInit()
end
function OnFirstStart(level, obj)
  progress = "none"
  pushBlockState = "left"
  TP_PushBlocks[1]:HideTraverseLink()
  TP_PushBlocks[2]:HideTraverseLink()
  GameObjects.TL_SandBowlJump:HideTraverseLink()
end
function OnStart(level, obj)
  if progress == "bowlCompleted" then
    PlatformDone()
  elseif progress == "bowlEnabled" or progress == "atBowl" then
    sandBowl.LuaObjectScript.Enable()
    engine.SendHook("OnStandGround", son, true)
    timers.StartLevelTimer(5, function()
      engine.SendHook("OnStandGround", son, false)
    end)
  else
    pushBlockMonitor = monitors.CreateAnimFrameMonitor(thisObj)
    pushBlockMonitor:OnFrameBackward(1, function()
      Puzzle_UpdateGapJumps("left")
    end)
    pushBlockMonitor:OnFrameForward(2, function()
      Puzzle_UpdateGapJumps("middle")
    end)
    pushBlockMonitor:OnFrameBackward(148, function()
      Puzzle_UpdateGapJumps("middle")
    end)
    pushBlockMonitor:OnFrameForward(149, function()
      Puzzle_UpdateGapJumps("right")
    end)
  end
  if ValidateBreakable(GameObjects.gen_multiStage_brk5, "Wooden_Barrier_3hit_02") == false then
    sonPathClear = true
  end
  ValidateBreakableEasy(GameObjects.wooden_barrier_RuneSymbol_01)
  ValidateBreakableEasy(GameObjects.wooden_barrier_RuneSymbol_02)
  ValidateBreakableEasy(GameObjects.wooden_barrier_RuneSymbol_03)
end
function ValidateBreakable(breakableRefnode, childBreakableName)
  local breakableRef = breakableRefnode:FindSingleGOByName(childBreakableName)
  if breakableRef ~= nil and breakableRef.LuaObjectScript ~= nil then
    local breakableComponent = breakableRef:GetBreakable()
    if breakableComponent ~= nil and breakableComponent.Broken == false then
      return true
    end
  end
  return false
end
function ValidateBreakableEasy(BreakableBoards)
  if BreakableBoards ~= nil then
    BreakableBoards = BreakableBoards.Child:GetBreakable()
    if BreakableBoards.Broken == true then
      boardsCounter = boardsCounter + 1
    end
  end
end
function OnUpdate(level, obj)
  if (game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_BlockSlideStage1") or game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_BlockSlideStage2")) and (player.Pad.CorrectedRightStick.y ~= 0 or player.Pad.CorrectedRightStick.x ~= 0) then
    game.Camera.SubmitCameraByName("PLYR_BlockSlide_LookAround")
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    progress = progress,
    pushBlockState = pushBlockState,
    burnableBurnt = burnableBurnt
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  progress = savedInfo.progress
  pushBlockState = savedInfo.pushBlockState
  burnableBurnt = savedInfo.burnableBurnt or IsBurnableBurnt()
end
function SonClearPath()
  sonPathClear = true
  Puzzle_UpdateGapJumps(pushBlockState)
end
function UnlockCrank()
  if crankObject.LuaObjectScript.CrankIsLocked() then
    crankObject.LuaObjectScript.Unlock()
    TP_PushBlocks[2]:HideTraverseLink()
  end
end
function Puzzle_UpdateGapJumps(state)
  if state == "right" and progress == "readyForBlock" then
    JumpOnBlock()
  elseif state == "left" and sonPathClear == true and progress == "readyOnBlock" then
    JumpOffBlock()
  elseif state == "left" and sonPathClear == false and progress == "readyOnBlock" then
    GameObjects.Riv925_Banter.LuaObjectScript.SeesRuneBowl06_Banter()
  end
  pushBlockState = state
end
function StartSonSequence()
  if burnableBurnt == true then
    return
  end
  GameObjects.LTW_Boost.LuaObjectScript.Disable()
  GameObjects.EntZn_CA_EnableWaitforBlock:HideEntityVolume()
  if pushBlockState == "right" then
    JumpOnBlock()
  else
    GameObjects.Point_WaitForBlock.LuaObjectScript.Enable()
  end
end
function WaitingForPushBlock()
  if burnableBurnt == true then
    return
  end
  progress = "readyForBlock"
  if pushBlockState == "right" then
    JumpOnBlock()
  else
    print("Play Banter 3")
    GameObjects.Riv925_Banter.LuaObjectScript.SeesRuneBowl03_Banter()
    StartLevelTimer(15, WaitingforBlock_HintBanter)
  end
end
function WaitingforBlock_HintBanter()
  if burnableBurnt == true then
    return
  end
  if pushBlockState == "left" or pushBlockState == nil then
    print("Play Banter 7")
    GameObjects.Riv925_Banter.LuaObjectScript.SeesRuneBowl07_Banter()
  end
end
function JumpOnBlock()
  if burnableBurnt == true then
    return
  end
  progress = "onBlock"
  TP_PushBlocks[1]:ShowTraverseLink()
  crankObject.LuaObjectScript.Lock()
  GameObjects.Point_WaitForBlock.LuaObjectScript.Disable()
  GameObjects.LTW_JumptToBlock.LuaObjectScript.Enable()
end
function EnterBlock()
  TP_PushBlocks[1]:HideTraverseLink()
  timers.StartLevelTimer(0.25, PositionOnBlock)
end
function PositionOnBlock()
  GameObjects.LTW_JumptToBlock.LuaObjectScript.Disable()
  GameObjects.Point_OnBlock.LuaObjectScript.Enable()
end
function ReadyOnBlock()
  progress = "readyOnBlock"
  camZoneBlockSlideStage1:HideCameraVolume()
  crankObject.LuaObjectScript.Unlock()
end
function Banter_SonRide()
  print("Play Banter 5")
  GameObjects.Riv925_Banter.LuaObjectScript.SeesRuneBowl05_Banter()
end
function JumpOffBlock()
  progress = "bowlEnabled"
  TP_PushBlocks[2]:ShowTraverseLink()
  crankObject.LuaObjectScript.Lock()
  if pushBlockMonitor ~= nil then
    pushBlockMonitor = nil
  end
  GameObjects.Point_OnBlock.LuaObjectScript.Disable()
  GameObjects.LTW_SandBowlFinish.LuaObjectScript.Enable()
end
function EnableSandBowl()
  sandBowl.LuaObjectScript.Enable()
end
function BlockDone()
  if pushBlockState == "left" then
    crankObject.LuaObjectScript.Unlock()
    TP_PushBlocks[2]:HideTraverseLink()
    game.World.StoreCheckpoint({
      OverrideObject = GameObjects.ChkOvr_BowlEnabled.Child
    })
  end
end
function AtBowl()
  local availabilityState = {
    AvailableForSync = false,
    AvailableForBanter = true,
    AvailableInLevel = true,
    AvailableForCombat = true,
    Unoccupied = false
  }
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  if progress == "atBowl" or progress == "bowlCompleted" then
    return
  end
  progress = "atBowl"
  ShowNavObstacle()
  son:CallScript("OnStandGround", true)
end
function BeginRuneHintBanter()
  if game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    StartLevelTimer(12, function()
      if runeDiscoverd == false then
        game.Audio.PlayBanter("RIV_BasementBowl2")
      end
    end)
  end
  StartLevelTimer(34, function()
    if runeDiscoverd == false then
      game.Audio.PlayBanter("RIV_BasementBowl3")
    end
  end)
end
function DiscoverRune()
  if runeDiscoverd == false then
    runeDiscoverd = true
    sandBowl.LuaObjectScript.SetRuneDiscovered()
    sandBowl.LuaObjectScript.SetQuestionGiven()
  end
end
function BoardBroken_01()
  boardsCounter = boardsCounter + 1
  CheckEnableRune()
end
function BoardBroken_02()
  boardsCounter = boardsCounter + 1
  CheckEnableRune()
end
function BoardBroken_03()
  boardsCounter = boardsCounter + 1
  CheckEnableRune()
end
function CheckEnableRune()
  if 3 <= boardsCounter then
    cielingRuneInteract.LuaObjectScript.Enable()
  end
end
function ShowBeckonZone()
  GameObjects.EntZn_PuzzleBeckon:ShowEntityVolume()
  GameObjects.EntZn_PuzzleBeckon_TextOn:ShowEntityVolume()
  GameObjects.EntZn_PuzzleBeckon_TextOff:ShowEntityVolume()
end
function HideBeckonZone()
  GameObjects.EntZn_PuzzleBeckon:HideEntityVolume()
  GameObjects.EntZn_PuzzleBeckon_TextOn:HideEntityVolume()
  GameObjects.EntZn_PuzzleBeckon_TextOff:HideEntityVolume()
end
function ShowBeconText()
  uiCalls.SendBottomDesignerMessage({
    Text = 43051,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER
  })
end
function HideBeckonText()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function BowlCompleted()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  GameObjects.EntZn_PuzzleBeckon:HideEntityVolume()
  GameObjects.EntZn_PuzzleBeckon_TextOn:HideEntityVolume()
  GameObjects.EntZn_PuzzleBeckon_TextOff:HideEntityVolume()
  HideBeckonText()
  progress = "bowlCompleted"
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_LOW",
    Duration = 5,
    TweenIn = {Time = 1},
    TweenOut = {Time = 2}
  })
  game.Blender.Trigger({
    Name = "FSE_SWAY_CRANK_RUMBLE_SMALL",
    Duration = 5,
    TweenIn = {Time = 1},
    TweenOut = {Time = 2}
  })
  PlatformRepaired()
  engine.SendHook("OnStandGround", son, true)
  LD.CallFunctionAfterDelay(function()
    GameObjects.ReactionStim_PlatformAnimating.LuaObjectScript:Trigger()
  end, 0.2)
  local availabilityState = {Unoccupied = true}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  GameObjects.LTW_UpperPuzzle.LuaObjectScript.Disable()
  GameObjects.LTW_UpperPuzzle_Lead.LuaObjectScript.Disable()
  GameObjects.EntZn_SwitchUpperLead:HideEntityVolume()
  GameObjects.EntZn_EnableSandBowl:HideEntityVolume()
  GameObjects.EntZn_KratosBonusArea_SplneOn:HideEntityVolume()
  GameObjects.EntZn_EnableSandBowl:HideEntityVolume()
  _G.DisableBuddyBoost()
end
function PlatformRepaired()
  floatingPlatform:PlayAnimToEnd(0.4)
  PlayFloatingPlatformLowerLoop()
  floatingPlatform:OnAnimDone(thisObj, "PlatformDone")
end
function secretChestOpen()
  StartLevelTimer(6, function()
    thisLevel:Broadcast("Area_2_EnctounterTrigger")
  end)
  if game.Level.GetVariable("CompletedCineNumber") < 180 then
    GameObjects.EntZn_Arena2_Encounter_Witch:ShowEntityVolume()
  end
end
function PlatformDone()
  if floatingPlatform.AnimPercent ~= 1 then
    floatingPlatform:JumpAnimToPercent(1)
  end
  StopFloatingPlatformLowerLoop()
  engine.SendHook("OnStandGround", son, false)
  GameObjects.TL_SandBowlJump:ShowTraverseLink()
  GameObjects.LTW_SandBowlFinish.LuaObjectScript.Disable()
  GameObjects.LTW_UpperPuzzle.LuaObjectScript.Disable()
  GameObjects.Follow_ToSandbowl.LuaObjectScript.Enable()
  GameObjects.CA_SandBowlExit.LuaObjectScript.Enable()
end
function PlayerEnteredPlatform(...)
  engine.SendHook("OnStandGround", son, false)
end
function HideNavObstacle()
  GameObjects.NavObstacle_PushBlock:HideNavObstacle()
  progress = "none"
end
function ShowNavObstacle()
  GameObjects.NavObstacle_PushBlock:ShowNavObstacle()
end
local floatingPlatformEmitter
local floatingPlatformLoop = "SND_CINE_Cave_Platform_Lower_Riv925_LP"
function SoundInit()
  floatingPlatformEmitter = floatingPlatform.SoundEmitters[1]
end
function PlayFloatingPlatformLowerLoop()
  LD.PlaySound(floatingPlatformEmitter, floatingPlatformLoop)
end
function StopFloatingPlatformLowerLoop()
  LD.StopSound(floatingPlatformEmitter, floatingPlatformLoop)
end
function BurnableBurnt()
  burnableBurnt = true
  if progress == "readyForBlock" then
    GameObjects.Point_WaitForBlock.LuaObjectScript.Interrupt()
    GameObjects.Point_WaitForBlock.LuaObjectScript.Disable()
  elseif progress == "none" then
    GameObjects.Point_WaitForBlock.LuaObjectScript.Interrupt()
    GameObjects.Point_WaitForBlock.LuaObjectScript.Disable()
    GameObjects.LTW_Boost.LuaObjectScript.Disable()
    GameObjects.EntZn_CA_EnableWaitforBlock:HideEntityVolume()
  end
  _G.FIXUP_INT_89525()
end
function IsBurnableBurnt()
  return GameObjects.flammableBramble4x3.Child:FindSingleGOByName("flammableBramble4x2"):FindSingleGOByName("flammablePile00"):GetBreakable().Broken
end
