local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local CCOS = require("camera.camera_oneshot")
local TUT = require("game.GlobalTutorials")
local uiCalls = require("ui.uicalls")
local LM = require("level.loadmonitor")
local thisLevel, son, player, firstEncounter, reached2ndElevator, elevator1Up, elevator2Up
local phaseComplete = 0
local sonBoosted, BoostHintTimer, pathToWell_Open, upperAccess, upperWoodBroken, sonAtBowl, rememberBoost, backToTyrTemple_BanterPlayed
local wellRead = false
local hiddenRoomOpen = false
local lookAtInteractDone = false
local kratosOnTheBlock = false
local restartBackToTemple
local pushBlock01PushedOffLedge = false
local sonPushBlock, sidewaysCrankDropBlock
function OnScriptLoaded(level)
  thisLevel = level
  son = game.AI.FindSon()
  player = game.Player.FindPlayer()
  sonPushBlock = GameObjects.PushBlock2
  sidewaysCrankDropBlock = GameObjects.PushBlock_Side:FindSingleGOByName("StraightCrankHandleSidewaysOfficial")
  SoundOnInit()
end
function OnFirstStart(level)
  GameObjects.TemporalBridge01:Hide()
  GameObjects.TemporalBridge01:HideCollision()
  GameObjects.TemporalBridge02:Hide()
  GameObjects.TemporalBridge02:HideCollision()
  GameObjects.TemporalBridge03:Hide()
  GameObjects.TemporalBridge03:HideCollision()
  GameObjects.GapJumpFloorCollision4:HideCollision()
  GameObjects.TL_UpperAreaAccess:HideTraverseLink()
  GameObjects.EntZn_TurtleRear_Down:HideEntityVolume()
  GameObjects.TL_EasyRoute02:HideTraverseLink()
  GameObjects.TL_SandBowlJump:ShowTraverseLink()
  LD.DisableBoatLore()
  GameObjects.LoadZone_UpperExit_Helpers:HideEntityVolume()
  GameObjects.TL_Kratos01_Left:HideTraverseLink()
  GameObjects.TL_Kratos01_Right:HideTraverseLink()
  GameObjects.TL_Kratos02_Left:HideTraverseLink()
  GameObjects.TL_Kratos02_Right:HideTraverseLink()
  GameObjects.TL_Kratos03_Right:HideTraverseLink()
  GameObjects.Water_04:Hide()
  GameObjects.EntZn_Arena2_Encounter_Witch:HideEntityVolume()
  GameObjects.EntZn_CA_SandBowlAreaDisable:HideEntityVolume()
  GameObjects.EntZn_CA_SandBowlAreaEnable:HideEntityVolume()
  game.Compass.SetGatewayMarkerIsOpen("RP_925_Helper2", false)
  sidewaysCrankDropBlock.LuaObjectScript.SetMaxStopCycle(5)
end
function OnStart(level)
  if game.InGameplayOnlyPlaytestMode() then
    GameObjects.FreyaCaveBoat_00.Child.LuaObjectScript.Disable()
  end
  GameObjects.BanterZone_TurtleUp.LuaObjectScript.DisableConsoleError("RIV_TurtleUp")
  GameObjects.EntZn_PostRevived_SpeedControl:HideEntityVolume()
  GameObjects.EntZn_CheckPoint_SonRetrieved:HideEntityVolume()
  GameObjects.EntZn_PuzzleBeckon:HideEntityVolume()
  GameObjects.EntZn_PuzzleBeckon_TextOn:HideEntityVolume()
  GameObjects.EntZn_PuzzleBeckon_TextOff:HideEntityVolume()
  CheckIfCameraZonesNeedToBeHidden()
  if rememberBoost then
    EnableSonBoost_Scaffold()
  end
  local waterLevel = LD.GetCurrentWaterLevel()
  if waterLevel == 2 then
    game.Compass.SetGatewayMarkerIsOpen("RP_925_HelperGate", false)
    game.Compass.SetGatewayMarkerIsOpen("RP_obj925", false)
  end
  if not hiddenRoomOpen then
    local ClimbPath = thisLevel:FindTraversePath("CrackClimb_Open")
    ClimbPath:Disable("ClimbExitPoint")
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 250 and game.Level.GetVariable("CompletedCineNumber") < 330 then
    GameObjects.Scripted_Sheet_Freya_House:ShowCollision()
    GameObjects.Scripted_Sheet_Freya_House_Ground:HideCollision()
  else
    GameObjects.Scripted_Sheet_Freya_House:HideCollision()
    GameObjects.Scripted_Sheet_Freya_House_Ground:ShowCollision()
  end
  if game.Level.GetVariable("CompletedCineNumber") == 387 then
    HealSon_SetOccupied()
    GameObjects.EntZn_HealSon_SetOccupied:ShowEntityVolume()
    GameObjects.EntZn_HealSon_ClearOccupied:ShowEntityVolume()
    GameObjects.FollowIntro.LuaObjectScript.Disable()
  else
    GameObjects.EntZn_HealSon_SetOccupied:HideEntityVolume()
    GameObjects.EntZn_HealSon_ClearOccupied:HideEntityVolume()
  end
  if restartBackToTemple then
    ReplayBackToTempleBanter()
  else
    GameObjects.EntZn_PostHeal_SpeedControl:HideEntityVolume()
  end
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = LowerWater_Level01,
    fn = LowerWater_Level01
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = LowerWater_Level02,
    fn = LowerWater_Level02
  })
  LD.RegisterForCineUpdate(level, {
    {
      at = 180,
      immediateFn = function()
        GameObjects.UpperDeathPlane:HideCollision()
        GameObjects.FreyaCaveBoat_00.LuaObjectScript.Disable()
      end,
      fn = function()
        GameObjects.UpperDeathPlane:HideCollision()
        GameObjects.FreyaCaveBoat_00.LuaObjectScript.Disable()
        BoatLoadZone_Hide()
      end
    }
  })
  if not wellRead then
    GameObjects.rune_12_Well.Child:JumpAnimToFrame(0)
    GameObjects.rune_12_Well.Child:PauseAnim()
  else
    local animLength = GameObjects.rune_12_Well.Child.AnimLengthFrames
    GameObjects.rune_12_Well.Child:JumpAnimToFrame(animLength)
    GameObjects.rune_12_Well.Child:PlayAnimToEnd()
    HideWellEffects()
  end
  SoundOnStart()
  local CeilingRuneInteract = GameObjects.CeilingRuneInteract.LuaObjectScript.GetInteractZone()
  CeilingRuneInteract:SetXZRange(20)
  CeilingRuneInteract:SetAngle(150)
  CeilingRuneInteract:SetHintXZRange(32)
  CeilingRuneInteract:SetHintAngle(150)
  if GameObjects.flammableBramble4x3.LuaObjectScript ~= nil and GameObjects.flammableBramble4x3.LuaObjectScript.IsChildBurned() == true then
    GameObjects.sonboost_scaffold.LuaObjectScript.Disable()
    sonPushBlock.LuaObjectScript.UnlockCrank()
  end
end
function LowerWater_Level01()
  GameObjects.Water_03:Hide()
  GameObjects.Water_04:Show()
end
function LowerWater_Level02()
  GameObjects.Water_03:Hide()
  GameObjects.Water_04:Show()
end
function OnEvaluateLoadGroup_LoadGroup_AI()
  if game.Level.GetVariable("CompletedCineNumber") < 180 then
    return "AI_Visit_01"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 180 and game.Level.GetVariable("CompletedCineNumber") < 320 then
    return "AI_Visit_01_Retraversal"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 320 and game.Level.GetVariable("CompletedCineNumber") < 331 then
    return "AI_Visit_02"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 360 and game.Level.GetVariable("CompletedCineNumber") < 371 then
    return "FreyaTendsSon"
  elseif game.Level.GetVariable("CompletedCineNumber") > 370 and game.Level.GetVariable("CompletedCineNumber") < 590 then
    return "SonHealed_DemiGodReveal"
  else
    return "AI_Visit_02"
  end
end
function OnEvaluateLoadGroup_LoadGroup_PuzzleArea()
  if game.Level.GetVariable("CompletedCineNumber") < 180 then
    return nil
  elseif game.Level.GetVariable("CompletedCineNumber") >= 180 and game.Level.GetVariable("CompletedCineNumber") < 320 then
    return nil
  elseif game.Level.GetVariable("CompletedCineNumber") >= 320 and game.Level.GetVariable("CompletedCineNumber") < 331 then
    return "AI_Visit_02"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 360 and game.Level.GetVariable("CompletedCineNumber") < 371 then
    return nil
  elseif game.Level.GetVariable("CompletedCineNumber") > 370 and game.Level.GetVariable("CompletedCineNumber") < 590 then
    return "SonHealed_DemiGodReveal"
  else
    return "Only_AI_Visit_03"
  end
end
function Finish_Helheim_Objective022()
  GameObjects.EntZn_PostHeal_SpeedControl:HideEntityVolume()
  GameObjects.LTW_ReturnToHouseReverse.LuaObjectScript.Disable()
  GameObjects.TP_Well1:ShowTraversePath()
  backToTyrTemple_BanterPlayed = true
  ClearSonOccupied()
  LD.SetMarkerState("Riv925_FreyaHouse", 0)
  LD.SetMarkerState("RP_935_Lower_FT", 1)
  ReturnToBoatQuestUI()
  game.Compass.SetDesignerForcedHide(false)
  restartBackToTemple = false
  game.World.StoreCheckpoint()
end
function ReturnToBoatQuestUI()
  uiCalls.UI_Event_SendMsgToQuestLog({
    Category = 10250,
    Header = 37404,
    Body = 1410,
    MessageType = tweaks.tQuestUiMessage.eMessageType.kQMS_Default,
    Quest = "Quest_Caldera_Objective360"
  })
end
function ReplayBackToTempleBanter()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("RIV_BackToTyrsTemple", Finish_Helheim_Objective022)
  end, 3.5)
end
function MimirRevivedSlowZone_Enable()
  GameObjects.EntZn_PostRevived_SpeedControl:ShowEntityVolume()
end
function MimirRevivedSlowZone_Disable()
  GameObjects.EntZn_PostRevived_SpeedControl:HideEntityVolume()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    phaseComplete = phaseComplete,
    elevator1Up = elevator1Up,
    sonBoosted = sonBoosted,
    pathToWell_Open = pathToWell_Open,
    upperAccess = upperAccess,
    upperWoodBroken = upperWoodBroken,
    rememberBoost = rememberBoost,
    backToTyrTemple_BanterPlayed = backToTyrTemple_BanterPlayed,
    wellRead = wellRead,
    hiddenRoomOpen = hiddenRoomOpen,
    restartBackToTemple = restartBackToTemple,
    pushBlock01PushedOffLedge = pushBlock01PushedOffLedge
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  phaseComplete = savedInfo.phaseComplete
  elevator1Up = savedInfo.elevator1Up
  sonBoosted = savedInfo.sonBoosted
  pathToWell_Open = savedInfo.pathToWell_Open
  upperAccess = savedInfo.upperAccess
  upperWoodBroken = savedInfo.upperWoodBroken
  rememberBoost = savedInfo.rememberBoost
  backToTyrTemple_BanterPlayed = savedInfo.backToTyrTemple_BanterPlayed
  wellRead = savedInfo.wellRead
  hiddenRoomOpen = savedInfo.hiddenRoomOpen
  restartBackToTemple = savedInfo.restartBackToTemple
  pushBlock01PushedOffLedge = savedInfo.pushBlock01PushedOffLedge
end
function TriggerLookAtSickSon()
  player:TriggerMoveEvent("kLE_CarrySonHeadAdditive")
end
function TriggerLookAtSickSon_Faster()
  player:TriggerMoveEvent("kLE_CarrySonHeadAdditive_Faster")
end
function IncreaseSonCarrySpeed()
  player:TriggerMoveEvent("kLE_CarrySonSpeedUp")
end
function PathToWellOpen()
  GameObjects.Riv925_Banter.LuaObjectScript.WellPath_Opened()
  GameObjects.CA2_Area1_Fwd_02.LuaObjectScript.Disable()
  pathToWell_Open = true
  GameObjects.Lead_ToWell.LuaObjectScript.Enable()
  GameObjects.CA2_Area1_Up_01.LuaObjectScript.Enable()
  GameObjects.LTW_ReturnToHouse.LuaObjectScript.Disable()
  GameObjects.Cbt_Riv925_V1_Script.LuaObjectScript.Start_A1E3()
end
function WellRuneRead()
  wellRead = true
  local wellEmitter = GameObjects.WellRead_SNDGroup:FindSingleSoundEmitterByName("SND_WellRead")
  GameObjects.rune_12_Well.Child:PlayAnimToEnd()
  LD.PlaySound(wellEmitter, "SND_MAG_Rune_Read_Burn_Away_LP")
  GameObjects.rune_12_Well.Child:OnAnimDone(thisLevel, "HideWellEffects")
  LD.UpdateJournal("RIV_925_Lore_01", 1)
  LD.ActivateAndIncrementQuest("RegionSummary_RP_LoreMarker_Parent")
end
function HideWellEffects()
  if GameObjects.rune_12_Well.Child then
    local wellEmitter = GameObjects.WellRead_SNDGroup:FindSingleSoundEmitterByName("SND_WellRead")
    LD.StopSound(wellEmitter, "SND_MAG_Rune_Read_Burn_Away_LP")
    LD.HideFX(GameObjects.rune_12_Well.Child)
  end
end
function ChangePathingDelay()
  LD.CallFunctionAfterDelay(ChangePathing, 4)
end
function ChangePathing()
  game.Compass.SetGatewayMarkerIsOpen("RP_925_Helper", false)
  game.Compass.SetGatewayMarkerIsOpen("RP_925_Helper2", true)
  game.Compass.OnWarp()
end
function DisableChest()
  GameObjects.chest_locked_tier1_riv925_1.LuaObjectScript:Disable()
end
function HeartCollected()
  game.Level.SetVariable("CompletedCineNumber", 388)
end
function FirstEncounterStart()
  if game.Level.GetVariable("CompletedCineNumber") < 200 then
    firstEncounter:Start()
    GameObjects.SonGoToWait00.LuaObjectScript:SonResume()
  end
end
function WaterPushblockPushedForward()
  local currentCrankCycle = GameObjects.PushBlock_Side.LuaObjectScript.GetCurrentCycle()
  if currentCrankCycle == 6 then
    sidewaysCrankDropBlock.LuaObjectScript.Disable()
  elseif currentCrankCycle == 9 then
    local breakableDraugr = thisLevel:FindSingleGameObject("Draugr_Breakable_02")
    breakableDraugr = breakableDraugr and breakableDraugr.Child
    breakableDraugr = breakableDraugr and breakableDraugr:GetBreakable()
    if breakableDraugr and not breakableDraugr.Broken then
      breakableDraugr:Break()
    end
  end
  PlaySoundOnWaterPushBlockForward()
end
function WaterPushblockPulledBack()
  if GameObjects.PushBlock_Side.LuaObjectScript.GetCurrentCycle() == 5 then
    sidewaysCrankDropBlock.LuaObjectScript.Enable()
  end
  PlaySoundOnWaterPushBlockBackward()
end
function WaterPushBlockPaused()
  PlaySoundOnWaterPushBlockPause()
end
function PushBlock01AtEnd()
  pushBlock01PushedOffLedge = true
  sidewaysCrankDropBlock.LuaObjectScript.Disable()
  if game.Level.GetVariable("_GBL_WaterDrop01Triggered") == false then
    LD.CallFunctionAfterDelay(function()
      LD.ShowFX(GameObjects.FX_Crate_Splash)
    end, 0.9)
  end
  PlaySoundPushBlockIntoWater()
  GameObjects.TL_EasyRoute02:ShowTraverseLink()
  GameObjects.CA2_Forward_Area2_01.LuaObjectScript.Enable()
  GameObjects.CA_WaitForPushBlock.LuaObjectScript.Disable()
  GameObjects.GapJumpCollision4:HideCollision()
  GameObjects.GapJumpFloorCollision4:ShowCollision()
  GameObjects.NavObstacle_WaterPushblock:HideNavObstacle()
  GameObjects.Riv925_Banter.LuaObjectScript.DoNotTouchTheWater_Banter()
end
function PuzzleBailOut()
  if sonBoosted then
    sonBoosted = false
    GameObjects.LTW_Boost.LuaObjectScript.Disable()
    GameObjects.Follow_ToSandbowl.LuaObjectScript.Enable()
    GameObjects.entityZone_onPushblock:HideEntityVolume()
    GameObjects.Point_WaitForBlock.LuaObjectScript.Disable()
    GameObjects.Point_OnBlock.LuaObjectScript.Disable()
    GameObjects.PushBlock2.LuaObjectScript.DisableSandBowl()
    ClearSonOccupied()
    timer.StartLevelTimer(1, function()
      son:Warp(GameObjects.loc_puzzle_Bailout:GetWorldPosition(), GameObjects.loc_puzzle_Bailout:GetWorldForward())
    end)
    if not upperAccess then
      GameObjects.EntZn_CA_EnableWaitforBlock:ShowEntityVolume()
      GameObjects.sonboost_scaffold.LuaObjectScript.Enable()
    end
  end
end
function ChiselArenaEntrance()
  GameObjects.CrackClimb_Open:HideTraversePath()
  CA_SandBowlArea_Disable()
end
function ChiselArenaExit()
  if hiddenRoomOpen then
    GameObjects.CrackClimb_Open:ShowTraversePath()
  end
end
function ExitChiselDungeonIntoRiv925()
  local riv935Monitor = LM.CreateLoadMonitor()
  riv935Monitor:AddCallback({
    Wads = {
      "Riv935_FreyaElevator"
    },
    Functions = {
      Riv935Loaded
    }
  })
end
function Riv935Loaded(wads)
  wads.Riv935_FreyaElevator:CallScript("JumpElevatorToTop")
end
function ElevatorCollisionOn()
  GameObjects.Water_04:HideCollision()
end
function ElevatorAtBottom()
  GameObjects.Water_04:ShowCollision()
end
function ElevatorAtTop()
  GameObjects.ElevatorCollisionHelper:HideCollision()
  GameObjects.Water_04:ShowCollision()
  CA_CaveStart_Enable()
  GameObjects.CA_SyncExitElevator.LuaObjectScript.Enable()
end
function ShowTemporalBridge01()
  GameObjects.GapJumpCollision1:Hide()
  GameObjects.GapJumpCollision1:HideCollision()
end
function ShowTemporalBridge02()
  GameObjects.GapJumpCollision2:Hide()
  GameObjects.GapJumpCollision2:HideCollision()
  GameObjects.EntZn_DisableCrystalCollision:HideEntityVolume()
  if game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    GameObjects.ReactionStim_Crystal2.LuaObjectScript.Trigger()
  end
end
function ShowTemporalBridge03()
  GameObjects.GapJumpCollision3:Hide()
  GameObjects.GapJumpCollision3:HideCollision()
  GameObjects.EntZn_CA_TripleChestArea_Enable:ShowEntityVolume()
  GameObjects.EntZn_CA_TripleChestArea_Disable:ShowEntityVolume()
  if game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    GameObjects.ReactionStim_Crystal1.LuaObjectScript.Trigger()
  end
end
function Crystal2Col_Hide()
  GameObjects.TempCrystal02.Child.Child:HideCollision()
end
function Crystal2Col_Show()
  GameObjects.TempCrystal02.Child.Child:ShowCollision()
end
function ActiveLiftGate()
  GameObjects.LiftDoorGate01.LuaObjectScript:Enable()
  GameObjects.TempBlockerPuz1:HideCollision()
  GameObjects.TempBlockerPuz4:HideCollision()
  GameObjects.TempBlockerPuz2:HideCollision()
end
function HiddenRoomOpen()
  hiddenRoomOpen = true
  GameObjects.CrackClimb_Open:ShowTraversePath()
  local ClimbPath = thisLevel:FindTraversePath("CrackClimb_Open")
  ClimbPath:Enable("ClimbExitPoint")
  GameObjects.LoadZone_ChiselArea:ShowEntityVolume()
  if game.Level.GetVariable("CompletedCineNumber") ~= 390 then
    GameObjects.ReactionStim_Sap1.LuaObjectScript.Trigger()
  end
end
function UpperAreaOpen()
  rememberBoost = false
  GameObjects.TL_UpperAreaAccess:ShowTraverseLink()
  GameObjects.PushblockIC:HideCollision()
  GameObjects.EntZn_CA_EnableWaitforBlock:HideEntityVolume()
  GameObjects.LTW_UpperPuzzle.LuaObjectScript.Enable()
  GameObjects.CA_SonToUpperArea.LuaObjectScript.Enable()
  GameObjects.EntZn_CA_BanterSonRide:HideEntityVolume()
  GameObjects.entityZone_onPushblock:HideEntityVolume()
  GameObjects.EntZn_SonJumpedFromBlcok:HideEntityVolume()
  CA_SetContext_Clear()
  GameObjects.PushBlock2.LuaObjectScript.BurnableBurnt()
end
function SwitchToSandBowlLead()
  GameObjects.LTW_UpperPuzzle.LuaObjectScript.Disable()
  GameObjects.LTW_UpperPuzzle_Lead.LuaObjectScript.Enable()
  GameObjects.LTW_Boost.LuaObjectScript.Disable()
end
function SideAreaRevist()
  print("start second visit side encouter ")
end
function EnablePushBlock()
  GameObjects.StraightCrankSidewaysHandle.LuaObjectScript:Enable()
end
function temp_HousePositionCheck()
  if game.Level.GetVariable("CompletedCineNumber") == 387 then
    local riv480
    riv480 = game.FindLevel("Riv480_FreyaHouse")
    riv480:CallScript("Riv480_Bookmark_SonHealed")
  end
end
function HouseDefenseUp()
  if game.Level.GetVariable("CompletedCineNumber") >= 250 and game.Level.GetVariable("CompletedCineNumber") < 330 then
    local riv480 = game.FindLevel("Riv480_FreyaHouse")
    if riv480 ~= nil then
      riv480:CallScript("MimirRevivHousePositionCheck")
    end
    GameObjects.EntZn_TurtleRear_Down:ShowEntityVolume()
  end
end
function WellLoadCheck()
  game.UI.LoadCheck("Riv475_FreyaHouseExt")
end
function HouseDefenseDown()
  if game.Level.GetVariable("CompletedCineNumber") >= 250 and game.Level.GetVariable("CompletedCineNumber") < 330 then
    local riv480 = game.FindLevel("Riv480_FreyaHouse")
    if riv480 ~= nil then
      riv480:CallScript("CreatureUnderIdle")
    end
  end
end
function RemoveDefenseTriggerZones()
  GameObjects.EntZn_TurtleRear_Up:HideEntityVolume()
  GameObjects.EntZn_TurtleRear_Down:HideEntityVolume()
end
function UpdateHouseCollision()
  GameObjects.Scripted_Sheet_Freya_House:HideCollision()
  GameObjects.Scripted_Sheet_Freya_House_Ground:ShowCollision()
end
function EnableLTWIntro()
  GameObjects.CA_SyncExit_FrontDoor.LuaObjectScript.Enable()
  GameObjects.LTW_Intro.LuaObjectScript.Enable()
end
function CheckIfCameraZonesNeedToBeHidden()
  local cine = game.Level.GetVariable("CompletedCineNumber")
  if 200 <= cine then
    local zonetohide = GameObjects.CamZone_PushBlockToWater
    zonetohide:HideCameraVolume()
  end
end
function GetPhase(level)
  return phaseComplete
end
function SetPhase(level, value)
  phaseComplete = value
end
function CA_SetContext_Explore()
  if game.Level.GetVariable("CompletedCineNumber") == 390 then
    son:CallScript("EnterBehaviorContext", "SAD_BEHAVIOR_CONTEXT_CONFIG")
  else
    son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  end
end
function CA_PushBlock01_Switch()
  GameObjects.CA2_Area1_Fwd_01.LuaObjectScript.Interrupt()
  GameObjects.CA2_Forward_Area2_01.LuaObjectScript.Enable()
  GameObjects.CA_Forward_Area2_01.LuaObjectScript.Enable()
end
function CA_StartingArea_Switch()
  GameObjects.CA2_Forward_Area2_01.LuaObjectScript.Interrupt()
  GameObjects.CA_Forward_Area2_01.LuaObjectScript.Interrupt()
  GameObjects.CA2_Area1_Fwd_01.LuaObjectScript.Enable()
end
function CA_SetContext_Clear()
  son:CallScript("ClearBehaviorContext")
end
function CA_CaveStart_Enable()
  print("CA_CaveStart_Enable")
  GameObjects.CA_Forward_Area2_01.LuaObjectScript:Enable()
  if game.Level.GetVariable("CompletedCineNumber") < 180 then
    GameObjects.LTW_ToPushBlock.LuaObjectScript.Enable()
    if game.Level.GetVariable("CompletedCineNumber") < 165 then
      son:CallScript("EnterBehaviorContext", "LEAD_THE_WAY_BEHAVIOR_CONTEXT_CONFIG")
    end
  elseif game.Level.GetVariable("CompletedCineNumber") == 390 then
    GameObjects.LTW_ReturnToHouseReverse.LuaObjectScript.Enable()
    GameObjects.FollowIntro.LuaObjectScript.Disable()
    GameObjects.Follow_ToPushBlock.LuaObjectScript.Enable()
    GameObjects.CA_ElevatorReady.LuaObjectScript.Enable()
  else
    CA_V2_EnableArea1()
    GameObjects.FollowIntro.LuaObjectScript.Enable()
    GameObjects.Follow_ToPushBlock.LuaObjectScript.Enable()
    GameObjects.CA_observe_down_01.LuaObjectScript.Enable()
    BoatLoadZone_Hide()
  end
  if pathToWell_Open then
    GameObjects.Follow_ToWell.LuaObjectScript.Enable()
    GameObjects.LTW_ReturnToHouse.LuaObjectScript.Disable()
  elseif game.Level.GetVariable("CompletedCineNumber") > 180 then
    GameObjects.LTW_ReturnToHouse.LuaObjectScript.Enable()
  end
end
function Riv925_FDInteractionFinish()
  if game.Level.GetVariable("CompletedCineNumber") == 390 and not backToTyrTemple_BanterPlayed then
    restartBackToTemple = true
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("RIV_BackToTyrsTemple", Finish_Helheim_Objective022)
    end, 2.5)
    GameObjects.EntZn_PostHeal_SpeedControl:ShowEntityVolume()
    SetSonOccupied()
    game.World.StoreCheckpoint()
  end
end
function CA_CaveStart_Disable()
  print("CA_CaveStart_Disable")
  GameObjects.LTW_Intro.LuaObjectScript.Disable()
  GameObjects.FollowIntro.LuaObjectScript.Disable()
  GameObjects.LTW_ToPushBlock.LuaObjectScript.Disable()
  GameObjects.Follow_ToPushBlock.LuaObjectScript.Disable()
  GameObjects.LTW_ToSandbowl.LuaObjectScript.Disable()
  GameObjects.CA_NearBoat.LuaObjectScript.Disable()
  GameObjects.CA_Forward_Area2_01.LuaObjectScript:Disable()
  GameObjects.CA_ElevatorReady.LuaObjectScript.Disable()
  GameObjects.CA_SyncExitElevator.LuaObjectScript.Disable()
  GameObjects.CA_observe_down_01.LuaObjectScript.Disable()
  son:CallScript("ClearBehaviorContext")
  CA_V2_DisableArea1()
end
function EntZn_CA_Visit_01()
end
function CA_DisableArea1()
end
function ShowSandBowlCAEntityZones()
  GameObjects.EntZn_CA_SandBowlAreaDisable:ShowEntityVolume()
  GameObjects.EntZn_CA_SandBowlAreaEnable:ShowEntityVolume()
end
function CA_SandBowlArea_Enable()
  GameObjects.LTW_ToSandbowl.LuaObjectScript.Enable()
  if game.Level.GetVariable("CompletedCineNumber") == 390 then
    GameObjects.CA_IdleBehavior_PHeal.LuaObjectScript.Enable()
  else
    GameObjects.CA_SandBowl_Forward.LuaObjectScript.Enable()
  end
end
function CA_FirstBlockWait_Enable()
  GameObjects.CA_WaitForPushBlock.LuaObjectScript:Enable()
  GameObjects.Riv925_Banter.LuaObjectScript.FirstPushBlock01_Banter()
end
function CA_FirstBlockWait_Disable()
  GameObjects.CA_WaitForPushBlock.LuaObjectScript:Disable()
end
function CA_EnableArea3()
  if BoostHintTimer then
    GameObjects.CA_Area3_LookUp_02.LuaObjectScript:Enable()
    GameObjects.CA_Area3_LookUp_03.LuaObjectScript:Enable()
  end
end
function CA_SandBowlArea_Disable()
  GameObjects.CA_SandBowl_Forward.LuaObjectScript:Disable()
  GameObjects.CA_Area3_LookUp_02.LuaObjectScript:Disable()
  GameObjects.CA_Area3_LookUp_03.LuaObjectScript:Disable()
  GameObjects.CA_Boost_Hint.LuaObjectScript:Disable()
  GameObjects.CA_IdleBehavior_PHeal.LuaObjectScript:Disable()
end
function CA_SwitchTo_Area3()
  CA_EnableArea3()
end
function Banter_Sandbowl_Close()
  GameObjects.Riv925_Banter.LuaObjectScript.SeesRuneBowl01_Banter()
end
function CA_BoostHint()
  if not BoostHintTimer then
    timer.StartLevelTimer(120, CA_EnableBoostHint)
    BoostHintTimer = true
    CA_EnableArea3()
  end
end
function EnableSonBoost_Scaffold()
  if GameObjects.flammableBramble4x3.LuaObjectScript ~= nil and GameObjects.flammableBramble4x3.LuaObjectScript.IsChildBurned() == false then
    GameObjects.sonboost_scaffold.LuaObjectScript.Enable()
    rememberBoost = true
  end
end
function DisableBuddyBoost()
  upperAccess = true
end
function SonBoostUsed()
  GameObjects.LTW_Boost.LuaObjectScript.Enable()
  GameObjects.LTW_ToSandbowl.LuaObjectScript.Disable()
  GameObjects.Follow_ToSandbowl.LuaObjectScript.Disable()
  rememberBoost = false
  sonBoosted = true
  CA_SetContext_Clear()
  CA_SandBowlArea_Disable()
  if GameObjects.flammableBramble4x3.LuaObjectScript ~= nil and GameObjects.flammableBramble4x3.LuaObjectScript.IsChildBurned() == false then
    GameObjects.EntZn_CA_BanterSonRide:ShowEntityVolume()
    GameObjects.PushBlock2.LuaObjectScript.ShowBeckonZone()
    GameObjects.entityZone_onPushblock:ShowEntityVolume()
    SetSonOccupied()
  end
end
function SetSonOccupied()
  local availabilityState = {Unoccupied = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function ClearSonOccupied()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
end
function CA_EnableBoostHint()
  if not sonBoosted then
    GameObjects.CA_Boost_Hint.LuaObjectScript.Enable()
  end
end
function CA_OnTracks_Disable()
end
function Banter_BoostHint()
  GameObjects.Riv925_Banter.LuaObjectScript.SeesRuneBowl02_Banter()
  GameObjects.Riv925_Banter.LuaObjectScript.SeesRuneBowl02_Banter()
end
function CA_V2_EnableArea1()
  if not pathToWell_Open then
    GameObjects.CA2_Area1_Up_HouseGone.LuaObjectScript.Enable()
  elseif game.Level.GetVariable("CompletedCineNumber") < 330 then
    GameObjects.CA2_Area1_Up_01.LuaObjectScript.Enable()
  end
  GameObjects.CA2_Area1_Fwd_01.LuaObjectScript.Enable()
  GameObjects.CA2_Area1_Fwd_02.LuaObjectScript.Enable()
end
function CA_V2_DisableArea1()
  GameObjects.CA2_Area1_Up_HouseGone.LuaObjectScript.Disable()
  GameObjects.CA2_Area1_Fwd_01.LuaObjectScript.Disable()
  GameObjects.CA2_Area1_Fwd_02.LuaObjectScript.Disable()
  GameObjects.CA2_Area1_Up_01.LuaObjectScript.Disable()
end
function CA_TripleChestArea_Enable()
  GameObjects.CA2_Forward_Area2_01.LuaObjectScript.Disable()
  GameObjects.CA2_Idle_TripleChest.LuaObjectScript.Enable()
end
function CA_TripleChestArea_Disable()
  GameObjects.CA2_Forward_Area2_01.LuaObjectScript.Enable()
  GameObjects.CA2_Idle_TripleChest.LuaObjectScript.Disable()
end
function CA_V2_DisableArea3()
  GameObjects.CA2_Area3_Idle_01.LuaObjectScript.Disable()
end
function CA2_V2_DisableAll()
  CA_V2_DisableArea1()
end
function CA_UpperPuzzle()
  GameObjects.CA_SonToUpperArea.LuaObjectScript.Enable()
  GameObjects.LTW_UpperPuzzle.LuaObjectScript.Enable()
  GameObjects.Follow_ToSandbowl.LuaObjectScript.Disable()
  GameObjects.LTW_ToSandbowl.LuaObjectScript.Disable()
  GameObjects.entityZone_onPushblock:HideEntityVolume()
  CA_SandBowlArea_Disable()
end
function KratosOnBlock()
  kratosOnTheBlock = true
end
function KratoOffBlock()
  kratosOnTheBlock = false
end
function CheckIfKratosCanJump()
  if game.Level.GetVariable("CompletedCineNumber") >= 180 then
    if sonPushBlock.AnimFrame < 55 then
      GameObjects.TL_Kratos01_Left:HideTraverseLink()
      GameObjects.TL_Kratos01_Right:HideTraverseLink()
      GameObjects.TL_Kratos02_Left:HideTraverseLink()
      GameObjects.TL_Kratos02_Right:HideTraverseLink()
      GameObjects.TL_Kratos03_Right:HideTraverseLink()
      GameObjects.GapJumpIC_Right:HideCollision()
      GameObjects.GapJumpIC_Left:HideCollision()
      GameObjects.Point_OnBlock.LuaObjectScript.Disable()
    elseif sonPushBlock.AnimFrame >= 55 and sonPushBlock.AnimFrame <= 65 then
      if upperWoodBroken then
        GameObjects.TL_Kratos01_Left:ShowTraverseLink()
      end
      GameObjects.TL_Kratos01_Right:ShowTraverseLink()
      GameObjects.TL_Kratos02_Left:HideTraverseLink()
      GameObjects.TL_Kratos02_Right:HideTraverseLink()
      GameObjects.TL_Kratos03_Right:HideTraverseLink()
      GameObjects.GapJumpIC_Left:ShowCollision()
      GameObjects.GapJumpIC_Right:ShowCollision()
    elseif sonPushBlock.AnimFrame >= 85 and sonPushBlock.AnimFrame <= 95 then
      if upperWoodBroken then
        GameObjects.TL_Kratos02_Left:ShowTraverseLink()
      end
      GameObjects.TL_Kratos02_Right:ShowTraverseLink()
      GameObjects.TL_Kratos01_Left:HideTraverseLink()
      GameObjects.TL_Kratos01_Right:HideTraverseLink()
      GameObjects.TL_Kratos03_Right:HideTraverseLink()
      GameObjects.GapJumpIC_Left:ShowCollision()
      GameObjects.GapJumpIC_Right:ShowCollision()
    elseif sonPushBlock.AnimFrame >= 115 and sonPushBlock.AnimFrame <= 125 then
      GameObjects.TL_Kratos03_Right:ShowTraverseLink()
      GameObjects.TL_Kratos02_Left:HideTraverseLink()
      GameObjects.TL_Kratos02_Right:HideTraverseLink()
      GameObjects.TL_Kratos01_Left:HideTraverseLink()
      GameObjects.TL_Kratos01_Right:HideTraverseLink()
      GameObjects.GapJumpIC_Left:ShowCollision()
      GameObjects.GapJumpIC_Right:ShowCollision()
    elseif sonPushBlock.AnimFrame > 125 then
      GameObjects.TL_Kratos01_Left:HideTraverseLink()
      GameObjects.TL_Kratos01_Right:HideTraverseLink()
      GameObjects.TL_Kratos02_Left:HideTraverseLink()
      GameObjects.TL_Kratos02_Right:HideTraverseLink()
      GameObjects.TL_Kratos03_Right:ShowTraverseLink()
      GameObjects.GapJumpIC_Right:ShowCollision()
      GameObjects.GapJumpIC_Left:ShowCollision()
    end
  end
end
function UpperBreakableBroken()
  upperWoodBroken = true
  if kratosOnTheBlock then
    CheckIfKratosCanJump()
  end
end
function Disable_PushBlock_NavObstacle()
  GameObjects.PushBlock_NavObstacle:HideNavObstacle()
end
function ShowElevatorEntityZone()
  GameObjects.LoadZone_Elevator:ShowEntityVolume()
end
function ShowDeathPlane()
  GameObjects.LowerDeathPlane:ShowCollision()
end
function HideDeathPlane()
  GameObjects.LowerDeathPlane:HideCollision()
end
function QuestUpdate_BoatReached()
  LD.CompleteQuest("Quest_RiverPass_Objective925")
end
function Tutorial_ComapssToDaylight()
  TUT.Compass_ToDaylight()
end
function CA_475_Enable()
  local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
  if riv475 ~= nil then
    riv475:CallScript("SyncExit_Well")
  end
end
function CA_475_Disable()
  local riv475 = game.FindLevel("Riv475_FreyaHouseExt")
  if riv475 ~= nil then
    riv475:CallScript("CA_Area_Disable")
  end
end
function WellCrack_ExitBottom()
  GameObjects.Follow_ToWell.LuaObjectScript.Enable()
  CA_CaveStart_Enable()
  CA_475_Disable()
end
function BoatLoadZone_Show()
  GameObjects.LoadZone_UpperExit_Helpers:ShowEntityVolume()
end
function BoatLoadZone_Hide()
  GameObjects.LoadZone_UpperExit_Helpers:HideEntityVolume()
end
function HealSon_SetOccupied()
  local availabilityState = {
    AvailableForSync = false,
    AvailableForBanter = false,
    AvailableInLevel = false,
    AvailableForCombat = false,
    Unoccupied = false
  }
  game.AI.FindSon():SetNewAvailabilityRequest("SonUnavailable", availabilityState)
end
function HealSon_ClearOccupied()
  local availabilityState = {
    AvailableForSync = false,
    AvailableForBanter = false,
    AvailableInLevel = false,
    AvailableForCombat = false,
    Unoccupied = true
  }
  game.AI.FindSon():SetNewAvailabilityRequest("SonUnavailable", availabilityState)
end
function ClearOccupiedZones()
  GameObjects.EntZn_HealSon_SetOccupied:HideEntityVolume()
  GameObjects.EntZn_HealSon_ClearOccupied:HideEntityVolume()
end
function Riv925_Bookmark_Visit01()
end
function Riv925_Bookmark_HeadEnchant()
  GameObjects.SonBoatPOI.LuaObjectScript:Disable()
end
function Riv925_Bookmark_PuzzleStart()
  PushBlock01AtEnd()
  GameObjects.Cbt_Riv925_V1_Script.LuaObjectScript.Riv925_Bookmark_A1_E1_Complete()
  GameObjects.EntZn_Arena_1_Encounter_TEMP:HideEntityVolume()
end
function Riv925_Bookmark_SandBowlComplete()
  GameObjects.sonboost_scaffold.LuaObjectScript:Disable()
  Riv925_Bookmark_PuzzleStart()
  GameObjects.FloatingPlatformV12.Child:PlayAnimToEnd(1)
  GameObjects.EndLocatoinplatforms:PlayAnimToEnd(1)
  GameObjects.TP_Elevator:ShowTraverseLink()
  GameObjects.TP_Elevator1:ShowTraverseLink()
  game.Audio.StartMusic("SND_MX_RIV_freya_cavern_explore1_out")
end
function Riv925_Bookmark_CaveRetraversal()
  GameObjects.ElevatorCollisionHelper:HideCollision()
  GameObjects.EntZn_Arena_1_Encounter_TEMP:HideEntityVolume()
end
function Riv925_Bookmark_HideWellOpen()
  GameObjects.VibrateRock_Well:Hide()
  GameObjects.VibrateRock_Well:HideCollision()
  timer.StartLevelTimer(0, function()
    GameObjects.Vib_180_01_break1.Child:GetBreakable():BreakAllStages()
  end)
end
function Riv925_Bookmark_ElevatorUp()
  GameObjects.ElevatorCollisionHelper:HideCollision()
end
function Riv925_Bookmark_ElevatorMiddle()
  GameObjects.ElevatorCollisionHelper:HideCollision()
end
function Riv925_Bookmark_AllOpen()
  ShowTemporalBridge01()
  ShowTemporalBridge02()
  ShowTemporalBridge03()
  UpperAreaOpen()
  HiddenRoomOpen()
end
local PushBlockFakeEmitter, pushBlock1BackSoundEmitter, pushBlock1SideSoundEmitter
local pushBlockActiveLoop = "SND_MECH_Cart_Crystal_Stone_Push_LP"
local pushBlock1DrivenObjectSoundOverrides = {
  SoundEmitter = nil,
  UseExplicitSoundMotion = true,
  OnReturnToStart = "SND_MECH_Cart_Crystal_Stone_Push_Hit_Limit",
  OnForward = "SND_MECH_Cart_Crystal_Stone_Push_LP",
  OnBackward = "SND_MECH_Cart_Crystal_Stone_Push_LP",
  OnEnd = "SND_MECH_Cart_Crystal_Stone_Push_Hit_Limit",
  OnStuckAtEnd = "SND_MECH_Cart_Crystal_Stone_Push_Hit_Limit",
  OnStuckAtStart = "SND_MECH_Cart_Crystal_Stone_Push_Hit_Limit"
}
local pushBlock2DrivenObjectSoundOverrides = {
  SoundEmitter = nil,
  UseExplicitSoundMotion = true,
  OnAttach = "SND_MECH_Cart_Crystal_Handle_Grab_Creak",
  OnAttachFrame = 0,
  OnReturnToStart = "SND_MECH_Cart_Crystal_Wood_Push_Hit_Limit",
  OnForward = "SND_MECH_Cart_Crystal_Wood_Push_LP",
  OnBackward = "SND_MECH_Cart_Crystal_Wood_Push_LP",
  OnEnd = "SND_MECH_Cart_Crystal_Wood_Push_Hit_Limit",
  OnStuckAtEnd = "SND_MECH_Cart_Crystal_Wood_Struggle",
  OnStuckAtStart = "SND_MECH_Cart_Crystal_Wood_Struggle"
}
function SoundOnInit()
  PushBlockFakeEmitter = GameObjects.PushBlock01.SoundEmitters[1]
  pushBlock1BackSoundEmitter = GameObjects.PushBlock_Side.Child.SoundEmitters[1]
  pushBlock1SideSoundEmitter = GameObjects.PushBlock_Side:FindSingleGOByName("StraightCrankHandleSidewaysOfficial").Child.SoundEmitters[1]
  pushBlock2DrivenObjectSoundOverrides.SoundEmitter = GameObjects.PushBlock2:FindSingleGOByName("StraightCrankSidewaysHandle").Child.SoundEmitters[1]
end
function SoundOnStart()
  pushBlock1DrivenObjectSoundOverrides.SoundEmitter = pushBlock1SideSoundEmitter
  GameObjects.PushBlock_Side:FindSingleGOByName("StraightCrankHandleSidewaysOfficial").LuaObjectScript.DrivenObjectSoundSetup(pushBlock1DrivenObjectSoundOverrides)
  SoundSetupWaterPushBlock()
  GameObjects.PushBlock2:FindSingleGOByName("StraightCrankSidewaysHandle").LuaObjectScript.DrivenObjectSoundSetup(pushBlock2DrivenObjectSoundOverrides)
end
waterPushBlockSoundState = "Rest"
waterPushBlockAnimMonitor = nil
waterPushBlockCrankScript = nil
function SoundSetupWaterPushBlock()
  if not pushBlock01PushedOffLedge then
    waterPushBlockCrankScript = GameObjects.PushBlock_Side.LuaObjectScript
    pushBlock1DrivenObjectSoundOverrides.SoundEmitter = pushBlock1BackSoundEmitter
    pushBlock1DrivenObjectSoundOverrides.OnForward = ""
    pushBlock1DrivenObjectSoundOverrides.OnBackward = ""
    waterPushBlockCrankScript.DrivenObjectSoundSetup(pushBlock1DrivenObjectSoundOverrides)
    if waterPushBlockAnimMonitor == nil then
      waterPushBlockAnimMonitor = monitors.CreateAnimFrameMonitor(GameObjects.PushBlock01)
      waterPushBlockAnimMonitor:OnFrameBackward(0, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(11, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(22, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(33, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(43, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(54, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(65, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(75, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(86, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(97, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(108, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(118, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrame(129, AttemptPlaySoundOnWaterPushBlockPause)
      waterPushBlockAnimMonitor:OnFrameForward(140, AttemptPlaySoundOnWaterPushBlockPause)
    end
  end
end
function PlaySoundOnWaterPushBlockForward()
  if waterPushBlockSoundState ~= "Forward" then
    waterPushBlockSoundState = "Forward"
    LD.PlaySound(pushBlock1BackSoundEmitter, pushBlockActiveLoop, true)
  end
end
function PlaySoundOnWaterPushBlockBackward()
  if waterPushBlockSoundState ~= "Backward" then
    waterPushBlockSoundState = "Backward"
    LD.PlaySound(pushBlock1BackSoundEmitter, pushBlockActiveLoop, true)
  end
end
function PlaySoundOnWaterPushBlockPause()
  if waterPushBlockSoundState ~= "Pause" then
    waterPushBlockSoundState = "Pause"
    LD.StopSound(pushBlock1BackSoundEmitter, pushBlockActiveLoop)
  end
end
function AttemptPlaySoundOnWaterPushBlockPause()
  if not waterPushBlockCrankScript.PlayerIsAttached() then
    PlaySoundOnWaterPushBlockPause()
  end
end
function PlaySoundPushBlockIntoWater()
  LD.PlaySound(PushBlockFakeEmitter, "SND_MECH_Push_Cart_Water_Drop_Riv925")
  if waterPushBlockAnimMonitor ~= nil then
    waterPushBlockAnimMonitor:Stop()
    waterPushBlockAnimMonitor:Terminate()
    waterPushBlockAnimMonitor = nil
  end
end
function HidePushBlockCamZoneRightFacing()
  timer.StartLevelTimer(1, function()
    GameObjects.CamZone_BlockSlideStage1:HideCameraVolume()
  end)
end
function Emitters925CaveOff()
  GameObjects.SNDGrpCaveFalls:Hide()
end
function Emitters925CaveOn()
  GameObjects.SNDGrpCaveFalls:Show()
end
function LoadCheck_ElevatorUP()
  game.UI.LoadCheck("Riv925_AI_Visit02", "Riv480_FreyaHouse")
end
function LoadCheck_PuzzleArea()
  game.UI.LoadCheck("Riv925_AI_Visit02")
end
function EnableChiselMarker()
  LD.SetMarkerState("RP_925_ChiselEntrance", 1)
  LD.UpdateMap("RP_925_ChiselEntrance", 0)
  ChiselQuest()
end
function DisableChiselMarker()
  LD.SetMarkerState("RP_925_ChiselEntrance", 0)
end
function ChiselQuest()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Find_Riv")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Find_Riv")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Find", 1)
  end
end
local camOneShot_LookAtCeilingRunes, camOneShot_LookAtRunebowl
function DestroyOneShot_LookAtCeilingRunes()
  camOneShot_LookAtCeilingRunes = nil
end
function DestroyOneShot_LookAtRunebowl()
  camOneShot_LookAtRunebowl = nil
end
function SetSlowWalk()
  local player = game.Player.FindPlayer()
  player:SetMaxSpeedOverride(1.5)
end
function ClearSlowWalk()
  local player = game.Player.FindPlayer()
  player:ClearMaxSpeedOverride()
end
function SonReachedBowl()
  sonAtBowl = true
  GameObjects.EntZn_SwitchUpperLead:HideEntityVolume()
  sonPushBlock.LuaObjectScript.UnlockCrank()
end
function SonLeftBowl()
  sonAtBowl = false
end
function PressedSquare_Runes()
  if lookAtInteractDone == false then
    lookAtInteractDone = true
    if sonAtBowl then
      SetSlowWalk()
      camOneShot_LookAtCeilingRunes = CCOS.OneShotCamera.New("PLYR_NAR_Riv925_Solved_FrameBoth", 15)
      camOneShot_LookAtCeilingRunes:SetCallback(DestroyOneShot_LookAtCeilingRunes)
      camOneShot_LookAtCeilingRunes:Start()
    end
  end
end
function PressedSquare_Bowl()
  local fSubmissionTime = 5
  camOneShot_LookAtRunebowl = CCOS.OneShotCamera.New("PLYR_NAR_Riv925_Solved_Runebowl", fSubmissionTime)
  camOneShot_LookAtRunebowl:SetCallback(DestroyOneShot_LookAtRunebowl)
  camOneShot_LookAtRunebowl:Start()
  timer.StartLevelTimer(fSubmissionTime, ClearSlowWalk)
end
function OnUpdate()
  if camOneShot_LookAtCeilingRunes ~= nil then
    camOneShot_LookAtCeilingRunes:Update()
  end
  if camOneShot_LookAtRunebowl ~= nil then
    camOneShot_LookAtRunebowl:Update()
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_InsideWell") then
    game.Camera.SubmitCameraByName("PLYR_CrackClimb_CollisionReducer")
  end
end
function ShowDebugTable()
  local dt = {}
  dt.Title = "Push Block Info"
  dt.X = 15
  dt.Y = 15
  dt.TitleColor = engine.Vector.New(255, 0, 128)
  dt[#dt + 1] = {
    "Locked ",
    GameObjects.StraightCrankSidewaysHandle.LuaObjectScript.CrankIsLocked()
  }
  dt[#dt + 1] = {
    "Position ",
    GameObjects.StraightCrankSidewaysHandle.LuaObjectScript.GetCurrentCycle()
  }
  dt[#dt + 1] = {
    "Son Boosted ",
    sonBoosted
  }
  dt[#dt + 1] = {
    "Is Player Controlling ",
    GameObjects.StraightCrankSidewaysHandle.LuaObjectScript.PlayerIsAttached()
  }
  dt[#dt + 1] = {
    "Is Player On Block ",
    kratosOnTheBlock
  }
  dt[#dt + 1] = {
    "upperAccess",
    upperAccess
  }
  dt[#dt + 1] = {
    "upperWoodBroken",
    upperWoodBroken
  }
  dt[#dt + 1] = {"sonAtBowl", sonAtBowl}
  dt[#dt + 1] = {"wellRead", wellRead}
  dt[#dt + 1] = {
    "hiddenRoomOpen",
    hiddenRoomOpen
  }
  dt[#dt + 1] = {
    "lookAtInteractDone",
    lookAtInteractDone
  }
  dt[#dt + 1] = {
    "IsBurnableBurnt",
    GameObjects.PushBlock2.LuaObjectScript.IsBurnableBurnt()
  }
  engine.DrawDebugTable(dt)
end
function Dispel01_Complete()
end
function FIXUP_INT_89525()
  GameObjects.LTW_Boost.LuaObjectScript.Disable()
  GameObjects.LTW_ToSandbowl.LuaObjectScript.Enable()
  GameObjects.Follow_ToSandbowl.LuaObjectScript.Enable()
  GameObjects.EntZn_CA_BanterSonRide:HideEntityVolume()
  GameObjects.PushBlock2.LuaObjectScript.HideBeckonZone()
  GameObjects.entityZone_onPushblock:HideEntityVolume()
  ClearSonOccupied()
end
