local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local thisObj, thisLevel, kratosActor, sonActor, boatActor
local branchName = "BRA_SonBoatExit_R"
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function CreateActors()
  kratosActor = actor.Actor.New("KRATOS", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SON", game.AI.FindSon)
  boatActor = actor.Actor.New("BOAT", game.Boat.GetPlayerBoat)
end
function CheckCineNumber()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 368 <= cineNum and cineNum < 370 then
    GameObjects.FreyaCaveBoat_02.Child.LuaObjectScript.EnableCinematicTrigger()
  end
end
function SonBoatExitSeq()
  CreateActors()
  SetBranchName()
  local cineSeq = ND.CreateCineSequence(thisLevel, thisObj, "Son Boat Exit")
  local actorTable = {
    {Actor = sonActor},
    {Actor = kratosActor}
  }
  cineSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master", "SND_MX_RIV_start_master", nil, "SND_MX_SonSick_travel_to_freya_2")
  cineSeq:MarkAbleToSkip()
  cineSeq:WaitForLoadCheck("Riv480_c370_FreyaTendsSon")
  cineSeq:Do(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  cineSeq:ActorSync(boatActor, {
    Slaves = actorTable,
    Branch = branchName,
    ReferenceJoint = "SonBoatExit_SyncJoint"
  })
  cineSeq:Do(RemoveSonSickMarkers)
  cineSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.5)
  cineSeq:Do(ShowForcedCamera_SonBoatExit)
  cineSeq:WaitForActorPuppeteerComplete(kratosActor)
  cineSeq:StopPuppetingActor(kratosActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(boatActor)
  cineSeq:SetCompletedCineNumber(369)
  cineSeq:Do(HideForcedCamera_SonBoatExit)
  cineSeq:Do(function()
    _G.AttachToSpline1()
  end)
  cineSeq:Do(game.AI.FindSon():CallScript("ClearThisBehaviorContextIfActive", "BOAT_SICK_CONTEXT_CONFIG"))
  cineSeq:StartSequence()
end
function RemoveSonSickMarkers()
  local creatures = {
    game.Player.FindPlayer(),
    game.AI.FindSon(),
    game.Boat.GetPlayerBoat()
  }
  for _, creature in pairs(creatures) do
    if creature:HasMarker("pendingDockCinematic") then
      creature:RemoveMarker("pendingDockCinematic")
    end
    if creature:HasMarker("SonSick") then
      creature:RemoveMarker("SonSick")
    end
  end
end
function SetBranchName()
  local kraFacing = kratosActor:GetCreature():GetWorldForward()
  print(tostring(kraFacing.z))
  if kraFacing.z < 0 then
    branchName = "BRA_SonBoatExit_L"
    print(tostring(branchName))
  end
end
function ShowForcedCamera_SonBoatExit()
  GameObjects.CamZone_SonBoatExit_ForcedCamera:ShowCameraVolume()
end
function HideForcedCamera_SonBoatExit()
  timers.StartLevelTimer(2, function()
    GameObjects.CamZone_SonBoatExit_ForcedCamera:HideCameraVolume()
  end)
end
