local timers = require("level.timer")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCOS = require("camera.camera_oneshot")
local thisObj, thisLevel, kratosActor, sonActor, switchObj, switchScript, camOneShot_SonSickElevatorRide
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  switchObj = GameObjects.SwitchWall_Elevator.Child
  switchScript = switchObj.LuaObjectScript
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function SetSonSickLeverState()
  if switchScript.SwitchIsBeingTurnedOff() then
    switchScript.ToggleState()
  end
end
function PerformInteraction()
  if game.Level.GetVariable("CompletedCineNumber") == 369 then
    print("Performing son sick switch interaction")
    DisableStickInput()
    _G.DetachFromSpline1()
    GameObjects.BasicElevator_Manager.LuaObjectScript.DisableSonWarpOnElevator()
    switchScript.EnableCinematicTrigger()
    SetupCustomSequence()
  end
end
function SetupCustomSequence()
  kratosActor = actor.Actor.New("SON SICK SWITCH INTERACT: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SON SICK SWITCH INTERACT: Son Actor", game.AI.FindSon)
  local seq = ND.CreateCineSequence(thisLevel, switchObj, "sonSickSwitchInteraction")
  local actorTable = {
    {Actor = sonActor},
    {
      Obj = switchObj,
      Anim = "navCarrySonLeverWall"
    }
  }
  seq:RequestCineModeAndWait(kratosActor, switchObj)
  seq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_SwitchWall_SonSick",
    ReferenceJoint = "synchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.StopTurnRadius
  })
  seq:ActorSync(kratosActor, {
    Slaves = actorTable,
    Branch = "BRA_SwitchWall_SonSick",
    ReferenceJoint = "synchJoint"
  })
  seq:WaitUntilActorAnimPastPercentage(kratosActor, 0.2)
  seq:Do(function()
    RecenterToKratosRight()
    StartCamera_SonSickElevatorRide()
  end)
  seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  seq:StopPuppetingActor(kratosActor)
  seq:StopPuppetingActor(sonActor)
  seq:Do(_G.PlayWaterRushSound)
  seq:StartSequence()
end
function DisableStickInput()
  local pad = game.Player.FindPlayer().Pad
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickY)
end
function OnUpdate()
  if camOneShot_SonSickElevatorRide ~= nil then
    camOneShot_SonSickElevatorRide:Update()
  end
end
function RecenterToKratosRight()
  local elevator = {
    TimeStart = 0,
    TimeDuration = 8,
    LockRecenter = 0,
    YawRange = -1,
    TriggerLeft = -118,
    ReturnLeft = -118,
    ReturnRight = -118,
    TriggerRight = -118,
    PitchRange = -1,
    TriggerUp = -20,
    ReturnUp = -20,
    ReturnDown = -20,
    TriggerDown = -20,
    RotationSpace = 1
  }
  game.Camera.Recenter(elevator)
end
function StartCamera_SonSickElevatorRide()
  game.SubObject.Wake(thisObj)
  camOneShot_SonSickElevatorRide = CCOS.OneShotCamera.New("PLYR_NAR_Override_SonSick", 30)
  camOneShot_SonSickElevatorRide:SetCallback(DestroyCamera_SonSickElevatorRide)
  camOneShot_SonSickElevatorRide:Start()
end
function DestroyCamera_SonSickElevatorRide()
  camOneShot_SonSickElevatorRide = nil
  game.SubObject.Sleep(thisObj)
end
