local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, thisLevel
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  GameObjects.Btr_LeaveFreyaAlone:Hide()
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") == 390 and not banterPlayed.StillKinked then
    GameObjects.InteractZone_StillKinked.Child.LuaObjectScript.Enable()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    banterPlayed = savedInfo.banterPlayed
  end
end
function WaterDropped_Played()
  banterPlayed.WaterDropped = true
end
function KeepTheHead_Seq()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 310 <= cineNum and cineNum < 330 and not banterPlayed.KeepTheHead then
    local seq = LD.CreateCineSequence(thisLevel, thisObj, "keepTheHead")
    seq:WaitForFunctionTrue(function()
      return banterPlayed.WaterDropped
    end)
    seq:WaitSeconds(2)
    seq:Do(function()
      game.Audio.PlayBanter("RIV_KeepTheHead")
    end)
    seq:Do(function()
      banterPlayed.KeepTheHead = true
    end)
    seq:StartSequence()
  end
end
function LeaveFreyaAlone_Forwarding()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 330 <= cineNum and cineNum < 365 then
    LeaveFreyaAlone_Enable()
  end
end
function StillKinked_Banter()
  game.Audio.PlayBanter("RIV_StillKinked")
  banterPlayed.StillKinked = true
end
function PlayOnBoatEnterBanter()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum == 330 then
    timers.StartLevelTimer(0.5, function()
      game.Audio.PlayBanter("002_MimirTalksBaldur", nil, false, false)
    end)
  end
end
function LeaveFreyaAlone_Enable()
  if not banterPlayed.LeaveFreyaAlone2 then
    GameObjects.Btr_LeaveFreyaAlone:Show()
  end
end
function LeaveFreyaAlone_Banter()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if game.Level.GetVariable("CompletedCineNumber") >= 365 then
    GameObjects.Btr_LeaveFreyaAlone:Hide()
    return
  end
  if not banterPlayed.LeaveFreyaAlone1 and 330 <= cineNum then
    game.Audio.PlayBanter("RIV_LeaveFreyaAlone1")
    banterPlayed.LeaveFreyaAlone1 = true
    GameObjects.Btr_LeaveFreyaAlone:Hide()
  elseif not banterPlayed.LeaveFreyaAlone2 and 330 <= cineNum then
    game.Audio.PlayBanter("RIV_LeaveFreyaAlone2")
    banterPlayed.LeaveFreyaAlone2 = true
    GameObjects.Btr_LeaveFreyaAlone:Hide()
  end
end
function DisableKinkedInteractZone()
  GameObjects.InteractZone_StillKinked.Child.LuaObjectScript.Disable()
end
