local LD = require("design.LevelDesignLibrary")
local LM = require("level.loadmonitor")
local checkpoint = require("level.checkpoint")
local monitors = require("level.MonitorLibrary")
local timers = require("level.timer")
local player, elevatorManger
local firstVisit = true
local headEnchantVisitCheckpointed = false
local setRetreversalCheckpoint = false
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  elevatorManger = GameObjects.BasicElevator_Manager
  SoundInit()
  SetDockOpenings()
end
function OnFirstStart(level)
  GameObjects.BoatSideCollision:HideCollision()
  GameObjects.LoadZone_ElevatorUp:HideEntityVolume()
  GameObjects.LoadZone_ElevatorDown:HideEntityVolume()
  GameObjects.EntZn_Playtest_DemiGodEnd:HideEntityVolume()
end
function OnStart(level)
  LD.RegisterForCineUpdate(level, {
    {
      at = 365,
      immediateFn = function()
        elevatorManger.LuaObjectScript.JumpToBottomFloor()
        elevatorManger.LuaObjectScript.EnableElevator()
        GameObjects.FastTravel2.LuaObjectScript.LockFastTravelPoint()
        GameObjects.FastTravel1.LuaObjectScript.LockFastTravelPoint()
      end,
      fn = function()
        elevatorManger.LuaObjectScript.JumpToBottomFloor()
        elevatorManger.LuaObjectScript.EnableElevator()
        GameObjects.FastTravel2.LuaObjectScript.LockFastTravelPoint()
        GameObjects.FastTravel1.LuaObjectScript.LockFastTravelPoint()
      end
    },
    {
      at = 368,
      immediateFn = function()
        GameObjects.SonSickLeverInteractionObj.LuaObjectScript.SetSonSickLeverState()
      end,
      fn = function()
        GameObjects.SonSickLeverInteractionObj.LuaObjectScript.SetSonSickLeverState()
      end
    },
    {
      at = 369,
      immediateFn = function()
        GameObjects.FreyaCaveBoat_02.LuaObjectScript.Disable()
      end,
      fn = function()
        GameObjects.FreyaCaveBoat_02.LuaObjectScript.Disable()
      end
    },
    {
      at = 370,
      immediateFn = function()
        elevatorManger.LuaObjectScript.JumpToTopFloor()
        elevatorManger.LuaObjectScript.EnableElevator()
        DetachFromSpline1()
        DetachFromSpline2()
      end,
      fn = function()
        elevatorManger.LuaObjectScript.JumpToTopFloor()
        elevatorManger.LuaObjectScript.EnableElevator()
        DetachFromSpline1()
        DetachFromSpline2()
      end
    },
    {
      at = 400,
      immediateFn = function()
        GameObjects.FreyaCaveBoat_02.LuaObjectScript.Enable()
        GameObjects.FastTravel2.LuaObjectScript.UnlockFastTravelPoint()
        GameObjects.FastTravel1.LuaObjectScript.LockFastTravelPoint()
        GameObjects.Riv935_Banter.LuaObjectScript.DisableKinkedInteractZone()
      end,
      fn = function()
        GameObjects.FreyaCaveBoat_02.LuaObjectScript.Enable()
        GameObjects.FastTravel2.LuaObjectScript.UnlockFastTravelPoint()
        GameObjects.FastTravel1.LuaObjectScript.LockFastTravelPoint()
        GameObjects.Riv935_Banter.LuaObjectScript.DisableKinkedInteractZone()
      end
    }
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = LowerWater_Level01,
    fn = LowerWater_Level01
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = LowerWater_Level02,
    fn = LowerWater_Level02
  })
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if game.Boat.GetPlayerBoat() == nil and 369 <= cineNumber and cineNumber < 370 then
    AttachToSpline1()
    player:TriggerMoveEvent("kLE_CarrySonStand")
  else
    DetachFromSpline1()
    DetachFromSpline2()
  end
end
function Riv935_Bookmark_DemiGodReveal()
  GameObjects.FreyaCaveBoat_02.LuaObjectScript.DisableAndClear()
  GameObjects.Cine_DemigodReveal.LuaObjectScript.Prepare()
end
function ArrivedFromFastTravel()
  if game.Level.GetVariable("CompletedCineNumber") == 400 then
    GameObjects.FastTravel2.LuaObjectScript.UnlockFastTravelPoint()
    GameObjects.Riv935_Banter.LuaObjectScript.DisableKinkedInteractZone()
  end
  JumpElevatorToBottom()
end
function ElevatorCollisionOn()
  GameObjects.FreyaSideCollision:ShowCollision()
  GameObjects.BoatSideCollision:ShowCollision()
  local riv925Monitor = LM.CreateLoadMonitor()
  riv925Monitor:AddCallback({
    Wads = {
      "Riv925_FreyaCave"
    },
    Functions = {
      Riv925ElevatorCollOn
    }
  })
end
function Riv925ElevatorCollOn(wads)
  wads.Riv925_FreyaCave:CallScript("ElevatorCollisionOn")
end
function ElevatorAtBottom()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  GameObjects.BoatSideCollision:HideCollision()
  local riv925Monitor = LM.CreateLoadMonitor()
  riv925Monitor:AddCallback({
    Wads = {
      "Riv925_FreyaCave"
    },
    Functions = {
      Riv925ElevatorAtBottom
    }
  })
  if 320 < cineNumber and cineNumber < 340 then
    GameObjects.CA_Exit_Level1.LuaObjectScript.Enable()
  elseif cineNumber == 390 then
    GameObjects.CA_Exit_DemiGod.LuaObjectScript.Enable()
  elseif 340 <= cineNumber then
    GameObjects.CA_Exit_Level2.LuaObjectScript.Enable()
  end
end
function Riv925ElevatorAtBottom(wads)
  wads.Riv925_FreyaCave:CallScript("ElevatorAtBottom")
end
function ElevatorAtTop()
  GameObjects.FreyaSideCollision:HideCollision()
  local riv925Monitor = LM.CreateLoadMonitor()
  riv925Monitor:AddCallback({
    Wads = {
      "Riv925_FreyaCave"
    },
    Functions = {
      Riv925ElevatorAtTop
    }
  })
  if game.Level.GetVariable("CompletedCineNumber") >= 365 and game.Level.GetVariable("CompletedCineNumber") <= 389 then
    GameObjects.SwitchWall_Elevator.LuaObjectScript.Disable()
  end
  if game.Level.GetVariable("CompletedCineNumber") == 369 then
    AttachToSpline2()
    EnableStickInput()
  end
  if game.Level.GetVariable("CompletedCineNumber") == 320 and not headEnchantVisitCheckpointed then
    headEnchantVisitCheckpointed = true
    game.World.StoreCheckpoint()
  end
  if setRetreversalCheckpoint == true then
    setRetreversalCheckpoint = false
    game.World.StoreCheckpoint()
  end
end
function AllowElevatorCheckpoint()
  if game.Level.GetVariable("CompletedCineNumber") >= 400 then
    setRetreversalCheckpoint = true
  end
end
function Riv925ElevatorAtTop(wads)
  wads.Riv925_FreyaCave:CallScript("ElevatorAtTop")
end
function OnActivateElevator()
  GameObjects.CA_Exit_Level1.LuaObjectScript.Disable()
  GameObjects.CA_Exit_Level2.LuaObjectScript.Disable()
  GameObjects.CA_BoatExit.LuaObjectScript.Disable()
  GameObjects.CA_Exit_DemiGod.LuaObjectScript.Disable()
  SetSoundElevatorState()
end
function JumpElevatorToTop()
  if game.Level.GetVariable("CompletedCineNumber") >= 380 then
    elevatorManger.LuaObjectScript.JumpToTopFloor()
  end
end
function JumpElevatorToBottom()
  elevatorManger.LuaObjectScript.JumpToBottomFloor()
end
function LoadZoneSwitch_ElevatorUp()
  GameObjects.LoadZone_ElevatorUp:ShowEntityVolume()
  GameObjects.LoadZone_ElevatorDown:HideEntityVolume()
  if game.Level.GetVariable("CompletedCineNumber") == 390 then
    GameObjects.SadContext.LuaObjectScript.Enable()
    GameObjects.IdleContextZone.LuaObjectScript.Disable()
  else
    GameObjects.SadContext.LuaObjectScript.Disable()
    GameObjects.IdleContextZone.LuaObjectScript.Enable()
  end
end
function LoadZoneSwitch_ElevatorDown()
  GameObjects.LoadZone_ElevatorDown:ShowEntityVolume()
  GameObjects.LoadZone_ElevatorUp:HideEntityVolume()
  if game.Level.GetVariable("CompletedCineNumber") == 390 then
    GameObjects.SadContext.LuaObjectScript.Enable()
    GameObjects.IdleContextZone.LuaObjectScript.Disable()
  else
    GameObjects.SadContext.LuaObjectScript.Disable()
    GameObjects.IdleContextZone.LuaObjectScript.Enable()
  end
end
function EnableStickInput()
  local pad = game.Player.FindPlayer().Pad
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickY)
end
function LowerWater_Level01()
end
function LowerWater_Level02()
  elevatorManger.LuaObjectScript.SetBottomFloorFrame(0)
end
function OnEvaluateLoadGroup_LoadGroup_AI()
  if game.Level.GetVariable("CompletedCineNumber") >= 320 and game.Level.GetVariable("CompletedCineNumber") < 331 then
    return "AI_Visit_02"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 365 and game.Level.GetVariable("CompletedCineNumber") < 387 then
    return "SonSick"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 387 and game.Level.GetVariable("CompletedCineNumber") < 390 then
    return "SonHeal"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 390 and game.Level.GetVariable("CompletedCineNumber") <= 590 then
    return "DemiGodReveal"
  elseif game.Level.GetVariable("CompletedCineNumber") > 590 then
    return "AI_Visit_02"
  else
    return nil
  end
end
function OnEvaluateLoadGroup_LoadGroup_DemiGod()
  if game.Level.GetVariable("CompletedCineNumber") == 330 then
    return "MimiRevived"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 365 and game.Level.GetVariable("CompletedCineNumber") < 387 then
    return "SonCarry"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 390 and game.Level.GetVariable("CompletedCineNumber") <= 400 then
    return "DemiGod"
  else
    return nil
  end
end
function SetDockOpenings()
  local waterLevel = LD.GetCurrentWaterLevel()
  if waterLevel == 2 then
    game.Compass.SetGatewayMarkerIsOpen("RP_935Lower_Helper2", true)
  elseif waterLevel == 1 then
    game.Compass.SetGatewayMarkerIsOpen("RP_935Upper_Helper", true)
    game.Compass.SetGatewayMarkerIsOpen("RP_935Lower_Helper2", false)
  end
end
function BoatWadCheck()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 390 <= cineNumber and cineNumber < 400 then
    game.UI.LoadCheck("BoatGlobal")
  end
end
function Prepare_DemiGodReveal()
  GameObjects.Cine_DemigodReveal.LuaObjectScript.PrepareFromTrigger()
end
function ReEnable_ElevatorSwitch()
  GameObjects.SwitchWall_Elevator.LuaObjectScript.Enable()
end
function AttachToSpline1()
  GameObjects.SonSickCarry1Controller.LuaObjectScript.Enable()
end
function DetachFromSpline1()
  GameObjects.SonSickCarry1Controller.LuaObjectScript.Disable()
end
function AttachToSpline2()
  GameObjects.SonSickCarry2Controller.LuaObjectScript.Enable()
end
function DetachFromSpline2()
  GameObjects.SonSickCarry2Controller.LuaObjectScript.Disable()
end
function SyncExitLevel1()
  if firstVisit and game.Level.GetVariable("CompletedCineNumber") == 330 then
    GameObjects.CA_Post_Up_StoppedEnter.LuaObjectScript.Enable()
    firstVisit = false
  else
    GameObjects.CA_Post_Up_StoppedEnter.LuaObjectScript.Disable()
    GameObjects.CA_BoatExit.LuaObjectScript.Enable()
  end
end
function Quest_Caldera_Objective360_Complete()
  LD.CompleteQuest("Quest_Caldera_Objective360")
end
function Quest_PeaksPass_Objective7462_Complete()
  LD.CompleteQuest("Quest_PeaksPass_Objective7462")
end
function SoftSave()
  game.SubObject.SoftSave()
end
function RecenterToKratosLeft()
  local elevator = {
    TimeStart = 0,
    TimeDuration = 8,
    LockRecenter = 0,
    YawRange = -1,
    TriggerLeft = -56,
    ReturnLeft = -56,
    ReturnRight = -56,
    TriggerRight = -56,
    PitchRange = -1,
    TriggerUp = -12,
    ReturnUp = -12,
    ReturnDown = -12,
    TriggerDown = -12,
    RotationSpace = 1
  }
  game.Camera.Recenter(elevator)
end
function RecenterBehindLeftShoulder()
  local elevator = {
    TimeStart = 0,
    TimeDuration = 8.6,
    LockRecenter = 0,
    YawRange = -1,
    TriggerLeft = 30,
    ReturnLeft = 30,
    ReturnRight = 30,
    TriggerRight = 30,
    PitchRange = -1,
    TriggerUp = -18.9,
    ReturnUp = -18.9,
    ReturnDown = -18.9,
    TriggerDown = -18.9,
    RotationSpace = 1
  }
  game.Camera.Recenter(elevator)
end
function TriggerReactToHornBlowWithSickSon()
  timers.StartLevelTimer(1.25, RecenterToKratosLeft)
  timers.StartLevelTimer(8.75, RecenterBehindLeftShoulder)
  player:TriggerMoveEvent("kLE_CarrySonReactAdditive")
end
function TriggerLookAtSickSon()
  player:TriggerMoveEvent("kLE_CarrySonHeadAdditive")
end
function TriggerKratosPaceWithSon()
  player:TriggerMoveEvent("kLE_CarrySonPace")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    firstVisit = firstVisit,
    headEnchantVisitCheckpointed = headEnchantVisitCheckpointed
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  firstVisit = savedInfo.firstVisit
  headEnchantVisitCheckpointed = savedInfo.headEnchantVisitCheckpointed
end
local elevatorEmitter
local elevatorState = "Rest"
function SoundInit()
  elevatorEmitter = GameObjects.Sound:FindSingleSoundEmitterByName("SNDFreyaElevator")
end
function PlayWaterRushSound()
  local monitor = monitors.CreateAnimFrameMonitor(GameObjects.Elevator01_Group)
  monitor:OnFrameForward(48, function()
    LD.PlaySound(elevatorEmitter, "SND_OMEN_Freyas_Cave_Boat_Move_Water")
    monitor = nil
  end)
end
function SetSoundElevatorState()
  if elevatorState == "Rest" then
    elevatorState = "Active"
  end
end
function PlayElevatorLoop()
  if elevatorState == "Active" then
    LD.PlaySound(elevatorEmitter, "SND_MECH_Elevator_Wood_LP")
  end
end
function StopElevatorLoop()
  if elevatorState == "Active" then
    elevatorState = "Rest"
    LD.StopSound(elevatorEmitter, "SND_MECH_Elevator_Wood_LP")
  end
end
